/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class VsUnmountDsClSubProcessor
extends BaseRecoveryProcessor {
    protected static final Log logger = LogFactory.getInstance(VsUnmountDsClSubProcessor.class);
    private static final long serialVersionUID = 1075392589986752771L;
    private String hostMoId;
    private String dataStoreUuid;
    private String dataStoreName;
    private String vcenterUuid;

    public boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getDataStoreName()});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("ism.drm.recovery.vsphere.datastore.unmount.already", new String[]{this.getDataStoreName()});
            logger.debug((Object)("the datastore already has been unmounted,datastore=" + this.getDataStoreName()), 90160758784001L);
            return true;
        }
        for (int i = 0; i <= 2; ++i) {
            if (!this.doUnmount()) continue;
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.updateProcessDetail("", null);
            return true;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        return true;
    }

    private boolean doUnmount() {
        HostSystemAction hostAction = new HostSystemAction();
        try {
            if (hostAction.isUnmountedDatastore(this.vcenterUuid, this.dataStoreUuid)) {
                this.updateProcessDetail("ism.drm.recovery.vsphere.datastore.unmount.already", new String[]{this.getDataStoreName()});
                logger.debug((Object)("the datastore already has been unmounted,datastore=" + this.getDataStoreName()), 90160758784001L);
                return true;
            }
            hostAction.unmountDataStoreByUuid(this.vcenterUuid, this.getDataStoreUuid());
            logger.debug((Object)("unmount ds success by host " + this.hostMoId + " and ds uuid " + this.dataStoreName), 90160758786988L);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("unmount datastore by uuid - " + this.dataStoreUuid + " failed ."), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("unmount datastore by uuid - " + this.dataStoreUuid + " failed ." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail("ism.drm.recovery.vsphere.datastore.unmount.failed", new String[]{this.dataStoreName});
            return false;
        }
        return true;
    }

    public String getDataStoreName() {
        return this.dataStoreName;
    }

    public void setDataStoreName(String dsName) {
        this.dataStoreName = dsName;
    }

    public String getDataStoreUuid() {
        return this.dataStoreUuid;
    }

    public void setDataStoreUuid(String id) {
        this.dataStoreUuid = id;
    }

    public String getHostMoId() {
        return this.hostMoId;
    }

    public void setHostMoId(String hostMoId) {
        this.hostMoId = hostMoId;
    }

    public String getVcenterUuid() {
        return this.vcenterUuid;
    }

    public void setVcenterUuid(String vcenterUuid) {
        this.vcenterUuid = vcenterUuid;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getStopAppProcResultKey((String)this.dataStoreUuid);
    }
}

