/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.provider;

import com.google.common.collect.ImmutableSet;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderDelegate;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.framework.provider.BaseRefactorConfigurationProvider;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.service.IDataStoreGroupService;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.virtualization.service.impl.VirtualizationServiceHelper;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class VsphereVMRefactorConfigurationProvider
extends BaseRefactorConfigurationProvider {
    private static final Log logger = LogFactory.getInstance(VsphereVMRefactorConfigurationProvider.class);
    private static final List<Integer> SYNC_METRO_TEMPLATE_TYPE = Arrays.asList(1, 3, 5, 18, 20, 30, 31, 32);
    private static final Set<Integer> HYPERVAULT_TEMPLATE = ImmutableSet.of((Object)30, (Object)31, (Object)32);

    public List<String> getAppType() {
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.AppType.VM.name());
        return appTypes;
    }

    public void reverseProtectObjectAttributes(ProtectObject protectObject, Map<String, Object> params) {
    }

    public void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
    }

    public void reverseProtectGroupAttributes(ProtectGroup protectGroup, Map<String, Object> params) {
        Map pgAndDisasterHosts = (Map)params.get("PG_DISASTER_HOST");
        String hostOrGroupId = (String)pgAndDisasterHosts.get(protectGroup.getUuid());
        protectGroup.setPoProviderSN(hostOrGroupId);
        VirtualDataStoreGroup newDsg = this.getDisasterSiteDsg(protectGroup, hostOrGroupId);
        if (newDsg == null) {
            logger.error((Object)"can not find new Dsg id", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        protectGroup.getProps().remove("dsgId");
        protectGroup.getProps().put("dsgId", newDsg.getGroupId());
        this.updateProtectObjectUuid(protectGroup, newDsg);
        IProtectObjectBaseProvider vmProvider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(10);
        vmProvider.buildProtectObjects(protectGroup);
    }

    public void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        super.refactorRecoveryPlan(recoveryPlan, params);
        if (recoveryPlan.getProtectGroup().getTemplate().getType() == 18) {
            recoveryPlan.getGlobalSettings().put("DISASTER_SITE_ID", String.valueOf(params.get("PRODUCT_SITE_ID")));
        }
        HashSet<RecoverySetting> needRemovedSettings = new HashSet<RecoverySetting>();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        for (RecoverySetting recoverySetting : recoverySettings) {
            if ("startOrder".equals(recoverySetting.getName())) {
                recoverySetting.setValue(this.getIsReversed() != false ? recoverySetting.getValue() : String.valueOf(10));
                continue;
            }
            if ("isStart".equals(recoverySetting.getName())) {
                recoverySetting.setValue(this.getIsReversed() != false ? recoverySetting.getValue() : "true");
                continue;
            }
            needRemovedSettings.add(recoverySetting);
        }
        for (RecoverySetting setting : needRemovedSettings) {
            recoverySettings.remove(setting);
        }
    }

    public void updateRecoveryPlan(RecoveryPlan oldRecoveryPlan, RecoveryPlan newRecoveryPlan) {
        oldRecoveryPlan.getGlobalSettings().clear();
        oldRecoveryPlan.getGlobalSettings().putAll(newRecoveryPlan.getGlobalSettings());
        super.updateRecoveryPlan(oldRecoveryPlan, newRecoveryPlan);
    }

    public void updateProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        oldProtectObject.setProps(newProtectObject.getProps());
        super.updateProtectObject(oldProtectObject, newProtectObject);
    }

    public void updateProtectGroup(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        Set oldProtectObjects = oldProtectGroup.getPolist();
        ArrayList newProtectObjects = new ArrayList(newProtectGroup.getPolist());
        HashSet<ProtectObject> needDeleteOldProtectObjects = new HashSet<ProtectObject>();
        for (ProtectObject oldProtectObject : oldProtectObjects) {
            boolean needRemove = true;
            for (ProtectObject newProtectObject : newProtectObjects) {
                if (!oldProtectObject.getUuid().equals(newProtectObject.getUuid())) continue;
                needRemove = false;
                break;
            }
            if (!needRemove) continue;
            logger.warn((Object)("The po need remove.vm name is:" + oldProtectObject.getName()), 90160758784001L);
            needDeleteOldProtectObjects.add(oldProtectObject);
        }
        oldProtectObjects.removeAll(needDeleteOldProtectObjects);
        super.updateProtectGroup(oldProtectGroup, newProtectGroup);
        oldProtectGroup.setProps(newProtectGroup.getProps());
    }

    private VirtualDataStoreGroup getDisasterSiteDsg(ProtectGroup protectGroup, String disasterVCenterSN) {
        String productSiteId = protectGroup.getProductSiteId();
        List replications = protectGroup.getReplicationRelationByRecoverySiteId(productSiteId);
        if (replications == null || replications.isEmpty()) {
            return null;
        }
        ReplicationRelationBo replication = (ReplicationRelationBo)replications.get(0);
        Map allPairStorageIds = replication.getTgtLuns();
        List allDataStore = ((IDataStoreGroupService)ServiceLocator.getInstance().getService(IDataStoreGroupService.class)).getAvailableDataStoreStoreGroup(disasterVCenterSN, ProtectionTypeEnum.STORAGE_REPLICATION.getValue());
        VirtualDataStoreGroup result = this.getDataStoreGroupByStorageInfo(allPairStorageIds, replication.getTgtDeviceSn(), allDataStore);
        return result;
    }

    private VirtualDataStoreGroup getDataStoreGroupByStorageInfo(Map<String, String> allPairStorageIds, String storageDevSn, List<VirtualDataStoreGroup> allDataStore) {
        VirtualDataStoreGroup result = null;
        for (VirtualDataStoreGroup dsg : allDataStore) {
            List<StorageResource> storageResources = VsphereRecoveryUtils.getInstance().getStorageResourceByDsg(dsg.getGroupId());
            HashSet<String> allStorageIds = new HashSet<String>();
            for (StorageResource storageResource : storageResources) {
                if (!storageDevSn.equals(storageResource.getDevSn())) continue;
                allStorageIds.add(storageResource.getResourceId());
            }
            if (!allStorageIds.containsAll(allPairStorageIds.values())) continue;
            logger.debug((Object)("all salve lun Id is:" + VirtualizationServiceHelper.getInstance().getStringFromSet(allPairStorageIds.values()) + ";and dsg lun id is:" + VirtualizationServiceHelper.getInstance().getStringFromSet(allStorageIds)), 90160758784000L);
            result = dsg;
            break;
        }
        return result;
    }

    private void updateProtectObjectUuid(ProtectGroup protectGroup, VirtualDataStoreGroup newDsg) {
        ArrayList allVMmoids = new ArrayList();
        allVMmoids.addAll(newDsg.getVmUuidSet());
        Object[] uuids = new String[allVMmoids.size()];
        int index = 0;
        for (String uuid : allVMmoids) {
            uuids[index++] = uuid;
        }
        QueryCondition qc = new QueryCondition("uuid", (Object)uuids, 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        List vms = CommonDAOLocator.getMoDao().findMoBy(VsphereVirtualMachine.class, qcList);
        if (VerifyUtil.isEmpty((Collection)vms)) {
            logger.error((Object)("vm is empty:" + StringUtil.arrayToString((Object[])uuids)), 90160758784001L);
            return;
        }
        Iterator itr = protectGroup.getPolist().iterator();
        while (itr.hasNext()) {
            ProtectObject po = (ProtectObject)itr.next();
            for (VsphereVirtualMachine vm : vms) {
                if (!po.getName().equals(vm.getName())) continue;
                po.setMoUuid(vm.getUuid());
                break;
            }
            itr.remove();
        }
    }

    public void refactorPolicyTemplate(ProtectGroup pg) {
        super.refactorPolicyTemplate(pg);
        int templateType = pg.getTemplate().getType();
        if (templateType == 6 || templateType == 36) {
            pg.getTemplate().getProps().put("vmSnapshotFlag" + DrmEnumDefine.ProtectLocation.A_B.getValue(), "1");
            pg.getTemplate().getProps().put("vmSnapshotFlag" + DrmEnumDefine.ProtectLocation.A_C.getValue(), "1");
            pg.getTemplate().getProps().remove("vmSnapshotFlag");
        } else if (templateType == 4 || templateType == 35) {
            pg.getTemplate().getProps().put("vmSnapshotFlag", "1");
            pg.getTemplate().getProps().remove("vmSnapshotFlag" + DrmEnumDefine.ProtectLocation.A_B.getValue());
            pg.getTemplate().getProps().remove("vmSnapshotFlag" + DrmEnumDefine.ProtectLocation.A_C.getValue());
        } else if (SYNC_METRO_TEMPLATE_TYPE.contains(templateType) && pg.getTemplate().getProps().containsKey("vmSnapshotFlag")) {
            pg.getTemplate().getProps().put("vmSnapshotFlag", this.getIsReversed() != false ? (String)pg.getTemplate().getProps().get("vmSnapshotFlag") : "1");
        }
    }

    protected void refactorLocalPoReplica(ProtectGroupReplica remotePgReplica, Set<ProtectObjectReplica> replicas, Map<String, ProtectObject> poMap, Map<String, Object> params) {
        if (VerifyUtil.isEmpty(replicas) || VerifyUtil.isEmpty((Object)remotePgReplica)) {
            return;
        }
        for (ProtectObjectReplica poReplica : replicas) {
            this.refactorRelicaStorageInfo(remotePgReplica, poReplica, params);
            this.refactorVmInfoOfPoInReplica(remotePgReplica, poReplica, poMap.get(poReplica.getPoId()));
        }
    }

    private void refactorVmInfoOfPoInReplica(ProtectGroupReplica remotePgReplica, ProtectObjectReplica replica, ProtectObject newPo) {
        if (VerifyUtil.isEmpty((Object)newPo)) {
            logger.error((Object)"The protect object has removed. replica id: %s", new Object[]{replica.getId()});
            return;
        }
        ProtectObject poInReplica = replica.getProtectObject();
        ProtectGroup protectGroup = newPo.getProtectGroup();
        int type = protectGroup.getTemplate().getType();
        if (poInReplica.getPoType() != 10 || !HYPERVAULT_TEMPLATE.contains(type)) {
            return;
        }
        RelicaStorageInfo storageInfo = (RelicaStorageInfo)CommonUtil.getFirstElement((Collection)replica.getStorageInfos());
        if (VerifyUtil.isEmpty((Object)storageInfo)) {
            logger.error((Object)"no storageInfo in replica: replicaId=%s", new Object[]{replica.getId()});
            return;
        }
        logger.info((Object)"refactor localReplica vm info: newProductArray=%s, proArrayOfReplica=%s", new Object[]{remotePgReplica.getProductArray(), storageInfo.getStorageProviderSN()});
        this.setReplicaNewPo(replica, newPo);
        IProtectObjectBaseProvider provider = ((IProtectObjectProviderDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderDelegate.class)).getProviderByAppType(protectGroup.getPoType());
        provider.backUpPoMetadata(replica);
    }

    private void setReplicaNewPo(ProtectObjectReplica replica, ProtectObject protectObject) {
        ProtectObject newPo;
        try {
            Object obj = protectObject.clone();
            if (!(obj instanceof ProtectObject)) {
                logger.error((Object)"Illegal type: %s", new Object[]{obj.getClass()});
                throw new LegoCheckedException(1073947393L);
            }
            newPo = (ProtectObject)obj;
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Clone po(name:%s) failed, dev sn:%s!, error msg:%s.", new Object[]{protectObject.getName(), protectObject.getProviderSN(), ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObject poInReplica = replica.getProtectObject();
        if (poInReplica.getProps().containsKey("VMPATH")) {
            newPo.getProps().put("VMPATH", poInReplica.getProps().get("VMPATH"));
        }
        replica.setProtectObject(newPo);
    }

    protected void resetWwnMap(ProtectObject po, ProtectGroupReplica remotePgReplica, Map<String, Object> params) {
        super.caculateOToNewWwnMap(new ArrayList(po.getUsedStorageResourceSet()), (ProtectObject)CommonUtil.getFirstElement((Collection)remotePgReplica.getPg().getPolist()), params);
    }

    protected ProtectObjectReplica getProtectObjectReplica(ProtectObject protectObject, Map<String, Object> params) {
        ProtectGroup protectGroup = protectObject.getProtectGroup();
        List replicaList = Optional.ofNullable(protectGroup.listAllReplicatonRepica()).orElse(Collections.emptyList());
        Optional<ProtectGroupReplica> pgReplicaOptional = replicaList.stream().filter(protectGroupReplica -> protectGroupReplica.getProtectLocation() == DrmEnumDefine.ProtectLocation.A_B.getValue()).findFirst();
        if (!pgReplicaOptional.isPresent()) {
            logger.error((Object)"Can't get protect group replica, protect group(name: %s).", new Object[]{protectGroup.getName()});
            throw new LegoCheckedException(1073947394L);
        }
        Optional<ProtectObjectReplica> poReplicaOptional = pgReplicaOptional.get().getReplicas().stream().filter(poReplica -> poReplica.getPoId().equals(protectObject.getUuid())).findFirst();
        if (!poReplicaOptional.isPresent()) {
            logger.error((Object)"CurPoReplica is null!");
            throw new LegoCheckedException(1073947394L);
        }
        return poReplicaOptional.get();
    }
}

