/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.task.HandleScsiLunTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class AttachScsiLunSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(AttachScsiLunSubTask.class);
    private StorageResource storageResource;
    private VsphereHostSystem hostSystem;

    public AttachScsiLunSubTask() {
    }

    public AttachScsiLunSubTask(RecoveryProcessor parentProc, VsphereHostSystem hostSystem, StorageResource storageResource) {
        this.setParentProc(parentProc);
        this.storageResource = storageResource;
        this.hostSystem = hostSystem;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String lunWwn = this.storageResource.getResourceIndentifier();
        this.updateProcessNameParams(new String[]{lunWwn});
        String paramsInfoStr = HandleScsiLunTask.getHandleParameter(context, this.hostSystem, this.storageResource);
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            logger.debug((Object)("lun has already attached. paramsInfoStr = " + paramsInfoStr));
            return true;
        }
        try {
            logger.debug((Object)"into execute ettachSiciLun, params->%s", new Object[]{paramsInfoStr});
            String vcenterUuid = (String)context.getAttribute("Target_vCenter");
            this.attachIscsiLun(vcenterUuid);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("attach lun failed: %s " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{paramsInfoStr});
            return this.failure(e);
        }
        catch (Exception e) {
            logger.error((Object)("attach lun failed: %s " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{paramsInfoStr});
            return this.failure("ism.drm.recovery.vsphere.attachlun.failed", new String[]{lunWwn});
        }
        logger.info((Object)"AttachScsiLunSubTask successfully:%s", new Object[]{paramsInfoStr});
        return this.success();
    }

    private void attachIscsiLun(String vcenterUuid) {
        logger.debug((Object)"mount iscsiLun start", 90160758786816L);
        String hostMoId = this.hostSystem.getHostMoId();
        HostSystemAction action = new HostSystemAction();
        action.mountScsiLUN(vcenterUuid, hostMoId, this.storageResource.getResourceIndentifier());
        logger.debug((Object)"mount iscsiLun finished", 90160758786816L);
    }
}

