/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class CheckDatastoreSubTask
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 1033228787851522764L;
    private static final String CHECK_FAILED = "com.huawei.ism.drm.vsphere.recovery.task.CheckDatastoreSubTask.failed.";
    private static final int DEFAULT_RETRY_TYMES = 10;
    private static final String CHECKDATASTORE_RETRY_TYMES_KEY = "vmware.checkdatastore.retrytimes";
    private static final Log logger = LogFactory.getInstance(ConfigDatastoreTask.class);
    private String vcenterUuid;
    private Set<String> hostIds;
    private final transient DataStoreAction dataStoreAction = new DataStoreAction();
    private final transient HostSystemAction hostSystemAction = new HostSystemAction();

    public CheckDatastoreSubTask() {
    }

    CheckDatastoreSubTask(RecoveryProcessor parentProc, String vcenterUuid, Set<String> hostIds) {
        this.vcenterUuid = vcenterUuid;
        this.hostIds = hostIds;
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.dataStoreAction.setSnapShotNguid((Map)this.getContextRef().getAttribute("snapShotNguid"));
        long retryTimes = LegoConfig.getInstance().getNumber(CHECKDATASTORE_RETRY_TYMES_KEY, 10L);
        int i = 0;
        while ((long)i < retryTimes) {
            if (i < 3) {
                CommonUtil.sleep((long)TimeUnit.SECONDS.toMillis(5L));
            } else {
                CommonUtil.sleep((long)TimeUnit.SECONDS.toMillis(30L));
            }
            if (this.checkDatastore(true)) {
                return this.success();
            }
            ++i;
        }
        if (this.checkDatastore(false)) {
            logger.info((Object)"datastore is mounted at part esx host.");
            return this.success(CHECK_FAILED, null);
        }
        logger.error((Object)"CheckDatastoreSubTask excute failed.");
        return this.failure(CHECK_FAILED, null);
    }

    private boolean checkDatastore(boolean needCheckAllMounted) {
        List<VsphereDataStore> dataStoreList = this.dataStoreAction.queryAllValidDataStores(this.vcenterUuid);
        List resources = this.getContextRef().getObjects("Target_Storage", StorageResource.class);
        if (VerifyUtil.isEmpty(dataStoreList = this.dataStoreAction.filterDatastores(this.vcenterUuid, dataStoreList, resources))) {
            logger.error((Object)"DataStore is empty.");
            return false;
        }
        boolean isAllMounted = this.checkIsMounted(dataStoreList, needCheckAllMounted);
        List oldDataStoreList = this.getContextRef().getObjects("Target_Datastore", VsphereDataStore.class);
        boolean isDataStoreMatched = this.dataStoreAction.compareDatastore(oldDataStoreList, dataStoreList);
        logger.info((Object)"Check dataStore configuration: mount[%s], match[%s].", new Object[]{isAllMounted, isDataStoreMatched});
        return isAllMounted && isDataStoreMatched;
    }

    private boolean checkIsMounted(List<VsphereDataStore> datastores, boolean needCheckAllMounted) {
        HashSet<String> rescanHosts = new HashSet<String>();
        boolean isMounted = true;
        for (VsphereDataStore datastore : datastores) {
            for (String hostId2 : this.hostIds) {
                if (!this.dataStoreAction.isMountedToHost(this.vcenterUuid, datastore.getUuid().split(":")[1], hostId2)) {
                    logger.error((Object)"dataStore name:[%s] is not mount to host:[%s] ", new Object[]{datastore.getName(), hostId2});
                    rescanHosts.add(hostId2);
                    isMounted = false;
                    continue;
                }
                if (needCheckAllMounted) continue;
                return true;
            }
        }
        rescanHosts.forEach(hostId -> this.hostSystemAction.rescanVmfs(this.vcenterUuid, (String)hostId));
        return isMounted;
    }
}

