/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreTask;
import com.huawei.ism.drm.vsphere.recovery.task.MountDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.RecoveryAlternateTargetPreparer;
import com.huawei.ism.drm.vsphere.recovery.task.RegisterVMSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public class CleanResourcePrepare
extends RecoveryAlternateTargetPreparer {
    private static final Log logger = LogFactory.getInstance(CleanResourcePrepare.class);
    private static final String REGISTERED_VM_SQL = "select a.VMNAME, a.DCMOID, a.VMXFILEPATH, a.VMMOID, a.TEMPLATEFLAG b.PROCSTATUS from ti_vs_initvmsubprocessor a , ti_recoveryprocessor b where a.PROCID=b.PROCID and b.PLANID =:planId and b.PROCTYPE =:procType";
    private static final String CONFIG_DATASTORE_SQL = "select a.NEWDATASTOREUUID, a.NEWDATASTORENAME from ti_vs_configdatastoresubprocessor , ti_recoveryprocessor b where a.PROCID=b.PROCID and b            + .PLANID =:planId and b.procType =:procType";
    private static final int VMNAME = 0;
    private static final int DCMOID = 1;
    private static final int VMXPATH = 2;
    private static final int VMMOID = 3;
    private static final int PROCSTATUS = 5;
    private static final int NEWDATASTOREUUID = 0;
    private static final int NEWDATASTORENAME = 1;

    public CleanResourcePrepare(BaseRecoveryProcessor processor) {
        super(processor);
    }

    @Override
    public void prepareTargetVirtualMachine(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        RecoveryPlan plan = context.getRecoveryPlan();
        Assert.notNull((Object)plan, (String)"Connot find recovery plan from recovery context.");
        List<RecoveryProcessor> registerVmProcesses = BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)recoveryPlan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)Integer.parseInt(this.getRefProcType())), RegisterVMSubTask.class);
        if (null == registerVmProcesses || registerVmProcesses.isEmpty()) {
            registerVmProcesses = this.loadOldRegisteredVMProcessor(recoveryPlan.getPlanId());
        }
        ArrayList<VsphereVirtualMachine> virtualMachineList = new ArrayList<VsphereVirtualMachine>();
        for (RecoveryProcessor processor : registerVmProcesses) {
            if (!(processor instanceof RegisterVMSubTask)) continue;
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != processor.getProcStatus()) {
                logger.debug((Object)"Register vm[%s] sub task failed, do not need to unregister.", new Object[]{((RegisterVMSubTask)processor).getVmName()});
                continue;
            }
            RegisterVMSubTask task = (RegisterVMSubTask)processor;
            VsphereVirtualMachine virtualMachine = new VsphereVirtualMachine();
            virtualMachine.setVmMoId(task.getVmMoId());
            virtualMachine.setUuid(task.getVmMoId());
            virtualMachine.setDcMoId(task.getDcMoId());
            virtualMachine.setVmPath(task.getVmPath());
            virtualMachine.setName(task.getVmName());
            virtualMachineList.add(virtualMachine);
        }
        this.prepareDeleteRdmDiskVms(context);
        context.setAttribute("Target_VM", virtualMachineList);
    }

    private void prepareDeleteRdmDiskVms(RecoveryProcessorContext context) {
        RecoveryPlan plan = context.getRecoveryPlan();
        String rdmVmStr = (String)plan.getGlobalSettings().get("Rdm_Target_VM");
        JSONArray array = JSONArray.fromObject((Object)rdmVmStr);
        if (array.size() == 0) {
            return;
        }
        List rdmVmList = JSONArray.toCollection((JSONArray)array, VsphereVirtualMachine.class);
        context.setAttribute("Rdm_Target_VM", (Object)rdmVmList);
    }

    @Override
    protected void prepareTargetDatastore(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        RecoveryPlan plan = context.getRecoveryPlan();
        Assert.notNull((Object)plan, (String)"Connot find recovery plan from recovery context.");
        List configDatastoreProcesses = BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)plan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)Integer.parseInt(this.getRefProcType())), ConfigDatastoreTask.class);
        if (null == configDatastoreProcesses || configDatastoreProcesses.isEmpty()) {
            logger.info((Object)"Config datastroe task is not exists,try to load old processor before upgrade...");
            Set<RecoveryProcessor> processors = this.loadOldConfigDatastoreProcessor(plan.getPlanId());
            this.prepareTargetDatastore(context, processors);
        } else {
            RecoveryProcessor configDatastoreTask = (RecoveryProcessor)configDatastoreProcesses.get(0);
            Set subTasks = configDatastoreTask.getChildProc();
            this.prepareTargetDatastore(context, subTasks);
        }
    }

    private void prepareTargetDatastore(RecoveryProcessorContext context, Set<RecoveryProcessor> subTasks) {
        if (null == subTasks || subTasks.isEmpty()) {
            logger.warn((Object)"Config datastore sub task is null.");
            context.setAttribute("Target_Datastore", Collections.emptyList());
            return;
        }
        ArrayList<VsphereDataStore> vsphereDataStoreList = new ArrayList<VsphereDataStore>();
        for (RecoveryProcessor processor : subTasks) {
            if (!(processor instanceof ConfigDatastoreSubTask) || processor.getProcStatus() != DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) continue;
            ConfigDatastoreSubTask task = (ConfigDatastoreSubTask)processor;
            VsphereDataStore dataStore = new VsphereDataStore();
            dataStore.setName(task.getTargetDatastoreName());
            dataStore.setUuid(task.getTargetDatastoreUuid());
            vsphereDataStoreList.add(dataStore);
        }
        context.setAttribute("Target_Datastore", vsphereDataStoreList);
    }

    private List<RecoveryProcessor> loadOldRegisteredVMProcessor(String planId) {
        Integer procType = Integer.valueOf(this.getRefProcType());
        ArrayList<RecoveryProcessor> results = new ArrayList<RecoveryProcessor>();
        List objects = CommonDAOLocator.getBaseDao().executeNativeSql(REGISTERED_VM_SQL, new Object[]{planId, procType});
        if (null == objects || objects.isEmpty()) {
            logger.error((Object)"Cannot get old Registered VM proccessor before upgrade from database");
            return results;
        }
        for (Object object : objects) {
            if (!(object instanceof Object[])) continue;
            Object[] values = (Object[])object;
            RegisterVMSubTask task = new RegisterVMSubTask();
            task.setVmName(CommUtil.convertToString((Object)values[0]));
            task.setDcMoId(CommUtil.convertToString((Object)values[1]));
            task.setVmPath(CommUtil.convertToString((Object)values[2]));
            task.setVmMoId(CommUtil.convertToString((Object)values[3]));
            task.setProcStatus(CommUtil.convertToInteger((Object)values[5]));
            results.add((RecoveryProcessor)task);
        }
        return results;
    }

    private Set<RecoveryProcessor> loadOldConfigDatastoreProcessor(String planId) {
        Integer procType = Integer.valueOf(this.getRefProcType());
        HashSet<RecoveryProcessor> results = new HashSet<RecoveryProcessor>();
        List objects = CommonDAOLocator.getBaseDao().executeNativeSql(CONFIG_DATASTORE_SQL, new Object[]{planId, procType});
        if (null == objects || objects.isEmpty()) {
            logger.error((Object)"Cannot get config datastore proccessor before upgrade from database");
            return results;
        }
        for (Object object : objects) {
            if (!(object instanceof Object[])) continue;
            Object[] values = (Object[])object;
            MountDatastoreSubTask dataStore = new MountDatastoreSubTask();
            dataStore.setTargetDatastoreUuid(CommUtil.convertToString((Object)values[0]));
            dataStore.setTargetDatastoreName(CommUtil.convertToString((Object)values[1]));
            results.add((RecoveryProcessor)dataStore);
        }
        return results;
    }
}

