/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.sdk.model.ResourceVO;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.recovery.process.CreateLunSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.CreateReplicationSubProcessor;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.process.VmRollbackMappingLunSubProcessor;
import com.huawei.ism.drm.vsphere.recovery.task.CleanTestResourcePrepare;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CleanVmResourcePreparer
extends CleanTestResourcePrepare {
    private static final Log logger = LogFactory.getInstance(CleanVmResourcePreparer.class);
    private static final String WWN_REFER_TO_DATASTORE = "wwnReferToDatastore";

    public CleanVmResourcePreparer(BaseRecoveryProcessor processor) {
        super(processor);
    }

    @Override
    public boolean before() {
        BaseRecoveryProcessor processor = this.getInterceptTask();
        RecoveryProcessorContext context = processor.getContextRef();
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"Recovery context is null");
            throw new LegoCheckedException(1073947393L);
        }
        this.prepareTargetLun(context);
        this.prepareRemoteRecoveryTask(context);
        this.prepareMappingLunProcessors(context);
        return super.before();
    }

    @Override
    public void prepareTargetVirtualMachine(RecoveryProcessorContext context) {
        super.prepareTargetVirtualMachine(context);
        List registeredVmListFromDb = (List)context.getAttribute("Target_VM");
        String registeredSuffix = ":migrated";
        Map toDeleteVmMap = registeredVmListFromDb.stream().filter(vm -> !vm.getName().endsWith(registeredSuffix)).collect(Collectors.toMap(VsphereVirtualMachine::getVmMoId, Function.identity()));
        ArrayList targetVms = new ArrayList();
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            logger.warn((Object)"vCenter is empty.");
            context.setAttribute("Target_VM", targetVms);
            return;
        }
        VmwareConnection vmwareConnection = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuid);
        VMAction vmAction = new VMAction();
        List<VsphereVirtualMachine> vmFromVmware = vmAction.queryAllVms(vmwareConnection);
        HashMap dataCenter = new HashMap();
        vmFromVmware.stream().filter(vm -> toDeleteVmMap.containsKey(vm.getVmMoId()) && ((VsphereVirtualMachine)toDeleteVmMap.get(vm.getVmMoId())).getName().equals(vm.getName())).forEach(vm -> this.fillToList(targetVms, vCenterUuid, dataCenter, (VsphereVirtualMachine)vm));
        context.setAttribute("Target_VM", targetVms);
    }

    private void fillToList(List<VsphereVirtualMachine> targetVms, String vCenterUuid, Map<String, VsDataCenter> dataCenter, VsphereVirtualMachine vm) {
        String dataCenterId = this.getDatacenterMoId(dataCenter, vCenterUuid, vm);
        vm.setDcMoId(dataCenterId);
        targetVms.add(vm);
    }

    private String getDatacenterMoId(Map<String, VsDataCenter> dataCenterMap, String vCenterUuid, VsphereVirtualMachine vm) {
        if (dataCenterMap.containsKey(vCenterUuid)) {
            return dataCenterMap.get(vCenterUuid).getMoId();
        }
        VsDataCenter center = VsphereVirtualMachineUtils.findDataCenter(vm, vCenterUuid);
        dataCenterMap.put(vCenterUuid, center);
        VerifyUtil.checkObject((Object)center);
        return center.getMoId();
    }

    @Override
    protected void prepareTargetDatastore(RecoveryProcessorContext context) {
        super.prepareTargetDatastore(context);
        context.removeAttribute("datastoreChangeMap");
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            logger.info((Object)"vCenter is empty.");
            context.setAttribute("Target_Datastore", Collections.emptyList());
            return;
        }
        DataStoreAction dataStoreAction = new DataStoreAction();
        List<VsphereDataStore> dataStoreListFromVcenter = dataStoreAction.queryAllDsWithoutValidate(vCenterUuid);
        Set dsUuidSetFromVcenter = dataStoreListFromVcenter.stream().map(ds -> VsphereCommUtil.getDatastoreId(ds.getUrl())).collect(Collectors.toSet());
        List targetDatastores = (List)context.getAttribute("Target_Datastore");
        List newTargetDatastoreList = targetDatastores.stream().filter(ds -> dsUuidSetFromVcenter.contains(ds.getUuid())).collect(Collectors.toList());
        context.setAttribute("Target_Datastore", newTargetDatastoreList);
    }

    @Override
    public void prepareTargetStoreageResource(RecoveryProcessorContext context) {
        super.prepareTargetStoreageResource(context);
        List targetResource = (List)context.getAttribute("Target_Storage");
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)vCenterUuid)) {
            logger.warn((Object)"vCenterUuid is empty.");
            context.setAttribute("Target_Storage", Collections.emptyList());
            return;
        }
        ProtectGroup protectGroup = context.getProtectGroup();
        VerifyUtil.checkObject((Object)protectGroup);
        context.setAttribute("Target_Storage", (Object)targetResource);
    }

    @Override
    public void prepareTargetHost(RecoveryProcessorContext context) {
        try {
            Object hostObj = context.getAttribute("Target_Host");
            if (!VerifyUtil.isEmpty((Object)hostObj)) {
                return;
            }
            super.prepareTargetHost(context);
        }
        catch (Exception e) {
            logger.error((Object)"prepare host failed: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            context.setAttribute("Target_Host", Collections.emptyList());
        }
    }

    @Override
    public void prepareTargetVCenter(RecoveryProcessorContext context) {
        try {
            if (!VerifyUtil.isEmpty((Object)context.getAttribute("Target_vCenter"))) {
                return;
            }
            super.prepareTargetVCenter(context);
        }
        catch (Exception e) {
            logger.error((Object)"error for clean prepare: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private void prepareTargetLun(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List recoveryProcessors = BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)recoveryPlan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)Integer.parseInt(this.getRefProcType())), CreateLunSubProcessor.class);
        String productArray = context.getProtectGroupReplica().getProductArray();
        List createLunSubProcessorList = recoveryProcessors.stream().filter(processor -> processor instanceof CreateLunSubProcessor).map(processor -> (CreateLunSubProcessor)processor).filter(createLunSubProcessor -> DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == createLunSubProcessor.getProcStatus()).filter(createLunSubProcessor -> productArray.equals(createLunSubProcessor.getDeviceId())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(createLunSubProcessorList)) {
            return;
        }
        HashMap<String, Lun> lunMap = new HashMap<String, Lun>();
        for (CreateLunSubProcessor createLunSubProcessor2 : createLunSubProcessorList) {
            Lun lun = new Lun();
            lun.setName(createLunSubProcessor2.getLunName());
            lun.setLunId(createLunSubProcessor2.getLunId());
            lun.setDevSn(createLunSubProcessor2.getDeviceId());
            lun.setWwn(createLunSubProcessor2.getLunWwn());
            lunMap.put(lun.getName(), lun);
        }
        context.setAttribute("lunToBeCreated", lunMap);
    }

    private void prepareRemoteRecoveryTask(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List recoveryProcessors = BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)recoveryPlan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)Integer.parseInt(this.getRefProcType())), CreateReplicationSubProcessor.class);
        String productArray = context.getProtectGroupReplica().getProductArray();
        List createReplicationProcessorList = recoveryProcessors.stream().filter(processor -> processor instanceof CreateReplicationSubProcessor).map(processor -> (CreateReplicationSubProcessor)processor).filter(createReplicationSubProcessor -> !VerifyUtil.isEmpty((String)createReplicationSubProcessor.getReplicationId())).filter(processor -> productArray.equals(processor.getTargetDevSn())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(createReplicationProcessorList)) {
            return;
        }
        String productSiteId = (String)context.getAttribute("DISASTER_SITE_ID", String.class);
        String disasterSiteId = (String)context.getAttribute("PRODUCT_SITE_ID", String.class);
        ISiteService siteService = (ISiteService)ServiceLocator.getInstance().getService(ISiteService.class);
        Site productionSite = VerifyUtil.isEmpty((String)productSiteId) ? null : siteService.getSiteById(productSiteId);
        Site disasterSite = VerifyUtil.isEmpty((String)productSiteId) ? null : siteService.getSiteById(disasterSiteId);
        ArrayList<RecoveryTask> recoveryTaskList = new ArrayList<RecoveryTask>();
        for (CreateReplicationSubProcessor createReplicationSubProcessor2 : createReplicationProcessorList) {
            RecoveryTask recoveryTask = new RecoveryTask();
            recoveryTask.setProtectId(createReplicationSubProcessor2.getReplicationId());
            recoveryTask.setProductionSite(productionSite);
            recoveryTask.setDisasterSite(disasterSite);
            recoveryTask.setRecoveryPlanId(createReplicationSubProcessor2.getPlanId());
            recoveryTask.setProtectType(ReplicationConstantDefine.ReplicationDescription.HYPER_MIRROR.getValue());
            String srcDevSn = createReplicationSubProcessor2.getSrcDevSn();
            String tgtDevSn = createReplicationSubProcessor2.getTargetDevSn();
            String srcResourceId = createReplicationSubProcessor2.getSrcResourceId();
            String tgtResourceId = createReplicationSubProcessor2.getTargetDevSn();
            recoveryTask.setProtectName(createReplicationSubProcessor2.getRemoteResourceName());
            recoveryTask.setSrcDeviceId(srcDevSn);
            recoveryTask.setTgtDevcieId(tgtDevSn);
            recoveryTask.setSrcStorageIds(Collections.singleton(srcDevSn + ":" + srcResourceId));
            recoveryTask.setTgtStorageIds(Collections.singleton(tgtDevSn + ":" + tgtResourceId));
            recoveryTaskList.add(recoveryTask);
        }
        context.setAttribute("remoteRecoveryTasks", recoveryTaskList);
    }

    private void prepareMappingLunProcessors(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List recoveryProcessors = BaseRecoveryProcessor.getRecoveryPlanRecoveryProcessors((RecoveryPlan)recoveryPlan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)Integer.parseInt(this.getRefProcType())), VmRollbackMappingLunSubProcessor.class);
        String productArray = context.getProtectGroupReplica().getProductArray();
        Iterator iterator = recoveryProcessors.iterator();
        while (iterator.hasNext()) {
            RecoveryProcessor recoveryProcessor = (RecoveryProcessor)iterator.next();
            if (!(recoveryProcessor instanceof VmRollbackMappingLunSubProcessor)) {
                iterator.remove();
                continue;
            }
            VmRollbackMappingLunSubProcessor mappingLunSubProcessor = (VmRollbackMappingLunSubProcessor)recoveryProcessor;
            if (mappingLunSubProcessor.getProcStatus() != DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() || !productArray.equals(mappingLunSubProcessor.getDeviceSn())) {
                iterator.remove();
                continue;
            }
            ResourceVO resourceVo = RecoveryToolsUtil.getInstance().getResourceVO(mappingLunSubProcessor.getHostOrGroupId());
            if (resourceVo == null) {
                iterator.remove();
                continue;
            }
            mappingLunSubProcessor.setResourceVo(resourceVo);
        }
        context.setAttribute("mappingForVmRecovery", (Object)recoveryProcessors);
    }
}

