/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigLinuxVMIpAddressSubTask;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VCenterNicIpInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VsNetWork;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ArrayOfVirtualDevice;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualDevice;
import com.huawei.vmware.vim25.VirtualEthernetCard;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class ConfigVMIpAddressSubTask
extends BaseRecoveryProcessor {
    protected static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.";
    protected static final String CONFIGIP_CONFIG_ERROR = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.configiperror";
    protected static final String CONFIG_IP_ADDRESS_FAILED = "com.huawei.ism.drm.vsphere.recovery.task.configIpAddress.failed";
    protected static final Log logger = LogFactory.getInstance(ConfigLinuxVMIpAddressSubTask.class);
    protected static final String IP_ADDRESS_CONFIGED = "add_address_has_configed";
    protected static final String IP_ADDRESS_NO_NEED_CONFIGED = "ip_address_no_need_config";
    protected static final String UNKOWN_GUEST_OS_CANNOT_CONFIG_IP = "unkown_guest_os_connot_config_ip";
    protected static final String NETWORK_ADAPTER_AUTOCONNECT_FAILED = "config_network_adpater_auto_connect_failed";
    protected static final String CONFIGNETWORK_FAILED = "com.huawei.ism.drm.vsphere.recovery.process.VsCfgVmSubProcessor.configVmNetwork.failed";
    private static final String MAC_MAP = "virtualEthernetCardMacMap";
    private VsphereVirtualMachine virtualMachine = null;

    public ConfigVMIpAddressSubTask() {
    }

    public ConfigVMIpAddressSubTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc) {
        this.virtualMachine = virtualMachine;
        this.setParentProc(parentProc);
    }

    public VsphereVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public void setVirtualMachine(VsphereVirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String nameParams = null == this.virtualMachine ? "-" : this.virtualMachine.getName();
        this.updateProcessNameParams(new String[]{nameParams});
        boolean result = this.configVmIp(context);
        logger.info((Object)"config vm[%s] ip result = %s", new Object[]{nameParams, result});
        return this.updateExecuteResult(result);
    }

    protected boolean configVmIp(RecoveryProcessorContext context) {
        boolean cfgNetResult;
        if (null == this.virtualMachine || null == this.virtualMachine.getNetworkAdapterInfo()) {
            logger.error((Object)"params error.");
            return false;
        }
        String vmName = this.virtualMachine.getName();
        this.updateProcessNameParams(new String[]{vmName});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail(IP_ADDRESS_CONFIGED, new String[0]);
            logger.debug((Object)"VM[%s] IP address has already started", new Object[]{vmName});
            return true;
        }
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        String vmMoId = this.getVirtualMachine().getVmMoId();
        Map<String, VsNetWork> vmNetwork = VsphereRecoveryUtils.buildRecoveryNetworkInfo(this.virtualMachine, context);
        VMAction action = new VMAction();
        boolean isKeepMac = VsphereRecoveryUtils.getKeepMacParam(context);
        Map<String, Object> keepMacMap = this.getKeepMacMap(isKeepMac);
        if (!this.needCfgIp(context)) {
            logger.info((Object)"VM[%s] IP address config is empty, no need to config ip.", new Object[]{vmName});
            boolean isCfgNetResult = isKeepMac ? action.configVMNetWorks(vcenterUuid, vmMoId, vmNetwork, true, keepMacMap) : action.configVMNetWorks(vcenterUuid, vmMoId, vmNetwork, true);
            return this.checkCfgNetResult(vmName, isCfgNetResult);
        }
        if (!this.startVm(vcenterUuid, vmMoId, vmName)) {
            logger.error((Object)("startupVm failed " + vmName), 90160758786989L);
            return false;
        }
        Map<String, VCenterNicIpInfo> configMap = this.getConfigParamMap(context);
        boolean configResult = this.configVmIpAddr(context, configMap);
        if (configResult && !(cfgNetResult = isKeepMac ? action.configVMNetWorks(vcenterUuid, vmMoId, vmNetwork, true, keepMacMap) : action.configVMNetWorks(vcenterUuid, vmMoId, vmNetwork, true))) {
            logger.error((Object)"change network to auto connect true failed");
            this.updateProcessDetail(NETWORK_ADAPTER_AUTOCONNECT_FAILED, new String[0]);
            return cfgNetResult;
        }
        return configResult;
    }

    private boolean checkCfgNetResult(String vmName, boolean isCfgNetResult) {
        if (isCfgNetResult) {
            this.updateProcessDetail(IP_ADDRESS_NO_NEED_CONFIGED, new String[0]);
            return true;
        }
        logger.error((Object)"change network to auto connect true failed. vmName:%s", new Object[]{vmName});
        this.updateProcessDetail(NETWORK_ADAPTER_AUTOCONNECT_FAILED, new String[0]);
        return false;
    }

    private Map<String, Object> getKeepMacMap(boolean isKeepMac) {
        HashMap<String, Object> keepMacMap = new HashMap<String, Object>();
        if (isKeepMac) {
            Map<String, String> virtualEthernetCardMacMap = VsphereRecoveryUtils.buildRecoveryMacInfo(this.virtualMachine);
            keepMacMap.put("keepMac", isKeepMac);
            keepMacMap.put(MAC_MAP, virtualEthernetCardMacMap);
        }
        return keepMacMap;
    }

    protected boolean startVm(String vcenterUuid, String vmMoId, String vmName) {
        boolean ret = false;
        VMAction action = new VMAction();
        try {
            VirtualMachinePowerState powserState = action.getVMPowerState(vcenterUuid, vmMoId);
            if (VirtualMachinePowerState.POWERED_OFF == powserState) {
                action.powerOnVM(vcenterUuid, vmMoId);
            }
            for (int i = 0; i < 50; ++i) {
                VirtualMachineToolsRunningStatus state = action.getGuestVMToolState(vcenterUuid, vmMoId);
                if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING == state) {
                    logger.info((Object)("start VM " + vmName + " sucessfully"), 90160758786988L);
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
            if (!ret) {
                this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("start vm start failed " + vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)("start vm start failed " + vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail(CONFIGNETWORK_FAILED, new String[0]);
        }
        logger.debug((Object)"start vm[%s] result=%s", new Object[]{vmName, ret});
        return ret;
    }

    abstract boolean configVmIpAddr(RecoveryProcessorContext var1, Map<String, VCenterNicIpInfo> var2);

    protected Map<String, VCenterNicIpInfo> getConfigParamMap(RecoveryProcessorContext context) {
        logger.debug((Object)"getConfigParamMap start");
        Map map = this.virtualMachine.getNetworkAdapterInfo();
        RecoveryPlan plan = context.getRecoveryPlan();
        Map<String, String> nameAndRealMacMap = this.getNameAndMacMap(context);
        HashMap<String, VCenterNicIpInfo> configMap = new HashMap<String, VCenterNicIpInfo>();
        for (Map.Entry entry : map.entrySet()) {
            String mac = (String)entry.getKey();
            String ipInfo = this.getIpInfo(mac, plan);
            if (VerifyUtil.isEmpty((String)ipInfo)) continue;
            String realMac = nameAndRealMacMap.get(entry.getValue()).replaceAll(":", "-").toUpperCase(Locale.US);
            VCenterNicIpInfo cfg = (VCenterNicIpInfo)JSONObject.toBean((String)ipInfo, VCenterNicIpInfo.class);
            configMap.put(realMac, cfg);
        }
        return configMap;
    }

    protected Map<String, String> getNameAndMacMap(RecoveryProcessorContext context) {
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        String vmMoId = this.virtualMachine.getVmMoId();
        HashMap<String, String> map = new HashMap<String, String>();
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        ManagedObjectReference vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(vmMoId);
        ArrayOfVirtualDevice array = (ArrayOfVirtualDevice)GetMoPropsValueUtils.getInstance().entityProps(conn, vmMor, new String[]{"config.hardware.device"}).get("config.hardware.device");
        if (null == array) {
            return map;
        }
        for (VirtualDevice dev : array.getVirtualDevice()) {
            if (!(dev instanceof VirtualEthernetCard)) continue;
            map.put(dev.getDeviceInfo().getLabel(), ((VirtualEthernetCard)dev).getMacAddress());
        }
        return map;
    }

    protected boolean shutdownVm(RecoveryProcessorContext context) {
        boolean ret = false;
        String vmName = this.virtualMachine.getName();
        String vmMoId = this.virtualMachine.getVmMoId();
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        try {
            VMAction action = new VMAction();
            action.shutdownGuest(vcenterUuid, vmMoId);
            ret = action.checkVmShutdownResultAndWait(vmMoId, vcenterUuid);
            if (!ret) {
                this.updateProcessDetail(CONFIG_IP_ADDRESS_FAILED, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            this.updateProcessDetail(e);
            logger.error((Object)(vmName + " rebootVm  failed: "), (Throwable)e, 90160758786989L);
        }
        catch (Exception e) {
            logger.error((Object)(vmName + " rebootVm  failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            this.updateProcessDetail(CONFIG_IP_ADDRESS_FAILED, new String[0]);
        }
        logger.info((Object)(vmName + " rebootVm  result is " + ret), 90160758786988L);
        return ret;
    }

    private boolean needCfgIp(RecoveryProcessorContext context) {
        Map map = this.virtualMachine.getNetworkAdapterInfo();
        boolean hasCfgedIP = false;
        for (Map.Entry entry : map.entrySet()) {
            String mac = (String)entry.getKey();
            String ipInfo = this.getIpInfo(mac, context.getRecoveryPlan());
            if (VerifyUtil.isEmpty((String)ipInfo)) continue;
            hasCfgedIP = true;
            break;
        }
        return hasCfgedIP;
    }

    private String getIpInfo(String mac, RecoveryPlan plan) {
        logger.debug((Object)"getIpInfo start");
        String poId = this.virtualMachine.getUuid();
        String key = "IPV4:" + mac;
        Set recoverySettingSet = plan.getRecoverySettings();
        String ipInfo = "";
        for (RecoverySetting setting : recoverySettingSet) {
            if (setting == null || !setting.getOwnerId().equals(poId) || !key.equals(setting.getName())) continue;
            ipInfo = setting.getValue();
            break;
        }
        return ipInfo;
    }
}

