/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.base.util.ResourceLockUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.sdk.model.VmConfigRdmInfo;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public class ConfigVirtualMachineRdmDiskSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(ConfigVirtualMachineRdmDiskSubTask.class);
    private static final String RDM_DISK = "rdm_disk_";
    private VmConfigRdmInfo vmConfigRdmInfo;
    private DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E operateType;

    public ConfigVirtualMachineRdmDiskSubTask() {
    }

    public ConfigVirtualMachineRdmDiskSubTask(VmConfigRdmInfo vmConfigRdmInfo, DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E operateType) {
        this.vmConfigRdmInfo = vmConfigRdmInfo;
        this.operateType = operateType;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        String rdmDiskFileName = this.vmConfigRdmInfo.getRdmDiskFileName();
        logger.debug((Object)"Config rdm disk[%s] start.", new Object[]{rdmDiskFileName});
        this.updateProcessNameParams(new String[]{rdmDiskFileName.substring(rdmDiskFileName.lastIndexOf("/") + 1)});
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.rdm.already.config", new String[0]);
            return true;
        }
        try {
            boolean result = this.configRdmDisk(context);
            if (result) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                logger.debug((Object)"Config rdm disk[%s] succeed.", new Object[]{rdmDiskFileName});
            } else {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigRDMSubProcessor.fail", null);
                logger.debug((Object)"Config rdm disk[%s] failed.", new Object[]{rdmDiskFileName});
            }
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail(e);
            logger.error((Object)String.format("Config rdm disk[%s] failed.", rdmDiskFileName), (Throwable)e);
        }
        catch (Exception e) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.process.VsConfigRDMSubProcessor.fail", null);
            logger.error((Object)String.format("Config rdm disk[%s] failed.", rdmDiskFileName), (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configRdmDisk(RecoveryProcessorContext context) {
        boolean result;
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        List hostSystemList = context.getObjects("Target_Host", VsphereHostSystem.class);
        String lunPath = "";
        String storageResourceWwn = this.vmConfigRdmInfo.getStorageResourceWwn();
        for (VsphereHostSystem host : hostSystemList) {
            String hostMoId = host.getHostMoId();
            logger.info((Object)"config rdm disk, vCenterUuid[%s], hostMoId[%s], WWN[%s].", new Object[]{vCenterUuid, hostMoId, storageResourceWwn});
            VerifyUtil.checkObjs((Object[])new Object[]{vCenterUuid, hostMoId, storageResourceWwn});
            HostSystemAction hostAction = new HostSystemAction();
            lunPath = hostAction.queryScsiLunByHost(vCenterUuid, hostMoId, storageResourceWwn);
        }
        String dataCenterMoId = this.vmConfigRdmInfo.getDcMoId();
        String dataStoreMoId = this.vmConfigRdmInfo.getDataStore().getUuid().split(":")[1];
        String dataStoreName = this.vmConfigRdmInfo.getDataStore().getName();
        String rdmDiskFileName = this.vmConfigRdmInfo.getRdmDiskFileName();
        int diskType = this.vmConfigRdmInfo.getDiskType();
        DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E type = DrmVsphereEnumDefine.VSPHERE_VIRTUALDISK_TYPE_E.getType((int)diskType);
        logger.info((Object)"config rdm disk, lunPath[%s], dcMoId[%s], DataStoreMoId[%s], DataStoreName[%s], rdmDiskFileName[%s], type[%s].", new Object[]{lunPath, dataCenterMoId, dataStoreMoId, dataStoreName, rdmDiskFileName, diskType});
        VerifyUtil.checkObjs((Object[])new Object[]{lunPath, dataCenterMoId, dataStoreName, dataStoreMoId, rdmDiskFileName, type});
        VMAction vmAction = new VMAction();
        if (this.isMappingRdmToVm(context) && this.operateType != null) {
            result = vmAction.configMappingVmRdmDisk(vCenterUuid, this.vmConfigRdmInfo, lunPath, type, this.operateType);
            if (result) {
                this.updateRecoveryPlanGlobalSetting(context, this.operateType);
            }
        } else {
            String lockRes = ResourceLockUtil.lockRes((String)rdmDiskFileName, (String)RDM_DISK);
            try {
                result = vmAction.reconfigRdmDisk(vCenterUuid, dataCenterMoId, dataStoreMoId, lunPath, rdmDiskFileName, type);
            }
            finally {
                ResourceLockUtil.unlockRes((String)lockRes);
            }
        }
        logger.debug((Object)"Config rdm disk result: %s", new Object[]{result});
        return result;
    }

    private boolean isMappingRdmToVm(RecoveryProcessorContext context) {
        List targetVms = (List)context.getAttribute("Rdm_Target_VM");
        if (CollectionUtils.isEmpty((Collection)targetVms)) {
            return false;
        }
        Optional<VsphereVirtualMachine> opt = targetVms.stream().filter(targetVm -> Objects.equals(targetVm.getUuid(), this.vmConfigRdmInfo.getVirtualMachine().getUuid())).findAny();
        return opt.isPresent() && this.operateType != null;
    }

    private void updateRecoveryPlanGlobalSetting(RecoveryProcessorContext context, DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E operateType) {
        if (operateType == DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E.REMOVE) {
            return;
        }
        RecoveryPlan plan = context.getRecoveryPlan();
        String rdmVmStr = (String)plan.getGlobalSettings().get("Rdm_Target_VM");
        JSONArray array = JSONArray.fromObject((Object)rdmVmStr);
        List rdmVmList = array.size() == 0 ? new ArrayList() : JSONArray.toCollection((JSONArray)array, VsphereVirtualMachine.class);
        Optional<VsphereVirtualMachine> opt = rdmVmList.stream().filter(vm -> vm.getUuid().equals(this.vmConfigRdmInfo.getVirtualMachine().getUuid())).findAny();
        if (!opt.isPresent()) {
            rdmVmList.add(this.vmConfigRdmInfo.getVirtualMachine());
        }
        context.getRecoveryPlan().getGlobalSettings().put("Rdm_Target_VM", ((Object)rdmVmList).toString());
    }
}

