/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigMigratedVmDiskTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigVirtualMachineRdmDiskTask;
import com.huawei.ism.drm.vsphere.recovery.task.DeleteVmFromDiskSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.IMigrateVmTask;
import com.huawei.ism.drm.vsphere.recovery.task.MigrateResourceOnlySubTask;
import com.huawei.ism.drm.vsphere.recovery.task.RegisterVMSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.RenameVmSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.UnregisterVMSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.VmRollbackRdmTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.ism.drm.vsphere.sdk.util.DrmVsphereEnumDefine;
import com.huawei.ism.drm.vsphere.sdk.util.VsphereAppConstants;
import com.huawei.ism.drm.vsphere.tools.VsphereCommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MigrateResourceOnlyTask
extends BaseRecoveryProcessor
implements IMigrateVmTask {
    public static final String REUSE_RDM_WWN = "REUSE_RDM_WWN";
    public static final String MIGRATED_SUFFIX = "migrated";
    private static final String BAK_SUFFIX = "bak";
    private static final Log logger = LogFactory.getInstance(MigrateResourceOnlyTask.class);
    private VsphereVirtualMachine targetVm;

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateMigrateSubTask(context, this.targetVm);
        this.updateProcessNameParams(new String[]{this.targetVm.getName()});
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(new ArrayList(this.getChildProc()), null);
        VerifyUtil.checkObjs((Object[])new Object[]{executor});
        executor.process(context);
        DrmEnumDefine.RecoveryPlanExecuteResultE resultE = this.calcProcStatusBySubProc(this.getChildProc());
        this.setProcStatus(resultE.getValue());
        return resultE == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS;
    }

    private void updateMigrateSubTask(RecoveryProcessorContext context, VsphereVirtualMachine vm) {
        VsphereVirtualMachine oldVm = this.findVmInReplica(vm, context);
        Optional<VsphereVirtualMachine> targetVmToDelete = this.checkAndGetVmToDelete(oldVm, context);
        LinkedHashSet<RecoveryProcessor> subMigrateProcessor = new LinkedHashSet<RecoveryProcessor>();
        this.createRenameTaskForOldVm(targetVmToDelete.orElse(null), subMigrateProcessor);
        RenameVmSubTask renameVmForSnapshot = new RenameVmSubTask();
        renameVmForSnapshot.setVm(vm);
        renameVmForSnapshot.setOriginalName(vm.getName());
        renameVmForSnapshot.setTargetName(oldVm.getName());
        renameVmForSnapshot.setParentProc((RecoveryProcessor)this);
        subMigrateProcessor.add((RecoveryProcessor)renameVmForSnapshot);
        subMigrateProcessor.add((RecoveryProcessor)this.createMigrateResourceOnlySubTask(context, vm, oldVm));
        subMigrateProcessor.add(this.createDeleteVmSubTask(context, vm, targetVmToDelete.orElse(null)));
        this.configForRdm(context, vm, oldVm, subMigrateProcessor);
        UnregisterVMSubTask unregisterVMSubTask = new UnregisterVMSubTask(vm, (RecoveryProcessor)this);
        subMigrateProcessor.add((RecoveryProcessor)unregisterVMSubTask);
        ConfigMigratedVmDiskTask configVmDiskTask = this.createConfigMigratedVmDiskTask(context, vm);
        subMigrateProcessor.add((RecoveryProcessor)configVmDiskTask);
        VsphereVirtualMachine registerTempVm = this.createTempVm(vm);
        registerTempVm.setName(oldVm.getName());
        RegisterVMSubTask registerVMSubTask = new RegisterVMSubTask(registerTempVm, (RecoveryProcessor)this);
        subMigrateProcessor.add((RecoveryProcessor)registerVMSubTask);
        context.removeAttribute("NameSuffixKey");
        this.setChildProc(subMigrateProcessor);
    }

    private void createRenameTaskForOldVm(VsphereVirtualMachine targetVm, Set<RecoveryProcessor> subMigrateProcessor) {
        RenameVmSubTask renameVmForOldVm = new RenameVmSubTask();
        if (VerifyUtil.isEmpty((Object)targetVm)) {
            logger.info((Object)"no old vm to rename");
            return;
        }
        renameVmForOldVm.setVm(targetVm);
        renameVmForOldVm.setOriginalName(targetVm.getName());
        renameVmForOldVm.setTargetName(this.createBakName(targetVm.getName()));
        renameVmForOldVm.setParentProc((RecoveryProcessor)this);
        subMigrateProcessor.add((RecoveryProcessor)renameVmForOldVm);
    }

    private String createBakName(String name) {
        RegisterVMSubTask registerVMSubTask = new RegisterVMSubTask();
        String newName = registerVMSubTask.modifyVmName(name, BAK_SUFFIX);
        int suffixLen = 6 + BAK_SUFFIX.length();
        if (Objects.equals(newName, name) && newName.length() > suffixLen) {
            logger.warn((Object)"newName(%s) is same as oldName(%s), cut tail for newName: %s", new Object[]{newName, name});
            String newCutName = name.substring(0, name.length() - suffixLen);
            newName = registerVMSubTask.modifyVmName(newCutName, BAK_SUFFIX);
        }
        logger.info((Object)"bak name is: %s", new Object[]{newName});
        return newName;
    }

    private void configForRdm(RecoveryProcessorContext context, VsphereVirtualMachine vm, VsphereVirtualMachine oldVm, Set<RecoveryProcessor> subMigrateProcessor) {
        ConfigVirtualMachineRdmDiskTask removeCopyVmRdmDiskTask = null;
        ConfigVirtualMachineRdmDiskTask addOldRdmDiskTask = null;
        VmRollbackRdmTask vmRollbackRdmTask = null;
        if (vm.containRdmDisk()) {
            removeCopyVmRdmDiskTask = new ConfigVirtualMachineRdmDiskTask(vm, (RecoveryProcessor)this, DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E.REMOVE);
            subMigrateProcessor.add((RecoveryProcessor)removeCopyVmRdmDiskTask);
            vmRollbackRdmTask = new VmRollbackRdmTask();
            subMigrateProcessor.add((RecoveryProcessor)vmRollbackRdmTask);
            VsphereVirtualMachine vmCopy = this.createTempVm(vm);
            vmCopy.setVirtualDisk(oldVm.getVirtualDisk());
            vmCopy.getProps().put(REUSE_RDM_WWN, "true");
            addOldRdmDiskTask = new ConfigVirtualMachineRdmDiskTask(vmCopy, (RecoveryProcessor)this, DrmVsphereEnumDefine.VSPHERE_RDM_OPERATE_TYPE_E.Add);
            subMigrateProcessor.add((RecoveryProcessor)addOldRdmDiskTask);
            this.addRdmVmToContext(vm, context);
        }
    }

    private RecoveryProcessor createDeleteVmSubTask(RecoveryProcessorContext context, VsphereVirtualMachine vm, VsphereVirtualMachine targetVm) {
        DeleteVmFromDiskSubTask deleteVmFromDiskSubTask = new DeleteVmFromDiskSubTask(context, targetVm);
        deleteVmFromDiskSubTask.setParentProc((RecoveryProcessor)this);
        return deleteVmFromDiskSubTask;
    }

    private MigrateResourceOnlySubTask createMigrateResourceOnlySubTask(RecoveryProcessorContext context, VsphereVirtualMachine vm, VsphereVirtualMachine vmInReplica) {
        vm.setVirtualDisk(vmInReplica.getVirtualDisk());
        List selectedDatastore = (List)context.getAttribute("datastoreRefToSelectedVMs");
        VerifyUtil.checkObjs((Object[])new Object[]{selectedDatastore});
        String datastoreNameInReplica = VsphereCommUtil.getDatastoreName(vmInReplica.getVmPath());
        if (VsphereAppConstants.SNAPSHOT_VM_NAME_PATTERN.matcher(datastoreNameInReplica).matches()) {
            datastoreNameInReplica = datastoreNameInReplica.replaceFirst("^snap-[0-9a-z]+-", "");
        }
        String vmxDatastoreMoId = null;
        for (VsphereDataStore dataStore : selectedDatastore) {
            String curDsName = dataStore.getName();
            if (VsphereAppConstants.SNAPSHOT_VM_NAME_PATTERN.matcher(curDsName).matches()) {
                curDsName = curDsName.replaceFirst("^snap-[0-9a-z]+-", "");
            }
            if (!Objects.equals(curDsName, datastoreNameInReplica)) continue;
            vmxDatastoreMoId = dataStore.getDsMoId();
            break;
        }
        if (VerifyUtil.isEmpty(vmxDatastoreMoId)) {
            logger.error((Object)"selected datastore is empty: vmName=%s", new Object[]{vmInReplica.getName()});
            throw new LegoCheckedException(2117645L);
        }
        MigrateResourceOnlySubTask migrateResourceOnlySubTask = new MigrateResourceOnlySubTask(vm, vmInReplica, vmxDatastoreMoId);
        migrateResourceOnlySubTask.setParentProc((RecoveryProcessor)this);
        return migrateResourceOnlySubTask;
    }

    private VsphereVirtualMachine findVmInReplica(VsphereVirtualMachine vm, RecoveryProcessorContext context) {
        List vmsInReplica = (List)context.getAttribute("oldTargetVMs");
        String vmUuidInReplica = vm.getUuid();
        Optional<VsphereVirtualMachine> oldVmOptional = vmsInReplica.stream().filter(vmInReplica -> vmInReplica.getUuid().equals(vmUuidInReplica)).findAny();
        if (!oldVmOptional.isPresent()) {
            logger.error((Object)"can't find vm from replica: vmMoId=%s, vmName=%s, vmUuIdInReplica=%s", new Object[]{vm.getVmMoId(), vm.getName(), vmUuidInReplica});
            throw new LegoCheckedException(1073947393L);
        }
        return oldVmOptional.get();
    }

    private Optional<VsphereVirtualMachine> checkAndGetVmToDelete(VsphereVirtualMachine oldVm, RecoveryProcessorContext context) {
        VMAction vmAction = new VMAction();
        String vCenterUuid = context.getProtectGroup().getPoProviderSN();
        ManagedObjectReference vmByPath = vmAction.findVmByPath(vCenterUuid, oldVm.getDcMoId(), oldVm.getVmPath());
        boolean isOldVm = false;
        if (vmByPath != null) {
            logger.info((Object)"vmMoId found by vmPath of old vm: vmMoIdByVmPath=%s, oldVmMoId=%s", new Object[]{vmByPath.getValue(), oldVm.getVmMoId()});
            String vmMoId = vmByPath.getValue();
            isOldVm = Objects.equals(oldVm.getVmMoId(), vmMoId);
        }
        if (!isOldVm) {
            Optional<ProtectObject> protectObjectOpt = context.getProtectGroup().getPolist().stream().filter(po -> Objects.equals(po.getUuid(), oldVm.getUuid())).findFirst();
            if (!protectObjectOpt.isPresent()) {
                logger.warn((Object)"target vm from protectObject does not exist, as deleted: vmName=%s, vmPath=%s", new Object[]{oldVm.getName(), oldVm.getVmPath()});
                return Optional.empty();
            }
            ProtectObject protectObject = protectObjectOpt.get();
            VmwareConnectionManager instance = VmwareConnectionManager.getInstance();
            List<VsphereVirtualMachine> vmsFromVCenter = new VMAction().queryAllVms(instance.getVmwareConnection(vCenterUuid));
            Optional<VsphereVirtualMachine> vmFromVCenterOpt = vmsFromVCenter.stream().filter(vm -> Objects.equals(vm.getUuid(), protectObject.getMoUuid())).findFirst();
            if (!vmFromVCenterOpt.isPresent()) {
                logger.warn((Object)"can't find vm from vCenter with same vmMoId as po's in pg, as deleted: vmName=%s, vmMoId=%s", new Object[]{oldVm.getName(), oldVm.getVmMoId()});
                return Optional.empty();
            }
            vmFromVCenterOpt.get().setDcMoId(oldVm.getDcMoId());
            return vmFromVCenterOpt;
        }
        return Optional.of(oldVm);
    }

    @Override
    public void setTargetVm(RecoveryProcessorContext context, VsphereVirtualMachine vm) {
        this.setContextRef(context);
        this.targetVm = vm;
    }

    private VsphereVirtualMachine createTempVm(VsphereVirtualMachine vm) {
        VsphereVirtualMachine tempVm = new VsphereVirtualMachine();
        tempVm.setUuid(vm.getUuid());
        tempVm.setName(vm.getName());
        tempVm.setDcMoId(vm.getDcMoId());
        tempVm.setVmMoId(vm.getVmMoId());
        tempVm.setVmPath(vm.getVmPath());
        tempVm.setProps(VerifyUtil.isEmpty((Map)vm.getProps()) ? new HashMap() : vm.getProps());
        return tempVm;
    }

    private void addRdmVmToContext(VsphereVirtualMachine vm, RecoveryProcessorContext context) {
        ArrayList<VsphereVirtualMachine> rmdVms = (ArrayList<VsphereVirtualMachine>)context.getAttribute("Rdm_Target_VM");
        if (VerifyUtil.isEmpty((Collection)rmdVms)) {
            rmdVms = new ArrayList<VsphereVirtualMachine>();
            context.setAttribute("Rdm_Target_VM", rmdVms);
        }
        rmdVms.add(vm);
    }

    public void endRecoveryProcessor() {
        this.renameVmIfMigrateFailed();
        IProtectGroupService pgService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        ProtectGroup protectGroup = this.getContextRef().getProtectGroup();
        String vCenterUuId = protectGroup.getPoProviderSN();
        ProtectGroup protectGroupFromDb = pgService.getProtectGroupByID(protectGroup.getUuid(), false);
        Set poList = protectGroupFromDb.getPolist();
        HashMap poIdAndPoMap = new HashMap();
        poList.forEach(poId -> poIdAndPoMap.put(poId.getUuid(), poId));
        Set childProc = this.getChildProc();
        for (RecoveryProcessor recoveryProcessor : childProc) {
            if (!(recoveryProcessor instanceof RegisterVMSubTask)) continue;
            RegisterVMSubTask registerVMSubTask = (RegisterVMSubTask)recoveryProcessor;
            if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() != registerVMSubTask.getProcStatus()) continue;
            String vmName = registerVMSubTask.getVmName();
            this.targetVm.setVmMoId(registerVMSubTask.getVmMoId());
            this.targetVm.setName(vmName);
            String poIdOfVm = registerVMSubTask.getVm().getUuid();
            ProtectObject poToUpdate = (ProtectObject)poIdAndPoMap.get(poIdOfVm);
            if (!VerifyUtil.isEmpty((Object)poToUpdate)) {
                logger.info((Object)"update vm info in po: poId=%s, vmMoUUid=%s, vmName=%s", new Object[]{poToUpdate.getUuid(), registerVMSubTask.getVmMoId(), registerVMSubTask.getVmName()});
                this.updateVmInfoOfPo(vCenterUuId, registerVMSubTask, poToUpdate);
            } else {
                logger.info((Object)"add new po for vm: poId=%s, vmMoUUid=%s, vmName=%s", new Object[]{registerVMSubTask.getVm().getUuid(), registerVMSubTask.getVmMoId(), registerVMSubTask.getVmName()});
                this.recoveryPoInReplica(this.getContextRef(), protectGroupFromDb, registerVMSubTask);
            }
            vmName = vmName + ":" + MIGRATED_SUFFIX;
            registerVMSubTask.setVmName(vmName);
        }
        super.endRecoveryProcessor();
    }

    private void renameVmIfMigrateFailed() {
        Set childProc = this.getChildProc();
        ArrayList<RenameVmSubTask> renameVmSubTaskList = new ArrayList<RenameVmSubTask>();
        for (RecoveryProcessor recoveryProcessor : childProc) {
            if (recoveryProcessor instanceof RenameVmSubTask && recoveryProcessor.getProcStatus() == DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) {
                renameVmSubTaskList.add((RenameVmSubTask)recoveryProcessor);
                continue;
            }
            if (!(recoveryProcessor instanceof MigrateResourceOnlySubTask) || recoveryProcessor.getProcStatus() != DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue()) continue;
            logger.info((Object)"Migrate vm successfully, no need to rename vm name back.");
            return;
        }
        if (VerifyUtil.isEmpty(renameVmSubTaskList)) {
            return;
        }
        logger.error((Object)"Migrate vm failed, try to rename vm name back.");
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(this.generateNewRenameVmSubTasks(renameVmSubTaskList), null);
        executor.process(this.getContextRef());
    }

    private List<RenameVmSubTask> generateNewRenameVmSubTasks(List<RenameVmSubTask> renameVmSubTaskList) {
        renameVmSubTaskList.sort(this::sortRenameVmSubTasks);
        return renameVmSubTaskList.stream().map(renameVmSubTask -> {
            RenameVmSubTask newRenameVmSubTask = new RenameVmSubTask();
            newRenameVmSubTask.setVm(renameVmSubTask.getVm());
            newRenameVmSubTask.setTargetName(renameVmSubTask.getOriginalName());
            newRenameVmSubTask.setIsNeedCreateDetail(false);
            newRenameVmSubTask.setIsNeedSave(false);
            logger.info((Object)"Rename vm name back, original name: %s, target name: %s", new Object[]{renameVmSubTask.getTargetName(), renameVmSubTask.getOriginalName()});
            return newRenameVmSubTask;
        }).collect(Collectors.toList());
    }

    private int sortRenameVmSubTasks(RenameVmSubTask task1, RenameVmSubTask task2) {
        return task1.getTargetName().contains(BAK_SUFFIX) ? 1 : -1;
    }

    private void updateVmInfoOfPo(String vCenterUuId, RegisterVMSubTask registerVMSubTask, ProtectObject poToUpdate) {
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vCenterUuId);
        ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(registerVMSubTask.getVmMoId(), "VirtualMachine");
        String vmPathPropPath = "config.files.vmPathName";
        String[] props = new String[]{vmPathPropPath};
        Map<String, Object> propsMap = GetMoPropsValueUtils.getInstance().entityProps(conn, vmMor, props);
        logger.info((Object)"vmPath of migrated vm is : %s", new Object[]{propsMap});
        String vmPath = (String)Optional.ofNullable(propsMap.get(vmPathPropPath)).orElse(poToUpdate.getProps().get("VMPATH"));
        poToUpdate.getProps().put("VMPATH", vmPath);
        poToUpdate.setMoUuid(vCenterUuId + ":" + registerVMSubTask.getVmMoId());
        poToUpdate.setName(registerVMSubTask.getVmName());
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)poToUpdate);
    }

    private void recoveryPoInReplica(RecoveryProcessorContext context, ProtectGroup protectGroupFromDb, RegisterVMSubTask registerVMSubTask) {
        String vCenterUuId = (String)context.getAttribute("Target_vCenter");
        VsphereVirtualMachine vm = registerVMSubTask.getVm();
        String poIdInReplica = vm.getUuid();
        ProtectObject poInReplica = context.getProtectGroupReplica().getReplicas().stream().filter(poReplica -> Objects.equals(poReplica.getPoId(), poIdInReplica)).map(ProtectObjectReplica::getProtectObject).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L, "can't get po in replica by vm uuid: " + poIdInReplica));
        poInReplica.setName(registerVMSubTask.getVmName());
        String poMoId = vCenterUuId + ":" + registerVMSubTask.getVmMoId();
        poInReplica.setMoUuid(poMoId);
        poInReplica.setProtectGroup(protectGroupFromDb);
        protectGroupFromDb.getPolist().add(poInReplica);
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroupFromDb);
    }

    private ConfigMigratedVmDiskTask createConfigMigratedVmDiskTask(RecoveryProcessorContext context, VsphereVirtualMachine vm) {
        Map dsChangeMap = (Map)context.getAttribute("reversedDatastoreIdChangeMap");
        return new ConfigMigratedVmDiskTask(vm, (RecoveryProcessor)this, dsChangeMap);
    }
}

