/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreSubTask;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class MountDatastoreSubTask
extends ConfigDatastoreSubTask {
    private static final long serialVersionUID = 7935968233577533551L;
    private static final long WAIT_INTERVAL = 10000L;
    private static final Log logger = LogFactory.getInstance(ConfigDatastoreTask.class);
    private VsphereDataStore dataStore;
    private final transient DataStoreAction dataStoreAction = new DataStoreAction();

    public MountDatastoreSubTask() {
    }

    MountDatastoreSubTask(RecoveryProcessor parentProc, VsphereDataStore dataStore) {
        this.dataStore = dataStore;
        this.setTargetDatastoreUuid(dataStore.getUrl().substring("ds:///vmfs/volumes/".length(), dataStore.getUrl().length() - 1));
        this.setTargetDatastoreName(dataStore.getName());
        this.setTargetDatastoreMoId(dataStore.getDsMoId());
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.dataStore.getName()});
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        String key = "Target_Host";
        List vsphereHostSystemList = context.getObjects(key, VsphereHostSystem.class);
        try {
            for (VsphereHostSystem hostSystem : vsphereHostSystemList) {
                logger.info((Object)"mount datastore start, venterUuid:[%s],hostId:[%s],datastoreUuid:[%s]", new Object[]{vcenterUuid, hostSystem, this.dataStore.getUuid()});
                String hostMoId = hostSystem.getHostMoId();
                this.checkDatastoreIsMounted(vcenterUuid, hostMoId);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"mount datastore failed.", (Throwable)e);
            return this.failure(e);
        }
        logger.debug((Object)"mount datastore success.");
        return this.success();
    }

    private void checkDatastoreIsMounted(String vcenterUuid, String hostMoId) {
        HostSystemAction hostSystemAction = new HostSystemAction();
        String dsMoId = this.dataStore.getDsMoId();
        for (int i = 0; i < 30; ++i) {
            block5: {
                try {
                    logger.info((Object)"Start to mount datastores, datastoreUuid:[%s], hostId:[%s]", new Object[]{dsMoId, hostMoId});
                    hostSystemAction.mountDataStore(vcenterUuid, hostMoId, dsMoId);
                }
                catch (LegoCheckedException ex) {
                    if (1073948877L == ex.getErrorCode()) break block5;
                    throw ex;
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"InterruptedException.", (Throwable)e);
            }
            if (!this.dataStoreAction.isMountedToHost(vcenterUuid, dsMoId, hostMoId)) continue;
            logger.info((Object)"All datastores are  ready, datastoreUuid:[%s], hostId:[%s]", new Object[]{dsMoId, hostMoId});
            return;
        }
        logger.error((Object)"datastores are not ready, datastoreUuid:[%s], hostId:[%s]", new Object[]{dsMoId, hostMoId});
        throw new LegoCheckedException(-1L);
    }
}

