/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.sdk.model.HostSystem;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereRecoveryUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereComputeResource;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ClusterAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterNotAttemptedVmInfo;
import com.huawei.vmware.vim25.ClusterPowerOnVmResult;
import com.huawei.vmware.vim25.ClusterRecommendation;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PowerOnVMGroupPriSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(PowerOnVMGroupPriSubTask.class);
    private List<VsphereVirtualMachine> virtualMachineList = null;
    private int priorityNum = 0;

    public PowerOnVMGroupPriSubTask() {
    }

    public PowerOnVMGroupPriSubTask(List<VsphereVirtualMachine> virtualMachineList, RecoveryProcessor parentProc) {
        this.virtualMachineList = virtualMachineList;
        this.setParentProc(parentProc);
        this.setProcName(this.getName());
        this.setProcType(parentProc.getProcType());
        this.setPlanId(parentProc.getPlanId());
        this.setProcessId(parentProc.getProcessId());
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{"" + this.priorityNum});
        this.createSubTask();
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.error((Object)"subprocessors is empty.", 90160758786989L);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.batchPowerOnVirtualMachine(context);
        boolean result = this.calcProcessResultBySubProc();
        logger.info((Object)"Result of power on vm: %s", new Object[]{result});
        return result;
    }

    private void createSubTask() {
        if (this.virtualMachineList == null || this.virtualMachineList.isEmpty()) {
            logger.error((Object)"virtual machine list is empty.");
            return;
        }
        HashSet<PowerOnVMSubTask> childProcessors = new HashSet<PowerOnVMSubTask>();
        for (VsphereVirtualMachine vm : this.virtualMachineList) {
            PowerOnVMSubTask subTask = new PowerOnVMSubTask(vm, (RecoveryProcessor)this);
            childProcessors.add(subTask);
        }
        this.setChildProc(childProcessors);
    }

    private void batchPowerOnVirtualMachine(RecoveryProcessorContext context) {
        HashMap<String, PowerOnVMSubTask> vmIdProcMap = new HashMap<String, PowerOnVMSubTask>();
        HashMap<Integer, List<ManagedObjectReference>> vmMap = new HashMap<Integer, List<ManagedObjectReference>>();
        this.dividePowerOnSubTask(vmMap, vmIdProcMap, context);
        Map settings = context.getRecoveryPlan().getGlobalSettings();
        String dcMoId = (String)settings.get("VSDATACENTERID");
        String vcenterUuid = (String)context.getAttribute("Target_vCenter");
        VMAction action = new VMAction();
        List<PowerOnVMSubTask> startVMTaskGroup = null;
        for (Map.Entry entry : vmMap.entrySet()) {
            startVMTaskGroup = this.getStartVMTaskGroup((List)entry.getValue(), vmIdProcMap);
            if (VerifyUtil.isEmpty(startVMTaskGroup)) {
                logger.info((Object)"startVMTaskGroup is empty");
                continue;
            }
            if ((Integer)entry.getKey() != Integer.MAX_VALUE) {
                try {
                    logger.info((Object)("will power on vms:moIds=" + entry.getValue()));
                    ClusterPowerOnVmResult result = action.powerOnMultiVm(vcenterUuid, dcMoId, (List)entry.getValue());
                    this.updateProcAfterPowerOn(result, vmIdProcMap);
                }
                catch (Exception e) {
                    logger.error((Object)("powerOnMultiVms failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                    this.updateProcAfterFailed(startVMTaskGroup);
                }
            }
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(startVMTaskGroup, (boolean)false);
            recoveryTemplate.process(context);
        }
    }

    private void updateProcAfterPowerOn(ClusterPowerOnVmResult result, Map<String, PowerOnVMSubTask> vmIdProcMap) {
        if (VerifyUtil.isEmpty((Object)result) || VerifyUtil.isEmpty(vmIdProcMap)) {
            logger.error((Object)"result or vmIdProcMap is empty", 90160758786989L);
            return;
        }
        List attemptedList = result.getAttempted();
        List notAttemptedList = result.getNotAttempted();
        List recommList = result.getRecommendations();
        this.dealAttemptedVms(vmIdProcMap, attemptedList);
        this.dealNotAttemptedVms(vmIdProcMap, notAttemptedList);
        this.dealRecommVms(recommList);
    }

    private void dealAttemptedVms(Map<String, PowerOnVMSubTask> procMap, List<ClusterAttemptedVmInfo> attemptedList) {
        if (!VerifyUtil.isEmpty(attemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,attempted vms:");
            for (ClusterAttemptedVmInfo info : attemptedList) {
                ManagedObjectReference vm = info.getVm();
                PowerOnVMSubTask proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setTaskId(info.getTask().getValue());
                buffer.append(" moId=" + vm.getValue());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    private void dealNotAttemptedVms(Map<String, PowerOnVMSubTask> procMap, List<ClusterNotAttemptedVmInfo> notAttemptedList) {
        if (!VerifyUtil.isEmpty(notAttemptedList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm, not attempted vms:");
            for (ClusterNotAttemptedVmInfo info : notAttemptedList) {
                ManagedObjectReference vm = info.getVm();
                PowerOnVMSubTask proc = procMap.get(vm.getValue());
                if (null == proc) continue;
                proc.setErrorCode(1073948880L);
                buffer.append(" vmMoId=" + vm.getValue());
                buffer.append(" fault msg:" + info.getFault().getLocalizedMessage());
            }
            logger.info((Object)buffer.toString(), 90160758786988L);
        }
    }

    private void dealRecommVms(List<ClusterRecommendation> recommList) {
        if (!VerifyUtil.isEmpty(recommList)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("power on multi vm,recommand vms:");
            for (ClusterRecommendation recomm : recommList) {
                buffer.append(" vmMoId=" + recomm.getTarget().getValue());
            }
            logger.error((Object)buffer.toString(), 90160758786989L);
        }
    }

    private void updateProcAfterFailed(List<PowerOnVMSubTask> procGroup) {
        for (PowerOnVMSubTask proc : procGroup) {
            proc.setErrorCode(1073948883L);
        }
    }

    private List<PowerOnVMSubTask> getStartVMTaskGroup(List<ManagedObjectReference> morList, Map<String, PowerOnVMSubTask> procMap) {
        ArrayList<PowerOnVMSubTask> procGroup = new ArrayList<PowerOnVMSubTask>();
        for (ManagedObjectReference mor : morList) {
            String id = mor.getValue();
            procGroup.add(procMap.get(id));
        }
        return procGroup;
    }

    private void dividePowerOnSubTask(Map<Integer, List<ManagedObjectReference>> vmMap, Map<String, PowerOnVMSubTask> vmIdProcMap, RecoveryProcessorContext context) {
        String vCenterUuid = (String)context.getAttribute("Target_vCenter");
        List powerOnHosts = context.getObjects("Target_Host", HostSystem.class);
        if (powerOnHosts == null || powerOnHosts.isEmpty()) {
            logger.error((Object)"powerOnHosts is empty");
            return;
        }
        HostSystem esxHost = (HostSystem)powerOnHosts.get(0);
        String cpResUuid = esxHost.getComputeResourceUuid();
        boolean isCluster = this.isClusterByCpResUuid(cpResUuid);
        int batchStartNum = VsphereRecoveryUtils.getInstance().getBatchStartCeiling(isCluster);
        int count = 0;
        Integer batchNo = 0;
        ArrayList<ManagedObjectReference> notPowerOnVmList = new ArrayList<ManagedObjectReference>();
        vmMap.put(Integer.MAX_VALUE, notPowerOnVmList);
        Set childProcSet = this.getChildProc();
        for (RecoveryProcessor proc : childProcSet) {
            List<Object> vmList;
            PowerOnVMSubTask startVmSubProc = (PowerOnVMSubTask)proc;
            String vmMoId = startVmSubProc.getVirtualMachine().getVmMoId();
            String poId = startVmSubProc.getVirtualMachine().getUuid();
            String vmName = startVmSubProc.getVirtualMachine().getName();
            ManagedObjectReference mor = new ManagedObjectReference();
            mor.setType("VirtualMachine");
            mor.setValue(VerifyUtil.isEmpty((String)vmMoId) ? poId : vmMoId);
            vmIdProcMap.put(mor.getValue(), startVmSubProc);
            VMAction action = new VMAction();
            VirtualMachinePowerState status = action.getVMPowerState(vCenterUuid, vmMoId);
            boolean isVmToolInstalled = action.isVmToolInstalled(vCenterUuid, vmMoId);
            logger.debug((Object)"Power on vm[%s]. it's status: [%s], VmToolStatus: [%s]", new Object[]{vmName, status, isVmToolInstalled});
            if (VirtualMachinePowerState.POWERED_OFF != status || !isVmToolInstalled) {
                logger.info((Object)"The vm[%s] can not be power on.", new Object[]{vmName});
                notPowerOnVmList.add(mor);
                continue;
            }
            if (count % batchStartNum == 0) {
                vmList = new ArrayList();
                Integer n = batchNo;
                Integer n2 = batchNo = Integer.valueOf(batchNo + 1);
                vmMap.put(batchNo, vmList);
            }
            vmList = vmMap.get(batchNo);
            vmList.add(mor);
            ++count;
        }
    }

    private boolean isClusterByCpResUuid(String cpResUuid) {
        boolean isCluster = false;
        VsphereComputeResource compRes = (VsphereComputeResource)CommonDAOLocator.getMoDao().getMo(VsphereComputeResource.class, "uuid", (Object)cpResUuid);
        if (null != compRes) {
            isCluster = compRes.getIsCluster();
        }
        return isCluster;
    }

    public int getPriorityNum() {
        return this.priorityNum;
    }

    public void setPriorityNum(int priorityNum) {
        this.priorityNum = priorityNum;
    }
}

