/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.adapter.action.util.VsphereTaskResultMonitor;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnection;
import com.huawei.ism.drm.vsphere.adapter.connect.VmwareConnectionManager;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;
import com.huawei.vmware.vim25.MethodFault;
import com.huawei.vmware.vim25.VirtualMachinePowerState;
import com.huawei.vmware.vim25.VirtualMachineToolsRunningStatus;

public class PowerOnVMSubTask
extends BaseRecoveryProcessor {
    private static final Log logger = LogFactory.getInstance(PowerOnVMSubTask.class);
    private static final String START_TIMEOUT = "com.huawei.ism.drm.vsphere.recovery.process.VsStartVmSubProcessor.starttimeout";
    private static final String START_FAILED = "com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask.powerOnVm.failed";
    private static final String VMTOOLS_STATE_ABNORMAL = "com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask.vmTools.state_abnormal";
    private VsphereVirtualMachine virtualMachine;
    private int preResult;
    private long errorCode = 0L;
    private String taskId = "";

    public PowerOnVMSubTask() {
    }

    public PowerOnVMSubTask(VsphereVirtualMachine virtualMachine, RecoveryProcessor parentProc) {
        this.virtualMachine = virtualMachine;
        this.setParentProc(parentProc);
    }

    protected boolean execute(RecoveryProcessorContext context) {
        boolean result = false;
        if (this.virtualMachine == null) {
            logger.error((Object)"param virtualMachine is null");
            return false;
        }
        String vmName = this.virtualMachine.getName();
        try {
            this.updateProcessNameParams(new String[]{vmName});
            logger.info((Object)"into exe vm[%s] PowerOnVMSubTask.", new Object[]{vmName});
            String poId = this.virtualMachine.getUuid();
            String vcenterUuid = (String)context.getAttribute("Target_vCenter");
            String vmMoId = this.virtualMachine.getVmMoId();
            VMAction action = new VMAction();
            VirtualMachinePowerState status = action.getVMPowerState(vcenterUuid, vmMoId);
            if (status == VirtualMachinePowerState.POWERED_ON) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
                this.setPoRecoveryStatus(poId, context);
                return true;
            }
            if (0L != this.errorCode) {
                this.updateProcessDetail("lego.err." + this.errorCode, null);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                this.setPoRecoveryStatus(poId, context);
                return false;
            }
            if (!VerifyUtil.isEmpty((String)this.taskId)) {
                result = this.monitorVMPowerOnResult(vcenterUuid, context);
                return result;
            }
            result = this.powerOnVirtualMachine(context);
            if (result) {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            } else {
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            }
            this.setPoRecoveryStatus(poId, context);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("power on VM[%s] failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{vmName});
            return this.failure(e);
        }
        catch (Exception e) {
            logger.error((Object)("power on VM[%s] failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{vmName});
            return this.failure(START_FAILED, new String[]{vmName});
        }
        logger.info((Object)"end exe vm[%s] PowerOnVMSubTask, result = %s.", new Object[]{vmName, result});
        return result;
    }

    private boolean monitorVMPowerOnResult(String vcenterUuid, RecoveryProcessorContext context) {
        String vmMoId = this.virtualMachine.getVmMoId();
        VMAction action = new VMAction();
        action.answerVM(vcenterUuid, vmMoId);
        boolean taskResult = this.monitorTask(vcenterUuid);
        String poId = this.virtualMachine.getUuid();
        String vmName = this.virtualMachine.getName();
        if (taskResult) {
            logger.debug((Object)"vm[%s] is batch powerOn, waitForVmStarted", new Object[]{vmName});
            taskResult = this.waitForVmStarted(vcenterUuid);
            logger.debug((Object)"vm[%s] is batch powerOn, waitForVmStarted result = %s", new Object[]{vmName, taskResult});
        }
        if (taskResult) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        this.setPoRecoveryStatus(poId, context);
        return taskResult;
    }

    private boolean waitForVmStarted(String vcenterUuid) {
        boolean ret = false;
        VMAction action = new VMAction();
        String vmMoId = this.virtualMachine.getVmMoId();
        String vmName = this.virtualMachine.getName();
        try {
            for (int i = 0; i < 50; ++i) {
                VirtualMachineToolsRunningStatus state = action.getGuestVMToolState(vcenterUuid, vmMoId);
                if (VirtualMachineToolsRunningStatus.GUEST_TOOLS_RUNNING == state) {
                    logger.debug((Object)("start VM " + vmName + " sucessfully"), 90160758786988L);
                    ret = true;
                    break;
                }
                Thread.sleep(6000L);
            }
            if (!ret) {
                VirtualMachinePowerState powerState = action.getVMPowerState(vcenterUuid, vmMoId);
                if (powerState == VirtualMachinePowerState.POWERED_ON) {
                    this.updateProcessDetail(VMTOOLS_STATE_ABNORMAL, new String[0]);
                    return true;
                }
                this.updateProcessDetail(START_TIMEOUT, new String[0]);
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("start vm start failed " + vmName), (Throwable)e, 90160758786989L);
            this.updateProcessDetail(e);
            ret = false;
        }
        catch (Exception e) {
            logger.error((Object)("start vm start failed " + vmName + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
        return ret;
    }

    private void setPoRecoveryStatus(String poId, RecoveryProcessorContext context) {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
            return;
        }
        String key = RecoveryProcessResult.getPoRecoveryStatusKey((int)this.getProcType(), (String)poId, (int)DrmEnumDefine.AppType.VM.getValue());
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            context.getProcessResult().addProcessResult(key, true);
        } else {
            context.getProcessResult().addProcessResult(key, false);
        }
    }

    private boolean monitorTask(String vcenterUuid) {
        ManagedObjectReference task = GetMoPropsValueUtils.getInstance().getMorByObjUuid(this.taskId, "Task");
        VmwareConnection conn = VmwareConnectionManager.getInstance().getVmwareConnection(vcenterUuid);
        MethodFault fault = new VsphereTaskResultMonitor(conn, task).monitorTaskResultAfterDone();
        if (!VerifyUtil.isEmpty((Object)fault)) {
            VMAction action = new VMAction();
            LegoCheckedException legoExc = action.getPowerOnLegoException(fault);
            this.updateProcessDetail(legoExc);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean powerOnVirtualMachine(RecoveryProcessorContext context) {
        vcenterUuid = (String)context.getAttribute("Target_vCenter");
        vmMoId = this.virtualMachine.getVmMoId();
        vmxPath = this.virtualMachine.getVmPath();
        vmName = this.virtualMachine.getName();
        dataCenter = VsphereVirtualMachineUtils.findDataCenter(this.virtualMachine, vcenterUuid);
        if (null == dataCenter) {
            PowerOnVMSubTask.logger.error((Object)"Cannot find datacenter from vCenter[%s] by virtual machine config[%s]", new Object[]{vcenterUuid, this.virtualMachine.getVmConfig()});
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948868", null);
            return false;
        }
        vmAction = new VMAction();
        dcMoId = dataCenter.getMoId();
        if (vmAction.findVmByPath(vcenterUuid, dcMoId, vmxPath) == null) {
            PowerOnVMSubTask.logger.info((Object)"Virtaul Machine[%s] will be shutdown has been deleted! ", new Object[]{vmName});
            this.updateProcessDetail("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{vmName});
            return false;
        }
        vmMor = new ManagedObjectReference();
        vmMor.setType("VirtualMachine");
        vmMor.setValue(vmMoId);
        isVmtoolInstalled = vmAction.isVmToolInstalled(vcenterUuid, vmMoId);
        if (!isVmtoolInstalled) {
            PowerOnVMSubTask.logger.info((Object)" vm[%s] is not install vmtool, could not exe powerOn.", new Object[]{vmName});
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask.powerOnVm.failed", new String[]{vmName});
            return false;
        }
        powserState = vmAction.getVMPowerState(vcenterUuid, vmMoId);
        if (VirtualMachinePowerState.POWERED_OFF == powserState) {
            PowerOnVMSubTask.logger.info((Object)"Virtaul Machine named %s powserState is %s", new Object[]{vmName, powserState});
            try {
                result = vmAction.powerOnVM(vcenterUuid, vmMoId);
                if (result) ** GOTO lbl45
                this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask.powerOnVm.failed", new String[]{vmName});
            }
            catch (LegoCheckedException e) {
                this.updateProcessDetail(e);
                PowerOnVMSubTask.logger.error((Object)"PowerOn  Virtual Machine %s failed.", new Object[]{vmName});
                return false;
            }
            catch (Exception e) {
                PowerOnVMSubTask.logger.error((Object)"PowerOn  Virtual Machine %s failed.", new Object[]{vmName});
                PowerOnVMSubTask.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160758786989L);
                this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask.powerOnVm.failed", new String[]{vmName});
                return false;
            }
        } else {
            PowerOnVMSubTask.logger.info((Object)" vm[%s] is not powerOff, could not exe powerOn.", new Object[]{vmName});
            this.updateProcessDetail("com.huawei.ism.drm.vsphere.recovery.task.PowerOnVMSubTask.powerOnVm.failed", new String[]{vmName});
            result = false;
        }
lbl45:
        // 3 sources

        PowerOnVMSubTask.logger.info((Object)"PowerOn vm[%s] result=%s", new Object[]{vmName, result});
        return result;
    }

    public VsphereVirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public void setVirtualMachine(VsphereVirtualMachine virtualMachine) {
        this.virtualMachine = virtualMachine;
    }

    public int getPreResult() {
        return this.preResult;
    }

    public void setPreResult(int preResult) {
        this.preResult = preResult;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
}

