/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.recovery.task.VMwareRecoveryTaskInterceptor;
import com.huawei.ism.drm.vsphere.recovery.utils.VsphereVirtualMachineUtils;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.Assert;

public class RecoverySourcePreparer
extends VMwareRecoveryTaskInterceptor {
    private static final Log logger = LogFactory.getInstance(RecoverySourcePreparer.class);

    public RecoverySourcePreparer(BaseRecoveryProcessor processor) {
        super(processor);
    }

    @Override
    public void prepareTargetHost(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        ArrayList vsphereHostSystemList = new ArrayList();
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List hostUuidList = context.getObjects("TargetHostUuidList", String.class);
        if (null == hostUuidList || hostUuidList.isEmpty()) {
            logger.error((Object)"Target host uuid is null");
            throw new LegoCheckedException(1073947393L);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String uuid : hostUuidList) {
            VsphereHostSystem hostSystem = (VsphereHostSystem)moDao.getMo(VsphereHostSystem.class, "uuid", (Object)uuid);
            if (!treeSet.add(hostSystem.getComputeResourceUuid())) continue;
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("computeResourceUuid", hostSystem.getComputeResourceUuid());
            context.setAttribute("computeResourceUuid", (Object)hostSystem.getComputeResourceUuid());
            vsphereHostSystemList.addAll(moDao.findMoBy(VsphereHostSystem.class, props));
        }
        context.setAttribute("Target_Host", vsphereHostSystemList);
    }

    @Override
    public void prepareTargetStoreageResource(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        ProtectGroup protectGroup = context.getProtectGroup();
        Assert.notNull((Object)protectGroup, (String)"Connot find protectGroup from recovery context.");
        List protectObjectStorageInfoList = protectGroup.distinctStorageInfo();
        ArrayList<StorageResource> storageResourceList = new ArrayList<StorageResource>();
        for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObjectStorageInfoList) {
            StorageResource storageResource = new StorageResource();
            storageResource.setDevSn(protectObjectStorageInfo.getResourceProviderSN());
            storageResource.setResourceId(protectObjectStorageInfo.getResourceId());
            storageResource.setResourceIndentifier(protectObjectStorageInfo.getLunWWN());
            storageResourceList.add(storageResource);
        }
        context.setAttribute("Target_Storage", storageResourceList);
    }

    @Override
    public void prepareTargetDatastore(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        ProtectGroup protectGroup = context.getProtectGroup();
        Assert.notNull((Object)protectGroup, (String)"Connot find protectGroup from recovery context.");
        ArrayList<VsphereDataStore> dataStoreList = new ArrayList<VsphereDataStore>();
        List protectObjectStorageInfoList = protectGroup.distinctStorageInfo();
        TreeSet<String> datastoreUuidSet = new TreeSet<String>();
        List selectedVMUuidList = (List)context.getAttribute("selectedVmMoIdList");
        for (ProtectObjectStorageInfo protectObjectStorageInfo : protectObjectStorageInfoList) {
            String mountPoint = protectObjectStorageInfo.getMountPoint();
            if (null == mountPoint) {
                logger.error((Object)"Cannot find Datastore mountPoint from protectObject storage");
                continue;
            }
            String dsUuid = mountPoint.substring("ds:///vmfs/volumes/".length(), mountPoint.length() - 1);
            String poUuid = protectObjectStorageInfo.getProtectObject().getUuid();
            if (!CollectionUtils.isEmpty((Collection)selectedVMUuidList) && !selectedVMUuidList.contains(poUuid) || !datastoreUuidSet.add(dsUuid)) continue;
            VsphereDataStore dataStore = new VsphereDataStore();
            dataStore.setUuid(dsUuid);
            dataStore.setName(protectObjectStorageInfo.getDeviceName());
            dataStoreList.add(dataStore);
        }
        if (CollectionUtils.isEmpty((Collection)selectedVMUuidList)) {
            context.setAttribute("Target_Datastore", dataStoreList);
        }
    }

    @Override
    public void prepareTargetVirtualMachine(RecoveryProcessorContext context) {
        Assert.notNull((Object)context, (String)"Recovery context cannot be null.");
        ProtectGroup protectGroup = context.getProtectGroup();
        RecoveryPlan plan = context.getRecoveryPlan();
        Assert.notNull((Object)protectGroup, (String)"Connot find protectGroup from recovery context.");
        Assert.notNull((Object)plan, (String)"Connot find recovery plan from recovery context.");
        String hostUuidKey = "TargetHostUuidList";
        Set protectObjectSet = protectGroup.getPolist();
        String dcMoId = this.getDataCenterMoId(context, protectObjectSet);
        ArrayList<VsphereVirtualMachine> vsphereVirtualMachineList = new ArrayList<VsphereVirtualMachine>();
        HashSet<String> hostUuidSet = new HashSet<String>();
        for (ProtectObject po : protectObjectSet) {
            VsphereVirtualMachine vm2 = VsphereVirtualMachineUtils.convertFrom(po);
            if (null == vm2) continue;
            vsphereVirtualMachineList.add(vm2);
            hostUuidSet.add(vm2.getHostUuid());
        }
        context.setAttribute(hostUuidKey, new ArrayList(hostUuidSet));
        if (!VerifyUtil.isEmpty((String)dcMoId)) {
            vsphereVirtualMachineList.forEach(vm -> vm.setDcMoId(dcMoId));
        }
        context.setAttribute("Target_VM", vsphereVirtualMachineList);
    }

    protected String getDataCenterMoId(RecoveryProcessorContext context, Set<ProtectObject> protectObjectSet) {
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            logger.error((Object)"Protect object is empty.");
            throw new LegoCheckedException(2117645L);
        }
        String ethernetCardInfo = (String)((ProtectObject)protectObjectSet.stream().findFirst().get()).getProps().get("VirtualEthernetCard");
        String vCenterUuid = context.getProtectGroup().getPoProviderSN();
        VsDataCenter dataCenter = VsphereVirtualMachineUtils.solveVsDataCenter(vCenterUuid, ethernetCardInfo);
        String dcMoId = null;
        if (null != dataCenter) {
            dcMoId = dataCenter.getMoId();
            logger.info((Object)"Solve data center moId: %s in vCenter: %s", new Object[]{dcMoId, vCenterUuid});
        }
        return dcMoId;
    }

    @Override
    public void prepareTargetVCenter(RecoveryProcessorContext context) {
        context.setAttribute("Target_vCenter", (Object)context.getProtectGroup().getPoProviderSN());
        context.setAttribute("VSDATACENTERNAME", context.getRecoveryPlan().getGlobalSettings().get("VSDATACENTERNAME"));
    }
}

