/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.task.ConfigDatastoreSubTask;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.HostUnresolvedVmfsResolutionResult;
import com.huawei.vmware.vim25.LocalizedMethodFault;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ResignatureDatastoreSubTask
extends ConfigDatastoreSubTask {
    private static final String RESIGNATURE_FAILED = "ResignatureDatastoreSubTask.failed";
    private static final Log logger = LogFactory.getInstance(ResignatureDatastoreSubTask.class);
    private String vcenterUuid;
    private String hostMoId;
    private String devicePath;
    private Set<String> conflictWwn;

    public ResignatureDatastoreSubTask() {
    }

    ResignatureDatastoreSubTask(RecoveryProcessor parentProc, String vcenterUuid, String hostMoId, String devicePath, String dataStoreName, Set<String> conflictWwn) {
        this.setParentProc(parentProc);
        this.vcenterUuid = vcenterUuid;
        this.hostMoId = hostMoId;
        this.devicePath = devicePath;
        this.setSourceDatastoreName(dataStoreName);
        this.conflictWwn = null == conflictWwn ? Collections.emptySet() : conflictWwn;
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.getSourceDatastoreName()});
        List<HostUnresolvedVmfsResolutionResult> results = new HostSystemAction().resignatureDataStore(this.vcenterUuid, this.hostMoId, this.devicePath);
        if (VerifyUtil.isEmpty(results)) {
            logger.error((Object)"ResignatureDatastoreSubTask is empty.");
            return this.failure(RESIGNATURE_FAILED, null);
        }
        LocalizedMethodFault fault = results.get(0).getFault();
        if (null != fault) {
            logger.error((Object)"ResignatureDatastoreSubTask failed, fault:[%s]", new Object[]{fault.getLocalizedMessage()});
            return this.failure(RESIGNATURE_FAILED, null);
        }
        boolean isRenameDatastore = this.isRenameDatastore(context);
        if (isRenameDatastore) {
            try {
                DataStoreAction.renameDataStore(results, this.vcenterUuid);
            }
            catch (Exception e) {
                logger.error((Object)("rename datastore failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), new Object[]{""});
            }
        }
        String newDataStoreName = results.get(0).getVmfs().getName();
        String newDataStoreUuid = results.get(0).getVmfs().getUuid();
        this.setTargetDatastoreUuid(newDataStoreUuid);
        this.setTargetDatastoreName(newDataStoreName);
        logger.info((Object)"resignature success.newDataStoreName:[%s],newDataStoreUuid:[%s]", new Object[]{newDataStoreName, newDataStoreUuid});
        return this.success();
    }

    private boolean isRenameDatastore(RecoveryProcessorContext context) {
        boolean isRenameDatastore = false;
        int procType = this.getProcType();
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue() || procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            isRenameDatastore = true;
        }
        if (procType == DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() && context.getAttribute("DISASTER_SITE_ID") != context.getAttribute("PRODUCT_SITE_ID")) {
            isRenameDatastore = true;
        }
        return isRenameDatastore;
    }

    public void beforeExecRecoveryProcessor() {
        logger.debug((Object)"start dettachScsiLun, wwn: %s", new Object[]{this.conflictWwn});
        HostSystemAction hostAction = new HostSystemAction();
        for (String lunWwn : this.conflictWwn) {
            hostAction.unmountScsiLunByWwn(this.vcenterUuid, this.hostMoId, lunWwn);
            logger.debug((Object)"doDettachScsiLun successful:wwn: %s", new Object[]{lunWwn});
        }
        super.beforeExecRecoveryProcessor();
    }

    public void endRecoveryProcessor() {
        logger.debug((Object)"start attachScsiLun, wwn: %s", new Object[]{this.conflictWwn});
        HostSystemAction hostAction = new HostSystemAction();
        for (String lunWwn : this.conflictWwn) {
            hostAction.mountScsiLUN(this.vcenterUuid, this.hostMoId, lunWwn);
            logger.debug((Object)"doAttachScsiLun successful:wwn: %s", new Object[]{lunWwn});
        }
        super.endRecoveryProcessor();
    }
}

