/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.VMAction;
import com.huawei.ism.drm.vsphere.adapter.action.VMSnapshotAction;
import com.huawei.ism.drm.vsphere.adapter.action.util.GetMoPropsValueUtils;
import com.huawei.ism.drm.vsphere.recovery.task.OperateVsphereVmSubTask;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereVirtualMachine;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.vmware.vim25.ManagedObjectReference;

public class RestoreVMSubTask
extends OperateVsphereVmSubTask {
    private static final long serialVersionUID = -2266135104512657257L;
    private static final Log logger = LogFactory.getInstance(RestoreVMSubTask.class);
    private static final String BASE_STR = "com.huawei.ism.drm.vsphere.recovery.task.RestoreVMSubTask.";
    private static final String ALREADY_SUCC = "com.huawei.ism.drm.vsphere.recovery.task.RestoreVMSubTask.already.success";
    private static final String TEMPLATE_VM_SUCCESS = "com.huawei.ism.drm.vsphere.recovery.task.RestoreVMSubTask.template.success";
    private static final String SNAPSHOT_NOT_EXIST = "com.huawei.ism.drm.vsphere.recovery.task.RestoreVMSubTask.not.exist";
    private static final String FAILED = "com.huawei.ism.drm.vsphere.recovery.task.RestoreVMSubTask.failed";
    private String vcenterUuid;

    public RestoreVMSubTask() {
    }

    public RestoreVMSubTask(VsphereVirtualMachine vm, RecoveryProcessor parentProc) {
        super(vm, parentProc);
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        boolean flag;
        String vmPath;
        if (VerifyUtil.isEmpty((Object)this.getVm())) {
            logger.error((Object)"vm is null");
            throw new LegoCheckedException(1073947393L);
        }
        String vmMoId = this.getVm().getVmMoId();
        String vmName = this.getVm().getName();
        Boolean templateFlag = this.getVm().getIsTemplate();
        String dcMoId = this.getVm().getDcMoId();
        if (VerifyUtil.isMultiEmpty((Object[])new Object[]{vmMoId, vmName, dcMoId, vmPath = this.getVm().getVmPath()})) {
            logger.error((Object)"contain null params.vmMoid:[%s],vmName:[%s],dcMoId:[%s],vmPath:[%s]", new Object[]{vmMoId, vmName, dcMoId, vmPath});
            throw new LegoCheckedException(1073947393L);
        }
        this.vcenterUuid = (String)context.getAttribute("Target_vCenter");
        if (VerifyUtil.isEmpty((String)this.vcenterUuid)) {
            logger.error((Object)"contain null params.vcenterUuid:[%s]", new Object[]{this.vcenterUuid});
            throw new LegoCheckedException(1073947393L);
        }
        this.updateProcessNameParams(new String[]{vmName});
        VMAction action = new VMAction();
        ManagedObjectReference tempMor = action.findVmByPath(this.vcenterUuid, dcMoId, vmPath);
        if (null == tempMor) {
            logger.error((Object)"Vm[%s] not exist, cannot restore vm Snapshot.", new Object[]{vmName});
            return this.failure("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{vmName});
        }
        String poId = this.getVm().getUuid();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() == this.getProcStatus()) {
            logger.debug((Object)"restore vm is already success. vmName=[%s], procId=[%s]", new Object[]{vmName, this.getProcId()});
            this.setPoRecoveryStatus(poId);
            return this.success(ALREADY_SUCC, new String[]{vmName});
        }
        if (!templateFlag.booleanValue() && this.getProcType() != DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() && !(flag = this.operateVm(context))) {
            this.updateProcessDetail(FAILED, new String[]{vmName});
            logger.info((Object)("revert to snapshot failed vmName=" + vmName), 90160758786989L);
        }
        if (templateFlag.booleanValue()) {
            this.updateProcessDetail(TEMPLATE_VM_SUCCESS, new String[]{vmName});
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        this.setPoRecoveryStatus(poId);
        return true;
    }

    @Override
    protected boolean operateVm(RecoveryProcessorContext context) {
        return this.revertToSnapshot();
    }

    private boolean revertToSnapshot() {
        VMSnapshotAction snapshotAction = new VMSnapshotAction();
        VMAction vmAction = new VMAction();
        boolean revertRet = false;
        String vmMoId = this.getVm().getVmMoId();
        for (int i = 1; i <= 3; ++i) {
            try {
                if (vmAction.findVmByPath(this.vcenterUuid, this.getVm().getDcMoId(), this.getVm().getVmPath()) == null) {
                    logger.error((Object)"target vm is not register.vmName:[%s],vmPath:[%s],vcenterId:[%s],dcMoId:[%s].", new Object[]{this.getVm().getName(), this.getVm().getVmPath(), this.vcenterUuid, this.getVm().getDcMoId()});
                    return this.failure("ism.drm.recovery.vsphere.vm.unregister.already", new String[]{this.getVm().getName()});
                }
                ManagedObjectReference vmMor = GetMoPropsValueUtils.getInstance().getMorByObjUuid(vmMoId, "VirtualMachine");
                ManagedObjectReference mor = snapshotAction.getRdSnapshotReferenceOfVM(this.vcenterUuid, vmMor);
                if (VerifyUtil.isEmpty((Object)mor)) {
                    logger.debug((Object)"Vmware Snapshot is not exist. vmMoid:[%s]", new Object[]{vmMoId});
                    return this.success(SNAPSHOT_NOT_EXIST, new String[]{this.getVm().getName()});
                }
                revertRet = snapshotAction.revertToSnapshot(this.vcenterUuid, vmMoId);
            }
            catch (Exception e) {
                logger.error((Object)("revert snapshot failed with times=" + i + " vmname=" + this.getVm().getName() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
            if (revertRet) break;
            if (i >= 3) continue;
            CommonUtil.sleep((long)(5 * i * 1000));
            logger.debug((Object)"revert vmware snapshot retry. current retry time [%s]", (long)i);
        }
        logger.debug((Object)(this.getVm().getName() + "revert to snapshot result=" + revertRet), 90160758786988L);
        if (!revertRet) {
            return this.failure(FAILED, new String[]{this.getVm().getName()});
        }
        return this.success();
    }
}

