/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task.disaster;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunBaseManager;
import com.huawei.ism.drm.vsphere.recovery.task.RecoveryAlternateTargetPreparer;
import java.util.List;

public class DisasterRecoveryPreparer
extends RecoveryAlternateTargetPreparer {
    public DisasterRecoveryPreparer(BaseRecoveryProcessor processor) {
        super(processor);
    }

    @Override
    public void updateTargetStorageResourceWwn(RecoveryProcessorContext context) {
        List storageResourceList = context.getObjects("Target_Storage", StorageResource.class);
        storageResourceList.forEach(storageResource -> {
            if (DrmEnumDefine.ResourceTypeE.LUN.getValue() == storageResource.getResourceType().intValue()) {
                String deviceSn = storageResource.getDevSn();
                StorageLunManagerProxy proxy = StorageLunManagerProxy.getInstance();
                IStorageLunBaseManager manager = proxy.getStorageLunMgrByDevId(deviceSn);
                Lun lun = manager.getLunById(deviceSn, storageResource.getResourceId());
                storageResource.setResourceIndentifier(lun.getWwn());
            }
        });
    }
}

