/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.task.usedata;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateNativeLunSubProcessor;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;

public interface INativeRecoveryTargetLunBuilder {
    public static final Log logger = LogFactory.getInstance(INativeRecoveryTargetLunBuilder.class);

    default public void buildStorageResource(RecoveryProcessorContext context, Collection<RecoveryProcessor> subTasks) {
        ArrayList<StorageResource> storageResourceList = new ArrayList<StorageResource>();
        if (null == subTasks || subTasks.isEmpty()) {
            logger.info((Object)"No Native backup resources to clean up");
            context.setAttribute("Target_Storage", storageResourceList);
            return;
        }
        for (RecoveryProcessor processor : subTasks) {
            if (!(processor instanceof CreateNativeLunSubProcessor)) {
                logger.debug((Object)"Processor is %s ", new Object[]{processor.getClass().getName()});
                continue;
            }
            CreateNativeLunSubProcessor task = (CreateNativeLunSubProcessor)processor;
            StorageResource storageResource = new StorageResource(task.getDeviceId(), task.getDstLunId(), task.getDstLunWwn());
            storageResourceList.add(storageResource);
        }
        context.setAttribute("Target_Storage", storageResourceList);
    }
}

