/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.recovery.utils;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.vsphere.adapter.action.DataStoreAction;
import com.huawei.ism.drm.vsphere.adapter.action.HostSystemAction;
import com.huawei.ism.drm.vsphere.recovery.utils.StorageResourceFinder;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStore;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereDataStoreDiskInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DatastoreFinder {
    private static final Log LOGGER = LogFactory.getInstance(DatastoreFinder.class);
    private final RecoveryProcessorContext context;
    private final List<VsphereDataStore> allDatastore;

    public DatastoreFinder(RecoveryProcessorContext context) {
        if (null == context) {
            LOGGER.error((Object)"Recovery context cannot be null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupReplica protectGroupReplica = context.getProtectGroupReplica();
        if (null == protectGroupReplica) {
            String errorMsg = "Cannot find protection group replia from recovery context";
            LOGGER.error((Object)errorMsg);
            throw new LegoCheckedException(2117645L, errorMsg);
        }
        this.context = context;
        this.allDatastore = new ArrayList<VsphereDataStore>();
    }

    public VsphereDataStore findDatastore(String newDatastoreUuid) {
        return this.findDatastore(newDatastoreUuid, Collections.emptyMap());
    }

    public VsphereDataStore findDatastore(String newDatastoreUuid, Map<StorageResource, StorageResource> storageResourceConvertMap) {
        ProtectObjectStorageInfo protectObjectStorage = this.findPoStorageInfo(newDatastoreUuid, storageResourceConvertMap);
        return DatastoreFinder.generateDataStoreByPoStorageInfo(protectObjectStorage);
    }

    public ProtectObjectStorageInfo findPoStorageInfo(String newDatastoreUuid, Map<StorageResource, StorageResource> storageResourceConvertMap) {
        StorageResourceFinder storageResourceFinder;
        ProtectObjectStorageInfo protectObjectStorage;
        VsphereDataStore datastore = this.getDatastore(newDatastoreUuid);
        StorageResource oneStorageResource = this.getStorageResource(datastore);
        if (null == oneStorageResource) {
            LOGGER.error((Object)"Cannot find storeage resource by datastore, datastore url is %s and datastore name is %s", new Object[]{datastore.getUrl(), datastore.getName()});
            throw new LegoCheckedException(2117645L);
        }
        for (Map.Entry<StorageResource, StorageResource> resourceEntry : storageResourceConvertMap.entrySet()) {
            StorageResource entryKey = resourceEntry.getKey();
            if (!Objects.equals(entryKey.getDevSn(), oneStorageResource.getDevSn()) || !Objects.equals(entryKey.getResourceIndentifier(), oneStorageResource.getResourceIndentifier()) && !Objects.equals(entryKey.getResourceId(), oneStorageResource.getResourceId())) continue;
            StorageResource entryValue = resourceEntry.getValue();
            LOGGER.info((Object)"Find target resource, convert to entry value: devSn: %s=%s, resId: %s=%s, wwn: %s=%s", new Object[]{oneStorageResource.getDevSn(), entryValue.getDevSn(), oneStorageResource.getResourceId(), entryValue.getResourceId(), oneStorageResource.getResourceIndentifier(), entryValue.getResourceIndentifier()});
            oneStorageResource = entryValue;
            break;
        }
        if ((protectObjectStorage = (storageResourceFinder = new StorageResourceFinder(this.context)).getProtectObjectStorageInfo(oneStorageResource)) == null) {
            LOGGER.error((Object)"Cannot find protect object storage info by datastore uuid[%s] and target storage[%s, %s]", new Object[]{newDatastoreUuid, oneStorageResource.getDevSn(), oneStorageResource.getResourceId()});
            throw new LegoCheckedException(2117645L);
        }
        return protectObjectStorage;
    }

    public static VsphereDataStore generateDataStoreByPoStorageInfo(ProtectObjectStorageInfo poStorageInfo) {
        if (poStorageInfo == null) {
            LOGGER.error((Object)"Illegal param, protect object storage info is null.");
            throw new LegoCheckedException(1073947393L);
        }
        VsphereDataStore dataStore = new VsphereDataStore();
        dataStore.setName(poStorageInfo.getDeviceName());
        String mountPoint = poStorageInfo.getMountPoint();
        String dsUuid = mountPoint.substring("ds:///vmfs/volumes/".length(), mountPoint.length() - 1);
        dataStore.setUuid(dsUuid);
        dataStore.setUrl(mountPoint);
        return dataStore;
    }

    public VsphereDataStore getDatastore(String datastoreUuid) {
        if (null == datastoreUuid) {
            LOGGER.error((Object)"Datastore uuid cannot be null!");
            throw new LegoCheckedException(1073947393L, "Datastore uuid cannot be null!");
        }
        if (this.allDatastore.isEmpty()) {
            this.loadAllDatastore();
        }
        String dsUrl = "ds:///vmfs/volumes/" + datastoreUuid + "/";
        VsphereDataStore datastore = this.allDatastore.stream().filter(ds -> dsUrl.equals(ds.getUrl())).findFirst().orElse(null);
        if (null == datastore) {
            String errorMsg = String.format("Datastore[%s] is not exists", datastoreUuid);
            LOGGER.error((Object)errorMsg);
            throw new LegoCheckedException(2117645L, errorMsg);
        }
        return datastore;
    }

    private StorageResource getStorageResource(VsphereDataStore datastore) {
        Set diskInList = datastore.getChildMos(VsphereDataStoreDiskInfo.class);
        List storageResourceList = this.context.getObjects("Target_Storage", StorageResource.class);
        Map snapShotNguid = (Map)this.context.getAttribute("snapShotNguid");
        StorageResource oneStorageResource = null;
        for (VsphereDataStoreDiskInfo disk : diskInList) {
            for (StorageResource storageResource : storageResourceList) {
                String wwn = HostSystemAction.processStorageWwn(disk.getStorageWwn(), snapShotNguid);
                if (!wwn.equals(storageResource.getResourceIndentifier())) continue;
                oneStorageResource = storageResource;
                break;
            }
            if (null == oneStorageResource) continue;
            break;
        }
        return oneStorageResource;
    }

    private void loadAllDatastore() {
        String vCenterUuid = (String)this.context.getAttribute("Target_vCenter");
        DataStoreAction action = new DataStoreAction();
        this.allDatastore.addAll(action.queryAllDsWithoutValidate(vCenterUuid));
    }
}

