/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.ScopeManagerUtil;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.ism.drm.vsphere.sdk.model.DrHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.DrVsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereHostSystem;
import com.huawei.ism.drm.vsphere.sdk.model.VspherePhysicalStorageDevice;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

@ServiceBoundInfo(methodName="onBind", targetBeanName="siteResourceServiceProxy", properties="resType:ism.drm.deviceType.drvsphere.mainType")
public class VsphereSiteResourceServiceImpl
implements ISiteResourceService {
    private static final Log logger = LogFactory.getInstance(VsphereSiteResourceServiceImpl.class);

    public void isResourceUsed(Long moId) {
        logger.debug((Object)"isResourceUsed start");
        if (null == moId) {
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject ob = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)moId);
        if (null == ob) {
            return;
        }
        DrResource resource = SiteResourceManagerUtil.getDrResourceByMoId((Long)moId);
        if (null == resource) {
            return;
        }
        this.isVsphereUsed(resource.getDeviceSn());
    }

    public void registerResource(Site site, String[] sns) {
        if (null == site) {
            throw new LegoCheckedException(1073947393L);
        }
        if (0 == site.getSiteType() && VerifyUtil.isEmpty((Object[])sns)) {
            return;
        }
        if (site.getSiteType() != 0) {
            logger.error((Object)("the type is error:" + site.getSiteType()), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.saveVsphereIntoDB(site, sns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveVsphereIntoDB(Site site, String[] resSns) {
        if (VerifyUtil.isEmpty((Object)site) || VerifyUtil.isEmpty((Object[])resSns)) {
            return;
        }
        ArrayList<Object> drVspheres = new ArrayList<Object>(resSns.length);
        ArrayList<DrResource> drEsxis = new ArrayList<DrResource>();
        HashMap<String, String[]> props = new HashMap<String, String[]>();
        props.put("sn", resSns);
        List networkList = CommonDAOLocator.getMoDao().findMoBy(NetworkEntity.class, props);
        if (networkList.size() != resSns.length) {
            logger.error((Object)"the entity is not existed:", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        for (NetworkEntity network : networkList) {
            if (!(network instanceof VsphereCenter)) continue;
            if (null != ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(network.getSn(), "ism.drm.deviceType.drvsphere.mainType")) {
                logger.error((Object)("the storage has been registered:" + network.getSn()), 90160758787071L);
                throw new LegoCheckedException(1073947671L);
            }
            DrVsphereCenter drVsphere = (DrVsphereCenter)this.getDrResourceByMo(network);
            drVsphere.setSiteId(site.getSiteId());
            for (DrResource child : drVsphere.getChildResources()) {
                child.setSiteId(site.getSiteId());
                drEsxis.add(child);
            }
            drVspheres.add(drVsphere);
        }
        Session session = null;
        Transaction t = null;
        try {
            session = CommonDAOLocator.getMoDao().getHibernateTemplate().getSessionFactory().openSession();
            t = session.beginTransaction();
            for (DrResource drResource : drVspheres) {
                session.saveOrUpdate((Object)drResource);
            }
            for (DrResource drResource : drEsxis) {
                session.save((Object)drResource);
            }
            t.commit();
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                ExceptionUtil.rethrowException((Throwable)e, (String)"Batch save resource failed.", (long)-1L, null, (Log)logger);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
        }
        DBOperationUtil.closeSession((Session)session);
    }

    public void refreshResouce(Site site) {
        if (null == site) {
            throw new LegoCheckedException(1073947393L);
        }
        if (0 != site.getSiteType()) {
            logger.error((Object)("the type is error:" + site.getSiteType()), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public int sum(String siteId, Long userId) {
        logger.debug((Object)"sum start");
        if (VerifyUtil.isEmpty((String)siteId)) {
            return 0;
        }
        List<DrResource> resources = this.getDrResourceBySite(siteId);
        if (VerifyUtil.isEmpty(resources)) {
            return 0;
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(siteId);
        if (VerifyUtil.isEmpty((Object)site) || site.getSiteType() != 0) {
            return resources.size();
        }
        List<String> sns = new ArrayList<String>();
        for (DrResource drResource : resources) {
            sns.add(drResource.getDeviceSn());
        }
        sns = this.filterDrResourceSN(sns, userId);
        return sns.size();
    }

    private void isVsphereUsed(String uuid) {
        String hql = "from ProtectGroup as pg where poProviderSN = ?";
        List pgs = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, new Object[]{uuid});
        if (!VerifyUtil.isEmpty((Collection)pgs)) {
            logger.error((Object)"Vsphere(%s) has been used by protectGroup. Failed to unRegister.", new Object[]{uuid});
            throw new LegoCheckedException(1073947694L);
        }
        boolean isUsed = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedHostGroupByRp(uuid);
        if (isUsed) {
            logger.error((Object)"vCenter(%s) has been used by recoveryPlan.Failed to unRegister.", new Object[]{uuid});
            throw new LegoCheckedException(1073947694L);
        }
    }

    public <T extends ManagedObject> DrResource getDrResourceByMo(T mo) {
        logger.debug((Object)"getDrResourceByMo start");
        if (null == mo) {
            return null;
        }
        VsphereCenter ne = (VsphereCenter)mo;
        DrVsphereCenter vc = new DrVsphereCenter();
        vc.setDeviceSn(ne.getSn());
        vc.setIpAddress(ne.getLinkIp());
        vc.setName(ne.getName());
        vc.setStatus(String.valueOf(ne.getStatus()));
        vc.setVersion(ne.getVersion());
        vc.setDbId(UUIDGenerator.getUUID());
        List esxiHosts = CommonDAOLocator.getMoDao().getAllSubMo(mo.getMoId().longValue(), VsphereHostSystem.class);
        if (null != esxiHosts && !esxiHosts.isEmpty()) {
            for (VsphereHostSystem esxiHost : esxiHosts) {
                DrHostSystem drEsxiHost = new DrHostSystem();
                drEsxiHost.setDbId(UUIDGenerator.getUUID());
                drEsxiHost.setDeviceSn(esxiHost.getUuid());
                drEsxiHost.setName(esxiHost.getName());
                drEsxiHost.setStatus(String.valueOf(esxiHost.getStatus()));
                String hbaString = this.getHbaJsonInfo(esxiHost);
                drEsxiHost.setExtProperty(hbaString);
                drEsxiHost.setParentDrResource((DrResource)vc);
                vc.addChildResource((DrResource)drEsxiHost);
            }
        }
        return vc;
    }

    private String getHbaJsonInfo(VsphereHostSystem esxiHost) {
        JSONObject jsonObj = new JSONObject();
        JSONArray jsonArry = new JSONArray();
        List hbas = CommonDAOLocator.getMoDao().getAllSubMo(esxiHost.getMoId().longValue(), VspherePhysicalStorageDevice.class);
        try {
            for (VspherePhysicalStorageDevice hba : hbas) {
                JSONObject jsonHba;
                if ("FibreChannelHba".equals(hba.getDeviceType())) {
                    jsonHba = new JSONObject();
                    jsonHba.put((Object)"TYPE", (Object)"FC");
                    jsonHba.put((Object)"IDENTITY", (Object)hba.getStorageWwn());
                    jsonArry.add((Object)jsonHba);
                    continue;
                }
                if (!"InternetScsiHba".equals(hba.getDeviceType())) continue;
                jsonHba = new JSONObject();
                jsonHba.put((Object)"TYPE", (Object)"ISCSI");
                jsonHba.put((Object)"IDENTITY", (Object)hba.getStorageWwn());
                jsonArry.add((Object)jsonHba);
            }
            jsonObj.put((Object)"HBA", (Object)jsonArry);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"create json error.", (Throwable)e, 90160758787071L);
        }
        String hbaString = jsonObj.toString();
        return hbaString;
    }

    public DrResource getDrResourceBySn(String devSN) {
        logger.debug((Object)"getDrResourceBySn start");
        List drVsphereCenters = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVsphereCenter where deviceSn=?", new Object[]{devSN});
        if (null != drVsphereCenters && !drVsphereCenters.isEmpty()) {
            return (DrResource)drVsphereCenters.get(0);
        }
        return null;
    }

    public List<DrResource> getDrResourceBySite(Integer siteType) {
        logger.debug((Object)"getDrResourceBySite start");
        List drVsphereCenters = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVsphereCenter where siteId in (select siteId from Site where siteType = ?)", new Object[]{siteType});
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        if (null != drVsphereCenters) {
            result.addAll(drVsphereCenters);
        }
        return result;
    }

    public List<DrResource> getDrResourceBySite(String siteId) {
        logger.debug((Object)("getDrResourceBySite start:siteId=" + siteId));
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        List vsphereCenters = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVsphereCenter where siteId=?", new Object[]{siteId});
        if (null == vsphereCenters) {
            return result;
        }
        for (DrVsphereCenter vc : vsphereCenters) {
            result.add((DrResource)vc);
        }
        return result;
    }

    private List<String> filterDrResourceSN(List<String> sns, Long userId) {
        logger.debug((Object)"filterDrResourceSN start");
        if (sns.isEmpty()) {
            return new ArrayList<String>();
        }
        List filterEntities = ScopeManagerUtil.filterManagedObjectByScope(sns, (Long)userId, NetworkEntity.class);
        if (filterEntities.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> fiterSns = new ArrayList<String>();
        for (NetworkEntity entity : filterEntities) {
            fiterSns.add(entity.getSn());
        }
        return fiterSns;
    }
}

