/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.tools;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.FileEntity;

public class FileHelperEx {
    private static final String VMX_MAX_SIZE_KEY = "vmware.vmx.max.size";
    private static final String TLSV1_2 = "TLSv1.2";
    private static final long VMX_MAX_DEFAULT_SIZE = 51200L;
    private final Log logger = LogFactory.getInstance(FileHelperEx.class);
    private final CloseableHttpClient client;

    public FileHelperEx(String ip, String port, String userName, String passwd) {
        SSLContext context;
        try {
            context = SSLContext.getInstance(TLSV1_2);
            SecureRandom random = SecureRandomFactory.getInstanceStrongWithDRBG();
            context.init(null, new TrustManager[]{new BcmX509TrustManager(ip, port)}, random);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new LegoCheckedException(-1L, "Create SSL context fail,ipAddress:" + ip + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        String[] supportedProtocols = new String[]{TLSV1_2};
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, supportedProtocols, null, (HostnameVerifier)new NoopHostnameVerifier());
        Registry registry = RegistryBuilder.create().register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(registry);
        cm.setMaxTotal(100);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(ip, Integer.parseInt(port)), (Credentials)new UsernamePasswordCredentials(userName, passwd.toCharArray()));
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cm).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getFile(String url, String localDir, String localFileName) throws IOException {
        String filePath;
        CloseableHttpResponse response;
        InputStream in;
        FileOutputStream fileStream;
        HttpGet httpGet;
        block4: {
            boolean bl;
            httpGet = null;
            fileStream = null;
            in = null;
            response = null;
            try {
                httpGet = new HttpGet(url);
                response = this.client.execute((ClassicHttpRequest)httpGet);
                filePath = localDir + localFileName;
                int statusCode = response.getCode();
                long contentLen = response.getEntity().getContentLength();
                long limitLen = LegoConfig.getInstance().getNumber(VMX_MAX_SIZE_KEY, 51200L);
                if (contentLen > limitLen) {
                    this.logger.error((Object)("the file is too large,biger than size limitLen=" + limitLen + " name=" + localFileName), 90160758786989L);
                    throw new LegoCheckedException(-1L, localFileName);
                }
                if (statusCode == 200) break block4;
                this.logger.error((Object)("get file failed:reason=" + response.getReasonPhrase()));
                bl = false;
                this.closeInputStream(in);
                this.closeOutputStream(fileStream);
                this.closeResponse(response);
                if (null == httpGet) return bl;
            }
            catch (Throwable throwable) {
                this.closeInputStream(in);
                this.closeOutputStream(fileStream);
                this.closeResponse(response);
                if (null == httpGet) throw throwable;
                httpGet.cancel();
                throw throwable;
            }
            httpGet.cancel();
            return bl;
        }
        in = response.getEntity().getContent();
        fileStream = new FileOutputStream(filePath);
        response.getEntity().writeTo((OutputStream)fileStream);
        boolean ret = true;
        this.closeInputStream(in);
        this.closeOutputStream(fileStream);
        this.closeResponse(response);
        if (null == httpGet) return ret;
        httpGet.cancel();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean putFile(String url, String localDir, String localFileName) throws IOException {
        boolean ret;
        HttpPut httpPut;
        CloseableHttpResponse response;
        block4: {
            boolean bl;
            response = null;
            httpPut = null;
            ret = false;
            try {
                httpPut = new HttpPut(url);
                String filePath = localDir + localFileName;
                File file = new File(filePath);
                FileEntity fileEntity = new FileEntity(file, ContentType.APPLICATION_OCTET_STREAM);
                long fileLen = fileEntity.getContentLength();
                long limitLen = LegoConfig.getInstance().getNumber(VMX_MAX_SIZE_KEY, 51200L);
                if (fileLen > limitLen) {
                    this.logger.error((Object)("the file is too large,biger than size limitLen=" + limitLen + " name=" + localFileName), 90160758786989L);
                    throw new LegoCheckedException(-1L, localFileName);
                }
                httpPut.setEntity((HttpEntity)fileEntity);
                response = this.client.execute((ClassicHttpRequest)httpPut);
                int statusCode = response.getCode();
                if (statusCode == 200) break block4;
                this.logger.error((Object)("put file failed:faile reason:" + response.getReasonPhrase()));
                bl = false;
                this.closeResponse(response);
                if (null == httpPut) return bl;
            }
            catch (Throwable throwable) {
                this.closeResponse(response);
                if (null == httpPut) throw throwable;
                httpPut.abort();
                throw throwable;
            }
            httpPut.abort();
            return bl;
        }
        ret = true;
        this.closeResponse(response);
        if (null == httpPut) return ret;
        httpPut.abort();
        return ret;
    }

    private void closeResponse(CloseableHttpResponse response) {
        if (null != response) {
            try {
                response.close();
            }
            catch (IOException e) {
                this.logger.error((Object)("close response failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
            }
        }
    }

    private void closeOutputStream(OutputStream out) {
        if (null == out) {
            return;
        }
        try {
            out.close();
        }
        catch (IOException e) {
            this.logger.error((Object)("close outputstream failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private void closeInputStream(InputStream in) {
        if (null == in) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            this.logger.error((Object)("close inputstream failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    public void deleteLocalFile(String filePath) {
        File file = new File(filePath);
        boolean isSuccess = false;
        if (file.exists()) {
            isSuccess = file.delete();
        }
        if (!isSuccess) {
            this.logger.error((Object)"file delete failed.", 90160758786989L);
        }
    }
}

