/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.vsphere.tools;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.NeMgrProtocolExtendServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.vsphere.adapter.action.DataCenterAction;
import com.huawei.ism.drm.vsphere.sdk.model.VsDataCenter;
import com.huawei.ism.drm.vsphere.sdk.model.VsphereCenter;
import com.huawei.ism.drm.vsphere.tools.FileHelperEx;
import com.huawei.ism.drm.vsphere.tools.FileHelperMgr;
import com.huawei.lego.core.base.util.StreamUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.lego.core.sdk.util.SafeBufferedReader;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VsphereCommUtil {
    public static final String SCSI_NUM_SUFFIX = "_scsi_number";
    public static final String SCSI_FILE_PATH_REG = "scsi\\d+:\\d\\.fileName = \"/vmfs/volumes/.+";
    public static final String VM_SWAP_FILE_PATH = "sched.swap.derivedName = \"/vmfs/volumes/";
    public static final String VM_USED_FILE_PATH_SUFFIX = "\"/vmfs/volumes/";
    public static final String UTF = "UTF-8";
    public static final String EQUAL_SIGN = "=";
    private static final long RETRY_INTERVAL = 3000L;
    private static final Log logger = LogFactory.getInstance(VsphereCommUtil.class);

    public static String getTempFilePath() {
        return PathUtil.getLegoRuntimePath() + File.separator + "tmp" + File.separator;
    }

    public static boolean getFileWithRetry(String tempFileName, FileHelperEx fh, String url) throws IOException, InterruptedException {
        boolean opStatus = false;
        for (int i = 1; i <= 3 && !(opStatus = fh.getFile(url, VsphereCommUtil.getTempFilePath(), tempFileName)); ++i) {
            Thread.sleep((long)i * 3000L);
        }
        return opStatus;
    }

    public static boolean downLoadAndParseVmFile(ProtectGroup pg, Map<String, String> prop) {
        String tempDir = VsphereCommUtil.getTempFilePath();
        if (VerifyUtil.isEmpty((String)tempDir)) {
            return false;
        }
        Set pos = pg.getPolist();
        for (ProtectObject po : pos) {
            VsphereCenter vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)po.getProviderSN());
            if (null == vCenter) {
                logger.error((Object)("vCenter not exist. vcenter uuid : " + po.getProviderSN()));
                throw new LegoCheckedException(2117645L);
            }
            NeMgrProtocolExtend neMgr = NeMgrProtocolExtendServiceUtil.getNeMgrExtendService().findByMoId(vCenter.getMoId());
            if (null == neMgr) {
                logger.error((Object)("neMgr not exist. vcenter uuid : " + po.getProviderSN()));
                throw new LegoCheckedException(2117645L);
            }
            if (VsphereCommUtil.downLoadAndParse(po, prop)) continue;
            logger.error((Object)"down vm file and parse failed.");
            return false;
        }
        return true;
    }

    public static boolean downLoadAndParse(ProtectObject po, Map<String, String> prop) {
        if (null == po || null == prop) {
            logger.error((Object)"po or prop is error.");
            return false;
        }
        VsphereCenter vCenter = (VsphereCenter)CommonDAOLocator.getMoDao().getMo(VsphereCenter.class, "uuid", (Object)po.getProviderSN());
        if (null == vCenter) {
            logger.error((Object)("vCenter not exist. vcenter uuid : " + po.getProviderSN()));
            throw new LegoCheckedException(2117645L);
        }
        NeMgrProtocolExtend neMgr = NeMgrProtocolExtendServiceUtil.getNeMgrExtendService().findByMoId(vCenter.getMoId());
        if (null == neMgr) {
            logger.error((Object)"neMgr is null.");
            return false;
        }
        return VsphereCommUtil.downloadVmxByProtectObject(po, prop, neMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean downloadVmxByProtectObject(ProtectObject po, Map<String, String> prop, NeMgrProtocolExtend neMgr) {
        boolean bl;
        String ip = neMgr.getNetworkIpAddress();
        if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
            ip = Ipv6AddressUtil.convertIpv6((String)ip);
        }
        String userName = neMgr.getNetworkUserName();
        String passWd = neMgr.getNetworkPassword();
        String port = (String)neMgr.getExtendParams().get("port");
        String vmxPath = (String)po.getProps().get("VMPATH");
        int lastIndex = vmxPath.lastIndexOf("/");
        String fileNameAndSuffix = vmxPath.substring(lastIndex + 1);
        int lastDotIndex = fileNameAndSuffix.lastIndexOf(".");
        String fileName = fileNameAndSuffix.substring(0, lastDotIndex);
        String filePostfix = fileNameAndSuffix.substring(lastDotIndex + 1);
        String tempFileName = fileName + "_temp." + filePostfix + System.nanoTime();
        String datastoreName = vmxPath.substring(vmxPath.indexOf("[") + 1, vmxPath.indexOf("]"));
        FileHelperEx fh = null;
        try {
            String encodeDcName = URLEncoder.encode(VsphereCommUtil.getDcName(po), UTF);
            String encodeDsName = URLEncoder.encode(datastoreName, UTF);
            String encodeFolderName = URLEncoder.encode(fileName, UTF);
            String encodeFullFileName = URLEncoder.encode(fileNameAndSuffix, UTF);
            StringBuilder url = new StringBuilder();
            url.append("https://").append(ip).append(":").append(port).append("/folder/").append(encodeFolderName).append("/").append(encodeFullFileName).append("?dcPath=").append(encodeDcName).append("&dsName=").append(encodeDsName);
            fh = FileHelperMgr.getInstance().getFileHelper(ip, port, userName, passWd);
            boolean opStatus = VsphereCommUtil.getFileWithRetry(tempFileName, fh, url.toString());
            if (!opStatus) {
                boolean bl2 = false;
                return bl2;
            }
            String tempFile = VsphereCommUtil.getTempFilePath() + tempFileName;
            VsphereCommUtil.parseVmFile(tempFile, po, prop);
        }
        catch (IOException e) {
            logger.error((Object)("IOException" + ExceptionUtil.getErrorMessage((Throwable)e)));
            bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)("Exception" + ExceptionUtil.getErrorMessage((Throwable)e)));
            bl = false;
            return bl;
        }
        finally {
            if (null != fh) {
                fh.deleteLocalFile(VsphereCommUtil.getTempFilePath() + tempFileName);
            }
        }
        return true;
    }

    private static String getDcName(ProtectObject po) {
        String dcName = null;
        String poNetwork = (String)po.getProps().get("VirtualEthernetCard");
        JSONArray networkArr = JSONArray.fromObject((Object)poNetwork);
        if (networkArr.size() == 0) {
            logger.error((Object)"VirtualEthernetCard is empty");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject networkJson = networkArr.getJSONObject(0);
        String netWorkUuid = networkJson.getString("netWorkUuid");
        if (null == netWorkUuid || !netWorkUuid.contains(":")) {
            logger.error((Object)"netWorkUuid is empty");
            throw new LegoCheckedException(1073947393L);
        }
        String netWorkid = netWorkUuid.split(":")[1];
        DataCenterAction dcAction = new DataCenterAction();
        List<VsDataCenter> dcList = dcAction.queryVsphereDataCenter(po.getProviderSN());
        for (VsDataCenter dc : dcList) {
            if (!dc.getNetWorks().contains(netWorkid)) continue;
            dcName = dc.getName();
            break;
        }
        if (null == dcName) {
            logger.error((Object)"dcName is empty");
            throw new LegoCheckedException(1073947393L);
        }
        return dcName;
    }

    /*
     * Exception decompiling
     */
    private static void parseVmFile(String fullFilePath, ProtectObject po, Map<String, String> prop) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setScsiNumAndLunWwn(JSONObject scsiNumAndLunWwn, String fileLine, ProtectObject po) {
        String[] vmConf = fileLine.split(EQUAL_SIGN);
        String confKey = vmConf[0].trim();
        String confValue = vmConf[1].trim();
        Set poUsedStorageResources = po.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo poStorageInfo : poUsedStorageResources) {
            if (!confValue.startsWith(VM_USED_FILE_PATH_SUFFIX + poStorageInfo.getMountPoint().substring(19))) continue;
            if (scsiNumAndLunWwn.containsKey((Object)confKey)) {
                String lunWwns = scsiNumAndLunWwn.getString(confKey) + "," + poStorageInfo.getLunWWN();
                scsiNumAndLunWwn.put((Object)confKey, (Object)lunWwns);
                continue;
            }
            scsiNumAndLunWwn.put((Object)confKey, (Object)poStorageInfo.getLunWWN());
        }
    }

    public static boolean alreadyBackupScsiNum(ProtectGroup pg) {
        for (ProtectObject po : pg.getPolist()) {
            String scsiNumInfo = (String)po.getProps().get(po.getName() + SCSI_NUM_SUFFIX);
            if (null != scsiNumInfo) continue;
            logger.info((Object)"wasn't backup ScsiNum.");
            return false;
        }
        logger.info((Object)"already backup ScsiNum.");
        return true;
    }

    public static void initMasterAndSlaveMap(Map<String, String> srcAndSlaveMapping, Map<String, String> srcSnLunIdAndWwn, Map<String, String> slaveSnLunIdAndWwn, ProtectGroup pg) {
        if (null == srcAndSlaveMapping || null == srcSnLunIdAndWwn || null == slaveSnLunIdAndWwn || null == pg) {
            logger.error((Object)"error param.");
            throw new LegoCheckedException(1073947393L);
        }
        String srcStorageProviderSN = null;
        String storageProviderSN = null;
        ArrayList<String> srcStorageIds = new ArrayList<String>();
        ArrayList<String> storageIds = new ArrayList<String>();
        Set protectGroupReplicas = pg.getReplicaList();
        for (ProtectGroupReplica protectGroupReplica : protectGroupReplicas) {
            if (!protectGroupReplica.isStorageReplicationReplica()) continue;
            Set poReplicas = protectGroupReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : poReplicas) {
                Set storageInfos = protectObjectReplica.getStorageInfos();
                for (RelicaStorageInfo relicaStorageInfo : storageInfos) {
                    srcStorageProviderSN = relicaStorageInfo.getSrcStorageProviderSN();
                    srcStorageIds.add(relicaStorageInfo.getSrcStorageId());
                    storageProviderSN = relicaStorageInfo.getStorageProviderSN();
                    storageIds.add(relicaStorageInfo.getStorageId());
                    srcAndSlaveMapping.put(srcStorageProviderSN + ":" + relicaStorageInfo.getSrcStorageId(), storageProviderSN + ":" + relicaStorageInfo.getStorageId());
                }
            }
        }
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List srcLuns = storageService.getLunsByDeviceSnAndLunIds(srcStorageProviderSN, srcStorageIds);
        List slaveLun = storageService.getLunsByDeviceSnAndLunIds(storageProviderSN, storageIds);
        VsphereCommUtil.initSnLunIdAndWwn(srcLuns, srcSnLunIdAndWwn);
        VsphereCommUtil.initSnLunIdAndWwn(slaveLun, slaveSnLunIdAndWwn);
    }

    private static void initSnLunIdAndWwn(List<Lun> luns, Map<String, String> snLunIdAndWwn) {
        if (null == luns) {
            logger.error((Object)"error param.");
            throw new LegoCheckedException(1073947393L);
        }
        for (Lun lun : luns) {
            snLunIdAndWwn.put(lun.getDevSn() + ":" + lun.getLunId(), lun.getWwn());
        }
    }

    public static Map<String, String> getPoScsiNumInfo(ProtectGroup pg) {
        HashMap<String, String> allScsiNOAndLunWwn = new HashMap<String, String>();
        boolean alreadyBackup = VsphereCommUtil.alreadyBackupScsiNum(pg);
        if (!alreadyBackup && !VsphereCommUtil.downLoadAndParseVmFile(pg, allScsiNOAndLunWwn)) {
            logger.error((Object)("downLoadAndParseVmFile error. allScsiNOAndLunWwn :" + allScsiNOAndLunWwn));
            return Collections.emptyMap();
        }
        if (alreadyBackup) {
            for (ProtectObject po : pg.getPolist()) {
                String scsiBackupKey = po.getName() + SCSI_NUM_SUFFIX;
                allScsiNOAndLunWwn.put(scsiBackupKey, (String)po.getProps().get(scsiBackupKey));
            }
        }
        return allScsiNOAndLunWwn;
    }

    public static boolean downloadVmxFile(String vCenterUuid, String dcName, String vmxFilePath, String localFileName) {
        NeMgrProtocolExtend neMgr = NeMgrProtocolExtendServiceUtil.getNeMgrExtendService().findByUuid(vCenterUuid);
        if (null == neMgr) {
            logger.error((Object)"Cannot find NeMgrProtocolExtend by uuid {%s}.", new Object[]{vCenterUuid});
            return false;
        }
        String url = VsphereCommUtil.makeUrl(dcName, vmxFilePath, neMgr);
        boolean opStatus = false;
        try {
            FileHelperEx fh = FileHelperMgr.getInstance().getFileHelper(neMgr);
            opStatus = VsphereCommUtil.getFileWithRetry(localFileName, fh, url);
        }
        catch (IOException e) {
            logger.error((Object)"downloadVmxFile IOException", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"downloadVmxFile Exception", (Throwable)e);
            return false;
        }
        if (!opStatus) {
            logger.error((Object)"download vmx file:{%s} failed, not found.", new Object[]{vmxFilePath});
            throw new LegoCheckedException(1073948088L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean uploadVmxFile(String vCenterUuid, String dcName, String vmxFilePath, String localVmxfileName) {
        NeMgrProtocolExtend neMgr = NeMgrProtocolExtendServiceUtil.getNeMgrExtendService().findByUuid(vCenterUuid);
        if (null == neMgr) {
            logger.error((Object)"NeMgrProtocolExtend Not Found. vCenterUuid:%s", new Object[]{vCenterUuid});
            return false;
        }
        String url = VsphereCommUtil.makeUrl(dcName, vmxFilePath, neMgr);
        FileHelperEx fh = null;
        String tmpFilePath = VsphereCommUtil.getTempFilePath();
        try {
            fh = FileHelperMgr.getInstance().getFileHelper(neMgr);
            boolean bl = fh.putFile(url, tmpFilePath, localVmxfileName);
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)"uploadVmxFile IOException:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error((Object)"uploadVmxFile Exception:", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != fh) {
                fh.deleteLocalFile(tmpFilePath + localVmxfileName);
            }
        }
    }

    private static String makeUrl(String dcName, String vmxFilePath, NeMgrProtocolExtend neMgr) {
        try {
            String dsName = VsphereCommUtil.getDatastoreName(vmxFilePath);
            String vmxFileName = VsphereCommUtil.getVmxFileName(vmxFilePath);
            String folderName = VsphereCommUtil.getVmxFolderName(vmxFilePath);
            String encodeDcName = VsphereCommUtil.getUrlNameAfterEncode(dcName);
            String encodeDsName = VsphereCommUtil.getUrlNameAfterEncode(dsName);
            String encodeFolderName = VsphereCommUtil.getUrlNameAfterEncode(folderName);
            String encodeFullFileName = VsphereCommUtil.getUrlNameAfterEncode(vmxFileName);
            String ip = neMgr.getNetworkIpAddress();
            if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
                ip = Ipv6AddressUtil.convertIpv6((String)ip);
            }
            String port = (String)neMgr.getExtendParams().get("port");
            StringBuilder sb = new StringBuilder();
            sb.append("https://").append(ip).append(":").append(port).append("/folder/").append(encodeFolderName).append("/").append(encodeFullFileName).append("?dcPath=").append(encodeDcName).append("&dsName=").append(encodeDsName);
            String url = sb.toString();
            logger.info((Object)"vmx file path : %s", new Object[]{url});
            return url;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Encode failed", (Throwable)e);
            return null;
        }
    }

    private static String getUrlNameAfterEncode(String oriName) throws UnsupportedEncodingException {
        String newUrlName = URLEncoder.encode(oriName, UTF);
        newUrlName = newUrlName.replaceAll("\\+", "%20");
        return newUrlName;
    }

    public static String getVmxFileName(String vmxFilePath) {
        return vmxFilePath.substring(vmxFilePath.lastIndexOf("/") + 1);
    }

    public static String getDatastoreName(String vmxFilePath) {
        return vmxFilePath.substring(vmxFilePath.indexOf("[") + 1, vmxFilePath.indexOf("]"));
    }

    public static String getVmxFolderName(String vmxFilePath) {
        return vmxFilePath.substring(vmxFilePath.indexOf("]") + 2, vmxFilePath.indexOf("/"));
    }

    public static String getVmFolderPrefix(String vmxPath) {
        if (vmxPath.contains("/")) {
            return vmxPath.substring(0, vmxPath.indexOf("/"));
        }
        return vmxPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static List<AbstractMap.SimpleEntry<String, String>> loadVmxFile(String fileName) {
        String localFileFullPath = VsphereCommUtil.getTempFilePath();
        ArrayList<AbstractMap.SimpleEntry<String, String>> list = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        FileInputStream fileInputStream = null;
        SafeBufferedReader in = null;
        try {
            String line;
            fileInputStream = new FileInputStream(localFileFullPath + fileName);
            in = new SafeBufferedReader((Reader)new InputStreamReader((InputStream)fileInputStream, UTF));
            while ((line = in.readLine()) != null) {
                String[] args = line.split(EQUAL_SIGN);
                if (args.length != 2) continue;
                AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(args[0], args[1]);
                list.add(entry);
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot load vmx file");
            List<AbstractMap.SimpleEntry<String, String>> list2 = null;
            StreamUtils.closeBufferedReader(in);
            StreamUtils.closeInputStream((InputStream)fileInputStream);
            return list2;
        }
        catch (IOException ioe) {
            logger.error((Object)"Cannot load vmx file");
            List<AbstractMap.SimpleEntry<String, String>> list3 = null;
            {
                catch (Throwable throwable) {
                    StreamUtils.closeBufferedReader(in);
                    StreamUtils.closeInputStream(fileInputStream);
                    throw throwable;
                }
            }
            StreamUtils.closeBufferedReader(in);
            StreamUtils.closeInputStream((InputStream)fileInputStream);
            return list3;
        }
        StreamUtils.closeBufferedReader((BufferedReader)in);
        StreamUtils.closeInputStream((InputStream)fileInputStream);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean storeProperties(List<AbstractMap.SimpleEntry<String, String>> list, String filePath) {
        String localFilePath = VsphereCommUtil.getTempFilePath() + filePath;
        FileOutputStream fos = null;
        BufferedWriter out = null;
        if (VerifyUtil.isEmpty(list)) {
            return false;
        }
        try {
            fos = new FileOutputStream(new File(localFilePath));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, UTF));
            for (AbstractMap.SimpleEntry<String, String> entry : list) {
                String key = entry.getKey();
                String value = entry.getValue();
                String line = key + EQUAL_SIGN + value;
                out.write(line);
                out.newLine();
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Cannot find vmx from temp dir.");
            boolean bl = false;
            StreamUtils.closeOutputStream((OutputStream)fos);
            StreamUtils.closeBufferWriter(out);
            return bl;
        }
        catch (IOException ioe) {
            logger.error((Object)"Save vmx file failed");
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    StreamUtils.closeOutputStream(fos);
                    StreamUtils.closeBufferWriter(out);
                    throw throwable;
                }
            }
            StreamUtils.closeOutputStream((OutputStream)fos);
            StreamUtils.closeBufferWriter(out);
            return bl;
        }
        StreamUtils.closeOutputStream((OutputStream)fos);
        StreamUtils.closeBufferWriter((BufferedWriter)out);
        return true;
    }

    public static String getDatastoreId(String mountPoint) {
        if (VerifyUtil.isEmpty((String)mountPoint)) {
            return "";
        }
        return mountPoint.substring("ds:///vmfs/volumes/".length(), mountPoint.length() - 1);
    }
}

