/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.kube.util;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public class StringUtilsX
extends StringUtils {
    private static final String CLUSTER_SERVER_REGEX = "^(https?://).*";
    private static final String CLUSTER_SERVER_REGEX_IP_PORT = "^(http|https)://(?:[0-9]{1,3}\\.){3}[0-9]{1,3}:[0-9]{1,5}$";

    public static boolean isServerAddressAvailable(String server) {
        return StringUtilsX.isServerAddressAvailable(server, true);
    }

    public static boolean isServerAddressAvailable(String server, boolean isStrict) {
        if (StringUtilsX.isEmpty((CharSequence)server)) {
            return false;
        }
        if (isStrict) {
            return server.matches(CLUSTER_SERVER_REGEX_IP_PORT);
        }
        return server.matches(CLUSTER_SERVER_REGEX);
    }

    public static String parseHostByAddress(String address) {
        URI uri = StringUtilsX.parseAddress(address);
        return uri.getHost();
    }

    public static int parsePortByAddress(String address) {
        URI uri = StringUtilsX.parseAddress(address);
        return uri.getPort();
    }

    public static URI parseAddress(String address) {
        try {
            URI uri = new URI(address);
            if (VerifyUtil.isEmpty((String)uri.getScheme()) || VerifyUtil.isEmpty((String)uri.getHost()) || uri.getPort() == -1) {
                throw new LegoCheckedException(1073947735L);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new LegoCheckedException(-1L);
        }
    }
}

