/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.trapaddress.model;

import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;

public class TrapSNMPV3VO {
    private static final long serialVersionUID = 1025401137032696995L;
    private Long id;
    private String authProtocol;
    private String authPwd;
    private String encryptProtocol;
    private String encryptPwd;
    private int type;
    private String securityName;
    private String contextEngineId;
    private String contextName;
    private int version;
    private String readCommunity;
    private String writeCommunity;

    public TrapSNMPV3VO() {
    }

    public TrapSNMPV3VO(SnmpV3Param templateV3) {
        this.changeProtocol(templateV3);
        this.authPwd = templateV3.getAuthPwd();
        this.encryptPwd = templateV3.getPrivPwd();
        this.securityName = templateV3.getSecurityName();
        this.contextName = templateV3.getContextName();
        this.contextEngineId = templateV3.getContextEngineId();
        this.id = templateV3.getSnmpV3ParamId();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getContextEngineId() {
        return this.contextEngineId;
    }

    public void setContextEngineId(String contextEngineId) {
        this.contextEngineId = contextEngineId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    private void changeProtocol(SnmpV3Param snmpv3) {
        String authName = snmpv3.getAuthProtocol().name();
        this.authProtocol = SnmpEnum.AuthProtocol.MD5_AUTH.name().equals(authName) ? "HMACMD5" : (SnmpEnum.AuthProtocol.SHA1_AUTH.name().equals(authName) ? "HMAC_SHA1" : (SnmpEnum.AuthProtocol.SHA2_AUTH.name().equals(authName) ? "HMAC_SHA2" : (SnmpEnum.AuthProtocol.SHA2_384_AUTH.name().equals(authName) ? "HMAC_SHA2_384" : (SnmpEnum.AuthProtocol.SHA2_512_AUTH.name().equals(authName) ? "HMAC_SHA2_512" : ""))));
        String privName = snmpv3.getPrivProtocol().name();
        this.encryptProtocol = SnmpEnum.PrivProtocol.CFB_AES_128.name().equals(privName) ? "AES" : (SnmpEnum.PrivProtocol.CFB_AES_192.name().equals(privName) ? "AES192" : (SnmpEnum.PrivProtocol.CFB_AES_256.name().equals(privName) ? "AES256" : (SnmpEnum.PrivProtocol.CBC_DES.name().equals(privName) ? "DES" : "")));
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.authProtocol = authProtocol;
    }

    public String getAuthPwd() {
        return this.authPwd;
    }

    public void setAuthPwd(String authPwd) {
        this.authPwd = authPwd;
    }

    public String getEncryptProtocol() {
        return this.encryptProtocol;
    }

    public void setEncryptProtocol(String encryptProtocol) {
        this.encryptProtocol = encryptProtocol;
    }

    public String getEncryptPwd() {
        return this.encryptPwd;
    }

    public void setEncryptPwd(String encryptPwd) {
        this.encryptPwd = encryptPwd;
    }

    public String getReadCommunity() {
        return this.readCommunity;
    }

    public void setReadCommunity(String readCommunity) {
        this.readCommunity = readCommunity;
    }

    public String getWriteCommunity() {
        return this.writeCommunity;
    }

    public void setWriteCommunity(String writeCommunity) {
        this.writeCommunity = writeCommunity;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

