/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.protection.group;

import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.kube.sdk.model.AbstractKubeBackupModel;
import com.huawei.ism.drm.kube.sdk.model.BackupInstanceInfo;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeSchedulePolicy;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.protection.action.model.ProtectActionVo;
import com.huawei.ism.drm.protection.action.model.ProtectPathActionLogs;
import com.huawei.ism.drm.protection.action.model.ProtectPathActions;
import com.huawei.ism.drm.protection.action.service.IProtectActionService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.UpdateDiskRequest;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.ProtectLocationPath;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupBaseRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.service.platform.protection.group.ScheduleFormater;
import com.huawei.ism.drm.rest.util.DrmStorageUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.BackupPlan;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.moment.bedstone.shield.annotation.Context;
import com.huawei.moment.bedstone.shield.annotation.Contexts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;

public class ProtectGroupRestServiceImpl
extends ProtectGroupBaseRestServiceImpl {
    private static final Log LOG = LogFactory.getInstance(ProtectGroupRestServiceImpl.class);
    private static final String PROTECTION_RELATION = "protectionRelation";
    private static final List<String> TEMPLATE_PROPS_KEY = Collections.unmodifiableList(Arrays.asList("CLONE_SPLIT", "AUTOMOUNTCONFIGS"));
    private static final int MAX_SPLIT_TIME = 1410;

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String queryProtectActionsLog(String protectGroupId) {
        List detail;
        this.validateProtectGroupId(protectGroupId);
        try {
            detail = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).getActionLogs(protectGroupId);
        }
        catch (LegoCheckedException e) {
            LOG.info((Object)"QueryProtectActionsLog service error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (VerifyUtil.isEmpty((Collection)detail)) {
            LOG.info((Object)"Detail is empty");
            return "";
        }
        return this.toProtectGroupActionLogJson(detail);
    }

    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    public String queryProtectActions(String protectGroupId) {
        List detail;
        this.validateProtectGroupId(protectGroupId);
        try {
            detail = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).getActions(protectGroupId);
        }
        catch (LegoCheckedException e) {
            LOG.info((Object)"QueryProtectActions service error");
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (VerifyUtil.isEmpty((Collection)detail)) {
            throw new LegoCheckedException(1073947393L);
        }
        return this.toProtectGroupActionJson(detail);
    }

    @Override
    @Contexts(value={@Context(name="pg"), @Context(name="vo")})
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedAction_disableStep_operateName", rank=2, object="$vo?.name", detail="protectedGroup_disableStep_operateDetail", parameters={"$pg?.name", "$vo?.name"})
    public Response disableProtectAction(String protectGroupId, String actionId) {
        this.validateProtectGroupId(protectGroupId);
        this.validateProtectGroupId(actionId);
        ProtectActionVo vo = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).queryProtectAction(protectGroupId, actionId);
        if (vo == null) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"vo", (Object)vo);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(vo.getProtectGroupId(), false);
        if (pg == null) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"pg", (Object)pg);
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        ((IProtectActionService)this.getBundleService(IProtectActionService.class)).disableAction(protectGroupId, actionId);
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="pg"), @Context(name="vo")})
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedAction_enableStep_operateName", rank=2, object="$vo?.name", detail="protectedGroup_enableStep_operateDetail", parameters={"$pg?.name", "$vo?.name"})
    public Response enableProtectAction(String protectGroupId, String actionId) {
        this.validateProtectGroupId(protectGroupId);
        this.validateProtectGroupId(actionId);
        ProtectActionVo vo = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).queryProtectAction(protectGroupId, actionId);
        if (vo == null) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"vo", (Object)vo);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(vo.getProtectGroupId(), false);
        if (pg == null) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"pg", (Object)pg);
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        ((IProtectActionService)this.getBundleService(IProtectActionService.class)).enableAction(protectGroupId, actionId);
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="pg"), @Context(name="vo")})
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedAction_modifyStep_operateName", rank=2, object="$vo?.name", detail="protectedGroup_modifyStep_operateDetail", parameters={"$pg?.name", "$vo?.name"})
    public Response modifyProtectAction(String protectGroupId, String actionId, Map<String, String> params) {
        this.validateProtectGroupId(actionId);
        ProtectActionVo vo = ((IProtectActionService)this.getBundleService(IProtectActionService.class)).queryProtectAction(protectGroupId, actionId);
        if (vo == null) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"vo", (Object)vo);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(vo.getProtectGroupId(), false);
        if (pg == null) {
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)"pg", (Object)pg);
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        ((IProtectActionService)this.getBundleService(IProtectActionService.class)).modifyAction(protectGroupId, actionId, params);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getStorageLunsStatistic(int poType, int templateType, List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects) || null == DrmEnumDefine.AppType.getType((int)poType) || null == PolicyTemplateType.PolicyTemplateE.getType((int)templateType)) {
            LOG.error((Object)"PoType: %s, templateType: %s", new Object[]{poType, templateType});
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService protectGroupService = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
        List storageResources = protectGroupService.getUsedStorageLunsByProtectObject(protectObjects, poType, templateType);
        return DrmStorageUtil.getStorageResourceStatisticByLun(storageResources, templateType);
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"}, moid={"$1"})
    public String getAvailableTimeWindowRanges(String devSn, List<ProtectObject> pos) {
        if (CollectionUtils.isEmpty(pos)) {
            LOG.error((Object)"Error input ProtectObject list.");
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class.getName(), IProtectGroupService.class);
        return pgServices.getProtectGroupTimeWindowRange(devSn, pos);
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getStorageResources(int poType, int templateType, List<ProtectObject> protectObjects) {
        if (VerifyUtil.isEmpty(protectObjects) || null == DrmEnumDefine.AppType.getType((int)poType) || null == PolicyTemplateType.PolicyTemplateE.getType((int)templateType)) {
            LOG.error((Object)"PoType: %s, templateType: %s", new Object[]{poType, templateType});
            throw new LegoCheckedException(1073947393L);
        }
        IProtectGroupService protectGroupService = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
        List storageResources = protectGroupService.getUsedStorageLunsByProtectObject(protectObjects, poType, templateType);
        JSONArray response = new JSONArray();
        for (StorageResource storageResource : storageResources) {
            JSONObject record = new JSONObject();
            record.put((Object)"uuid", (Object)storageResource.getUuid());
            record.put((Object)"name", (Object)storageResource.getName());
            record.put((Object)"devSn", (Object)storageResource.getDevSn());
            record.put((Object)"resourceId", (Object)storageResource.getResourceId());
            String identifier = storageResource.getResourceIndentifier();
            record.put((Object)"resourceIndentifier", (Object)(identifier != null ? identifier : ""));
            double totalCapacity = UnitConvert.convert((double)storageResource.getTotalCapacity(), (IUnitType)CapabilityUnitType.valueOf((String)storageResource.getTotalCapacityUnit()), (IUnitType)CapabilityUnitType.MB, (int)3);
            record.put((Object)"totalCapacity", (Object)totalCapacity);
            String displayTotalCapacity = CapacityUnitUtil.getCapacityAndUnit((Double)totalCapacity, (CapabilityUnitType)CapabilityUnitType.MB);
            record.put((Object)"totalCapacityDisplayValue", (Object)displayTotalCapacity);
            if (storageResource instanceof XveLun) {
                XveLun xveLun = (XveLun)storageResource;
                record.put((Object)"poolId", (Object)xveLun.getStoragePoolId());
                record.put((Object)"poolName", (Object)xveLun.getStoragePoolName());
            }
            response.add((Object)record);
        }
        return response.toString();
    }

    private String toProtectGroupActionLogJson(List<ProtectPathActionLogs> detail) {
        if (VerifyUtil.isEmpty(detail)) {
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (ProtectPathActionLogs entry : detail) {
            JSONObject everyDetail = new JSONObject();
            ProtectLocationPath path = entry.getPath();
            everyDetail.put((Object)"protectLocation", (Object)path.getProtectLocation());
            everyDetail.put((Object)"protectedSiteName", (Object)path.getProtectedSiteName());
            everyDetail.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            JSONArray array = new JSONArray();
            List logDetailList = entry.getProtectionLogDetails();
            for (ProtectGroupLogDetail groupLogDetail : logDetailList) {
                JSONObject obj = new JSONObject();
                try {
                    this.addGroupDetailToJson(array, groupLogDetail, obj);
                }
                catch (LegoCheckedException e) {
                    LOG.error((Object)"JSON operation failed.", (Throwable)e);
                }
            }
            everyDetail.put((Object)"protectGroupLogDetails", (Object)array);
            result.add((Object)everyDetail);
        }
        return result.toString();
    }

    private String toProtectGroupActionJson(List<ProtectPathActions> detail) {
        if (VerifyUtil.isEmpty(detail)) {
            LOG.debug((Object)"Detail is empty!");
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (ProtectPathActions entry : detail) {
            JSONObject everyAction = new JSONObject();
            ProtectLocationPath path = entry.getPath();
            everyAction.put((Object)"protectLocation", (Object)path.getProtectLocation());
            everyAction.put((Object)"protectedSiteName", (Object)path.getProtectedSiteName());
            everyAction.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            List actionList = entry.getActions();
            JSONArray array = new JSONArray();
            for (ProtectActionVo vo : actionList) {
                JSONObject everyVo = new JSONObject();
                everyVo.put((Object)"uuid", (Object)vo.getActionId());
                everyVo.put((Object)"actionType", (Object)vo.getActionType());
                everyVo.put((Object)"name", (Object)vo.getName());
                everyVo.put((Object)"nameParams", (Object)(VerifyUtil.isEmpty((String)vo.getNameParams()) ? "" : vo.getNameParams()));
                everyVo.put((Object)"isEditable", (Object)vo.isEditable());
                everyVo.put((Object)"enable", (Object)vo.isEnable());
                JSONObject everyParams = new JSONObject();
                for (Map.Entry param : vo.getParams().entrySet()) {
                    everyParams.put(param.getKey(), param.getValue());
                }
                everyVo.put((Object)"params", (Object)everyParams);
                everyVo.put((Object)"protectedType", (Object)vo.getProtectedType());
                array.add((Object)everyVo);
            }
            everyAction.put((Object)"actions", (Object)array);
            result.add((Object)everyAction);
        }
        return result.toString();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_modifyPolicy_operateName", rank=2, object="$pg?.name")
    public Response modifyProtectGroupPolicyTemplate(String protectgroupId, PolicyTemplate policyTemplate) {
        this.validateProtectGroupId(protectgroupId);
        ProtectGroup pg = this.getService().getProtectGroupByID(protectgroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        if (this.validateIsHypermetro(pg) || this.validateIsReplication(pg)) {
            throw new LegoCheckedException(1073947453L);
        }
        PolicyTemplate pt = this.checkModifyProtectGroupParam(policyTemplate, pg);
        this.validatePolicyTemplate(pt, pg.getPoType());
        ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).updateProtectGroupTemplate(protectgroupId, pt);
        return Response.ok().build();
    }

    private PolicyTemplate checkModifyProtectGroupParam(PolicyTemplate inputPolicyTpl, ProtectGroup pg) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            throw new LegoCheckedException(1073947394L);
        }
        PolicyTemplate pt = pg.getTemplate();
        if (VerifyUtil.isEmpty((Object)pt) || VerifyUtil.isEmpty((Collection)pt.getSchedules())) {
            LOG.error((Object)"Pt may be empty! pt: %s", new Object[]{pt});
            throw new LegoCheckedException(1073947394L);
        }
        if (VerifyUtil.isEmpty((Object)inputPolicyTpl)) {
            LOG.error((Object)"The input policyTpl is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        this.setProps(inputPolicyTpl, pt);
        return pt;
    }

    private void setProps(PolicyTemplate inputPolicyTpl, PolicyTemplate pt) {
        Map props = inputPolicyTpl.getProps();
        if (VerifyUtil.isEmpty((Map)props)) {
            LOG.error((Object)"Not find props.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.checkTplProps(props)) {
            LOG.error((Object)"Not find props key in the white list, please check");
            throw new LegoCheckedException(1073947393L);
        }
        String protectionRelation = (String)pt.getProps().get(PROTECTION_RELATION);
        pt.getProps().clear();
        pt.setProps(props);
        pt.getProps().put(PROTECTION_RELATION, protectionRelation);
    }

    private boolean checkTplProps(Map<String, String> props) {
        Iterator<Map.Entry<String, String>> iterator = props.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!TEMPLATE_PROPS_KEY.contains(entry.getKey())) {
                return false;
            }
            String valueString = entry.getValue();
            try {
                JSONObject data = JSONObject.fromObject((Object)valueString);
                return this.checkData(entry.getKey(), data);
            }
            catch (LegoCheckedException e) {
                LOG.error((Object)"To json failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                return false;
            }
        }
        return true;
    }

    private boolean checkData(String key, JSONObject data) {
        if ("CLONE_SPLIT".equals(key)) {
            if (!data.containsKey((Object)"create_snap") || !(data.get("create_snap") instanceof Boolean)) {
                LOG.error((Object)"Not find needed create_snap key.");
                return false;
            }
            if (data.containsKey((Object)"split_delay_time")) {
                Object obj = data.get("split_delay_time");
                int delayTime = NumberUtil.parseInteger((Object)obj.toString());
                if (delayTime == 0) {
                    LOG.error((Object)"Value of split_delay_time type is maybe wrong: %s", new Object[]{obj});
                    return false;
                }
                return delayTime >= 1 && delayTime <= 1410;
            }
        }
        if ("AUTOMOUNTCONFIGS".equals(key)) {
            if (!data.containsKey((Object)"enabled")) {
                LOG.error((Object)"Not find needed enabled key.");
                return false;
            }
            boolean enabled = (Boolean)data.get("enabled");
            if (enabled) {
                JSONArray jsonArray = (JSONArray)data.get("mountConfigs");
                return jsonArray != null && !jsonArray.isEmpty();
            }
        }
        return true;
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getProtectLocations(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        List detail = null;
        try {
            detail = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectLocations(protectGroupId);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"GetProtectLocations service error", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"GetProtectLocations service error", (long)-1L, null, (Log)LOG);
        }
        if (VerifyUtil.isEmpty((Collection)detail)) {
            LOG.error((Object)"Detail is empty.");
            throw new LegoCheckedException(-1L);
        }
        return this.toProtectLocationJson(detail);
    }

    private String toProtectLocationJson(List<ProtectLocationPath> detail) {
        JSONArray array = new JSONArray();
        for (ProtectLocationPath path : detail) {
            JSONObject jo = new JSONObject();
            jo.put((Object)"protectLocation", (Object)String.valueOf(path.getProtectLocation()));
            JSONObject child = new JSONObject();
            child.put((Object)"recoverySiteName", (Object)path.getRecoverySiteName());
            child.put((Object)"recoverySiteId ", (Object)path.getRecoverySiteId());
            jo.put((Object)"detail", (Object)child);
            array.add((Object)jo);
        }
        LOG.debug((Object)"Array str: %s", new Object[]{array});
        return array.toString();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"})
    public String getProtectObjecsByReplica(String replicaId) {
        JSONObject jsonObject = new JSONObject();
        try {
            List poList = ((IReplicaService)this.getBundleService(IReplicaService.class)).getProtectObjectListByReplicaId(replicaId);
            jsonObject.put((Object)"records", this.protectObjectListToJsonStr(poList));
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Querying protect object by pg failed, replicaId: %s", new Object[]{replicaId, e});
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"GetProtectObjecsByReplica error", (long)-1L, null, (Log)LOG);
        }
        return jsonObject.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String queryUseHypermetroStorage(String protectGroupId) {
        List list = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getUseHypermetroStorage(protectGroupId);
        JSONArray array = JSONArray.fromObject((Object)list);
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String queryDiskInfo(String protectGroupId) {
        this.validateProtectGroupId(protectGroupId);
        List diskInfos = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).queryDiskInfo(protectGroupId);
        JSONArray diskJSONArray = new JSONArray();
        diskInfos.stream().map(diskInfo -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"devSn", (Object)diskInfo.getDevSn());
            jsonObject.put((Object)"resourceId", (Object)diskInfo.getResourceId());
            jsonObject.put((Object)"deviceName", (Object)diskInfo.getDeviceName());
            jsonObject.put((Object)"poolId", (Object)diskInfo.getPoolId());
            jsonObject.put((Object)"poolName", (Object)diskInfo.getPoolName());
            jsonObject.put((Object)"status", (Object)diskInfo.getStatus());
            JSONArray poArray = new JSONArray();
            diskInfo.getProtectObjects().stream().map(po -> {
                JSONObject poJsonObj = new JSONObject();
                poJsonObj.put((Object)"moUuid", (Object)po.getMoUuid());
                poJsonObj.put((Object)"name", (Object)po.getName());
                return poJsonObj;
            }).forEach(arg_0 -> ((JSONArray)poArray).add(arg_0));
            jsonObject.put((Object)"protectObjects", (Object)poArray);
            jsonObject.put((Object)"recoveryPools", (Object)JSONArray.fromObject((Object)diskInfo.getRecoveryPools()));
            return jsonObject;
        }).forEach(arg_0 -> ((JSONArray)diskJSONArray).add(arg_0));
        return diskJSONArray.toString();
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.refresh"}, uuid={"$1"})
    @Logging(name="protectedGroup_updateDiskProtect_operateName", rank=2, object="$1")
    public Response updateDiskProtect(String protectGroupId, UpdateDiskRequest updateDiskRequest) {
        this.validateProtectGroupId(protectGroupId);
        ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).updateDiskProtect(protectGroupId, updateDiskRequest);
        return Response.ok().build();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String listSchedule(String protectGroupId) {
        List<Schedule> results = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getAllSchedule(protectGroupId);
        if (null == results) {
            results = Collections.emptyList();
        } else {
            ScheduleFormater.format(results);
        }
        JSONArray jsonArray = new JSONArray();
        for (Schedule schedule : results) {
            JSONObject scheduleObject = JSONObject.fromObject((Object)schedule);
            this.setRangeTime(scheduleObject);
            jsonArray.add((Object)scheduleObject);
        }
        return jsonArray.toString();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_schedule_add_operateName", rank=2, object="$pg?.name")
    public Response addSchedule(String protectGroupId, Schedule schedule) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        ProtectGroupValidator.checkSchedule(schedule);
        ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).addSchedule(protectGroupId, schedule);
        return Response.ok().build();
    }

    private void checkScheduleAuthority(String protectGroupId) {
        this.checkUserOperationAuthority("protectedGroup_modifyPolicy_operateName", 2, "ism.drm.protectgroup.auth.modify");
        this.validateProtectGroupId(protectGroupId);
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getSchedule(String protectGroupId, String scheduleId) {
        List scheduleList = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getAllSchedule(protectGroupId);
        Schedule result = null;
        for (Schedule schedule : scheduleList) {
            if (!schedule.getScheduleId().equals(scheduleId)) continue;
            result = schedule;
            break;
        }
        if (null == result) {
            throw new LegoCheckedException(1073947394L);
        }
        ScheduleFormater.format(result);
        JSONObject scheduleObject = JSONObject.fromObject(result);
        this.setRangeTime(scheduleObject);
        return scheduleObject.toString();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_schedule_update_operateName", rank=2, object="$pg?.name", detail="protectedGroup_schedule_update_operateDetail", parameters={"$pg?.name", "$2"})
    public Response updateSchedule(String protectGroupId, String scheduleId, Schedule schedule) {
        if (schedule == null) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroupValidator.checkSchedule(schedule);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        schedule.setScheduleId(scheduleId);
        long taskId = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).updateSchedule(protectGroupId, schedule);
        JSONObject obj = new JSONObject();
        obj.put((Object)"taskId", (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Override
    @Contexts(value={@Context(name="pg"), @Context(name="scheduleIds")})
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_schedule_update_operateName", rank=2, object="$pg?.name", detail="protectedGroup_schedule_update_operateDetail", parameters={"$pg?.name", "$scheduleIds"})
    public Response updateSchedules(String protectGroupId, List<Schedule> schedules) {
        if (VerifyUtil.isEmpty(schedules)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.checkScheduleAuthority(protectGroupId);
        HashSet<Schedule> updateSchedules = new HashSet<Schedule>();
        HashSet<String> updateScheduleIds = new HashSet<String>();
        HashSet<Schedule> addSchedules = new HashSet<Schedule>();
        for (Schedule schedule : schedules) {
            if ("1".equals(schedule.getExtParameters().get("isNewSchedule"))) {
                addSchedules.add(schedule);
                continue;
            }
            updateSchedules.add(schedule);
            updateScheduleIds.add(schedule.getScheduleId());
        }
        this.checkScheduleAuthority(protectGroupId);
        IProtectGroupService service = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
        ProtectGroup pg = service.getProtectGroupByID(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        this.deleteSchedules(pg, schedules, updateScheduleIds, service);
        this.updateSchedules(protectGroupId, updateSchedules, service);
        this.addSchedules(protectGroupId, addSchedules, service);
        ArrayList scheduleIds = new ArrayList(schedules.stream().map(Schedule::getScheduleId).collect(Collectors.toList()));
        Context.Variable.set((String)"scheduleIds", (Object)((Object)scheduleIds).toString());
        return Response.ok().build();
    }

    private void deleteSchedules(ProtectGroup protectGroup, List<Schedule> schedules, Set<String> updateScheduleIds, IProtectGroupService service) {
        List<Schedule> disableScheduleList = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getAllSchedule(protectGroup.getUuid()).stream().filter(schedule -> !updateScheduleIds.contains(schedule.getScheduleId())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(disableScheduleList)) {
            return;
        }
        IKubeService kubeService = (IKubeService)this.getBundleService("DRM_Kubernetes_Manager", IKubeService.class.getName(), IKubeService.class);
        this.checkPlanStatus(protectGroup, kubeService);
        List<String> names = this.getListFromProps(protectGroup.getProps(), "kube_policy");
        Map<KubeEnumDefine.PolicyType, KubeSchedulePolicy> policyTypeKubeSchedulePolicyMap = kubeService.getPolicies(schedules.get(0).getSourceSn(), names).stream().filter(policy -> policy.getPolicyType() != null).collect(Collectors.toMap(policy -> policy.getPolicyType(), policy -> policy));
        Map<KubeEnumDefine.TimeWaitType, KubeSchedulePolicy> timeWaitTypeKubeSchedulePolicyMap = kubeService.getPolicies(schedules.get(0).getSourceSn(), names).stream().filter(policy -> policy.getTimeWait() != null).collect(Collectors.toMap(policy -> policy.getTimeWait(), policy -> policy));
        ArrayList<KubeSchedulePolicy> deletePolicies = new ArrayList<KubeSchedulePolicy>();
        this.buildNamesAndPolicies(disableScheduleList, names, policyTypeKubeSchedulePolicyMap, deletePolicies, timeWaitTypeKubeSchedulePolicyMap);
        protectGroup.getProps().put("kube_policy", JSONArray.fromObject(names).toString());
        service.saveProtectGroup(protectGroup);
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.removePolicyFromProtectionPlan(kubeService, protectGroup, deletePolicies);
            this.checkReplicationPolicyDeletedInCDR(kubeService, protectGroup, deletePolicies);
            kubeService.deleteSchedulePolicy(schedules.get(0).getTargetSn(), deletePolicies);
            kubeService.deleteSchedulePolicy(schedules.get(0).getSourceSn(), deletePolicies);
        } else if (PolicyTemplateType.KUBE_BACKUP_TYPES.contains(protectGroup.getTemplate().getType())) {
            this.removePolicyFromBackupInstance(kubeService, protectGroup, deletePolicies);
            this.checkBackupPolicyDeletedInCDR(kubeService, protectGroup, deletePolicies);
            kubeService.deleteSchedulePolicy(schedules.get(0).getSourceSn(), deletePolicies);
        }
        disableScheduleList.forEach(schedule -> service.disableSchedule(protectGroup.getUuid(), schedule.getScheduleId()));
    }

    private void checkPlanStatus(ProtectGroup protectGroup, IKubeService kubeService) {
        int type = protectGroup.getTemplate().getType();
        if (!PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(type) && !PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(type)) {
            return;
        }
        KubeProtectionPlan srcPlan = kubeService.getProtectionPlan(protectGroup.getPoProviderSN(), protectGroup.getProperty("kube_protection_plan"));
        KubeProtectionPlan trgPlan = kubeService.getProtectionPlan(((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn(), protectGroup.getProperty("kube_protection_plan"));
        if (!KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)srcPlan.getStatus()) || !KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)trgPlan.getStatus())) {
            throw new LegoCheckedException(1073947751L, new String[]{srcPlan.getName(), !KubeEnumDefine.CDRProtectGroupStatus.NORMAL.equals((Object)srcPlan.getStatus()) ? String.valueOf(srcPlan.getStatus()) : String.valueOf(trgPlan.getStatus())});
        }
    }

    private void checkBackupPolicyDeletedInCDR(IKubeService kubeService, ProtectGroup protectGroup, List<KubeSchedulePolicy> deletePolicies) {
        if (VerifyUtil.isEmpty(deletePolicies)) {
            return;
        }
        int maxTime = 30;
        String devSn = protectGroup.getPoProviderSN();
        List deletePolicyNames = deletePolicies.stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toList());
        boolean isPolicyRemoveInBackupInstance = true;
        long waitTime = 6000L;
        for (int retryTime = 0; retryTime < maxTime; ++retryTime) {
            CommUtil.pauseThread((long)waitTime);
            isPolicyRemoveInBackupInstance = true;
            BackupInstanceInfo backupInstance = kubeService.getBackupInstance(devSn, protectGroup.getProperty("kube_backup_instance"));
            if (VerifyUtil.isEmpty((Collection)backupInstance.getBackupPolicyNamesInStatus())) {
                return;
            }
            HashSet policyNames = new HashSet(backupInstance.getBackupPolicyNamesInStatus());
            for (String name : deletePolicyNames) {
                if (!policyNames.contains(name)) continue;
                isPolicyRemoveInBackupInstance = false;
            }
            if (isPolicyRemoveInBackupInstance) break;
        }
        if (!isPolicyRemoveInBackupInstance) {
            LOG.error((Object)"Delete policy from CDR failed. Policy names:", new Object[]{deletePolicyNames.toString()});
            throw new LegoCheckedException(-1L);
        }
    }

    private void checkReplicationPolicyDeletedInCDR(IKubeService kubeService, ProtectGroup protectGroup, List<KubeSchedulePolicy> deletePolicies) {
        if (VerifyUtil.isEmpty(deletePolicies)) {
            return;
        }
        int maxTime = 30;
        String devSn = protectGroup.getPoProviderSN();
        List deletePolicyNames = deletePolicies.stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toList());
        boolean isPolicyRemoveInProtectionPlan = true;
        long waitTime = 6000L;
        for (int retryTime = 0; retryTime < maxTime; ++retryTime) {
            CommUtil.pauseThread((long)waitTime);
            KubeProtectionPlan plan = kubeService.getProtectionPlan(devSn, protectGroup.getProperty("kube_protection_plan"));
            if (VerifyUtil.isEmpty((Collection)plan.getProtectionPoliciesInstatus())) {
                return;
            }
            HashSet policyNames = new HashSet(plan.getProtectionPoliciesInstatus());
            isPolicyRemoveInProtectionPlan = true;
            for (String name : deletePolicyNames) {
                if (!policyNames.contains(name)) continue;
                isPolicyRemoveInProtectionPlan = false;
            }
            if (isPolicyRemoveInProtectionPlan) break;
        }
        if (!isPolicyRemoveInProtectionPlan) {
            LOG.error((Object)"Delete policy from CDR failed. Policy names:", new Object[]{deletePolicyNames.toString()});
            throw new LegoCheckedException(-1L);
        }
    }

    private void removePolicyFromBackupInstance(IKubeService kubeService, ProtectGroup protectGroup, List<KubeSchedulePolicy> deletePolicies) {
        if (VerifyUtil.isEmpty(deletePolicies)) {
            return;
        }
        String devSn = protectGroup.getPoProviderSN();
        Set deletePolicyNames = deletePolicies.stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toSet());
        BackupInstanceInfo backupInstance = kubeService.getBackupInstance(devSn, protectGroup.getProperty("kube_backup_instance"));
        backupInstance.getBackupPolicyNames().removeIf(deletePolicyNames::contains);
        kubeService.rebuildBackupInstance(devSn, backupInstance);
    }

    private void removePolicyFromProtectionPlan(IKubeService kubeService, ProtectGroup protectGroup, List<KubeSchedulePolicy> deletePolicies) {
        if (VerifyUtil.isEmpty(deletePolicies)) {
            return;
        }
        String srcSn = protectGroup.getPoProviderSN();
        String trgSn = ((Schedule)protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
        Set deletePolicyNames = deletePolicies.stream().map(AbstractKubeBackupModel::getName).collect(Collectors.toSet());
        KubeProtectionPlan srcPlan = kubeService.getProtectionPlan(srcSn, protectGroup.getProperty("kube_protection_plan"));
        KubeProtectionPlan trgPlan = kubeService.getProtectionPlan(trgSn, protectGroup.getProperty("kube_protection_plan"));
        srcPlan.getProtectionPolicies().removeIf(deletePolicyNames::contains);
        trgPlan.getProtectionPolicies().removeIf(deletePolicyNames::contains);
        kubeService.rebuildProtectionPlan(srcSn, srcPlan);
        kubeService.rebuildProtectionPlan(trgSn, trgPlan);
    }

    private void buildNamesAndPolicies(List<Schedule> schedules, List<String> names, Map<KubeEnumDefine.PolicyType, KubeSchedulePolicy> policyTypeKubeSchedulePolicyMap, List<KubeSchedulePolicy> deletePolicies, Map<KubeEnumDefine.TimeWaitType, KubeSchedulePolicy> timeWaitTypeKubeSchedulePolicyMap) {
        block7: for (Schedule schedule : schedules) {
            switch (schedule.getPeriodType()) {
                case 4: {
                    this.removePropValue(names, policyTypeKubeSchedulePolicyMap, deletePolicies, KubeEnumDefine.PolicyType.MONTHLY);
                    break;
                }
                case 3: {
                    this.removePropValue(names, policyTypeKubeSchedulePolicyMap, deletePolicies, KubeEnumDefine.PolicyType.WEEKLY);
                    break;
                }
                case 2: {
                    this.removePropValue(names, policyTypeKubeSchedulePolicyMap, deletePolicies, KubeEnumDefine.PolicyType.DAILY);
                    break;
                }
                case 1: {
                    this.removePropValue(names, policyTypeKubeSchedulePolicyMap, deletePolicies, KubeEnumDefine.PolicyType.HOURS);
                    break;
                }
                case 5: {
                    if (timeWaitTypeKubeSchedulePolicyMap.isEmpty()) break;
                    ArrayList<KubeSchedulePolicy> kubeSchedulePolicies = new ArrayList<KubeSchedulePolicy>();
                    if (schedule.getSyncType() == 1 && timeWaitTypeKubeSchedulePolicyMap.containsKey(KubeEnumDefine.TimeWaitType.AFTER_SYNC_BEGINS)) {
                        kubeSchedulePolicies.add(timeWaitTypeKubeSchedulePolicyMap.get(KubeEnumDefine.TimeWaitType.AFTER_SYNC_BEGINS));
                    }
                    if (schedule.getSyncType() == 2 && timeWaitTypeKubeSchedulePolicyMap.containsKey(KubeEnumDefine.TimeWaitType.AFTER_SYNC_ENDS)) {
                        kubeSchedulePolicies.add(timeWaitTypeKubeSchedulePolicyMap.get(KubeEnumDefine.TimeWaitType.AFTER_SYNC_ENDS));
                    }
                    if (VerifyUtil.isEmpty(kubeSchedulePolicies)) continue block7;
                    KubeSchedulePolicy kubeSchedulePolicy = (KubeSchedulePolicy)kubeSchedulePolicies.iterator().next();
                    deletePolicies.add(kubeSchedulePolicy);
                    names.removeIf(name -> name.equals(kubeSchedulePolicy.getName()));
                    break;
                }
                default: {
                    if (schedule.getScheduleMode() == 1) continue block7;
                    throw new LegoCheckedException(1073947393L);
                }
            }
        }
    }

    private void removePropValue(List<String> names, Map<KubeEnumDefine.PolicyType, KubeSchedulePolicy> policyTypeKubeSchedulePolicyMap, List<KubeSchedulePolicy> deletePolicies, KubeEnumDefine.PolicyType type) {
        if (policyTypeKubeSchedulePolicyMap.containsKey(type)) {
            KubeSchedulePolicy policy = policyTypeKubeSchedulePolicyMap.get(type);
            deletePolicies.add(policy);
            names.removeIf(name -> name.equals(policy.getName()));
        }
    }

    private List<String> getListFromProps(Map<String, String> props, String prop) {
        if (VerifyUtil.isEmpty((String)props.get(prop))) {
            return Collections.emptyList();
        }
        List strs = (List)JSONObject.toBean((String)props.get(prop), List.class);
        if (VerifyUtil.isEmpty((Collection)strs)) {
            return Collections.emptyList();
        }
        return strs;
    }

    private void addSchedules(String protectGroupId, Set<Schedule> addSchedules, IProtectGroupService service) {
        if (VerifyUtil.isEmpty(addSchedules)) {
            return;
        }
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(protectGroupId, false);
        Set scheduleSet = pg.getTemplate().getSchedules();
        for (Schedule schedule1 : scheduleSet) {
            ScriptParamsUtils.convertUserDefinedParams((Schedule)schedule1);
        }
        addSchedules.forEach(ProtectGroupValidator::checkSchedule);
        service.addSchedules(protectGroupId, addSchedules);
    }

    private void updateSchedules(String protectGroupId, Set<Schedule> updateSchedules, IProtectGroupService service) {
        if (VerifyUtil.isEmpty(updateSchedules)) {
            return;
        }
        for (Schedule schedule : updateSchedules) {
            String id = schedule.getScheduleId();
            ProtectGroupValidator.checkSchedule(schedule);
            schedule.setScheduleId(id);
            service.updateSchedule(protectGroupId, schedule);
        }
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_schedule_disable_operateName", rank=2, object="$pg?.name")
    public Response disableSchedule(String protectGroupId, String scheduleId) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).disableSchedule(protectGroupId, scheduleId);
        return Response.ok().build();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_schedule_enable_operateName", rank=2, object="$pg?.name")
    public Response enableSchedule(String protectGroupId, String scheduleId) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).enableSchedule(protectGroupId, scheduleId);
        return Response.ok().build();
    }

    @Override
    @Context(name="pg")
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_enablePGExecution_operateName", rank=3, object="$pg?.name")
    public Response runSchedule(String protectGroupId, String scheduleId, Map<String, Object> parameter) {
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        long taskId = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).runSchedule(protectGroupId, scheduleId, parameter);
        JSONObject obj = new JSONObject();
        obj.put((Object)"taskId", (Object)taskId);
        return Response.ok((Object)obj.toString()).build();
    }

    @Permission(name={"ism.drm.protectgroup.auth.scan"}, uuid={"$1"})
    public String getReplica(String protectGroupId, String replicaId) {
        ProtectGroupReplica replica;
        this.validateProtectGroupId(protectGroupId);
        try {
            IReplicaService replicaService = (IReplicaService)this.getBundleService(IReplicaService.class);
            replica = replicaService.queryProtectGroupReplicaById(replicaId);
        }
        catch (Exception e) {
            LOG.debug((Object)"Query protectgroup replica by protectGroupId[%s] and replicaId[%s] failed:", new Object[]{protectGroupId, replicaId});
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        if (replica == null) {
            LOG.error((Object)"Replica[%s] is not exists, protectGroupId[%s]", new Object[]{replicaId, protectGroupId});
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray jsonArray = this.protectGroupReplicaListToJsonStr(Stream.of(replica).collect(Collectors.toList()));
        return jsonArray.getJSONObject(0).toString();
    }

    public String pageQueryProtectGroupReplicas(String s, Integer integer, Long aLong, Long aLong1, String s1, Integer integer1, Integer integer2) {
        return null;
    }

    @Override
    @Contexts(value={@Context(name="status"), @Context(name="pg"), @Context(name="label", statement="$status != null ? $status : 'unknown'")})
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_schedule_offline_#{label}_operateName", rank=3, detail="protectedGroup_schedule_offline_#{label}_operateName", object="$pg?.name")
    public Response offlineTransfer(String protectGroupId, String scheduleId, Map<String, String> status) {
        if (status == null) {
            throw new LegoCheckedException(1073947393L, "status is null");
        }
        String statusValue = status.get("status");
        if (!Validator.isNum((String)statusValue)) {
            throw new LegoCheckedException(1073947393L, "Cannot get status value from status parameter");
        }
        List validValues = Stream.of(BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.ENABLE.getStatus(), BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.DISABLE.getStatus(), BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.SUSPEND.getStatus()).collect(Collectors.toList());
        if (!validValues.contains(Integer.valueOf(statusValue))) {
            throw new LegoCheckedException(1073947393L, "Status value[%s] is invalid");
        }
        this.checkScheduleAuthority(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        int iStatus = NumberUtil.parseInteger((Object)statusValue);
        BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM eStaus = BackupPlan.OFFLINE_TRANSFER_STATUS_ENUM.getStatus((int)iStatus);
        Context.Variable.set((String)"status", (Object)eStaus);
        ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).offlineTransfer(protectGroupId, scheduleId, iStatus);
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="pg"), @Context(name="pgReplica")})
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectedGroup_replicaMisreportDeal_operateName", rank=3, object="$pg?.name", detail="protectedGroup_replicaMisreportDeal_operateDetail", parameters={"$pgReplica?.name", "$pgReplica?.id"})
    public Response dealMisreport(String protectGroupId, String replicaId) {
        this.validateProtectGroupId(protectGroupId);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupBasicInfo(protectGroupId, false);
        Context.Variable.set((String)"pg", (Object)pg);
        IReplicaService replicaService = (IReplicaService)this.getBundleService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            LOG.error((Object)"Replica[%s] is not exists, protectGroupId[%s]", new Object[]{replicaId, protectGroupId});
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)"pgReplica", (Object)replica);
        replicaService.dealMisreport(protectGroupId, replicaId);
        return Response.ok().build();
    }

    private void setRangeTime(JSONObject jsonObject) {
        JSONArray jsonArray = (JSONArray)jsonObject.get("scheduleRanges");
        if (null == jsonArray || jsonArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object endTime;
            JSONObject rangeObject = jsonArray.getJSONObject(i);
            Object startTime = rangeObject.get("startTime");
            if (startTime != null) {
                Date date = new Date((Long)startTime);
                rangeObject.put((Object)"startTime", (Object)CommUtils.formatDate((Date)date));
            }
            if ((endTime = rangeObject.get("endTime")) != null) {
                Date date = new Date((Long)endTime);
                rangeObject.put((Object)"endTime", (Object)CommUtils.formatDate((Date)date));
            }
            rangeObject.remove((Object)"schedule");
        }
    }

    @Override
    @Permission(name={"ism.drm.protectgroup.auth.modify"}, uuid={"$1"})
    @Logging(name="protectManager_snapshotDelete_operateName", rank=3)
    public BatchOperationResult deleteProtectGroupReplicas(String protectGroupId, Set<String> replicaIds) {
        CommUtils.isNullCollection(replicaIds);
        return ((IReplicaService)this.getBundleService(IReplicaService.class)).deleteProtectGroupReplicas(protectGroupId, replicaIds);
    }

    protected String getHostName(Map<String, String> hostCacheMap, Map<String, String> ecsServers, String hostId, ProtectGroup pg, Site site) {
        if (VerifyUtil.isEmpty((String)hostId)) {
            return hostId;
        }
        if (hostCacheMap.containsKey(hostId)) {
            return hostCacheMap.get(hostId);
        }
        String hostName = hostId;
        if (10 == pg.getPoType()) {
            HashMap<String, String> querys = new HashMap<String, String>();
            querys.put("uuid", hostId);
            List moLists = ((IResourceService)this.getBundleService(IResourceService.class)).queryMoList(ManagedObject.class, querys);
            if (!VerifyUtil.isEmpty((Collection)moLists)) {
                ManagedObject mo = (ManagedObject)moLists.get(0);
                hostName = mo.getName();
            }
            hostCacheMap.put(hostId, hostName);
            return hostName;
        }
        DrResource drResource = this.getResourceService().getDrResourceBySn(hostId);
        if (drResource != null) {
            hostName = drResource.getName();
        }
        hostCacheMap.put(hostId, hostName);
        return hostName;
    }
}

