/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.ILocalRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.host.sdk.model.DrHostGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.rest.service.platform.protection.group.ProtectGroupValidator;
import com.huawei.ism.drm.rest.service.platform.recovery.BaseAbstractRecoveryPlanRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.ExecuteStepBean;
import com.huawei.ism.drm.rest.service.platform.recovery.ProtectObjectSettingBean;
import com.huawei.ism.drm.rest.service.platform.recovery.RecoveryPlanQueryRestServiceImpl;
import com.huawei.ism.drm.rest.service.platform.recovery.util.RecoveryPlanExcelDetailsOperator;
import com.huawei.ism.drm.rest.service.platform.recovery.util.RecoveryPlanLogExcelOperator;
import com.huawei.ism.drm.rest.util.DownloadFileUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.system.thirdservice.sdk.service.ICloudConfigService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.util.FileExcelUtil;
import com.huawei.ism.drm.web.util.FileUtil;
import com.huawei.ism.drm.web.util.HtmlStringConverter;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.moment.bedstone.shield.annotation.Context;
import com.huawei.moment.bedstone.shield.annotation.Contexts;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.util.Strings;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class RecoveryPlanRestServiceImpl
extends RecoveryPlanQueryRestServiceImpl {
    private static final String PLAN = "plan";
    private static final Log logger = LogFactory.getInstance(RecoveryPlanRestServiceImpl.class);
    private static final List<Integer> REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES = new ArrayList<Integer>();

    private static void validateScriptParams(Map<String, String> executeParams) {
        Map scriptParams = Optional.ofNullable(executeParams).orElseGet(HashMap::new);
        Optional<Map.Entry> invalidEntry = scriptParams.entrySet().stream().filter(paramEntry -> SecurityUtil.fileValueBlackListCheck((String[])new String[]{(String)paramEntry.getKey(), (String)paramEntry.getValue()})).findFirst();
        if (invalidEntry.isPresent()) {
            Map.Entry stringEntry = invalidEntry.get();
            logger.error((Object)"Invalid script param: %s=%s", new Object[]{stringEntry.getKey(), stringEntry.getValue()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static String getDate(String date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        try {
            Long l = Long.parseLong(date);
            return sdf.format(new Date(l));
        }
        catch (Exception e) {
            if (date.length() <= 10) {
                return sdf.format(new Date());
            }
            return date.substring(0, date.length() - 10);
        }
    }

    private static String getEnd(List<RecoveryProcessorDetail> recoverDetails) {
        String end = "--";
        for (RecoveryProcessorDetail palnLog : recoverDetails) {
            if (null == palnLog.getEndTime() || "".equals(palnLog.getEndTime()) || "--".equals(palnLog.getEndTime())) break;
            end = palnLog.getEndTime();
        }
        return end;
    }

    @Override
    @Context(name="plan", required=true)
    @Permission(name={"ism.drm.drp.auth.modify"}, uuid={"$1"})
    @Logging(name="recoveryPlan_modify_operateName", rank=3, object="$plan?.name", parameters={"$plan?.name", "$2?.name", "$plan?.description", "$2?.description"}, detail="recoveryPlan_modify_operateDetail")
    public Response modifyDrp(String planId, RecoveryPlan rp) {
        if (VerifyUtil.isEmpty((String)planId) || null == rp) {
            throw new LegoCheckedException(1073947393L);
        }
        String recoveryPlanDes = rp.getDescription();
        String recoveryPlanName = rp.getName();
        String checkRecoveryPlanDes = HtmlStringConverter.decodeByLength((String)recoveryPlanDes);
        if (!CommUtil.checkDrmNameParam((String)recoveryPlanName) || !CommUtil.checkDrmDescParam((String)checkRecoveryPlanDes)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.getRecoveryPlanService().modifyRpBasicInfo(planId, recoveryPlan.getUse(), recoveryPlanName, recoveryPlanDes);
        this.getRecoveryPlanService().modifyRpExtendInfo(recoveryPlan, rp);
        return Response.ok().build();
    }

    @Override
    @Context(name="plan", required=true)
    @Permission(name={"ism.drm.drp.auth.test"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enableTest_operateName", rank=3, object="$plan?.name")
    public Response test(String planId, Map<String, String> recoveryContext) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        IRecoveryManager rm = (IRecoveryManager)this.getBundleService(IRecoveryManager.class);
        rm.startRecoveryDrilling(planId, recoveryContext, this.getCurrentUser());
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="plan"), @Context(name="resource", statement="$this.getDrResource($2)", required=true)})
    @Permission(name={"ism.drm.drp.auth.test"}, uuid={"$1", "$4", "$resource.siteId"})
    @Logging(name="recoveryPlan_enableTest_operateName", rank=3, object="$plan?.name")
    public Response test(String planId, String disasterHostSn, String replicaId, String productSiteId, Map<String, String> recoveryContext) {
        this.checkTestParams(planId, disasterHostSn, replicaId, productSiteId);
        DrResource resource = (DrResource)Context.Variable.get((String)"resource", DrResource.class);
        if (resource instanceof DrHostGroup) {
            for (DrResource drHost : resource.getChildResources()) {
                this.permissionService.checkUserMoAuthority((Object)drHost.getDeviceSn());
            }
        } else {
            this.permissionService.checkUserMoAuthority((Object)resource.getDeviceSn());
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
        this.checkLicenseControl(recoveryPlan);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        recoveryContext.put("REPLICA_ID", replicaId);
        recoveryContext.put("DISASTER_SITE_ID", productSiteId);
        recoveryContext.put("PG_DISASTER_HOST", disasterHostSn);
        recoveryContext.put("disasterHostSn", disasterHostSn);
        ILocalRecoveryManager drpLocalService = (ILocalRecoveryManager)this.getBundleService(ILocalRecoveryManager.class.getName(), ILocalRecoveryManager.class);
        drpLocalService.startMountSnapshot(planId, recoveryContext, this.getCurrentUser());
        return Response.ok().build();
    }

    public DrResource getDrResource(String sn) {
        IResourceService resourceService = (IResourceService)this.getBundleService("DRM_Base", IResourceService.class.getName());
        return resourceService.getDrResourceBySn(sn);
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.cleartest"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enableClear_operateName", rank=2, object="$plan?.name")
    public Response testCleanup(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        ((IRecoveryManager)this.getBundleService(IRecoveryManager.class)).cleanRecoveryDrilling(planId, this.getCurrentUser(), null);
        return Response.ok().build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.cleartest"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enableClear_operateName", rank=2, object="$plan?.name")
    public Response testLocalCleanup(String planId) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        ILocalRecoveryManager drpLocalService = (ILocalRecoveryManager)this.getBundleService(ILocalRecoveryManager.class.getName(), ILocalRecoveryManager.class);
        User currentUser = this.getCurrentUser();
        drpLocalService.startUmountSnapshot(planId, currentUser);
        return Response.ok().build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.local.auth.rollback"}, uuid={"$1"})
    @Logging(name="recoveryPlan_do_operateName", rank=2, object="$plan?.name")
    public Response executePlan(String planId, String disasterSiteId, String replicaId, String restoreSpeed, Map<String, String> recoveryContext) {
        String[] idArray = recoveryContext.containsKey("selectedIdList") ? recoveryContext.get("selectedIdList").split(",") : null;
        List<Object> selectedIdList = VerifyUtil.isEmpty(idArray) ? Collections.emptyList() : Arrays.asList(idArray);
        String executeTypeStr = this.getRequest().getParameter("executeType");
        int executeType = VerifyUtil.isEmpty((String)executeTypeStr) ? DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() : Integer.parseInt(executeTypeStr);
        this.checkRollbackParams(planId, disasterSiteId, replicaId, executeType);
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeTypeE = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)executeType);
        if (restoreSpeed.length() > 1 && DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue() == executeType) {
            logger.error((Object)"param restoreSpeed size larger than 1. expect 1.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)this.getBundleService(ISiteService.class)).getSiteById(disasterSiteId, this.getCurrentUserId());
        if (VerifyUtil.isEmpty((Object)site) || 0 != site.getSiteType()) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan, executeTypeE);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        recoveryContext.put("DISASTER_SITE_ID", disasterSiteId);
        recoveryContext.put("REPLICA_ID", replicaId);
        recoveryContext.put("ROLLBACK_RATE", restoreSpeed);
        recoveryContext.put("message_event_excute_type", String.valueOf(executeTypeE.getValue()));
        recoveryContext.put("selectedVmMoIdList", Strings.join(selectedIdList, (char)','));
        ((ILocalRecoveryManager)this.getBundleService(ILocalRecoveryManager.class)).startRollBackSnapshot(planId, recoveryContext, this.getCurrentUser());
        return Response.ok().build();
    }

    private void checkRollbackParams(String planId, String disasterSiteId, String replicaId, int executeType) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE executeTypeE = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)executeType);
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)disasterSiteId) || VerifyUtil.isEmpty((String)replicaId) || executeTypeE == null) {
            logger.error((Object)"null param. planId:[%s], disasterSiteId:[%s], replicaId:[%s], executeType[%s]", new Object[]{planId, disasterSiteId, replicaId, executeTypeE});
            throw new LegoCheckedException(1073947393L);
        }
        if (executeTypeE != DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK && executeTypeE != DrmEnumDefine.RecoveryPlanExecuteTypeE.VM_ROLLBACK) {
            logger.error((Object)"execute type is wrong");
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected boolean validateIsHypermetro(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            if (pg.getTemplate().getType() != 25) continue;
            return true;
        }
        return false;
    }

    protected boolean validateIsReplication(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : protectGroups) {
            if (!ServiceInstaceEnumDefine.ServiceInstanceTypeE.REPLICATION.getValue().equals(pg.getProps().get("serviceInstanceType")) && !ServiceInstaceEnumDefine.ServiceInstanceTypeE.VHA_REPLICATION.isCurrent((String)pg.getProps().get("serviceInstanceType"))) continue;
            return true;
        }
        return false;
    }

    private boolean isCshaCsdrWithinRegion(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (pg.getTemplate().getType() != 37) {
            return false;
        }
        return null != recoveryContext.get("recovery_region_id") && pg.getProperty("regionId").contains(recoveryContext.get("recovery_region_id"));
    }

    protected void checkConfirmReprotection(Map<String, String> map) {
        if (VerifyUtil.isEmpty(map)) {
            logger.error((Object)"Map is empty");
            return;
        }
        if (!map.containsKey("is_confirm_del_prod_vm")) {
            logger.error((Object)"Parameter not contains confirm del processor key.");
            return;
        }
        String confirmDelProdVm = map.get("is_confirm_del_prod_vm");
        if (!Boolean.FALSE.toString().equals(confirmDelProdVm) && !Boolean.TRUE.toString().equals(confirmDelProdVm)) {
            logger.error((Object)"Parameter isConfirmDelProdVm of recoveryContext is incorrect.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!map.containsKey("is_confirm_reprotection")) {
            map.put("is_confirm_reprotection", Boolean.TRUE.toString());
        } else {
            String confirmReprotectionSwitch = map.get("is_confirm_reprotection");
            if (!Boolean.FALSE.toString().equalsIgnoreCase(confirmReprotectionSwitch) && !Boolean.TRUE.toString().equalsIgnoreCase(confirmReprotectionSwitch)) {
                logger.error((Object)"Parameter isConfirmReprotection  of recoveryContext is incorrect.");
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.planed.motion"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enablePlannedMigration_operateName", rank=2, object="$plan?.name")
    public Response plannedMigration(String planId, Map<String, String> recoveryContext) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (recoveryContext == null) {
            recoveryContext = new HashMap<String, String>();
        }
        this.checkConfirmReprotection(recoveryContext);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        if (recoveryContext.containsKey("siteId") && !recoveryContext.containsKey("disasterHostSn")) {
            String siteId;
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            ProtectGroupReplica replica = Optional.ofNullable(pg.getReplicationReplicaByRecoverySiteId(siteId = recoveryContext.get("siteId"))).orElse(pg.getReplicaByHMNonReplicaSiteId(siteId));
            if (VerifyUtil.isEmpty((Object)replica)) {
                logger.error((Object)"plannedMigration get replica is null.");
                throw new LegoCheckedException(1073947393L);
            }
            recoveryContext.put("siteId", replica.getRecoverySite());
            String devSn = replica.getStorageDeviceId();
            IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
            ArrayUnit arrayUnit = service.getLunStorageModule(devSn);
            if (!(arrayUnit instanceof HvsUnit)) {
                logger.error((Object)"plannedMigration do not select a host for the LUN.");
                throw new LegoCheckedException(1073947393L);
            }
        }
        ((IRecoveryManager)this.getBundleService(IRecoveryManager.class)).startPlanedMotion(planId, recoveryContext, this.getCurrentUser());
        return Response.ok().build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.planed.hotmigration"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enableHotMigration_operateName", rank=2, object="$plan?.name")
    public Response hotMigration(String planId, Map<String, String> recoveryContext) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"planId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkUserOperationAuthority("recoveryPlan_enableHotMigration_operateName", 2, "ism.drm.drp.auth.planed.hotmigration");
        this.checkUserBizObjAuthority("recoveryPlan_enableHotMigration_operateName", 2, planId);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        if (null == recoveryContext) {
            recoveryContext = new HashMap<String, String>();
        }
        ((IRecoveryManager)this.getBundleService(IRecoveryManager.class)).startHotMigration(planId, recoveryContext, this.getCurrentUser());
        return Response.ok().build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.disaster.recovery"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enableFaultRecovery_operateName", rank=2, object="$plan?.name")
    public Response diasterRecovery(String planId, Map<String, String> recoveryContext) {
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        if (((ICloudConfigService)this.getBundleService(ICloudConfigService.class)).checkArbitrationSwitchMode(null)) {
            if (this.validateIsHypermetro(recoveryPlan)) {
                throw new LegoCheckedException(1073948807L);
            }
            if (this.isCshaCsdrWithinRegion(recoveryPlan, recoveryContext)) {
                throw new LegoCheckedException(1073949723L);
            }
        }
        if (recoveryContext.containsKey("siteId") && !recoveryContext.containsKey("disasterHostSn")) {
            String siteId;
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            ProtectGroupReplica replica = Optional.ofNullable(pg.getReplicationReplicaByRecoverySiteId(siteId = recoveryContext.get("siteId"))).orElse(pg.getReplicaByHMNonReplicaSiteId(siteId));
            if (null == replica) {
                logger.error((Object)"diasterRecovery get replica is null.");
                throw new LegoCheckedException(1073947393L);
            }
            String devSn = replica.getStorageDeviceId();
            recoveryContext.put("siteId", replica.getRecoverySite());
            IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
            ArrayUnit arrayUnit = service.getLunStorageModule(devSn);
            if (!(arrayUnit instanceof HvsUnit)) {
                logger.error((Object)"diasterRecovery is not Pure LUN HVS storage");
                throw new LegoCheckedException(1073947393L);
            }
        }
        ((IRecoveryManager)this.getBundleService(IRecoveryManager.class)).startDisasterRecovery(planId, recoveryContext, this.getCurrentUser());
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String getHvsLunMappingDetails(String planId, String siteId, int startPage, int pageSize) {
        if (VerifyUtil.isEmpty((String)planId) || 0 >= pageSize || 0 > startPage) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if (VerifyUtil.isEmpty((String)siteId)) {
            return this.getPureLunVerifyResult(pg);
        }
        ProtectGroupReplica replica = PolicyTemplateType.HYPERMETRO_SWITCHOVER_TEMPLATE.contains(pg.getTemplate().getType()) ? Optional.ofNullable(pg.getReplicationReplicaByRecoverySiteId(siteId)).orElse(pg.getReplicaByHMNonReplicaSiteId(siteId)) : Optional.ofNullable(pg.getReplicationReplicaByRecoverySiteId(siteId)).orElse(pg.getAnyoneReplicationReplica());
        if (replica == null) {
            logger.error((Object)"error: replica is null");
            return "";
        }
        return this.combineLunMappingRes(replica, startPage, pageSize);
    }

    private String getPureLunVerifyResult(ProtectGroup pg) {
        ProtectGroupReplica replica = pg.getAnyoneReplicationReplica();
        if (null == replica) {
            logger.error((Object)"replica is null");
            throw new LegoCheckedException(1073947393L);
        }
        JSONObject result = new JSONObject();
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        ArrayUnit arrayUnit = service.getLunStorageModule(replica.getStorageDeviceId());
        if (arrayUnit instanceof HvsUnit) {
            result.put((Object)"result", (Object)1);
        } else {
            result.put((Object)"result", (Object)0);
        }
        return result.toString();
    }

    private String combineLunMappingRes(ProtectGroupReplica replica, int startPage, int pageSize) {
        Map<String, List<String>> lunListByDevSn = this.classifyLunByDevSn(replica);
        String lessDevSn = null;
        String moreDevSn = null;
        List<Object> lessLunIdListByDevSn = Collections.emptyList();
        List<String> moreLunIdListByDevSn = Collections.emptyList();
        for (Map.Entry<String, List<String>> entry : lunListByDevSn.entrySet()) {
            if (lessLunIdListByDevSn.isEmpty() || lessLunIdListByDevSn.size() > entry.getValue().size()) {
                lessLunIdListByDevSn = entry.getValue();
                lessDevSn = entry.getKey();
            }
            if (moreLunIdListByDevSn.size() > entry.getValue().size()) continue;
            moreLunIdListByDevSn = entry.getValue();
            moreDevSn = entry.getKey();
        }
        if (Objects.equals(lessDevSn, moreDevSn)) {
            return this.getLunMappingRes(moreDevSn, moreLunIdListByDevSn, startPage, pageSize);
        }
        VerifyUtil.checkObject(lessDevSn);
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List lessLunList = service.pageQueryReplicasLunsBySnAndLunIds(lessDevSn, lessLunIdListByDevSn, 0, lessLunIdListByDevSn.size());
        List luns = service.queryRemoteLunsByResource(lessDevSn, lessLunList);
        VerifyUtil.checkObject((Object)luns);
        List collect = luns.stream().map(Lun::getLunId).sorted().collect(Collectors.toList());
        moreLunIdListByDevSn.addAll(collect);
        return this.getLunMappingRes(moreDevSn, moreLunIdListByDevSn, startPage, pageSize);
    }

    private Map<String, List<String>> classifyLunByDevSn(ProtectGroupReplica replica) {
        HashMap<String, List<String>> devSnLunList = new HashMap<String, List<String>>();
        for (ProtectObjectReplica objReplica : replica.getReplicas()) {
            if (VerifyUtil.isEmpty((Collection)objReplica.getStorageInfos())) continue;
            for (RelicaStorageInfo storageInfo : objReplica.getStorageInfos()) {
                String storageId = storageInfo.getStorageId();
                if (VerifyUtil.isEmpty((String)storageId)) continue;
                String devSn = storageInfo.getStorageProviderSN();
                List storageIdList = (List)devSnLunList.get(devSn);
                storageIdList = Optional.ofNullable(storageIdList).orElseGet(ArrayList::new);
                storageIdList.add(storageId);
                devSnLunList.put(devSn, storageIdList);
            }
        }
        return devSnLunList;
    }

    private String getLunMappingRes(String devSn, List<String> lunList, int startPage, int pageSize) {
        int size;
        List tmpList;
        ArrayList<Lun> listLuns = new ArrayList();
        IStorageResourceService service = (IStorageResourceService)this.getBundleService(IStorageResourceService.class);
        List remoteLuns = service.queryRemoteLunsByResource(devSn, tmpList = service.pageQueryReplicasLunsBySnAndLunIds(devSn, lunList, startPage, pageSize / 2));
        if (CollectionUtils.isEmpty((Collection)remoteLuns)) {
            listLuns = service.pageQueryReplicasLunsBySnAndLunIds(devSn, lunList, startPage, pageSize);
            size = lunList.size();
        } else {
            listLuns.addAll(remoteLuns);
            listLuns.addAll(tmpList);
            size = lunList.size() * 2;
        }
        if (CollectionUtils.isEmpty(listLuns)) {
            logger.error((Object)"failed to obtain devSn or lunId.");
            return "";
        }
        if (startPage == 0) {
            boolean mapped;
            try {
                if (remoteLuns.size() > 0) {
                    List remoteLunIds = remoteLuns.stream().map(Lun::getLunId).collect(Collectors.toList());
                    boolean remoteMapped = service.checkLunMapping(((Lun)remoteLuns.get(0)).getDevSn(), remoteLunIds);
                    boolean tmpMapped = service.checkLunMapping(devSn, lunList);
                    mapped = remoteMapped && tmpMapped;
                } else {
                    mapped = service.checkLunMapping(devSn, lunList);
                }
            }
            catch (Exception e) {
                logger.error((Object)"checkLunMapping exception.", (Throwable)e);
                return "";
            }
            return this.getLunRes(listLuns, mapped + "", size);
        }
        return this.getLunRes(listLuns, null, size);
    }

    private String getLunRes(List<Lun> listLuns, String mappedFlag, int total) {
        IStorageService service = (IStorageService)this.getBundleService(IStorageService.class);
        JSONArray array = new JSONArray();
        JSONObject result = new JSONObject();
        for (Lun lun : listLuns) {
            JSONObject json = new JSONObject();
            json.put((Object)"name", (Object)lun.getName());
            json.put((Object)"lunId", (Object)lun.getLunId());
            if (!VerifyUtil.isEmpty((String)lun.getHostGroupName())) {
                json.put((Object)"hostName", (Object)lun.getHostGroupName());
            } else if (!VerifyUtil.isEmpty((String)lun.getHostName())) {
                json.put((Object)"hostName", (Object)lun.getHostName());
            } else {
                json.put((Object)"hostName", (Object)"--");
            }
            json.put((Object)"mapped", (Object)lun.getMapped());
            List storageList = service.getStorageList(new String[]{lun.getDevSn()});
            String devName = ((StorageNE)storageList.get(0)).getName();
            json.put((Object)"devName", (Object)devName);
            array.add((Object)json);
        }
        result.put((Object)"records", (Object)array);
        result.put((Object)"totalCount", (Object)total);
        if ("true".equalsIgnoreCase(mappedFlag)) {
            result.put((Object)"mappedFlag", (Object)true);
        } else {
            result.put((Object)"mappedFlag", (Object)false);
        }
        return result.toString();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.reprotect"}, uuid={"$1"})
    @Logging(name="recoveryPlan_reProtect_operateName", rank=2, object="$plan?.name")
    public Response executeReprotectPlan(String planId, Map<String, String> recoveryContext) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty(recoveryContext)) {
            throw new LegoCheckedException(1073947393L);
        }
        String isResverdValue = recoveryContext.get("isReserved");
        if (!"true".equalsIgnoreCase(isResverdValue) && !"false".equalsIgnoreCase(isResverdValue)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        if ((this.validateIsHypermetro(recoveryPlan) || pg.getTemplate().getType() == 37 && "REGION_TYPE_WITHIN".equals(pg.getProperty("RECOVERY_REGION_TYPE"))) && ((ICloudConfigService)this.getBundleService(ICloudConfigService.class)).checkArbitrationSwitchMode(null)) {
            throw new LegoCheckedException(1073948807L);
        }
        IRecoveryManager rm = (IRecoveryManager)this.getBundleService(IRecoveryManager.class.getName(), IRecoveryManager.class);
        rm.reprotectRecoveryPlan(planId, recoveryContext, this.getCurrentUser());
        return Response.ok().build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.delete"}, uuid={"$1"})
    @Logging(name="recoveryPlan_delete_operateName", rank=2, object="$plan?.name")
    public Response delRecoveryPlan(String planId) {
        IRecoveryPlanBaseService rpService = this.getRecoveryPlanService();
        RecoveryPlan recoveryPlan = rpService.getRecoveryPlan(planId, false, false);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        rpService.removeRecoveryPlan(planId);
        return Response.ok().build();
    }

    @Override
    @Context(name="pgId", statement="$this.checkRecoverPlanAndGetPgId($1)", required=true)
    @Permission(name={"ism.drm.drp.auth.add"}, uuid={"$pgId"})
    @Logging(name="recoveryPlan_create_operateName", object="$1?.name")
    public Response createRecoveryPlan(RecoveryPlan rp) {
        logger.info((Object)"Begin to createRecoveryPlan");
        String pgUUID = (String)Context.Variable.get((String)"pgId", String.class);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(pgUUID, false);
        if (pg == null) {
            throw new LegoCheckedException(1073947394L);
        }
        HashSet<ProtectGroup> pgs = new HashSet<ProtectGroup>();
        pgs.add(pg);
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        DrmEnumDefine.RecoveryPlanTypeE planType = planService.getSuitablePlanType(pg);
        rp.setPlanType(planType.getValue());
        rp.setProtectGroups(pgs);
        rp.setRecoverySettings(new HashSet());
        if (!this.isRequiresHandleGlobalSettings(rp)) {
            rp.setGlobalSettings(new HashMap());
        }
        this.checkLicenseCount(pg);
        planService.createRecoveryPlan(this.getCurrentUserId().longValue(), rp);
        return Response.ok().build();
    }

    private boolean isRequiresHandleGlobalSettings(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        Iterator iterator = protectGroups.iterator();
        ProtectGroup firstGroup = (ProtectGroup)iterator.next();
        int poType = firstGroup.getPoType();
        return REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.contains(poType);
    }

    public String checkRecoverPlanAndGetPgId(RecoveryPlan rp) {
        if (VerifyUtil.isEmpty((Object)rp)) {
            throw new LegoCheckedException(-1L);
        }
        String checkRpDesc = HtmlStringConverter.decodeByLength((String)rp.getDescription());
        rp.setDescription(checkRpDesc);
        if (!CommUtil.checkDrmNameParam((String)rp.getName()) || !CommUtil.checkDrmDescParam((String)checkRpDesc)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)rp.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = rp.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(2117645L);
        }
        String pgUUID = ((ProtectGroup)iterator.next()).getUuid();
        if (!ParamChecker.checkUuidNotNull((String)pgUUID)) {
            logger.error((Object)"Pg uuid is illegal, pgUUID: %s", new Object[]{pgUUID});
            throw new LegoCheckedException(1073947393L);
        }
        if (!ParamChecker.checkNameQuery((String)rp.getLastProcessorName())) {
            logger.error((Object)"LastProcessorName: %s is illegal", new Object[]{rp.getLastProcessorName()});
            throw new LegoCheckedException(1073947393L);
        }
        return pgUUID;
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.recoverysetting.modify.operateID"}, uuid={"$1"})
    @Logging(name="recoveryPlan_modifyRecoveryStartSetting_operateName", rank=2, object="$plan?.name")
    public Response setRecoverySettings(String planId, List<ProtectObjectSettingBean> settings) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        this.verifyProtectObjectSetting(settings);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        CommUtils.checkObjectExists((Object[])new Object[]{recoveryPlan});
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        ArrayList<RecoverySetting> recoverySettings = new ArrayList<RecoverySetting>();
        CommUtils.checkObjectExists((Object[])new Object[]{recoveryPlan.getProtectGroups()});
        for (ProtectObjectSettingBean poSettingBean : settings) {
            RecoverySetting setting = new RecoverySetting();
            setting.setRecoveryPlan(recoveryPlan);
            setting.setOwnerId(poSettingBean.getUuid());
            setting.setName(poSettingBean.getName());
            setting.setValue(poSettingBean.getValue());
            recoverySettings.add(setting);
        }
        this.getRecoveryPlanService().saveOrUpdateRecoverySettings(planId, recoverySettings);
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="type"), @Context(name="plan")})
    @Permission(name={"ism.drm.drp.auth.modify"}, uuid={"$1"})
    @Logging(name="recoveryPlan_addRecoveryStep_operateName", rank=2, object="$plan?.name", detail="recoveryPlan_addRecoveryStep_operateDetail", parameters={"$plan?.name", "$type"})
    public String addStep(String planId, int procType, ExecuteStepBean stepBean) {
        if (VerifyUtil.isEmpty((String)planId) || null == stepBean) {
            throw new LegoCheckedException(1073947393L);
        }
        String stepId = stepBean.getSibStepId();
        String stepName = stepBean.getName();
        String scriptName = stepBean.getScriptName();
        Boolean isBefore = stepBean.getIsBefore();
        Boolean execPolicy = stepBean.getIsContinueIfFailed();
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, stepName, scriptName, isBefore, type, execPolicy});
        if (this.isStepBeanUnValid(stepName, scriptName)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
            throw new LegoCheckedException(1073947453L);
        }
        HashMap<String, Object> steps = new HashMap<String, Object>();
        steps.put("CUSTOM_PROCESSOR_NAME", stepName);
        steps.put("EXECUTE_SCRIPT_NAME", scriptName);
        steps.put("EXECUTE_POLICY", execPolicy);
        steps.put("isUserDefined", Boolean.TRUE);
        VerifyUtil.checkObject((Object)type);
        stepId = this.getCustomStepService().addCustomRecoveryProcessor(planId, type, steps, stepId, isBefore.booleanValue());
        Context.Variable.set((String)"type", (Object)this.getKeyByType(type));
        Context.Variable.set((String)PLAN, (Object)rp);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"stepId", (Object)stepId);
        return jsonObject.toString();
    }

    @Override
    @Contexts(value={@Context(name="step"), @Context(name="type"), @Context(name="plan")})
    @Permission(name={"ism.drm.drp.auth.modify"}, uuid={"$1"})
    @Logging(name="recoveryPlan_disableRecoveryStep_operateName", rank=2, object="$step?.procName", detail="recoveryPlan_disableRecoveryStep_operateDetail", parameters={"$plan?.name", "$type"})
    public Response disableStep(String planId, int procType, String stepId) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, type});
        RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)rp);
        if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
            throw new LegoCheckedException(1073947453L);
        }
        RecoveryProcessor recoveryProcessor = this.getRecoveryPlanService().getRecoveryProcessor(stepId);
        Context.Variable.set((String)"step", (Object)recoveryProcessor);
        Context.Variable.set((String)"type", (Object)this.getKeyByType(type));
        IRecoveryPlanService rpService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        rpService.disableRecoveryProcessor(planId, type, stepId);
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="type"), @Context(name="step"), @Context(name="plan")})
    @Permission(name={"ism.drm.drp.auth.modify"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enableRecoveryStep_operateName", rank=2, object="$step?.procName", detail="recoveryPlan_enableRecoveryStep_operateDetail", parameters={"$plan?.name", "$type"})
    public Response enableStep(String planId, int procType, String stepId) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, type});
        Context.Variable.set((String)"type", (Object)this.getKeyByType(type));
        RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)rp);
        if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
            throw new LegoCheckedException(1073947453L);
        }
        RecoveryProcessor recoveryProcessor = this.getRecoveryPlanService().getRecoveryProcessor(stepId);
        Context.Variable.set((String)"step", (Object)recoveryProcessor);
        IRecoveryPlanService rpService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        rpService.enableRecoveryProcessor(planId, type, stepId);
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="plan"), @Context(name="step"), @Context(name="type")})
    @Permission(name={"ism.drm.drp.auth.modify"}, uuid={"$1"})
    @Logging(name="recoveryPlan_delRecoveryStep_operateName", rank=2, object="$step?.procName", detail="recoveryPlan_delRecoveryStep_operateDetail", parameters={"$plan?.name", "$type"})
    public Response deleteStep(String planId, int procType, String stepId) {
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        Context.Variable.set((String)"type", (Object)this.getKeyByType(type));
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, stepId, type});
        RecoveryPlan rp = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)rp);
        if (this.validateIsHypermetro(rp) || this.validateIsReplication(rp)) {
            throw new LegoCheckedException(1073947453L);
        }
        RecoveryProcessor recoveryProcessor = this.getRecoveryPlanService().getRecoveryProcessor(stepId);
        Context.Variable.set((String)"step", (Object)recoveryProcessor);
        this.getCustomStepService().deleteRecoveryProcessor(planId, type, stepId);
        return Response.ok().build();
    }

    @Override
    @Contexts(value={@Context(name="type"), @Context(name="step"), @Context(name="plan")})
    @Permission(name={"ism.drm.drp.auth.modify"}, uuid={"$1"})
    @Logging(name="recoveryPlan_modifyRecoveryStep_operateName", rank=2, object="$step?.procName", detail="recoveryPlan_modifyRecoveryStep_operateDetail", parameters={"$plan?.name", "$type"})
    public Response editStep(String planId, int procType, String stepId, ExecuteStepBean stepBean) {
        if (null == stepBean || VerifyUtil.isEmpty((String)stepId)) {
            throw new LegoCheckedException(1073947393L);
        }
        String stepName = stepBean.getName();
        String scriptName = stepBean.getScriptName();
        Boolean execPolicy = stepBean.getIsContinueIfFailed();
        Map params = stepBean.getExecuteParams();
        Boolean isUserDefined = stepBean.getIsUserDefined();
        isUserDefined = isUserDefined != null ? isUserDefined : Boolean.TRUE;
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        DrmEnumDefine.RecoveryPlanExecuteTypeE type = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)procType);
        this.editStepPreCheck(planId, type, stepBean, recoveryPlan);
        Context.Variable.set((String)"type", (Object)this.getKeyByType(type));
        JSONObject json = new JSONObject();
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        RecoveryProcessor processor = planService.getRecoveryProcessor(stepId);
        if (null == processor) {
            throw new LegoCheckedException(1073947394L);
        }
        Context.Variable.set((String)"step", (Object)processor);
        HashMap<String, Object> steps = new HashMap<String, Object>();
        steps.put("CUSTOM_PROCESSOR_NAME", stepName);
        steps.put("EXECUTE_SCRIPT_NAME", scriptName);
        steps.put("EXECUTE_POLICY", execPolicy);
        steps.put("isUserDefined", isUserDefined);
        steps.put("recoveryScriptSchemeId", stepBean.getRecoveryScriptSchemeId());
        steps.put("STEP_PARAMS", params);
        steps.put("publicParam", stepBean.getPublicParams());
        json.putAll((Map)this.getCustomStepService().modifyCustomRecoveryProcessor(planId, type, stepId, steps));
        return Response.ok().entity((Object)json.toString()).build();
    }

    private void editStepPreCheck(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE type, ExecuteStepBean stepBean, RecoveryPlan recoveryPlan) {
        boolean updatePublicParams;
        String stepName = stepBean.getName();
        String scriptName = stepBean.getScriptName();
        Boolean execPolicy = stepBean.getIsContinueIfFailed();
        Boolean isUserDefined = stepBean.getIsUserDefined();
        Map executeParams = stepBean.getExecuteParams();
        isUserDefined = isUserDefined != null ? isUserDefined : Boolean.TRUE;
        CommUtils.checkParamEmpty((Object[])new Object[]{planId, type, stepName, scriptName, execPolicy});
        if (this.isStepBeanUnValid(stepName, scriptName)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlanRestServiceImpl.validateScriptParams(executeParams);
        this.checkUserOperationAuthority("recoveryPlan_modifyRecoveryStep_operateName", 2, "ism.drm.drp.auth.modify");
        this.checkUserBizObjAuthority("recoveryPlan_modifyRecoveryStep_operateName", 2, planId);
        if (null == recoveryPlan) {
            logger.error((Object)("not fint recovery plan " + planId));
            this.writeFailedOperationLog("recoveryPlan_modifyRecoveryStep_operateName", 2, "", (Exception)((Object)new LegoCheckedException(1073948693L)));
        }
        if (!isUserDefined.booleanValue()) {
            IProtectGroupService protectGroupService = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
            updatePublicParams = protectGroupService.checkPublicParamsChanged(recoveryPlan.getProtectGroup().getUuid(), stepBean.getPublicParams());
        } else {
            updatePublicParams = false;
        }
        if (updatePublicParams) {
            this.checkUserOperationAuthority("protectedGroup_modifyPolicy_operateName", 2, "ism.drm.protectgroup.auth.modify");
            this.checkUserBizObjAuthority("protectedGroup_modifyPolicy_operateName", 2, recoveryPlan.getProtectGroup().getUuid());
        }
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    public String getRecoverySettings(String planId, String ownerUuid, String settingName) {
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId, false, false);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(1073947394L);
        }
        Set settings = recoveryPlan.getRecoverySettings();
        if (null == settings) {
            logger.error((Object)("the recoverysetting is null: " + recoveryPlan.getPlanId()));
            return "";
        }
        JSONArray array = new JSONArray();
        for (RecoverySetting setting : settings) {
            if (!VerifyUtil.isEmpty((String)ownerUuid) && !ownerUuid.equals(setting.getOwnerId()) || !VerifyUtil.isEmpty((String)settingName) && !settingName.equals(setting.getName())) continue;
            JSONObject object = new JSONObject();
            object.put((Object)"uuid", (Object)setting.getOwnerId());
            object.put((Object)"name", (Object)setting.getName());
            object.put((Object)"value", (Object)setting.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    protected boolean isStepBeanUnValid(String stepName, String scriptName) {
        return !CommUtil.checkDrmNameParam((String)stepName) || !CommUtil.checkParam((String)scriptName, (int)4, (int)64) || !Pattern.matches("^[a-zA-Z0-9_\\u4e00-\\u9fa5]{1}[\\u4e00-\\u9fa5\\w-]*(\\.bat|\\.sh){1}$", Normalizer.normalize(scriptName, Normalizer.Form.NFKC));
    }

    private void verifyProtectObjectSetting(List<ProtectObjectSettingBean> settings) {
        if (VerifyUtil.isEmpty(settings)) {
            throw new LegoCheckedException(1073947393L);
        }
        for (ProtectObjectSettingBean setting : settings) {
            if (!VerifyUtil.isEmpty((String)setting.getUuid()) && !VerifyUtil.isEmpty((String)setting.getName()) && !VerifyUtil.isEmpty((String)setting.getValue())) continue;
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkTestParams(String planId, String disasterHostSn, String replicaId, String productSiteId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)disasterHostSn) || VerifyUtil.isEmpty((String)replicaId) || VerifyUtil.isEmpty((String)productSiteId)) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.recoverymapping.export"}, uuid={"$1"})
    @Logging(name="recoveryPlan_exportRecoveryPlanLog_operateName", object="$plan?.name")
    public Response exportRecoveryPlanLog(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.debug((Object)"planId is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        BatchOperationResult result = new BatchOperationResult();
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        CommUtils.checkObjectExists((Object[])new Object[]{recoveryPlan});
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        int pageSize = 20001;
        Page pageQueryRecoveryLogs = this.getRecoveryPlanService().pageQueryRecoveryLog(planId, 0, pageSize, "startTime", false);
        List recoveryLogs = pageQueryRecoveryLogs.getResult();
        CommUtils.checkObjectExists((Object[])new Object[]{recoveryLogs});
        if (recoveryLogs.size() > 20000) {
            throw new LegoCheckedException(1574L);
        }
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        this.exportLogHelper(recoveryLogs, result, recoveryPlan);
        return Response.ok((Object)result).build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.scan"}, uuid={"$1"})
    @Logging(name="recoveryPlan_exportRecoveryPlanLogDetail_operateName", object="$plan?.name")
    public Response exportRecoveryPlanLogDetails(String planId, String logId) {
        if (VerifyUtil.isEmpty((String)planId) || VerifyUtil.isEmpty((String)logId)) {
            throw new LegoCheckedException(1073947393L);
        }
        List recoverDetails = this.getRecoveryPlanService().getRecoveryProcessorDetailsByLogId(planId, logId);
        BatchOperationResult result = new BatchOperationResult();
        CommUtils.checkObjectExists((Object[])new Object[]{recoverDetails});
        if (!this.isExportChecked().booleanValue()) {
            return Response.ok().build();
        }
        RecoveryPlan plan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
        Context.Variable.set((String)PLAN, (Object)plan);
        if (this.validateIsHypermetro(plan) || this.validateIsReplication(plan)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.exportRecoveryHelper(recoverDetails, result, plan.getName());
        return Response.ok((Object)result).build();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportRecoveryHelper(List<RecoveryProcessorDetail> recoverDetails, BatchOperationResult result, String planName) {
        File excelFile;
        block10: {
            RecoveryPlanExcelDetailsOperator details = new RecoveryPlanExcelDetailsOperator((BaseAbstractRecoveryPlanRestService)this);
            FileOutputStream fileOutputStream = null;
            excelFile = null;
            try {
                SXSSFWorkbook wb = details.createExportExcel(recoverDetails, result);
                excelFile = new File(this.getExportCSVFilePath(planName, recoverDetails));
                fileOutputStream = new FileOutputStream(excelFile);
                wb.write((OutputStream)fileOutputStream);
                DownloadFileUtil.downloadFile((HttpServletResponse)this.getResponse(), (HttpServletRequest)this.getRequest(), (File)excelFile);
                if (fileOutputStream == null) break block10;
            }
            catch (LegoCheckedException e) {
                try {
                    logger.error((Object)"Creating exported excel failed.", (Throwable)e, 90160758784001L);
                    throw e;
                    catch (Exception ex) {
                        logger.error((Object)("Export recoveryplan log details failed >>>>>>. msg:" + ExceptionUtil.getErrorMessage((Throwable)ex)));
                        throw new LegoCheckedException(1073948423L, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            logger.error((Object)e2, 90160758784000L);
                        }
                    }
                    FileUtil.deleteFile(excelFile);
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)e, 90160758784000L);
            }
        }
        FileUtil.deleteFile((File)excelFile);
    }

    private String getExportCSVFilePath(String planName, List<RecoveryProcessorDetail> recoverDetails) {
        String fileName = RecoveryPlanRestServiceImpl.getDate(recoverDetails.get(0).getStartTime()) + "_" + RecoveryPlanRestServiceImpl.getDate(RecoveryPlanRestServiceImpl.getEnd(recoverDetails));
        return FileExcelUtil.createTempDownloadPath((HttpSession)this.getSession(), (String)planName, (String)fileName, (String)"csv");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exportLogHelper(List<RecoveryLog> recoveryLogs, BatchOperationResult result, RecoveryPlan recoveryPlan) {
        File excelFile;
        block10: {
            RecoveryPlanLogExcelOperator operator = new RecoveryPlanLogExcelOperator((BaseAbstractRecoveryPlanRestService)this);
            FileOutputStream fileOutputStream = null;
            excelFile = null;
            try {
                SXSSFWorkbook wb = operator.createExportExcel(recoveryLogs, result);
                String filePath = FileExcelUtil.createTempDownloadPath((HttpSession)this.getSession(), (String)recoveryPlan.getName(), null, (String)"csv");
                excelFile = new File(filePath);
                fileOutputStream = new FileOutputStream(excelFile);
                wb.write((OutputStream)fileOutputStream);
                DownloadFileUtil.downloadLogFile((HttpServletResponse)this.getResponse(), (HttpServletRequest)this.getRequest(), (File)excelFile);
                if (fileOutputStream == null) break block10;
            }
            catch (LegoCheckedException e) {
                try {
                    logger.error((Object)"Creating exported excel failed.", (Throwable)e);
                    throw e;
                    catch (Exception ex) {
                        logger.error((Object)"Export recoveryPlan log failed. Msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
                        throw new LegoCheckedException(1073948423L, (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e2) {
                            logger.error((Object)"Close file stream failed.", (Throwable)e2);
                        }
                    }
                    FileUtil.deleteFile(excelFile);
                    throw throwable;
                }
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)"Close file stream failed.", (Throwable)e);
            }
        }
        FileUtil.deleteFile((File)excelFile);
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.test"}, uuid={"$1"})
    @Logging(name="recoveryPlan_enableSwap_operateName", rank=3, object="$plan?.name")
    public Response swap(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(planId, false, false);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        this.checkLicenseControl(recoveryPlan);
        Set protectGroups = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)protectGroups.iterator().next();
        if (15 != pg.getTemplate().getType()) {
            logger.error((Object)("no support operation.PolicyTemplateType:" + pg.getTemplate().getType()));
            throw new LegoCheckedException(1073947453L);
        }
        int resourceType = this.getResourceType(pg);
        if (DrmEnumDefine.ResourceTypeE.NAS.getValue() != resourceType) {
            logger.error((Object)("no support operation. resourceType:" + resourceType));
            throw new LegoCheckedException(1073947453L);
        }
        ((IRecoveryManager)this.getBundleService(IRecoveryManager.class)).startSwaping(planId, this.getCurrentUser());
        return Response.ok().build();
    }

    private int getResourceType(ProtectGroup pg) {
        ProtectObject po = (ProtectObject)pg.getPolist().iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty! pgName : " + pg.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi.getResourceType();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.modify"}, uuid={"$1"})
    @Logging(name="syc_policyTemplate_props_to_recoveryPlan_operateName", rank=2, object="$plan?.name", detail="syc_policyTemplate_props_to_recoveryPlan_operateDetail", parameters={"$plan?.protectGroup?.name", "$plan?.name"})
    public Response syncPtPropsToRp(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"plan id is empty");
            throw new LegoCheckedException(1073947393L);
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        RecoveryPlan recoveryPlan = planService.getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)recoveryPlan);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(1073948693L);
        }
        if (this.validateIsHypermetro(recoveryPlan) || this.validateIsReplication(recoveryPlan)) {
            throw new LegoCheckedException(1073947453L);
        }
        this.getCustomStepService().syncPtPropsToRp(planId);
        return Response.ok().build();
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.add"}, uuid={"$1?.protectGroupId"})
    @Logging(name="mountplan_create_operateName", object="$1?.name", detail="mountplan_create_operateDetail", parameters={"$1?.name"})
    public Response createMountPlan(MountConfiguration mountPlan) {
        if (VerifyUtil.isEmpty((Object)mountPlan)) {
            logger.error((Object)"mountPlan is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        if (!CommUtil.checkDrmNameParam((String)mountPlan.getName()) || !CommUtil.checkDrmDescParam((String)mountPlan.getDescription())) {
            logger.error((Object)"mount plan have no name or description.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupValidator.checkKeepMacParam(mountPlan);
        ProtectGroup pg = ((IProtectGroupService)this.getBundleService(IProtectGroupService.class)).getProtectGroupByID(mountPlan.getProtectGroupId(), false);
        this.checkProtectGoupStatus(mountPlan, pg);
        this.checkLicenseCount(pg);
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        planService.createMountPlan(super.getCurrentUser(), mountPlan);
        return Response.ok().build();
    }

    private void checkProtectGoupStatus(MountConfiguration mountPlan, ProtectGroup pg) {
        if (null == pg) {
            logger.error((Object)("protectgroup is empty, proctectgroup id is " + mountPlan.getProtectGroupId() + "."));
            throw new LegoCheckedException(2117645L);
        }
        if (pg.isInvalid()) {
            logger.error((Object)("Protect Group has been invalid. Id:" + pg.getUuid()), 90160758784001L);
            throw new LegoCheckedException(1073948693L);
        }
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.disaster.mountplan.mount"}, uuid={"$1"})
    @Logging(name="mountplan_mount_replica_operateName", rank=3, object="$plan?.name")
    public Response mountReplica(String planId) {
        if (VerifyUtil.isEmpty((String)planId)) {
            logger.error((Object)"mountPlan is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan mountPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)mountPlan)) {
            logger.error((Object)("can not find mount plan " + planId + "."));
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)PLAN, (Object)mountPlan);
        this.checkLicenseControl(mountPlan);
        if (RecoveryPlanUse.INTERNAL_USE.getValue() != mountPlan.getUse().intValue()) {
            logger.error((Object)("This plan " + planId + " is recover plan, is not allow to mount."));
            throw new LegoCheckedException(1073947453L);
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        planService.execMountPlanManual(super.getCurrentUser(), mountPlan);
        return Response.ok().build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.disaster.mountplan.unmount"}, uuid={"$1"})
    @Logging(name="mountplan_unmount_replica_operateName", object="$plan?.name")
    public Response unmountReplica(String planId, boolean bDeleteReplica) {
        RecoveryPlan mountPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)mountPlan)) {
            logger.error((Object)("can not find mount plan " + planId + "."));
            throw new LegoCheckedException(2117645L);
        }
        Context.Variable.set((String)PLAN, (Object)mountPlan);
        this.checkLicenseControl(mountPlan);
        if (RecoveryPlanUse.INTERNAL_USE.getValue() != mountPlan.getUse().intValue()) {
            logger.error((Object)("This plan " + planId + " is recover plan, is not allow to mount."));
            throw new LegoCheckedException(1073947453L);
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        planService.clearMountPlanManual(super.getCurrentUser(), mountPlan, bDeleteReplica);
        return Response.ok().build();
    }

    @Override
    @Context(name="plan")
    @Permission(name={"ism.drm.drp.auth.disaster.mountplan.unmount"}, uuid={"$1"})
    @Logging(name="mountPlan_modify_operateName", rank=3, object="$plan?.name", detail="mountPlan_modify_operateDetail", parameters={"$plan?.name ?: $1", "$2?.startTime"})
    public Response modifyMountplan(String planId, MountConfiguration startInfo) {
        RecoveryPlan mountPlan = this.getRecoveryPlanService().getRecoveryPlan(planId);
        Context.Variable.set((String)PLAN, (Object)mountPlan);
        this.checkLicenseControl(mountPlan);
        if (RecoveryPlanUse.INTERNAL_USE.getValue() != mountPlan.getUse().intValue()) {
            logger.error((Object)"This plan %s is recover plan, is not allow to mount.", new Object[]{planId});
            throw new LegoCheckedException(1073947453L);
        }
        if (mountPlan.getPlanStatus() != DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() && mountPlan.getPlanStatus() != DrmEnumDefine.RecoveryPlanStatusE.UMOUNT_COMPLETED.getValue()) {
            logger.error((Object)"This plan %s is ready, do not to unmount replica.", new Object[]{planId});
            throw new LegoCheckedException(1073948693L);
        }
        String name = startInfo.getName();
        String description = startInfo.getDescription();
        String checkRecoveryPlanDes = HtmlStringConverter.decodeByLength((String)description);
        if (!CommUtil.checkDrmNameParam((String)name) || !CommUtil.checkDrmDescParam((String)checkRecoveryPlanDes)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.getRecoveryPlanService().isExistedRecoveryPlanByName(name, planId, Integer.valueOf(RecoveryPlanUse.INTERNAL_USE.getValue()))) {
            logger.error((Object)("The plan name already exists. PlanName:" + name + ",PlanId:" + planId), 90160758784001L);
            throw new LegoCheckedException(1073947392L);
        }
        IRecoveryPlanService planService = (IRecoveryPlanService)this.getBundleService("DRM_Base", IRecoveryPlanService.class.getSimpleName(), IRecoveryPlanService.class);
        planService.modifyMountplan(this.getCurrentUser(), mountPlan, startInfo);
        return Response.ok().build();
    }

    static {
        REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.add(21);
        REQUIRE_HANDLE_GLOBAL_SETTINGS_PO_TYPES.add(20);
    }
}

