/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.recovery;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.IShareTemplateService;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.recovery.IShareTemplateRestService;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ShareTemplateRestServiceImpl
extends AbstractRestService
implements IShareTemplateRestService {
    private static final Log LOGGER = LogFactory.getInstance(ShareTemplateRestServiceImpl.class);

    @Override
    @Permission(name={"ism.drm.drp.auth.add"}, uuid={"$2"})
    public String queryShareTemplates(String shareType, String protectGroupId, String replicaId) {
        if (VerifyUtil.isEmpty((String)shareType) || VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty((String)replicaId)) {
            LOGGER.error((Object)"Param is invalid, shareType=%s, protectGroupId=%s, replicaId=%s.", new Object[]{shareType, protectGroupId, replicaId});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = this.getProtectGroup(protectGroupId);
        ProtectGroupReplica protectGroupReplica = this.getProtectGroupReplica(replicaId);
        this.checkPgId(protectGroupId, replicaId, protectGroupReplica);
        String vstoreId = this.getVstoreId(pg.getPolist());
        String devSn = protectGroupReplica.getRecoveryArray();
        IShareTemplateService shareTemplateService = (IShareTemplateService)this.getBundleService(IShareTemplateService.class);
        List shareTemplateInfos = shareTemplateService.queryShareTemplates(shareType, devSn, vstoreId);
        JSONArray res = new JSONArray();
        shareTemplateInfos.forEach(e -> {
            JSONObject obj = new JSONObject();
            obj.set((Object)"id", (Object)e.getId());
            obj.set((Object)"name", (Object)e.getName());
            obj.set((Object)"sharePath", (Object)e.getSharePath());
            obj.set((Object)"vstoreId", (Object)e.getVstoreId());
            obj.set((Object)"shareType", (Object)e.getShareType());
            res.add((Object)obj);
        });
        return res.toString();
    }

    private void checkPgId(String protectGroupId, String replicaId, ProtectGroupReplica protectGroupReplica) {
        if (!protectGroupReplica.getPg().getUuid().equals(protectGroupId)) {
            LOGGER.error((Object)"ProtectGroupReplica is not belong to protectGroup, replicaId=%s, protectGroupId=%s.", new Object[]{replicaId, protectGroupId});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private ProtectGroupReplica getProtectGroupReplica(String replicaId) {
        IReplicaService replicaService = (IReplicaService)this.getBundleService(IReplicaService.class);
        return replicaService.queryProtectGroupReplicaById(replicaId);
    }

    private ProtectGroup getProtectGroup(String protectGroupId) {
        IProtectGroupService pgServices = (IProtectGroupService)this.getBundleService(IProtectGroupService.class);
        return pgServices.getProtectGroupByID(protectGroupId, false);
    }

    @Override
    @Permission(name={"ism.drm.drp.auth.add"}, uuid={"$3"})
    public String queryAuthClientCountByShareTemplate(String shareType, String templateId, String protectGroupId, String replicaId) {
        if (VerifyUtil.isEmpty((String)shareType) || VerifyUtil.isEmpty((String)templateId) || VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty((String)replicaId)) {
            LOGGER.error((Object)"Param is invalid, shareType=%s, templateId=%s, protectGroupId=%s, replicaId=%s.", new Object[]{templateId, shareType, protectGroupId, replicaId});
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = this.getProtectGroup(protectGroupId);
        ProtectGroupReplica protectGroupReplica = this.getProtectGroupReplica(replicaId);
        this.checkPgId(protectGroupId, replicaId, protectGroupReplica);
        String vstoreId = this.getVstoreId(pg.getPolist());
        String devSn = protectGroupReplica.getRecoveryArray();
        IShareTemplateService shareTemplateService = (IShareTemplateService)this.getBundleService(IShareTemplateService.class);
        return shareTemplateService.queryAuthClientCountByShareTemplate(shareType, templateId, devSn, vstoreId);
    }

    private String getVstoreId(Set<ProtectObject> protectObjects) {
        HashSet vStoreIds = new HashSet();
        protectObjects.forEach(protectObject -> protectObject.getUsedStorageResourceSet().forEach(storageInfo -> vStoreIds.add(storageInfo.getVstoreId())));
        if (vStoreIds.isEmpty()) {
            return "";
        }
        if (vStoreIds.size() == 1) {
            return (String)vStoreIds.stream().findFirst().get();
        }
        LOGGER.error((Object)"Get vStoreId failed, too many vStoreIds, vStoreIds=%s.", new Object[]{((Object)vStoreIds).toString()});
        throw new LegoCheckedException(1073947393L);
    }
}

