/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.platform.replication;

import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.platform.replication.IReplicationRestService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageReplicationService;
import com.huawei.ism.drm.topo.sdk.model.ReplicationLinkTopoData;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public class ReplicationRestServiceImpl
extends AbstractRestService
implements IReplicationRestService {
    private static final String REPLICATION_SERVICE = IStorageReplicationService.class.getName();
    private static final Class<IStorageReplicationService> CLAZZ = IStorageReplicationService.class;
    private static final Log LOG = LogFactory.getInstance(ReplicationRestServiceImpl.class);

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getReplicationTargetLun(String srcSN, String tgtSn, String tgtLunId) {
        if (VerifyUtil.isEmpty((String)tgtLunId) || VerifyUtil.isEmpty((String)srcSN) || VerifyUtil.isEmpty((String)tgtSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IStorageReplicationService service = (IStorageReplicationService)this.getBundleService(REPLICATION_SERVICE, CLAZZ);
        List tgtLunList = service.getTargetLunList(srcSN, tgtSn, tgtLunId.split(";"));
        if (null == tgtLunList || tgtLunList.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
        JSONArray array = new JSONArray();
        for (ReplicationTargetLun tgtLun : tgtLunList) {
            ReplicationPair parentMo = new ReplicationPair();
            ManagedObject mo = tgtLun.getParentMo();
            if (mo instanceof ReplicationPair) {
                parentMo = (ReplicationPair)mo;
            } else {
                LOG.info((Object)("Converting failed. ManagedObject:" + mo));
            }
            JSONObject object = new JSONObject();
            object.put((Object)"tgtDeviceName", (Object)tgtLun.getTgtDeviceName());
            object.put((Object)"dataStatus", (Object)tgtLun.getDataStatus());
            object.put((Object)"endTime", (Object)tgtLun.getEndTime());
            object.put((Object)"pairStatus", (Object)tgtLun.getPairStatus());
            object.put((Object)"progressRatio", (Object)(tgtLun.getProgressRatio() == null ? Integer.valueOf(-1) : tgtLun.getProgressRatio()));
            object.put((Object)"replicationPairId", (Object)tgtLun.getReplicationPairId());
            object.put((Object)"startTime", (Object)tgtLun.getStartTime());
            object.put((Object)"tgtDevSN", (Object)tgtLun.getTgtDevSN());
            object.put((Object)"tgtLunId", (Object)tgtLun.getTgtLunId());
            object.put((Object)"devSn", (Object)tgtLun.getDevSn());
            object.put((Object)"tgtLunName", (Object)tgtLun.getTgtLunName());
            object.put((Object)"isNeedInitSync", (Object)tgtLun.getIsNeedInitSync());
            object.put((Object)"resumePolicy", (Object)tgtLun.getResumePolicy());
            object.put((Object)"slientTime", (Object)tgtLun.getSlientTime());
            object.put((Object)"speedLevel", (Object)tgtLun.getSpeedLevel());
            object.put((Object)"syncMode", (Object)parentMo.getReplicationMode());
            object.put((Object)"syncType", (Object)tgtLun.getSyncType());
            object.put((Object)"name", (Object)parentMo.getName());
            object.put((Object)"timing", (Object)tgtLun.getTiming());
            object.put((Object)"consistentGroupId", (Object)parentMo.getConsistentGroupId());
            object.put((Object)"replicationMode", (Object)parentMo.getReplicationMode());
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.auth.scan"}, moid={"$1"})
    public String getReplicationLinks(String srcSN, String tgtSn) {
        if (VerifyUtil.isEmpty((String)srcSN) || VerifyUtil.isEmpty((String)tgtSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        IDrmTopoService topoService = (IDrmTopoService)this.getBundleService("DRM_Base", IDrmTopoService.class.getName());
        List linkDetails = topoService.getLinkDetailInfo(srcSN, tgtSn);
        JSONArray array = new JSONArray();
        if (null == linkDetails || linkDetails.isEmpty()) {
            return array.toString();
        }
        for (ReplicationLinkTopoData link : linkDetails) {
            JSONObject object = new JSONObject();
            object.put((Object)"linkId", (Object)link.getLinkId());
            object.put((Object)"productArrayName", (Object)link.getProductArrayName());
            object.put((Object)"deviceId", (Object)link.getDeviceId());
            object.put((Object)"recoveryArrayName", (Object)link.getRecoveryArrayName());
            object.put((Object)"remoteArrayId", (Object)link.getRemoteArrayId());
            object.put((Object)"linkType", (Object)link.getLinkType());
            object.put((Object)"linkStatus", (Object)link.getLinkStatus());
            object.put((Object)"linkIp", (Object)(link.getLinkIp() != null ? link.getLinkIp() : ""));
            array.add((Object)object);
        }
        return array.toString();
    }

    @Override
    @Permission(name={"ism.drm.site.resource.auth.management.operateID"}, moid={"$1"})
    @Logging(name="site_storage_modifyReplication_operateName", object="$2", detail="site_storage_modifyReplication_operateDetail", parameters={"$2", "$1", "$3 ? 'ReplicationGroup' : 'ReplicationPair'"})
    public Response modifyReplication(String devSn, String replicationId, boolean isConsistentGroup, JSONObject messageBody) {
        LOG.debug((Object)("Enter modify, sn=" + devSn + ", id=" + replicationId + "isCg=" + isConsistentGroup + ", params=" + messageBody));
        VerifyUtil.checkStrs((String[])new String[]{devSn, replicationId});
        if (null == messageBody || messageBody.isEmpty()) {
            LOG.error((Object)"params is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Map<String, Object> params = this.jsonObj2Map(messageBody);
        IStorageReplicationService replicationService = (IStorageReplicationService)this.getBundleService(IStorageReplicationService.class);
        replicationService.modifyReplication(devSn, replicationId, isConsistentGroup, params);
        LOG.debug((Object)"Exit modify.");
        return Response.ok().build();
    }

    private Map<String, Object> jsonObj2Map(JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null == json || json.isEmpty()) {
            return map;
        }
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Map<String, Object> value = json.get(key);
            if (value instanceof JSONObject) {
                value = this.jsonObj2Map((JSONObject)value);
            } else if (value instanceof JSONArray) {
                value = this.jsonArray2List((JSONArray)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private List<Object> jsonArray2List(JSONArray jsonArr) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (null == jsonArr || jsonArr.isEmpty()) {
            return list;
        }
        for (Object item : jsonArr) {
            Object value = item instanceof JSONObject ? this.jsonObj2Map((JSONObject)item) : (item instanceof JSONArray ? this.jsonArray2List((JSONArray)item) : item);
            list.add(value);
        }
        return list;
    }
}

