/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.backup;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.backup.model.BackupProxy;
import com.huawei.ism.drm.backup.model.BackupStoragePool;
import com.huawei.ism.drm.backup.model.BackupStorageRepository;
import com.huawei.ism.drm.backup.service.IBackupProxyService;
import com.huawei.ism.drm.backup.service.IBackupStorageService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Service(name="com.huawei.ism.drm.backup.service.IBackupStorageService", desc="", interfaceClass=IBackupStorageService.class)
public class BackupStorageServiceImpl
extends BaseService
implements IBackupStorageService {
    private static final Log LOGGER = LogFactory.getInstance(BackupStorageServiceImpl.class);

    public void createBackupStoragePool(BackupStoragePool pool) {
        if (VerifyUtil.isEmpty((String)pool.getProxyId())) {
            this.getManager().createBackupStoragePool(pool);
            return;
        }
        BackupProxy proxy = ((IBackupProxyService)ServiceLocator.getInstance().getService(IBackupProxyService.class)).getBackupProxy(pool.getProxyId());
        if (VerifyUtil.isEmpty((Object)proxy)) {
            LOGGER.error((Object)"The proxy is null");
            throw new LegoCheckedException(2117645L);
        }
        String tempProxyId = "";
        boolean flag = false;
        Optional<BackupProxy> opt = this.existBackupProxy(proxy, pool.getBackupEngineId());
        try {
            BackupProxy backupProxy;
            if (!opt.isPresent()) {
                backupProxy = this.getManager().createBackupProxy(proxy, pool.getBackupEngineId(), pool.getAddress());
                flag = true;
            } else {
                backupProxy = opt.get();
            }
            if (VerifyUtil.isEmpty((Object)backupProxy) || VerifyUtil.isEmpty((String)backupProxy.getBackupProxyId())) {
                throw new LegoCheckedException(1073947393L);
            }
            tempProxyId = backupProxy.getBackupProxyId();
            pool.setBackupProxyId(tempProxyId);
            BackupStoragePool newPool = this.getManager().createBackupStoragePool(pool);
            String str = proxy.getAssociateDevice();
            HashMap<String, String> relationMap = new HashMap<String, String>();
            JSONArray json = JSONArray.fromObject((Object)str);
            relationMap.put("backupEngineId", pool.getBackupEngineId());
            relationMap.put("backProxyId", backupProxy.getBackupProxyId());
            relationMap.put("poolId", newPool.getPoolId());
            relationMap.put("poolAddress", pool.getAddress());
            json.add(relationMap);
            proxy.setAssociateDevice(json.toString());
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("Create backup pool failed." + pool), (Throwable)e);
            if (!VerifyUtil.isEmpty((String)tempProxyId) && flag) {
                this.getManager().deleteBackupProxy(tempProxyId, pool.getBackupEngineId());
            }
            throw e;
        }
        try {
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)proxy);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Update proxy failed, proxyId: %s, errorMsg: %s", new Object[]{proxy.getProxyId(), ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public void updateBackupStoragePool(String backupEngineId, String poolId, BackupStoragePool newPool) {
        BackupStoragePool backupStoragePool = this.getBackupStoragePool(backupEngineId, poolId);
        if (backupStoragePool == null) {
            throw new LegoCheckedException(2117645L, "Backup storage pool is not exists!");
        }
        BackupProxy proxy = null;
        boolean flag = false;
        HashMap<String, String> map = new HashMap<String, String>();
        if (!VerifyUtil.isEmpty((String)newPool.getUserName())) {
            map.put("userName", newPool.getUserName());
        }
        if (!VerifyUtil.isEmpty((String)newPool.getPassword())) {
            map.put("password", newPool.getPassword());
        }
        String tempProxyId = "";
        String proxyId = newPool.getProxyId();
        if (!VerifyUtil.isEmpty((String)proxyId)) {
            BackupProxy backupProxy;
            proxy = ((IBackupProxyService)ServiceLocator.getInstance().getService(IBackupProxyService.class)).getBackupProxy(proxyId);
            Optional<BackupProxy> opt = this.existBackupProxy(proxy, backupEngineId);
            BackupStoragePool pool = this.getBackupStoragePool(backupEngineId, poolId);
            if (!opt.isPresent()) {
                try {
                    backupProxy = this.getManager().createBackupProxy(proxy, backupEngineId, pool.getAddress());
                }
                catch (LegoCheckedException e) {
                    LOGGER.error((Object)"Create backup pool failed, backupEngineId is: %s, poolId is: %s", new Object[]{backupEngineId, poolId, e});
                    throw e;
                }
                flag = true;
            } else {
                backupProxy = opt.get();
            }
            if (VerifyUtil.isEmpty((Object)backupProxy) || VerifyUtil.isEmpty((String)backupProxy.getBackupProxyId())) {
                throw new LegoCheckedException(1073947393L);
            }
            tempProxyId = backupProxy.getBackupProxyId();
            map.put("proxyId", tempProxyId);
            String str = proxy.getAssociateDevice();
            HashMap<String, String> relationMap = new HashMap<String, String>();
            JSONArray json = JSONArray.fromObject((Object)str);
            relationMap.put("backupEngineId", pool.getBackupEngineId());
            relationMap.put("backProxyId", backupProxy.getBackupProxyId());
            relationMap.put("poolId", pool.getPoolId());
            relationMap.put("poolAddress", pool.getAddress());
            json.add(relationMap);
            proxy.setAssociateDevice(json.toString());
        } else {
            map.put("proxyId", String.valueOf(0));
        }
        try {
            ArrayList<HashMap<String, String>> listParam = new ArrayList<HashMap<String, String>>();
            if (!VerifyUtil.isEmpty(map)) {
                map.put("id", backupStoragePool.getBrickS3Id());
                listParam.add(map);
                JSONArray json = JSONArray.fromObject(listParam);
                newPool.setBrickList(json.toString());
            }
            this.getManager().updateBackupStoragePool(backupEngineId, poolId, newPool);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Update backup pool failed.backupEngineId is: %s, poolId is:%s", new Object[]{backupEngineId, poolId, e});
            if (!VerifyUtil.isEmpty((String)tempProxyId) && flag) {
                this.getManager().deleteBackupProxy(tempProxyId, backupEngineId);
            }
            throw e;
        }
        this.reSetProxyData(proxy, backupStoragePool, proxyId);
    }

    private void reSetProxyData(BackupProxy proxy, BackupStoragePool backupStoragePool, String proxyId) {
        String backupEngineId = backupStoragePool.getBackupEngineId();
        String poolId = backupStoragePool.getPoolId();
        if (!VerifyUtil.isEmpty((Object)proxy)) {
            try {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)proxy);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Update proxy failed,proxyId: %s, errorMsg: %s", new Object[]{proxy.getProxyId(), ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            }
        }
        ArrayList<String> filterProxyIds = new ArrayList<String>();
        if (!VerifyUtil.isEmpty((String)proxyId)) {
            filterProxyIds.add(proxyId);
            this.cleanLocalDBAssociateProxy(backupEngineId, poolId, filterProxyIds);
        }
        if (!VerifyUtil.isEmpty((String)proxyId) && !proxyId.equals(backupStoragePool.getProxyId())) {
            try {
                this.getManager().deleteBackupProxy(backupStoragePool.getBackupProxyId(), backupEngineId);
            }
            catch (Exception e) {
                LOGGER.error((Object)"The proxy is cited, the proxyId is: %s, errorMsg: %s", new Object[]{proxyId, ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public void deleteBackupStoragePool(String backupEngineId, String poolId) {
        this.getManager().deleteBackupStoragePool(backupEngineId, poolId);
        this.cleanLocalDBAssociateProxy(backupEngineId, poolId, null);
    }

    public List<BackupStoragePool> listBackupStoragePool(String backupEngineId, Map<String, String> filter) {
        return this.getManager().listBackupStoragePool(backupEngineId, filter);
    }

    public BackupStoragePool getBackupStoragePool(String backupEngineId, String poolId) {
        BackupStoragePool backupStoragePool = this.getManager().getBackupStoragePool(backupEngineId, poolId);
        if (VerifyUtil.isEmpty((Object)backupStoragePool)) {
            return new BackupStoragePool();
        }
        List proxyList = null;
        BackupProxy backupProxy = null;
        if (!VerifyUtil.isEmpty((String)backupStoragePool.getProxyId()) && !String.valueOf(0).equals(backupStoragePool.getProxyId())) {
            backupProxy = this.getManager().getBackupProxy(backupStoragePool.getProxyId(), backupEngineId);
            if (VerifyUtil.isEmpty((Object)backupProxy)) {
                return backupStoragePool;
            }
            proxyList = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from BackupProxy as st where st.name = ? ", new Object[]{backupProxy.getName()});
        }
        if (!VerifyUtil.isEmpty(proxyList)) {
            List relationList = CommUtil.convertToListMap((String)((BackupProxy)proxyList.get(0)).getAssociateDevice());
            for (Map map : relationList) {
                String engineId = String.valueOf(map.get("backupEngineId"));
                String tempBackProxyId = String.valueOf(map.get("backProxyId"));
                if (VerifyUtil.isEmpty((String)engineId) || VerifyUtil.isEmpty((String)tempBackProxyId)) continue;
                if (backupProxy == null) {
                    LOGGER.error((Object)"backupProxy is null");
                    throw new LegoCheckedException(0x300001L);
                }
                if (!CommUtil.combineString((String[])new String[]{engineId, tempBackProxyId}).equals(CommUtil.combineString((String[])new String[]{backupEngineId, backupProxy.getBackupProxyId()}))) continue;
                backupStoragePool.setProxyId(((BackupProxy)proxyList.get(0)).getProxyId());
            }
        }
        return backupStoragePool;
    }

    public void createBackupStorageRepository(BackupStorageRepository repository) {
        this.getManager().createBackupStorageRepository(repository);
    }

    public void updateBackupStorageRepository(String backupEngineId, String repositoryId, BackupStorageRepository repository) {
        BackupStorageRepository repositoryOld = this.getBackupStorageRepository(backupEngineId, repositoryId);
        this.getManager().updateBackupStorageRepository(backupEngineId, repositoryId, repository);
        if (VerifyUtil.isEmpty((String)repository.getName()) || repository.getName().equals(repositoryOld.getName())) {
            return;
        }
        int cloudBackupType = ScheduleProtectedType.CLOUD_BACKUP.getValue();
        List schedules = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from Schedule where protectedType = ? and sourceSn = ?", new Object[]{cloudBackupType, backupEngineId});
        for (Schedule schedule : schedules) {
            Map extMap = (Map)JSONObject.toBean((String)schedule.getExtParameterDatas(), Map.class);
            String repositoryName = (String)extMap.get("repositoryName");
            if (VerifyUtil.isEmpty((String)repositoryName) || !repositoryName.equals(repositoryOld.getName())) continue;
            extMap.put("repositoryName", repository.getName());
            schedule.setExtParameterDatas(JSONObject.fromObject((Object)extMap).toString());
            try {
                CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)schedule);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Update schedule failed,scheduleId: %s, errorMsg: %s", new Object[]{schedule.getScheduleId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }

    public void deleteBackupStorageRepository(String backupEngineId, String repositoryId) {
        this.getManager().deleteBackupStorageRepository(backupEngineId, repositoryId);
    }

    public List<BackupStorageRepository> listBackupStorageRepository(String backupEngineId, Map<String, String> filter) {
        return this.getManager().listBackupStorageRepository(backupEngineId, filter);
    }

    public BackupStorageRepository getBackupStorageRepository(String backupEngineId, String repositoryId) {
        return this.getManager().getBackupStorageRepository(backupEngineId, repositoryId);
    }

    private IBackupManager getManager() {
        return BackupManagerProxy.getInstance().getBackupService("NativeBackupEngine");
    }

    private Optional<BackupProxy> existBackupProxy(BackupProxy proxy, String backupEngineId) {
        if (VerifyUtil.isEmpty((Object)proxy)) {
            return Optional.of(new BackupProxy());
        }
        HashSet<String> backProxyIdSet = new HashSet<String>();
        if (!VerifyUtil.isEmpty((String)proxy.getAssociateDevice())) {
            List relationList = CommUtil.convertToListMap((String)proxy.getAssociateDevice());
            for (Map map : relationList) {
                String engineId = String.valueOf(map.get("backupEngineId"));
                String tempBackProxyId = String.valueOf(map.get("backProxyId"));
                backProxyIdSet.add(CommUtil.combineString((String[])new String[]{engineId, tempBackProxyId}));
            }
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("name", proxy.getName());
            List proxys = this.getManager().listBackupProxy(backupEngineId, filter);
            if (!VerifyUtil.isEmpty((Collection)proxys)) {
                BackupProxy backupProxy = Optional.of(proxys.stream().filter(o -> o != null && o.getName().equals(proxy.getName())).findFirst()).get().orElse(null);
                if (null == backupProxy) {
                    LOGGER.debug((Object)"The backupProxy is null");
                    return Optional.empty();
                }
                String combineProxyId = CommUtil.combineString((String[])new String[]{backupEngineId, backupProxy.getBackupProxyId()});
                if (!backProxyIdSet.contains(combineProxyId)) {
                    throw new LegoCheckedException(1073947715L, new String[]{backupProxy.getName()});
                }
                return Optional.of(backupProxy);
            }
        }
        return Optional.empty();
    }

    private void cleanLocalDBAssociateProxy(String backupEngineId, String poolId, List<String> filterProxy) {
        List backupProxyList = ((IBackupProxyService)ServiceLocator.getInstance().getService(IBackupProxyService.class)).listBackupProxy();
        if (VerifyUtil.isEmpty((Collection)backupProxyList)) {
            return;
        }
        for (BackupProxy proxy : backupProxyList) {
            if (!VerifyUtil.isEmpty(filterProxy) && filterProxy.contains(proxy.getProxyId()) || VerifyUtil.isEmpty((String)proxy.getAssociateDevice())) continue;
            List relationList = CommUtil.convertToListMap((String)proxy.getAssociateDevice());
            Iterator iterator1 = relationList.iterator();
            try {
                while (iterator1.hasNext()) {
                    Map map = (Map)iterator1.next();
                    if (!String.valueOf(map.get("backupEngineId")).equals(backupEngineId) || !String.valueOf(map.get("poolId")).equals(poolId)) continue;
                    iterator1.remove();
                    CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)proxy);
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Update proxy failed, proxyId:%s, errorMsg: %s", new Object[]{proxy.getProxyId(), ExceptionUtil.getErrorMessage((Throwable)e)});
            }
        }
    }
}

