/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.backup.observer;

import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.backup.model.BackupProxy;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.common.sdk.service.IObjectObserver;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BackupProxyOperateObserver
implements IObjectObserver {
    private static Log logger = LogFactory.getInstance(BackupProxyOperateObserver.class);

    public void before(MessageEvent event) {
        logger.info((Object)"enter before");
        Map objectMap = event.getMessageMap();
        int messageType = event.getMessageType();
        if (VerifyUtil.isEmpty((Map)objectMap)) {
            return;
        }
        for (Map.Entry entry : objectMap.entrySet()) {
            BackupProxy proxy;
            Object object = entry.getValue();
            if (!((String)entry.getKey()).equals(BackupProxy.class.getSimpleName()) || VerifyUtil.isEmpty(object) || !(object instanceof BackupProxy) || !this.checkParam(proxy = (BackupProxy)object)) continue;
            if (messageType == 1 && !VerifyUtil.isEmpty((String)proxy.getAssociateDevice())) {
                this.updateBackupProxy(proxy);
            }
            if (messageType != 2) continue;
            this.deleteBackupProxy(proxy);
        }
    }

    public void after(MessageEvent event) {
    }

    public String getObserverType() {
        return BackupProxy.class.getName();
    }

    private boolean checkParam(BackupProxy proxy) {
        return !VerifyUtil.isEmpty((String)proxy.getProxyId());
    }

    private void updateBackupProxy(BackupProxy proxy) {
        if (VerifyUtil.isEmpty((Object)proxy)) {
            logger.error((Object)"the proxy is null");
            throw new LegoCheckedException(2117645L);
        }
        List relatList = CommUtil.convertToListMap((String)proxy.getAssociateDevice());
        Iterator iterator = relatList.iterator();
        HashSet<String> proxyIdSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            String backupEngineId = String.valueOf(map.get("backupEngineId"));
            String tempBackProxyId = String.valueOf(map.get("backProxyId"));
            if (VerifyUtil.isEmpty((String)backupEngineId) || VerifyUtil.isEmpty((String)tempBackProxyId) || !proxyIdSet.add(CommUtil.combineString((String[])new String[]{backupEngineId, tempBackProxyId}))) continue;
            proxy.setBackupProxyId(tempBackProxyId);
            try {
                this.getManager().updateBackupProxy(proxy, backupEngineId);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 348347146L || e.getErrorCode() == 335595787L) {
                    logger.error((Object)("update backup proxy error" + proxy.toString() + "backupEngineId is" + backupEngineId));
                    return;
                }
                throw e;
            }
        }
    }

    private void deleteBackupProxy(BackupProxy proxy) {
        HashSet<String> proolIdSet = new HashSet<String>();
        if (!VerifyUtil.isEmpty((String)proxy.getAssociateDevice())) {
            List relatList = CommUtil.convertToListMap((String)proxy.getAssociateDevice());
            for (Map map : relatList) {
                String backupEngineId = String.valueOf(map.get("backupEngineId"));
                String backupProxyId = String.valueOf(map.get("backProxyId"));
                if (VerifyUtil.isEmpty((String)backupEngineId) || VerifyUtil.isEmpty((String)backupProxyId) || !proolIdSet.add(CommUtil.combineString((String[])new String[]{backupEngineId, backupProxyId}))) continue;
                try {
                    this.getManager().deleteBackupProxy(backupProxyId, backupEngineId);
                    logger.info((Object)("delete proxy" + backupProxyId + "backupEngineId" + backupEngineId));
                }
                catch (LegoCheckedException e) {
                    if (e.getErrorCode() == 348347146L) {
                        logger.debug((Object)("backupEngineId" + backupEngineId + "proxyId" + proxy.getProxyId() + "the proxy is not exist"));
                        return;
                    }
                    throw e;
                }
            }
        }
    }

    private IBackupManager getManager() {
        return BackupManagerProxy.getInstance().getBackupService("NativeBackupEngine");
    }
}

