/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.service.impl;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanObserverManager;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreCheckerManager;
import com.huawei.ism.drm.recovery.framework.process.RecoveryPreProcessorManager;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTask;
import com.huawei.ism.drm.recovery.framework.task.RecoveryBackTaskExecutor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.framework.task.ReprotectCallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.SyncLockManager;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.task.ICallBackExcuteRecoveryTask;
import com.huawei.ism.drm.recovery.task.IRecoveryBackTask;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.manager.StorageManagerUtil;
import com.huawei.ism.drm.util.RecoveryOperationController;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Service(name="com.huawei.ism.drm.drp.sdk.service.IRecoveryManager", desc="", interfaceClass=IRecoveryManager.class)
public class RecoveryManager
extends BaseService
implements IRecoveryManager {
    private static final Log logger = LogFactory.getInstance(RecoveryManager.class);
    private static final String URL_TEST = "/ws/recoveryplans/{planId}/action/test";
    private static final String URL_TESTCLEANUP = "/ws/recoveryplans/{planId}/action/testCleanup";
    private static final String URL_PLANEDMIGRATION = "/ws/recoveryplans/{planId}/action/plannedMigration";
    private static final String URL_HOTMIGRATION = "/ws/recoveryplans/{planId}/action/hotMigration";
    private static final String URL_REPROTECT = "/ws/recoveryplans/{planId}/action/reprotect";
    private static final String SEPARATOR = ":";
    private IRecoveryPlanService recoveryPlanService;

    public IRecoveryPlanService getRecoveryPlanService() {
        return this.recoveryPlanService;
    }

    public void setRecoveryPlanService(IRecoveryPlanService recoveryPlanService) {
        this.recoveryPlanService = recoveryPlanService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDisasterRecovery(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkParameters(recoveryPlanId, recoveryContext, operator);
            RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
            IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            this.checkMatchAz2Region(recoveryContext, pg, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            Map settings = provider.checkRecoveryContext(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, recoveryContext, operator);
            String newDisasterSiteId = null;
            Object disasterSiteValue = settings.get("DISASTER_SITE_ID");
            if (null != disasterSiteValue) {
                newDisasterSiteId = String.valueOf(disasterSiteValue);
            }
            RecoveryServiceUtil.checkRecoveryOperationPrivilegeBySite((RecoveryPlan)recoveryPlan, (DrmEnumDefine.RecoveryPlanExecuteTypeE)DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, (String)newDisasterSiteId);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.DISASTER_RECOVERY);
            this.dealGlobalSettings(recoveryPlan);
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVM(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    public void startPlanedMotion(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, URL_PLANEDMIGRATION);
    }

    public void continuePlannedMigration(String s, Map<String, String> map, User user, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        this.checkParameters(s, map, user);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(s);
        IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        this.dealGlobalSettings(recoveryPlan);
        String recoverySiteId = provider.getRecoverySiteId(s, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, map);
        Site recoverySite = RecoveryServiceUtil.getRecoverySite((String)recoverySiteId);
        this.handleRecoveryContinue(recoveryPlan, user, DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, map);
    }

    private void sendRestRequestToDisasterSite(String recoveryPlanId, Map<String, String> recoveryContext, Site curDisasterSite, String restUrl, Map<String, Object> uriVariablesMap) {
        RestClient client = SiteUtil.initClient((Site)curDisasterSite);
        try {
            HashMap<String, Object> uriVariables = new HashMap<String, Object>();
            if (!VerifyUtil.isEmpty(uriVariablesMap)) {
                uriVariables.putAll(uriVariablesMap);
            }
            uriVariables.put("planId", recoveryPlanId);
            uriVariables.put("recoveryContext", recoveryContext);
            JSONObject object = JSONObject.fromObject(recoveryContext);
            client.put(restUrl, object.toString(), uriVariables);
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"Send message error, error message:%s", new Object[]{le.getMessage()});
            ExceptionUtil.rethrowException((Throwable)le, (String)le.getMessage(), (long)le.getErrorCode(), (String[])le.getParameters(), (Log)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryContinue(RecoveryPlan recoveryPlan, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE executeType, Map<String, String> recoveryContext) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            this.checkRecoveryPlanPaused(recoveryPlan);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)executeType.getValue()));
            RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(executeType);
            if (rpDefinition == null) {
                logger.error((Object)"The recoveryProcessDefinition is null!");
                throw new LegoCheckedException(1073947393L);
            }
            this.submitRecoveryBackTask(recoveryPlan, rpDefinition, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
        }
    }

    private void checkRecoveryPlanPaused(RecoveryPlan recoveryPlan) {
        if (DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue() != recoveryPlan.getPlanStatus()) {
            String msg = String.format(Locale.ROOT, "The recovery plan is not paused. PlanId:%s .", recoveryPlan.getPlanId());
            logger.error((Object)msg);
            throw new LegoCheckedException(msg);
        }
    }

    private void migration(String recoveryPlanId, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE excuteType, String urlMigration) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        this.dealGlobalSettings(recoveryPlan);
        String recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, excuteType, recoveryContext);
        Site recoverySite = RecoveryServiceUtil.getRecoverySite((String)recoverySiteId);
        if (this.validateRecoverySite(recoverySiteId, recoveryPlan)) {
            logger.error((Object)"illegal recovery siteName: %s", new Object[]{recoverySite.getName()});
            throw new LegoCheckedException(1073949730L, new String[]{recoverySite.getName()});
        }
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, excuteType);
    }

    private boolean validateRecoverySite(String recoverySiteId, RecoveryPlan recoveryPlan) {
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        int templateType = pg.getTemplate().getType();
        if (!PolicyTemplateType.REP_4DC_CASCADE_POLICYTEMPLATE.contains(templateType)) {
            return false;
        }
        String productSite = pg.getProductSiteId();
        Set hmSites = pg.getHyperMetroSiteIdSet();
        if (hmSites.contains(productSite)) {
            return false;
        }
        return !hmSites.contains(recoverySiteId);
    }

    public void startHotMigration(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.migration(recoveryPlanId, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION, URL_HOTMIGRATION);
    }

    private IRecoveryProcessBaseProvider getRecoveryProcessProvider(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (null == provider) {
            throw new LegoCheckedException(1073947393L);
        }
        return provider;
    }

    private void dealGlobalSettings(RecoveryPlan recoveryPlan) {
        Map globalSettings = recoveryPlan.getGlobalSettings();
        if (globalSettings.containsKey("RECOVERY_EXTEND_ATTRIBUTES")) {
            globalSettings.put("RECOVERY_EXTEND_ATTRIBUTES", "-1");
        }
        globalSettings.remove("REPLICA_ID");
    }

    public void startRecoveryDrilling(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        IRecoveryProcessBaseProvider provider = this.getRecoveryProcessProvider(recoveryPlan);
        String recoverySiteId = null;
        if (this.validateIsArrayHypermetro(recoveryPlan)) {
            this.checkPriorityStationType(recoveryContext);
            recoverySiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
            recoveryContext.put("DISASTER_SITE_ID", recoverySiteId);
        } else {
            recoverySiteId = provider.getRecoverySiteId(recoveryPlanId, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, recoveryContext);
        }
        Site recoverySite = RecoveryServiceUtil.getRecoverySite((String)recoverySiteId);
        if (this.validateRecoverySite(recoverySiteId, recoveryPlan)) {
            logger.error((Object)"illegal recovery siteName: %s when drilling", new Object[]{recoverySite.getName()});
            throw new LegoCheckedException(1073949730L, new String[]{recoverySite.getName()});
        }
        this.dealGlobalSettings(recoveryPlan);
        this.prepareSuffixType(recoveryPlanId, recoveryContext, "Drilling");
        if (DrmEnumDefine.ProtectGroupStatus.DISABLED.getStatus() == recoveryPlan.getProtectGroup().getStatus()) {
            logger.error((Object)"The protection group is disabled.", new Object[]{recoveryPlan.getProtectGroup().getName()});
            throw new LegoCheckedException(1073948193L);
        }
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING);
    }

    private boolean validateIsArrayHypermetro(RecoveryPlan recoveryPlan) {
        Set protectGroups = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)protectGroups.iterator().next();
        if (15 != pg.getTemplate().getType()) {
            return false;
        }
        ProtectObject po = (ProtectObject)pg.getPolist().iterator().next();
        Set usedStorageResourceSet = po.getUsedStorageResourceSet();
        if (VerifyUtil.isEmpty((Collection)usedStorageResourceSet)) {
            logger.error((Object)("usedStorageResourceSet is empty! pgName : " + pg.getName() + ", po:" + po.getMoUuid() + ", poName:" + po.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)usedStorageResourceSet.iterator().next();
        return posi.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.LUN.getValue();
    }

    private void checkPriorityStationType(Map<String, String> recoveryContext) {
        String priorityStationType = recoveryContext.get("priorityStationType");
        HashSet<String> types = new HashSet<String>();
        types.add(String.valueOf(0));
        types.add(String.valueOf(1));
        if (VerifyUtil.isEmpty((String)priorityStationType)) {
            logger.error((Object)"priorityStationType is empty");
            throw new LegoCheckedException(1073947393L);
        }
        if (!types.contains(priorityStationType)) {
            logger.error((Object)("priorityStationType is error, priorityStationType: " + priorityStationType));
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void cleanRecoveryDrilling(String recoveryPlanId, User operator, Map<String, String> recoveryContext) {
        this.checkParameters(recoveryPlanId, operator);
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId);
        this.handleRecoveryOperation(recoveryPlan, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING);
    }

    private RecoveryPlan getRecoveryPlan(String recoveryPlanId) {
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        this.checkIfProtectObjectExisted(recoveryPlan);
        return recoveryPlan;
    }

    public void reprotectRecoveryPlan(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        this.checkParameters(recoveryPlanId, recoveryContext, operator);
        RecoveryPlan recoveryPlan = this.recoveryPlanService.getRecoveryPlanWithProcess(recoveryPlanId);
        if (null == recoveryPlan) {
            throw new LegoCheckedException(201L);
        }
        RecoveryServiceUtil.checkReprotectOperationPrivilege((RecoveryPlan)recoveryPlan);
        this.handleRecoveryOperation(recoveryPlan, recoveryContext, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT);
    }

    public void startSwaping(String recoveryPlanId, User operator) {
        this.checkParameters(recoveryPlanId, operator);
        RecoveryPlan recoveryPlan = this.getRecoveryPlan(recoveryPlanId);
        RecoveryManager.checkStorageVersion(recoveryPlan);
        String recoverySiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
        recoveryPlan.getGlobalSettings().put("DISASTER_SITE_ID", recoverySiteId);
        this.handleRecoveryOperation(recoveryPlan, operator, DrmEnumDefine.RecoveryPlanExecuteTypeE.SWAP);
    }

    private static void checkStorageVersion(RecoveryPlan recoveryPlan) {
        String deviceSn = recoveryPlan.getProtectGroup().getPoProviderSN();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceSn);
        List storageUnits = CommonDAOLocator.getMoDao().findMoBy(StorageUnit.class, props);
        if (VerifyUtil.isEmpty((Collection)storageUnits)) {
            logger.info((Object)"SN is not storage device sn, sn= %s", new Object[]{deviceSn});
            Set protectObjectStorageInfos = recoveryPlan.getProtectGroup().getPolist().stream().findAny().map(ProtectObject::getUsedStorageResourceSet).orElse(new HashSet());
            deviceSn = protectObjectStorageInfos.stream().findAny().map(ProtectObjectStorageInfo::getResourceProviderSN).orElseThrow(() -> new LegoCheckedException(2117645L));
            props.put("devSn", deviceSn);
            logger.info((Object)"Storage device sn= %s", new Object[]{deviceSn});
            storageUnits = CommonDAOLocator.getMoDao().findMoBy(StorageUnit.class, props);
        }
        if (VerifyUtil.isEmpty((Collection)storageUnits)) {
            logger.error((Object)"Storage unit not exist, sn= %s", new Object[]{deviceSn});
            throw new LegoCheckedException(2117645L);
        }
        StorageUnit storageUnit = (StorageUnit)CommonUtil.getFirstElement((Collection)storageUnits);
        String productVersion = storageUnit.getProductVersion();
        if (StorageManagerUtil.versionCompare((String)productVersion, (String)"V600R000C00") >= 0) {
            logger.error((Object)"V6 storage does not support swap nas hyper metro. productVersion=%s.", new Object[]{productVersion});
            throw new LegoCheckedException(1677929524L, new String[]{productVersion});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryOperation(RecoveryPlan recoveryPlan, Map<String, String> recoveryContext, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        ProtectGroup pg = recoveryPlan.getProtectGroup();
        this.checkMatchAz2Region(recoveryContext, pg, execType);
        this.tryExcludeLockForVasa(pg.getUuid());
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
            if (null == provider) {
                logger.error((Object)("provider is null: " + recoveryPlanId));
                return;
            }
            HashMap<String, Object> settings = new HashMap<String, String>();
            if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)execType) || this.validateIsArrayHypermetro(recoveryPlan)) {
                settings.putAll(recoveryContext);
            } else {
                settings = provider.checkRecoveryContext(recoveryPlanId, execType, recoveryContext, operator);
            }
            provider.checkOperation(recoveryPlan, DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), DrmEnumDefine.RecoveryPlanOperationType.getType((int)execType.getValue()));
            recoveryPlan = this.updateRecoveryPlanSetting(recoveryPlan, settings);
            this.checkInstanceStatusAndHoldVM(recoveryPlan, execType);
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, execType);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, recoveryContext);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
            this.releaseExcludeLockForVasa(pg.getUuid());
        }
    }

    private void tryExcludeLockForVasa(String lockId) {
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            logger.debug((Object)"get exclude lock for vasa scenario: lockId=%s", new Object[]{lockId});
            ProtectionJobUtil.getInstance().checkIsNeedLock(lockId);
        }
    }

    private void releaseExcludeLockForVasa(String lockId) {
        boolean isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false));
        if (isVasa) {
            ProtectionJobUtil.getInstance().releaseLockPg(lockId);
        }
    }

    private void checkMatchAz2Region(Map<String, String> recoveryContext, ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        String pgRegionId = (String)pg.getProps().get("regionId");
        if (!VerifyUtil.isEmpty((String)pgRegionId) && pgRegionId.contains(SEPARATOR)) {
            pgRegionId = pgRegionId.split(SEPARATOR)[1];
        }
        String azId = recoveryContext.get("az_id");
        String regionId = recoveryContext.get("region_id");
        String pgazId = (String)pg.getProps().get("zoneName");
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)execType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.HOT_MIGRATION.equals((Object)execType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.equals((Object)execType) || DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)execType)) {
            if (!(VerifyUtil.isEmpty((String)regionId) || VerifyUtil.isEmpty((String)pgRegionId) || regionId.equals(pgRegionId))) {
                logger.error((Object)"region or az message error, regionId: %s, pgRegionId: %s", new Object[]{regionId, pgRegionId});
                throw new LegoCheckedException(1073949727L);
            }
            if (!(VerifyUtil.isEmpty((String)azId) || VerifyUtil.isEmpty((String)pgazId) || azId.equals(pgazId))) {
                logger.error((Object)"region or az message error, azId: %s, pgazId: %s", new Object[]{azId, pgazId});
                throw new LegoCheckedException(1073949727L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRecoveryOperation(RecoveryPlan recoveryPlan, User operator, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        String recoveryPlanId = recoveryPlan.getPlanId();
        this.checkRecoveryPlanExecuting(recoveryPlanId);
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        this.tryExcludeLockForVasa(protectGroup.getUuid());
        try {
            this.tryLockRecoveryPlan(recoveryPlanId);
            RecoveryOperationController.checkOperation((DrmEnumDefine.RecoveryPlanStatusE)DrmEnumDefine.RecoveryPlanStatusE.getType((int)recoveryPlan.getPlanStatus()), (DrmEnumDefine.RecoveryPlanOperationType)DrmEnumDefine.RecoveryPlanOperationType.getType((int)execType.getValue()));
            RecoveryProcessDefinition recoveryProcessDef = this.getRecoveryProcessDef(recoveryPlan, execType);
            this.submitRecoveryBackTask(recoveryPlan, recoveryProcessDef, operator, null);
        }
        finally {
            this.unLockRecoveryPlan(recoveryPlanId);
            this.releaseExcludeLockForVasa(protectGroup.getUuid());
        }
    }

    protected void checkRecoveryPlanExecuting(String recoveryPlanId) {
        if (SyncLockManager.isLocked(recoveryPlanId + 0)) {
            logger.error((Object)("The recovery plan is executing. PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(1073948750L);
        }
    }

    protected void tryLockRecoveryPlan(String recoveryPlanId) {
        if (!SyncLockManager.tryLock(recoveryPlanId + 1)) {
            logger.error((Object)("The recovery plan is executing. PlanId:" + recoveryPlanId), 90160758784001L);
            throw new LegoCheckedException(1073948750L);
        }
    }

    protected void unLockRecoveryPlan(String recoveryPlanId) {
        SyncLockManager.unLock(recoveryPlanId + 1);
    }

    protected RecoveryPlan updateRecoveryPlanSetting(RecoveryPlan recoveryPlan, Map<String, Object> settings) {
        if (null == recoveryPlan || null == settings || settings.isEmpty()) {
            return recoveryPlan;
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
        settings.put("PRODUCT_SITE_ID", productSiteId);
        HashSet recoverySettings = recoveryPlan.getRecoverySettings();
        if (null == recoverySettings) {
            recoverySettings = new HashSet();
            recoveryPlan.setRecoverySettings(recoverySettings);
        }
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = String.valueOf(settings.get("DISASTER_SITE_ID"));
        Set<Map.Entry<String, Object>> settingsEntrySet = settings.entrySet();
        for (Map.Entry<String, Object> entry : settingsEntrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof Map)) {
                globalSettings.put(key, String.valueOf(value));
                continue;
            }
            Map subSettingsMap = (Map)value;
            Set subEntrySet = subSettingsMap.entrySet();
            for (Map.Entry subEntry : subEntrySet) {
                Object subKey = subEntry.getKey();
                Object subValue = subEntry.getValue();
                RecoverySetting recoverySetting = new RecoverySetting();
                recoverySetting.setRecoveryPlan(recoveryPlan);
                recoverySetting.setDisasterSiteId(disasterSiteId);
                recoverySetting.setOwnerId(String.valueOf(subKey));
                recoverySetting.setName(key);
                recoverySetting.setValue(String.valueOf(subValue));
                RecoveryServiceUtil.resetRecoverySetting(recoverySettings, (RecoverySetting)recoverySetting);
            }
        }
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return recoveryPlan;
    }

    protected void checkParameters(String recoveryPlanId, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.", 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected void checkParameters(String recoveryPlanId, Map<String, String> recoveryContext, User operator) {
        if (VerifyUtil.isEmpty((String)recoveryPlanId) || null == recoveryContext || VerifyUtil.isEmpty((Object)operator) || VerifyUtil.isEmpty((String)operator.getUserName())) {
            logger.error((Object)"Invalid parameter.", 90160758786876L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    protected synchronized void submitRecoveryBackTask(RecoveryPlan plan, RecoveryProcessDefinition rpDefinition, User operator, Map<String, String> recoveryContext) {
        this.recoveryPlanService.checkBackendRecoveryTaskCount();
        if (null == plan) {
            logger.error((Object)"plan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == rpDefinition) {
            logger.error((Object)"rpDefinition is null.");
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType = DrmEnumDefine.RecoveryPlanExecuteTypeE.getType((int)rpDefinition.getProcType());
        Map<String, Object> initialContextData = this.getInitialContextData(plan, rpExecuteType);
        if (!VerifyUtil.isEmpty(recoveryContext)) {
            initialContextData.put("IS_CONTINUE_PROCESS", recoveryContext.get("recovery_continue_key"));
        }
        initialContextData.put("RecoveryProcessDefinition", rpDefinition);
        this.setSuffixTypeToContextData(recoveryContext, initialContextData);
        RecoveryBackTask recoveryBackTask = new RecoveryBackTask();
        recoveryBackTask.setInitialContextData(initialContextData);
        recoveryBackTask.setRecoveryPlan(plan);
        recoveryBackTask.setRecoveryPlanExecuteType(rpExecuteType);
        recoveryBackTask.setOperator(operator);
        RecoveryManager.updateCallBack(rpExecuteType, recoveryBackTask);
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.equals((Object)rpExecuteType)) {
            initialContextData.put("IS_CONFIRM_REPROTECTION", recoveryContext.get("is_confirm_reprotection"));
        }
        RecoveryProcessSerialExecutor recoveryTemplate = this.getRecoveryTemplate(rpDefinition, rpExecuteType);
        recoveryBackTask.setRecoveryProcessTemplate((IProcessor)recoveryTemplate);
        RecoveryPreCheckerManager.getInstance().check(plan, rpExecuteType);
        Map preProcessResults = RecoveryPreProcessorManager.getInstance().process(plan, rpExecuteType);
        recoveryBackTask.setPreProcessResults(preProcessResults);
        recoveryBackTask.setInitialContextData(initialContextData);
        logger.info((Object)"Begin submit recovery task. Plan name:%s,id: %s, status:%s, task type:%s", new Object[]{plan.getName(), plan.getPlanId(), plan.getPlanStatus(), rpExecuteType});
        RecoveryBackTaskExecutor.submitRecoveryBackTask((IRecoveryBackTask)recoveryBackTask);
    }

    private static void updateCallBack(DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType, RecoveryBackTask recoveryBackTask) {
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT.equals((Object)rpExecuteType)) {
            ReprotectCallBackExcuteRecoveryTask callBackTask = new ReprotectCallBackExcuteRecoveryTask();
            recoveryBackTask.setCallBaskTask(callBackTask);
            return;
        }
        HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE> extraExecTypeToAddCallback = new HashSet<DrmEnumDefine.RecoveryPlanExecuteTypeE>(Collections.singletonList(DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING));
        if (extraExecTypeToAddCallback.contains(rpExecuteType)) {
            RecoveryPlan recoveryPlan = recoveryBackTask.getRecoveryPlan();
            DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType((RecoveryPlan)recoveryPlan);
            IRecoveryProcessBaseProvider recoveryProcessProvider = RecoveryProcessorMgr.getInstance().getRecoveryProcessProvider(appType.name());
            ICallBackExcuteRecoveryTask callBackTask = recoveryProcessProvider.getRecoveryCallbackTask(rpExecuteType);
            recoveryBackTask.setCallBaskTask(callBackTask);
        }
    }

    protected void setSuffixTypeToContextData(Map<String, String> recoveryContext, Map<String, Object> initialContextData) {
        if (VerifyUtil.isEmpty(recoveryContext) || !recoveryContext.containsKey("NameSuffixKey")) {
            logger.info((Object)"context is empty.");
            return;
        }
        String suffix = recoveryContext.get("NameSuffixKey");
        logger.info((Object)"name suffix key: %s.", new Object[]{suffix});
        initialContextData.put("NameSuffixKey", suffix);
    }

    protected void prepareSuffixType(String recoveryPlanId, Map<String, String> recoveryContext, String initSuffix) {
        logger.info((Object)"prepare initial suffix.");
        RecoveryPlan recoveryPlan = this.getRecoveryPlanService().getRecoveryPlan(recoveryPlanId, true, false);
        if (null == recoveryPlan) {
            logger.error((Object)"recovery plan is null, id: %s.", new Object[]{recoveryPlanId});
            throw new LegoCheckedException(201L);
        }
        String suffix = initSuffix + "_" + recoveryPlan.getName();
        logger.info((Object)"name suffix in params: %s.", new Object[]{suffix});
        recoveryContext.put("NameSuffixKey", suffix);
    }

    protected RecoveryProcessSerialExecutor getRecoveryTemplate(RecoveryProcessDefinition rpDefinition, DrmEnumDefine.RecoveryPlanExecuteTypeE recoveryPlanExecuteType) {
        if (null == rpDefinition) {
            throw new LegoCheckedException(1073947393L);
        }
        Set processors = rpDefinition.getRecoveryProcessors();
        List sortedProcessors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)processors);
        RecoveryProcessSerialExecutor executor = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((List)sortedProcessors, (DrmEnumDefine.RecoveryPlanExecuteTypeE)recoveryPlanExecuteType);
        if (null == executor) {
            logger.error((Object)"Creating recovery process executor failed.", 90160758784001L);
            throw new LegoCheckedException(0x300001L);
        }
        return executor;
    }

    protected RecoveryProcessDefinition getRecoveryProcessDef(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        IRecoveryProcessBaseProvider provider;
        RecoveryProcessDefinition rpDefinition = recoveryPlan.getRecoveryProcess(execType);
        if (null == rpDefinition || this.doUpgradeForAutoPlanMotion(recoveryPlan, execType, rpDefinition)) {
            rpDefinition = this.createRecoveryProcessDefinition(recoveryPlan, execType);
        }
        if (null == (provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan))) {
            throw new LegoCheckedException(1073947393L);
        }
        provider.resetRecoveryProcessDefinition(recoveryPlan, rpDefinition, true);
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        if (null == protectGroup) {
            logger.error((Object)("The protectGroup does not exist.PlanId:" + recoveryPlan.getPlanId()), 90160758784001L);
            throw new LegoCheckedException(201L);
        }
        Set recoveryProcessors = rpDefinition.getRecoveryProcessors();
        for (RecoveryProcessor processor : recoveryProcessors) {
            processor.resetEnableStatus(recoveryPlan, execType);
        }
        return rpDefinition;
    }

    public RecoveryProcessDefinition createRecoveryProcessDefinition(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
        if (null == recoveryPlan || VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType((RecoveryPlan)recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (null == provider) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = recoveryPlan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)("planid: " + recoveryPlan.getPlanId()), 1L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        RecoveryProcessDefinition rpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, execType, protectGroup);
        HashSet<RecoveryProcessDefinition> recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        if (null == recoveryProcesses) {
            recoveryProcesses = new HashSet<RecoveryProcessDefinition>();
            recoveryPlan.setRecoveryProcesses(recoveryProcesses);
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
        return rpDefinition;
    }

    protected void checkIfProtectObjectExisted(RecoveryPlan recoveryPlan) {
        if (null == recoveryPlan) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Collection)recoveryPlan.getProtectGroups())) {
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList protectObjects = new ArrayList();
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            if (VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) continue;
            protectObjects.addAll(protectGroup.getPolist());
        }
        if (protectObjects.isEmpty()) {
            throw new LegoCheckedException(1073947394L);
        }
    }

    protected Map<String, Object> getInitialContextData(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE rpExecuteType) {
        HashMap<String, Object> initialContextData = new HashMap<String, Object>();
        if (VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) {
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = plan.getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = (ProtectGroup)iterator.next();
        Optional<Integer> optional = Optional.ofNullable(protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType);
        optional.ifPresent(integer -> plan.getGlobalSettings().put("Pg_Template_type", integer.toString()));
        String disasterSiteId = (String)plan.getGlobalSettings().get("DISASTER_SITE_ID");
        String replicaId = (String)plan.getGlobalSettings().get("REPLICA_ID");
        ProtectGroupReplica replica = RecoveryProcessUtil.getProtectGroupReplicaByReplicaId(protectGroup, replicaId);
        if (null == replica) {
            replica = RecoveryProcessUtil.getProtectGroupReplicaBySiteId(protectGroup, disasterSiteId);
        }
        if (null == replica) {
            logger.error((Object)("getReplica failed:" + replicaId + "pg:" + protectGroup.getName()));
            return initialContextData;
        }
        plan.getGlobalSettings().put("Recovery_PgReplica_Location", String.valueOf(replica.getProtectLocation()));
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replica = replicaService.queryProtectGroupReplicaById(replica.getId());
        logger.info((Object)("Initial context data, PlanId:" + plan.getPlanId() + ", SiteId:" + disasterSiteId + ", ReplicaId:" + replicaId + ", Replica:" + replica));
        Set protectObjects = RecoveryProcessUtil.getRecoveryProtectObjects((ProtectGroup)protectGroup, (ProtectGroupReplica)replica, (DrmEnumDefine.RecoveryPlanExecuteTypeE)rpExecuteType);
        initialContextData.put("Recovery_ProtectObjects", protectObjects);
        initialContextData.put("Recovery_ProtectGroup", protectGroup);
        initialContextData.put("Recovery_PgReplica", replica);
        return initialContextData;
    }

    private void checkInstanceStatusAndHoldVM(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE type) {
        MessageEvent event = new MessageEvent();
        HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE> messageMap = new HashMap<String, DrmEnumDefine.RecoveryPlanExecuteTypeE>();
        messageMap.put("message_event_excute_type", type);
        event.setMessageMap(messageMap);
        event.setMessageType(7);
        ArrayList<RecoveryPlan> objectList = new ArrayList<RecoveryPlan>();
        objectList.add(recoveryPlan);
        event.setObjectList(objectList);
        IRecoveryPlanObserverManager observerManager = (IRecoveryPlanObserverManager)ServiceLocator.getInstance().getService(IRecoveryPlanObserverManager.class);
        observerManager.notifyObserverList(event, "before");
    }

    public boolean doUpgradeForAutoPlanMotion(RecoveryPlan recoveryPlan, DrmEnumDefine.RecoveryPlanExecuteTypeE execType, RecoveryProcessDefinition rpDefinition) {
        logger.info((Object)"doUpgradeForAutoPlanMotion: recoveryPlan %s, execType %s", new Object[]{recoveryPlan.getName(), execType.getValue()});
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        if (!Arrays.asList(34, 22, 21).contains(protectGroup.getTemplate().getType())) {
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() != execType.getValue()) {
            return false;
        }
        Set set = rpDefinition.getRecoveryProcessors().stream().filter(processor -> processor.getProcName().indexOf("OpenStackReverseStorageRepDirectionProcessor") != -1).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            logger.info((Object)"no need refactPlanMotionProcessDefinition: %s", new Object[]{recoveryPlan.getName()});
            return false;
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"%s is PLANED_MOTION_FAILED, need refact definition.", new Object[]{recoveryPlan.getName()});
            this.refactPlanMotionProcessDefinition(recoveryPlan, rpDefinition, protectGroup);
        }
        if (DrmEnumDefine.RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.READY.getValue() == recoveryPlan.getPlanStatus() || DrmEnumDefine.RecoveryPlanStatusE.CLEAN_COMPLETED.getValue() == recoveryPlan.getPlanStatus()) {
            logger.info((Object)"recoveryPlan(%s), status(%s), need refact definition.", new Object[]{recoveryPlan.getName(), recoveryPlan.getPlanStatus()});
            recoveryPlan.getRecoveryProcesses().remove(rpDefinition);
            IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
            recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
            return true;
        }
        return false;
    }

    private void refactPlanMotionProcessDefinition(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, ProtectGroup protectGroup) {
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (null == provider) {
            logger.error((Object)("provider is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
        DrmEnumDefine.AppType appType = RecoveryServiceUtil.getAppType((RecoveryPlan)recoveryPlan);
        String disasterSiteId = (String)recoveryPlan.getGlobalSettings().get("DISASTER_SITE_ID");
        RecoveryProcessDefinition reprotectedRpDefinition = provider.getRecoveryProcess(recoveryPlan, disasterSiteId, appType, DrmEnumDefine.RecoveryPlanExecuteTypeE.REPROTECT, protectGroup);
        List rProcessors = RecoveryServiceUtil.sortRecoveryProcessors((Set)reprotectedRpDefinition.getRecoveryProcessors());
        ArrayList<Class<? extends RecoveryProcessor>> procClsList = new ArrayList<Class<? extends RecoveryProcessor>>();
        for (int i = 3; i < rProcessors.size(); ++i) {
            procClsList.add(((RecoveryProcessor)rProcessors.get(i)).getClass());
        }
        this.refactRecoveryProcessors(recoveryPlan, rpDefinition, procClsList);
    }

    private void refactRecoveryProcessors(RecoveryPlan recoveryPlan, RecoveryProcessDefinition rpDefinition, List<Class<? extends RecoveryProcessor>> procClsList) {
        RecoveryProcessor lastProcessor = RecoveryServiceUtil.getLastRecoveryProcessor((Set)rpDefinition.getRecoveryProcessors());
        if (null == lastProcessor || VerifyUtil.isEmpty(procClsList)) {
            logger.error((Object)"refact processDefinition error. Can not find the last processor .");
            return;
        }
        IRecoveryProcessService recoveryProcessService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        logger.info((Object)"recoveryPlan(%s), need delete definition %s.", new Object[]{recoveryPlan.getName(), rpDefinition.getName()});
        Set recoveryProcesses = recoveryPlan.getRecoveryProcesses();
        recoveryProcesses.remove(rpDefinition);
        recoveryProcessService.deleteRecoveryProcessDefinition(rpDefinition);
        IRecoveryProcessBaseProvider provider = RecoveryServiceUtil.getRecoveryProcessProvider((RecoveryPlan)recoveryPlan);
        if (null == provider) {
            logger.error((Object)("provider is null: " + recoveryPlan.getPlanId()), 90160758784001L);
            return;
        }
        provider.insertRecoveryProcessors(rpDefinition, lastProcessor.getPreviousProcessor().getClass(), procClsList, true, false);
        provider.deleteRecoveryProcessors(rpDefinition, lastProcessor.getProcId(), false);
        for (RecoveryProcessor pro : rpDefinition.getRecoveryProcessors()) {
            pro.setProcessId(rpDefinition.getProcessId());
            pro.setPlanId(recoveryPlan.getPlanId());
            if (!procClsList.contains(pro.getClass())) continue;
            pro.setIsPreset(Boolean.valueOf(true));
            pro.setIsEditable(Boolean.valueOf(false));
        }
        recoveryProcesses.add(rpDefinition);
        IRecoveryProcessService rpService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        rpService.updateRecoveryPlan(recoveryPlan);
    }
}

