/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.checker.manager;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.checker.manager.AbRateConfigBaseService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.template.sdk.service.IRateConfigService;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@ServiceBoundInfo(methodName="onBind", targetBeanName="rateConfigServiceMgr", properties="type:1##3##4##5##6##18##20##23##24##30##31##32##33##35##36##38##39##40##41##42##43##44##45##46##47")
public class RateConfigByReplicaServiceImpl
extends AbRateConfigBaseService
implements IRateConfigService {
    private static Log logger = LogFactory.getInstance(RateConfigByReplicaServiceImpl.class);

    public void modifyRate(DmEnumDefine.SpeedLevelE speedLevel, ProtectGroup pg, int protectionLocation) {
        if (VerifyUtil.isEmpty((Object)pg)) {
            logger.error((Object)"pg or protectionLocation is empty");
            throw new LegoCheckedException(1073947393L);
        }
        int times2 = 0;
        while (true) {
            if (times2 >= 3) {
                AlarmReporter.sendAlarm((long)52625438L, (String)pg.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])new String[]{pg.getUuid(), pg.getName()});
                break;
            }
            try {
                this.syncRateByReplicationRelationBo(speedLevel, pg, protectionLocation);
                AlarmReporter.restoreAlarm((long)52625438L, (String[])new String[]{pg.getUuid(), pg.getName()});
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"cannot alter ArrayRate...", (Throwable)e);
                ++times2;
                CommonUtil.sleep((long)60000L);
                continue;
            }
            break;
        }
    }

    private void syncRateByReplicationRelationBo(DmEnumDefine.SpeedLevelE speedLevel, ProtectGroup pg, int protectionLocation) {
        for (ProtectGroupReplica protectGroupReplica : pg.getReplicaList()) {
            if (protectGroupReplica.getProtectLocation() != protectionLocation) continue;
            Set protectObjectReplicas = protectGroupReplica.getReplicas();
            List<ReplicationRelationBo> replicationRelationBos = this.getReplicationRelationBos(pg, protectObjectReplicas);
            logger.debug((Object)("syncRateByReplicationRelationBo end. replicationRelationBos:" + replicationRelationBos));
            for (ReplicationRelationBo replicationRelationBo : replicationRelationBos) {
                String devSn;
                boolean isCg = replicationRelationBo.isConsistentGroup();
                boolean isAirGap = false;
                if (PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType())) {
                    devSn = replicationRelationBo.getTgtDeviceSn();
                    isAirGap = true;
                } else {
                    devSn = replicationRelationBo.getSrcDeviceSn();
                }
                this.changeSyncRateByReplic(devSn, speedLevel, isCg, replicationRelationBo, isAirGap);
            }
        }
    }

    protected List<ReplicationRelationBo> getReplicationRelationBos(ProtectGroup protectGroup, Set<ProtectObjectReplica> replicas) {
        return protectGroup.getReplicationRelationBos(replicas);
    }

    private void changeSyncRateByReplic(String devSn, DmEnumDefine.SpeedLevelE speedLevel, boolean isCg, ReplicationRelationBo replicationRelationBo, boolean isAirGap) {
        String pairId = replicationRelationBo.getReplicationId();
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(devSn);
        if (null == drResource) {
            logger.error((Object)"SyncRateJob,drResource is null");
            throw new LegoCheckedException(2117645L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)"SyncRateJob,site is null");
            throw new LegoCheckedException(2117645L);
        }
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        proxy.changeRate(devSn, pairId, isCg, speedLevel);
        logger.debug((Object)("Enter alterAndSaveSpeedLevel,isCg=" + isCg));
        if (!isCg) {
            HashSet<String> repSrcLuns = new HashSet<String>(replicationRelationBo.getTgtLuns().keySet());
            logger.debug((Object)"RepSrcLuns=%s, devSn=%s, pairId=%s", new Object[]{repSrcLuns, devSn, pairId});
            ReplicationPair replicationPair = this.getReplicationPair(repSrcLuns, devSn, pairId, replicationRelationBo.getResourceType());
            List replicationTargetLun = replicationPair.getRepTgtLuns();
            this.alterAndSaveSpeedLevel(replicationTargetLun, speedLevel);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("replicationId", pairId);
            if (isAirGap) {
                props.put("devSn", devSn);
            } else {
                props.put("srcDevSN", devSn);
            }
            List groups = CommonDAOLocator.getMoDao().findMoBy(ReplicationGroup.class, props);
            this.alterAndSaveCGSpeedLevel(groups, speedLevel);
        }
    }

    private ReplicationPair getReplicationPair(Set<String> repSrcLuns, String devSn, String pairId, Integer resourceType) {
        if (VerifyUtil.isEmpty(repSrcLuns)) {
            logger.warn((Object)("getReplicationPair start. repSrcLuns:" + repSrcLuns));
            return new ReplicationPair();
        }
        ReplicationPair replicationPairResult = new ReplicationPair();
        ArrayList<String> lunIdList = new ArrayList<String>();
        lunIdList.addAll(repSrcLuns);
        List<ReplicationPair> replicationPairs = this.getPairsByLun(lunIdList, devSn, resourceType);
        if (null == replicationPairs || replicationPairs.isEmpty()) {
            logger.debug((Object)("replicationPairs isEmpty. devSn = " + devSn));
            return new ReplicationPair();
        }
        for (ReplicationPair replicationPair : replicationPairs) {
            if (!replicationPair.getReplicationId().equals(pairId) && (VerifyUtil.isEmpty((String)replicationPair.getConsistentGroupId()) || !replicationPair.getConsistentGroupId().equals(pairId))) continue;
            replicationPairResult = replicationPair;
        }
        logger.debug((Object)("replicationPairResult = " + replicationPairResult.getReplicationId()));
        return replicationPairResult;
    }
}

