/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.bean.SnapShotAssociateProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessHandler;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBaseProtectExtendAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(AbstractBaseProtectExtendAction.class);

    protected AbstractBaseProtectAction.ReplicationProgress syncProgress(ReplicationRelationBo rrb, ActionContext context) {
        ReplicationRelation replicationRelation;
        Integer syncProgress;
        IRecoveryProcessHandler recoveryProcessHandler = (IRecoveryProcessHandler)RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler();
        if (rrb.isConsistentGroup() && !VerifyUtil.isEmpty((Object)(syncProgress = (replicationRelation = StorageReplicationManagerProxy.getInstance().queryRealtimeReplication(this.isAirGap(context) ? rrb.getTgtDeviceSn() : rrb.getSrcDeviceSn(), rrb.getReplicationId(), rrb.isConsistentGroup())).getSyncProgress())) && syncProgress > 0) {
            return new AbstractBaseProtectAction.ReplicationProgress().setProgress(syncProgress).setCompleted(syncProgress == 100);
        }
        List targetLuns = recoveryProcessHandler.querySyncStatus(rrb.getSrcDeviceSn(), rrb.getTgtDeviceSn(), rrb.getReplicationId(), rrb.isConsistentGroup());
        if (VerifyUtil.isEmpty((Collection)targetLuns)) {
            logger.error((Object)"Query Replication Target Lun error when check isSyncCompleted state.", 1073948461L);
            throw new LegoCheckedException(1073948461L, "query Replication Target Lun error when check isSyncCompleted state.");
        }
        boolean isCompleted = true;
        Integer progress = 100;
        for (ReplicationTargetLun repTargetLun : targetLuns) {
            Integer pairStatus = repTargetLun.getPairStatus();
            if (2 == pairStatus || XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() == pairStatus.intValue()) {
                isCompleted = false;
            } else if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() != pairStatus.intValue()) {
                logger.error((Object)("running status of " + rrb.getReplicationId() + " is incorrect. " + new JSONObject().set((Object)"isConsistentGroup", (Object)rrb.isConsistentGroup()).set((Object)"runningStatus", (Object)pairStatus)));
                throw new LegoCheckedException(1073948462L);
            }
            int targetProgress = this.detectLunExecutionProgress(repTargetLun);
            progress = Math.min(progress, targetProgress);
        }
        return new AbstractBaseProtectAction.ReplicationProgress().setProgress(progress).setCompleted(isCompleted);
    }

    private boolean isAirGap(ActionContext context) {
        ProtectGroup pg = (ProtectGroup)context.getObject("PG_ENTITY");
        return PolicyTemplateType.AIR_GAP_NETWORKING.contains(pg.getTemplate().getType());
    }

    private int detectLunExecutionProgress(ReplicationTargetLun target) {
        if (null == target) {
            logger.warn((Object)"Current lun object is null, set progress is 100.", 1073948462L);
            return 0;
        }
        Integer pairStatus = target.getPairStatus();
        logger.debug((Object)("Lun(" + target.getName() + ") pair status is " + pairStatus + ", and progress is " + target.getProgressRatio()), 90160758786876L);
        if (null == pairStatus) {
            logger.warn((Object)("Retrieve lun pair status is null, lun -> " + target.getName()), 1073948462L);
            return 100;
        }
        Integer progress = target.getProgressRatio();
        if (null == progress) {
            logger.warn((Object)("Retrieve lun progress ratio is null, lun -> " + target.getName()), 1073948462L);
            return 100;
        }
        return progress;
    }

    protected void setBackScriptParams(ActionContext context, Map<String, String> scriptParams, String key) {
        JSONObject scriptJsonParams = JSONObject.fromObject((Object)scriptParams.get(key));
        SnapShotAssociateProtectObject apo = (SnapShotAssociateProtectObject)context.getObject("PO_GROUP_MAP");
        Map snapshotInfo = apo.getSnapshotInfo();
        StringBuilder srcLunIds = new StringBuilder();
        StringBuilder snapshotIds = new StringBuilder();
        StringBuilder srcLunWwns = new StringBuilder();
        if (!VerifyUtil.isEmpty((Map)snapshotInfo)) {
            for (Map.Entry info : snapshotInfo.entrySet()) {
                srcLunIds.append((String)info.getKey() + ",");
                snapshotIds.append((String)info.getValue() + ",");
            }
            if (!VerifyUtil.isEmpty((Object)srcLunIds)) {
                srcLunIds.setLength(srcLunIds.length() - 1);
            }
            if (!VerifyUtil.isEmpty((Object)snapshotIds)) {
                snapshotIds.setLength(snapshotIds.length() - 1);
            }
        }
        String srcProviderSn = apo.getSrcStorageProviderSN();
        List<ProtectObjectStorageInfo> allProtectObjectStorageInfo = this.getAllProtectObjectStorageInfo(context);
        if (!VerifyUtil.isEmpty((Object)srcLunIds) && !VerifyUtil.isEmpty(allProtectObjectStorageInfo)) {
            String[] srcLunIdArr;
            for (String lunId : srcLunIdArr = srcLunIds.toString().split(",")) {
                for (ProtectObjectStorageInfo protectObjectStorageInfo : allProtectObjectStorageInfo) {
                    if (!lunId.equals(protectObjectStorageInfo.getResourceId())) continue;
                    srcLunWwns.append(protectObjectStorageInfo.getLunWWN() + ",");
                }
            }
        }
        if (!VerifyUtil.isEmpty((Object)srcLunWwns)) {
            srcLunWwns.setLength(srcLunWwns.length() - 1);
        }
        scriptJsonParams.put((Object)"SrcLunIds", (Object)srcLunIds.toString());
        scriptJsonParams.put((Object)"SnapshotIds", (Object)snapshotIds.toString());
        scriptJsonParams.put((Object)"SrcLunWWNs", (Object)srcLunWwns.toString());
        scriptJsonParams.put((Object)"SrcProviderSN", (Object)srcProviderSn);
        scriptParams.put(key, scriptJsonParams.toString());
    }

    protected List<ProtectObjectStorageInfo> getAllProtectObjectStorageInfo(ActionContext context) {
        ArrayList<ProtectObjectStorageInfo> protectObjectStorageInfoList = new ArrayList<ProtectObjectStorageInfo>();
        Set pos = (Set)context.getObject("PO_ENTITY");
        for (ProtectObject po : pos) {
            Set usedStorageResourceSet = po.getUsedStorageResourceSet();
            for (ProtectObjectStorageInfo protectObjectStorageInfo : usedStorageResourceSet) {
                protectObjectStorageInfoList.add(protectObjectStorageInfo);
            }
        }
        return protectObjectStorageInfoList;
    }

    protected final boolean isNeedSnpshot(ProtectGroup protectGroup) {
        JSONObject prJsonObj;
        PolicyTemplate template = protectGroup.getTemplate();
        String cloneSplitCofig = (String)template.getProps().get("CLONE_SPLIT");
        String createSnap = "";
        if (null != cloneSplitCofig && !cloneSplitCofig.isEmpty() && (prJsonObj = JSONObject.fromObject((Object)cloneSplitCofig)).containsKey((Object)"create_snap")) {
            createSnap = prJsonObj.getString("create_snap");
        }
        return Boolean.parseBoolean(createSnap);
    }
}

