/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.engine.action;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashSet;
import java.util.TreeSet;

public class FirstStageSitePrepareAction
extends AbstractBaseProtectAction {
    private static final Log logger = LogFactory.getInstance(FirstStageSitePrepareAction.class);
    private ProtectGroup pg = null;
    private int location;

    public void preExcute(ActionContext context) {
        this.pg = (ProtectGroup)context.getObject("PG_ENTITY");
        TreeSet<Integer> allProtectLocation = new TreeSet<Integer>();
        for (Schedule schedule : this.pg.getTemplate().getSchedules()) {
            if (schedule.getProtectedType() == 2 || schedule.getProtectedType() == 100) continue;
            allProtectLocation.add(schedule.getProtectLocation());
        }
        if (VerifyUtil.isEmpty(allProtectLocation)) {
            return;
        }
        this.location = (Integer)allProtectLocation.iterator().next();
        context.addObject("PG_EXECUTE_LOCATION", (Object)this.location);
        Site recoverSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(this.getRecoverSiteIdBySchedule(this.location, this.pg));
        this.setNameParams(recoverSite.getName() == null ? recoverSite.getSiteId() : recoverSite.getName());
    }

    public boolean doExecute(ActionContext context) {
        this.pg = (ProtectGroup)context.getObject("PG_ENTITY");
        logger.info((Object)("FirstStageSitePrepareAction begin to execute,pgId:" + this.pg.getUuid()), 90160758786988L);
        return this.prepare(context);
    }

    protected boolean prepare(ActionContext context) {
        ProtectGroupReplica pgReplica;
        if (DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus() != this.pg.getStatus()) {
            logger.error((Object)"pg'status is not Running.", 90160758786989L);
            this.setDetail("lego.err.1073948458");
            return false;
        }
        try {
            pgReplica = ExecuteReplicaManager.getInstance().calculateExecuteReplica(this.pg, this.location);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"calculateExecuteReplica is failed : %s", new Object[]{Long.toString(e.getErrorCode())});
            this.setDetail("lego.err." + e.getErrorCode());
            return false;
        }
        if (pgReplica == null) {
            logger.error((Object)"pgReplica is null.");
            this.setDetail("lego.err.1073947394");
            return false;
        }
        HashSet pos = new HashSet();
        pos.addAll(this.pg.getPolist());
        HashSet poReplicas = new HashSet();
        poReplicas.addAll(pgReplica.getReplicas());
        context.addObject("PO_ENTITY", pos);
        context.addObject("FIRST_STAGE_REPLICA", (Object)pgReplica);
        context.addObject("PO_REPLICA_ENTITY", poReplicas);
        context.addObject("PG_REPLICA_ENTITY", (Object)pgReplica);
        logger.info((Object)("FirstStageSitePrepareAction end to execute:" + this.pg.getName()), 90160758786988L);
        try {
            ProtectionJobUtil.getInstance().checkHyperMetro(this.pg, context, pgReplica);
        }
        catch (LegoCheckedException e) {
            this.setDetail(e.getErrorMessageKey());
            this.setDetailParams(this.constructParams(e.getParameters()));
            return false;
        }
        return true;
    }
}

