/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskHandler;
import com.huawei.ism.cbb.base.task.BackTaskService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.anti.blackmail.util.AntiBlackmailUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.ism.drm.constant.AntiBlackMailConstant;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.HttpMethod;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.mo.StorageObjectBo;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.checker.backtask.BackTaskCheckerManager;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.framework.service.group.AddProtectObjectsBackTask;
import com.huawei.ism.drm.protection.framework.service.group.AddScheduleTask;
import com.huawei.ism.drm.protection.framework.service.group.ApplicationRefreshProtectGroupBackTask;
import com.huawei.ism.drm.protection.framework.service.group.DeleteProtectGroupTask;
import com.huawei.ism.drm.protection.framework.service.group.DeleteProtectObjectTask;
import com.huawei.ism.drm.protection.framework.service.group.ProtectCustomStepHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupExtendUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupHelper;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupQueryExtendServiceImpl;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.framework.service.group.ProtectionTaskExecutor;
import com.huawei.ism.drm.protection.framework.service.group.UpdateDiskProtectedBackTask;
import com.huawei.ism.drm.protection.framework.service.group.UpdatePolicyTemplateBackTask;
import com.huawei.ism.drm.protection.framework.service.group.UpdateProtectGroupInfoTask;
import com.huawei.ism.drm.protection.framework.service.group.UpdateProtectGroupTransaction;
import com.huawei.ism.drm.protection.framework.service.group.UpdateScheduleTask;
import com.huawei.ism.drm.protection.framework.service.group.refinement.CreateProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.template.manager.TemplateFilterManager;
import com.huawei.ism.drm.protection.framework.template.util.PolicyTemplateTools;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLogDetail;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.model.UpdateDiskRequest;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.task.sdk.model.ProtectionTask;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateFilter;
import com.huawei.ism.drm.protection.template.sdk.service.IPolicyTemplateManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.site.util.RemoteSiteMonitorTask;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.impl.DrmStorageServiceImpl;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.ism.drm.task.service.IBackTaskChecker;
import com.huawei.ism.drm.util.ScriptParamsUtils;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.support.TransactionCallback;

@Service(name="com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService", desc="", interfaceClass=IProtectGroupService.class)
public class ProtectGroupServiceImpl
extends ProtectGroupQueryExtendServiceImpl
implements SystemStatusChangedListener {
    private static final Log LOG = LogFactory.getInstance(ProtectGroupServiceImpl.class);
    private static final Object THREAD_LOCK = new Object();
    private static final long PO_MAX_LIMIT = 4500L;
    private static final String STEP_BASE_ARRAY_SYN_MONITOR_ACTION = "BaseArraySynMonitorAction";
    private static boolean started = false;
    private IPolicyTemplateManager policyTemplateManager;
    private ILicenseControl licenseControl;

    public static void setStarted(boolean started) {
        ProtectGroupServiceImpl.started = started;
    }

    public static PolicyTemplate queryPolicyTemplateByProtectGroup(String protectGroupId) {
        PolicyTemplate template = null;
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            transaction = session.beginTransaction();
            Query query = session.createQuery("From ProtectGroup where uuid = :uuid");
            query.setParameter("uuid", (Object)protectGroupId);
            List results = query.list();
            if (VerifyUtil.isEmpty((Collection)results)) {
                throw new HibernateException("protect group is not exists", (Throwable)new LegoCheckedException(2117645L));
            }
            ProtectGroup protectGroup = (ProtectGroup)results.get(0);
            template = protectGroup.getTemplate();
            transaction.commit();
        }
        catch (HibernateException e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                LegoCheckedException exception = e.getCause() instanceof LegoCheckedException ? (LegoCheckedException)((Object)LegoCheckedException.class.cast(e.getCause())) : new LegoCheckedException(0x300001L);
                throw exception;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return template;
    }

    public ILicenseControl getLicenseControl() {
        return this.licenseControl;
    }

    public void setLicenseControl(ILicenseControl licenseControl) {
        this.licenseControl = licenseControl;
    }

    public IPolicyTemplateManager getPolicyTemplateManager() {
        return this.policyTemplateManager;
    }

    public void setPolicyTemplateManager(IPolicyTemplateManager policyTemplateManager) {
        this.policyTemplateManager = policyTemplateManager;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED && !started) {
            this.initialize();
            ProtectGroupServiceImpl.setStarted(true);
        }
    }

    public void initialize() {
        super.initialize();
        this.createIndexForPgLogDetail(null);
    }

    public long createProtectGroup(ProtectGroup protectGroup, boolean createRp) {
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Collection)protectGroup.getPolist())) {
            LOG.error((Object)"Po list is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectObjectQuantity(protectGroup.getPolist().size());
        this.licenseControl.isEnableCreateProtectGroup(protectGroup.getTemplate().getType());
        CreateProtectGroupRefineService instanceService = CreateProtectGroupRefineService.getInstance();
        instanceService.setConfigSyncRateService(this.getConfigSyncRateService());
        instanceService.setRetentionManager(this.getRetentionManager());
        return instanceService.createProtectGroup(protectGroup, createRp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateProtectGroupBasicInfo(ProtectGroup protectGroup, Boolean isFromMachine) {
        ProtectGroupUtil.getInstance().validateProtectGroupObj(protectGroup);
        if (!this.checkGroupNameForUpdate(protectGroup.getUuid(), protectGroup.getName())) {
            LOG.error((Object)"Failed to update protectGroup because of duplicate group name.");
            throw new LegoCheckedException(1073947392L);
        }
        ProtectGroup oldPg = this.getProtectGroupBasicInfo(protectGroup.getUuid(), false);
        if (oldPg == null) {
            LOG.error((Object)"Failed to update protectGroup because the oldPg is null.");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkOptStatus(ProtectGroupHelper.ProtectGroupOpt.MOFIFY.getStatus(), oldPg.getStatus());
        if (!oldPg.isPrimary() && !isFromMachine.booleanValue()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", oldPg.getUuid());
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("pgId", oldPg.getUuid());
            obj.put("uuid", oldPg.getUuid());
            obj.put("name", protectGroup.getName());
            obj.put("description", protectGroup.getDescription());
            try {
                long taskId = ProtectGroupExtendUtil.getInstance().invokeProductSiteMethod(oldPg.getProductSiteId(), "/ws/protectgroups/{protectGroupId}", JSONObject.fromObject(obj).toString(), uriVariables, HttpMethod.PUT);
                RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(oldPg.getProductSiteId(), taskId);
                task.setMonitorInterval(3L);
                BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
                return taskId;
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode != 1073947394L) {
                    LOG.error((Object)"Old pgId: %s", new Object[]{oldPg.getUuid()});
                    ExceptionUtil.rethrowException((Exception)((Object)e), (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters());
                }
                LOG.info((Object)"PG from product site is not existed, so forcibly delete the PG from the disaster site ");
            }
        }
        Object object = THREAD_LOCK;
        synchronized (object) {
            UpdateProtectGroupInfoTask task = new UpdateProtectGroupInfoTask((IProtectGroupBaseService)this, protectGroup);
            if (!oldPg.isPrimary() && isFromMachine.booleanValue()) {
                task.doWork();
                return -1L;
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
    }

    @Override
    public synchronized long deleteProtectGroup(String protectGroupId, Boolean isFromMachine) {
        boolean isUsedProtectGroupByRp;
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOG.error((Object)"Cannot get protectGroup");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DELETE, protectGroup);
        IBackTaskChecker backTaskChecker = BackTaskCheckerManager.getInstance().getBackTaskChecker(Integer.valueOf(protectGroup.getPoType()));
        if (!VerifyUtil.isEmpty((Object)backTaskChecker)) {
            backTaskChecker.checkBackTask(protectGroup);
        }
        if (isUsedProtectGroupByRp = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedProtectGroupByAllRp(protectGroupId)) {
            LOG.error((Object)"ProtectGroup(%s) is used by RecoveryPlan.", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073948160L);
        }
        this.checkProtectGroupReplicaCanBeDeleted(protectGroup);
        if (!protectGroup.isPrimary() && !isFromMachine.booleanValue()) {
            HashMap<String, String> uriVariables = new HashMap<String, String>();
            uriVariables.put("protectGroupId", protectGroup.getUuid());
            try {
                long taskId = ProtectGroupExtendUtil.getInstance().invokeProductSiteMethod(protectGroup.getProductSiteId(), "/ws/protectgroups/{protectGroupId}", null, uriVariables, HttpMethod.DELETE);
                RemoteSiteMonitorTask task = new RemoteSiteMonitorTask(protectGroup.getProductSiteId(), taskId);
                task.setMonitorInterval(3L);
                BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
                return taskId;
            }
            catch (LegoCheckedException e) {
                long errorCode = e.getErrorCode();
                if (errorCode != 1073947394L) {
                    LOG.error((Object)"PgId: %s", new Object[]{protectGroup.getUuid()});
                    ExceptionUtil.rethrowException((Exception)((Object)e), (String)e.getMessage(), (long)e.getErrorCode(), (String[])e.getParameters());
                }
                LOG.info((Object)"PG from product site is not existed, so forcibly delete the PG from the disaster site ");
            }
        }
        DeleteProtectGroupTask task = new DeleteProtectGroupTask((IProtectGroupBaseService)this, protectGroup);
        if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
            task.setTimeout(2147483);
        }
        if (!protectGroup.isPrimary() && isFromMachine.booleanValue()) {
            task.doWork();
            return -1L;
        }
        return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    private void checkProtectGroupReplicaCanBeDeleted(ProtectGroup protectGroup) {
        if (protectGroup.getTemplate().getType() != 46) {
            LOG.info((Object)"ProtectGroup type is not nas airGap anti blackmail.");
            return;
        }
        Set replicaSet = protectGroup.getReplicaList();
        List replicas = replicaSet.stream().filter(e -> e.getType() != 2).collect(Collectors.toList());
        if (replicas.size() == 0) {
            LOG.info((Object)"Has no replica,can be deleted.");
            return;
        }
        if (replicas.size() > 1) {
            LOG.error((Object)"Has more than one replicas,can not be deleted.");
            throw new LegoCheckedException(1073948530L);
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica replica = replicaService.queryProtectGroupReplicaById(((ProtectGroupReplica)replicas.get(0)).getId());
        if (VerifyUtil.isEmpty((Object)replica)) {
            LOG.info((Object)"replica has been deleted.");
            return;
        }
        if (AntiBlackMailConstant.REPLICA_DETECTION_RUNNING_STATUS_SET.contains(replica.getDetectionStatus())) {
            LOG.error((Object)"Has one replica is in detecting, can not be deleted.");
            throw new LegoCheckedException(1073948531L);
        }
        if (replica.getType() == 104 && AntiBlackmailUtil.checkSecureSnapshotCanBeDelete(protectGroup.getPoProviderSN(), replica)) {
            LOG.error((Object)"Has one secure replica in protection period,can not be deleted.");
            throw new LegoCheckedException(1073948532L);
        }
    }

    public synchronized void deleteProtectGroupFromSecondSite(String protectGroupId, Boolean forceDelete) {
        boolean isUsedProtectGroupByRp;
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DELETE, protectGroup);
        if (!forceDelete.booleanValue()) {
            ProtectGroupHelper.getInstance().checkProductPGIsExisted(protectGroup);
        }
        if (isUsedProtectGroupByRp = ((IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class)).isUsedProtectGroupByAllRp(protectGroupId)) {
            LOG.error((Object)"ProtectGroup(%s) is used by RecoveryPlan.", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073948160L);
        }
        DeleteProtectGroupTask task = new DeleteProtectGroupTask((IProtectGroupBaseService)this, protectGroup);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProtectGroupById(String protectGroupId) {
        LOG.info((Object)"Begin to delete protect group with id: %s", new Object[]{protectGroupId});
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            this.createIndexForPgLogDetail(session);
            session.beginTransaction();
            String delLogDetail = "DELETE FROM ti_protectgrouplogdetail t1 USING ti_protectgrouplog t2 WHERE t2.HISTORYLOGID = t1.HISTORYLOGID AND t2.PGID=:pgid";
            String delLog = "DELETE FROM ti_protectgrouplog where PGID=:pgid";
            String delPg = "DELETE FROM ti_protectgroup WHERE PGID=:pgid";
            NativeQuery qDelLogDetail = session.createSQLQuery(delLogDetail);
            qDelLogDetail.setString("pgid", protectGroupId);
            NativeQuery qDelLog = session.createSQLQuery(delLog);
            qDelLog.setString("pgid", protectGroupId);
            NativeQuery qDelPg = session.createSQLQuery(delPg);
            qDelPg.setString("pgid", protectGroupId);
            int dbResult = qDelLogDetail.executeUpdate();
            if (dbResult <= 0) {
                LOG.warn((Object)"Current protect group do not contains any log detail or delete failed, pg id: %s", new Object[]{protectGroupId});
            }
            if ((dbResult = qDelLog.executeUpdate()) <= 0) {
                LOG.warn((Object)"Current protect group do not contains any log detail or delete failed, pg id: %s", new Object[]{protectGroupId});
            }
            if ((dbResult = qDelPg.executeUpdate()) <= 0) {
                LOG.error((Object)"Failed to delete protectGroup by id: %s", new Object[]{protectGroupId});
                throw new LegoCheckedException(-1L);
            }
            session.getTransaction().commit();
        }
        catch (Exception ex) {
            try {
                DBOperationUtil.rollbackSession(session);
                ExceptionUtil.rethrowException((Throwable)ex, (String)"Delete protectGroup by id failed!", (long)-1L, (String[])new String[0], (Log)LOG);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                LOG.info((Object)"End to delete protect group with id: %s", new Object[]{protectGroupId});
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            LOG.info((Object)"End to delete protect group with id: %s", new Object[]{protectGroupId});
        }
        DBOperationUtil.closeSession((Session)session);
        LOG.info((Object)"End to delete protect group with id: %s", new Object[]{protectGroupId});
    }

    @Override
    public long addProtectObjects(String protectGroupId, Set<ProtectObject> protectObjectSet) {
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            LOG.error((Object)"Failed to add ProtectObjects because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        this.checkProtectObjectQuantity(protectObjectSet.size());
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.ADD, protectGroup);
            ProtectGroupHelper.getInstance().checkAddOrRemovePoIsAvailable(protectGroup);
            HashSet logs = new HashSet(protectGroup.getPgHistoryLogs());
            ProtectGroup tempProtectGroup = (ProtectGroup)protectGroup.clone();
            tempProtectGroup.setPolist(new HashSet<ProtectObject>(protectObjectSet));
            tempProtectGroup.setOwnerId(protectObjectSet.iterator().next().getOwnerId());
            this.updateProtectObjectProperties(tempProtectGroup);
            tempProtectGroup.getPolist().addAll(protectGroup.getPolist());
            this.checkProtectObjectsInProtectGroup(tempProtectGroup);
            protectGroup.setPgHistoryLogs(logs);
            ProtectGroupHelper.getInstance().validateProtectGroupParameter(protectGroup, false);
            AddProtectObjectsBackTask task = new AddProtectObjectsBackTask(this, protectGroup, protectObjectSet);
            if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
                task.setTimeout(2147483);
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)"Error to clone ProtectGroup", (Throwable)e);
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, (Throwable)e);
        }
        catch (LegoCheckedException e1) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw e1;
        }
        catch (Throwable e) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public long removeProtectObjects(String protectGroupId, Set<ProtectObject> protectObjectSet) {
        if (VerifyUtil.isEmpty(protectObjectSet)) {
            LOG.error((Object)"Failed to remove ProtectObjects because of invalidity parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.REMOVE, protectGroup);
            ProtectGroupHelper.getInstance().checkAddOrRemovePoIsAvailable(protectGroup);
            DeleteProtectObjectTask task = new DeleteProtectObjectTask((IProtectGroupBaseService)this, protectGroup, protectObjectSet);
            if (PolicyTemplateTools.getInstance().isNotimeout(protectGroup.getTemplate().getType())) {
                task.setTimeout(2147483);
            }
            return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        catch (LegoCheckedException e1) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw e1;
        }
        catch (Throwable e) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw new LegoCheckedException(-1L, ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateProtectGroupStatus(DrmEnumDefine.ProtectGroupStatus status, String ... protectGroupIds) {
        boolean bl;
        String currentPgId = "";
        Session session = null;
        try {
            session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            String[] stringArray = protectGroupIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                PolicyTemplate policyTemplate;
                String protectGroupId;
                currentPgId = protectGroupId = stringArray[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                session.beginTransaction();
                String sql = "UPDATE ti_protectgroup SET STATUS=:pgStatus WHERE PGID=:pgid";
                NativeQuery query = session.createSQLQuery(sql);
                query.setInteger("pgStatus", status.getStatus());
                query.setString("pgid", protectGroupId);
                int updateResult = query.executeUpdate();
                session.getTransaction().commit();
                if (updateResult != 1) {
                    LOG.error((Object)"Update protectGroup status failed!");
                    throw new LegoCheckedException(-1L);
                }
                if (status.getStatus() == DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus()) {
                    this.protectionTaskService.deleteTasks(protectGroupId);
                    this.deleteSyncRateTask(protectGroupId);
                    continue;
                }
                if (status.getStatus() != DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus() || VerifyUtil.isEmpty((Map)(policyTemplate = protectGroup.getTemplate()).getProps())) continue;
                List pgsrps = ProtectGroupUtil.convertToSyncRatePolicy((PolicyTemplate)policyTemplate);
                this.getConfigSyncRateService().updateSyncRateTask(protectGroupId, pgsrps);
                this.getConfigSyncRateService().runAtOnce(protectGroup, pgsrps, false);
            }
            bl = true;
        }
        catch (LegoCheckedException le) {
            try {
                DBOperationUtil.rollbackSession(session);
                LOG.error((Object)"Failed to update status of protectgroup(%s).", new Object[]{le, currentPgId});
                throw le;
                catch (DataAccessException e) {
                    DBOperationUtil.rollbackSession(session);
                    LOG.error((Object)"failed to update status of protectgroup(%s).", new Object[]{e, currentPgId});
                    throw new LegoCheckedException(-1L, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return bl;
    }

    @Override
    public boolean lockProtectGroup(String ... protectGroupIds) {
        String protectGroupId = "";
        try {
            String[] stringArray = protectGroupIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String groupId;
                protectGroupId = groupId = stringArray[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                if (DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus() == protectGroup.getStatus()) {
                    LOG.debug((Object)"No need lock pg:%s", new Object[]{protectGroup.getName()});
                    continue;
                }
                ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.LOCK, protectGroup);
                MessageEvent event = this.constructEnableMessage(protectGroup, 10);
                this.notifyObserverList(event, "before");
                if (DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == protectGroup.getStatus()) continue;
                this.protectionTaskService.pauseTasks(protectGroupId);
                protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.LOCKED.getStatus());
                protectGroup.setLockTime(Long.valueOf(new Date().getTime()));
                ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
                this.notifyObserverList(event, "after");
            }
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"The protectGroup(%s) is failed to lock.", new Object[]{le, protectGroupId});
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("The protectgroup(" + protectGroupId + ") is failed to lock."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        return true;
    }

    @Override
    public boolean unlockProtectGroup(String ... protectGroupIds) {
        String protectGroupId = "";
        try {
            String[] stringArray = protectGroupIds;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String groupId;
                protectGroupId = groupId = stringArray[i];
                ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
                ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UNLOCK, protectGroup);
                MessageEvent event = this.constructEnableMessage(protectGroup, 11);
                this.notifyObserverList(event, "before");
                if (DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus() == protectGroup.getStatus()) continue;
                this.protectionTaskService.resumeTasks(protectGroupId);
                protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
                protectGroup.setLockTime(null);
                ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
                this.notifyObserverList(event, "after");
            }
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"the protectGroup(%s) is failed to unlock.", new Object[]{le, protectGroupId});
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("The protectgroup(" + protectGroupId + ") is failed to unlock."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disableProtectGroup(String protectGroupId) {
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.DISABLE, protectGroup);
            MessageEvent event = this.constructEnableMessage(protectGroup, 8);
            this.notifyObserverList(event, "before");
            this.protectionTaskService.pauseTasks(protectGroupId);
            this.deleteSyncRateTask(protectGroupId);
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.DISABLED.getStatus());
            this.changeProtectionPlanStatus(protectGroup, String.valueOf(DrmEnumDefine.ProtectGroupStatus.DISABLED.getStatus()));
            ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
            this.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"The protectGroup(%s) is failed to disable.", new Object[]{le, protectGroupId});
            this.protectionTaskService.resumeTasks(protectGroupId);
            throw le;
        }
        catch (Exception e) {
            this.protectionTaskService.resumeTasks(protectGroupId);
            ExceptionUtil.rethrowException((Throwable)e, (String)("The protectgroup(" + protectGroupId + ") is failed to disable."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
        return true;
    }

    @Override
    public boolean stopProtectGroup(String protectgroupId, boolean isStopAirGap) {
        ProtectGroup protectGroup = this.getProtectGroupByID(protectgroupId, false);
        if (protectGroup.getStatus() != DrmEnumDefine.ProtectGroupStatus.RUNNING.getStatus()) {
            String pgName = protectGroup.getName();
            LOG.error((Object)"The protect group(name:%s) is not running.", new Object[]{pgName});
            throw new LegoCheckedException(1073948486L, new String[]{pgName});
        }
        boolean stopResult = false;
        Future<?> futureTask = this.findProtectBackTaskByPgId(protectgroupId, isStopAirGap);
        if (!VerifyUtil.isEmpty(futureTask)) {
            stopResult = futureTask.cancel(true);
        }
        LOG.info((Object)"StopProtectGroup id:%s, stopResult:%s", new Object[]{protectgroupId, stopResult});
        return stopResult;
    }

    private Future<?> findProtectBackTaskByPgId(String pgId, boolean isStopAirGap) {
        BackTaskService backTaskService = BackTaskService.getBackTaskService((String)"Protection_Task");
        ConcurrentLinkedQueue taskUnitQueue = backTaskService.getTaskUnitQueue();
        for (BackTaskService.TaskUnit taskUnit : taskUnitQueue) {
            ProtectGroup runningPg;
            ProtectionTaskExecutor protectionTaskExecutor;
            ProtectionTask protectionTask;
            AbstractBackTask task = taskUnit.getTask();
            if (!(task instanceof ProtectionTaskExecutor) || VerifyUtil.isEmpty((Object)(protectionTask = (protectionTaskExecutor = (ProtectionTaskExecutor)task).getTask())) || VerifyUtil.isEmpty((Object)protectionTask.getProtectGroup()) || !(runningPg = protectionTask.getProtectGroup()).getUuid().equals(pgId)) continue;
            if (isStopAirGap) {
                LOG.info((Object)"Set the thread communication variable to stop the air gap protection group{%s}", new Object[]{runningPg.getName()});
                protectionTaskExecutor.getActionContext().setShouldTerminate(true);
            }
            LOG.info((Object)"Success find ProtectBack Task for PgId:%s", new Object[]{pgId});
            return taskUnit.getTaskFuture();
        }
        LOG.info((Object)"Not find ProtectBack Task for PgId:%s", new Object[]{pgId});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enableProtectGroup(String protectGroupId) {
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.ENABLE, protectGroup);
            MessageEvent event = this.constructEnableMessage(protectGroup, 9);
            this.notifyObserverList(event, "before");
            this.protectionTaskService.resumeTasks(protectGroupId);
            this.resumeSyncRateTask(protectGroup);
            protectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus());
            this.changeProtectionPlanStatus(protectGroup, String.valueOf(DrmEnumDefine.ProtectGroupStatus.NORMAL.getStatus()));
            ProtectGroupHelper.getInstance().resetProtectGroupStatus(protectGroup);
            this.notifyObserverList(event, "after");
        }
        catch (LegoCheckedException le) {
            LOG.error((Object)"The protectgroup(%s) is failed to enable.", new Object[]{le, protectGroupId});
            throw le;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("the protectgroup(" + protectGroupId + ") is failed to enable."), (long)-1L, (String[])new String[0], (Log)LOG);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
        return true;
    }

    public long updateProtectGroupTemplate(String protectGroupId, PolicyTemplate policyTemplate) {
        if (protectGroupId == null || policyTemplate == null) {
            LOG.error((Object)"Param is error.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupBasicInfo(protectGroupId, false);
        if (protectGroup == null) {
            LOG.error((Object)"Cannot get protectGroup");
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UPDATE_TEMPLATE, protectGroup);
        protectGroup.setTemplate(policyTemplate);
        this.getRetentionManager().checkRetentionStrategy(protectGroup);
        UpdatePolicyTemplateBackTask task = new UpdatePolicyTemplateBackTask((IProtectGroupBaseService)this, protectGroup, policyTemplate);
        return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    @Override
    public long updateProtectGroupTemplate(String protectGroupId, Map<String, String> policyTemplateProps) {
        if (protectGroupId == null || VerifyUtil.isEmpty(policyTemplateProps)) {
            LOG.error((Object)"Param is error: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate template = ProtectGroupServiceImpl.queryPolicyTemplateByProtectGroup(protectGroupId);
        Map props = template.getProps();
        props.putAll(policyTemplateProps);
        ((IPolicyTemplateManager)ServiceLocator.getInstance().getService(IPolicyTemplateManager.class)).filterSensitiveParam(template);
        return this.updateProtectGroupTemplate(protectGroupId, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProtectObjectProps(String protectGroupId, String protectObjectId, Map<String, String> protectObjectProps) {
        if (VerifyUtil.isEmpty((String)protectGroupId) || VerifyUtil.isEmpty((String)protectObjectId) || VerifyUtil.isEmpty(protectObjectProps)) {
            LOG.error((Object)"Parameter is error");
            throw new LegoCheckedException(1073947393L);
        }
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId);
            ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UPDATE_PROTECTOBJECT_PROPS, protectGroup);
            ProtectObject protectObject = null;
            for (ProtectObject tempProtectObject : protectGroup.getPolist()) {
                if (!tempProtectObject.getUuid().equals(protectObjectId)) continue;
                protectObject = tempProtectObject;
            }
            if (protectObject == null) {
                LOG.error((Object)"ProtectObject(%s) not exists", new Object[]{protectObjectId});
                throw new LegoCheckedException(1073947394L);
            }
            IProtectObjectBaseProvider poProvider = this.getProtectObjectProvider(protectObject.getPoType());
            poProvider.updateProtectObjectProps(protectObject, protectObjectProps);
            UpdateProtectGroupTransaction callBack = new UpdateProtectGroupTransaction((IProtectGroupBaseService)this, protectGroup, null);
            this.getBaseDao().getTransactionTemplate().execute((TransactionCallback)callBack);
        }
        finally {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long refreshProtectGroup(String protectGroupId) {
        boolean lockFlag = ProtectionJobUtil.getInstance().getLockPg(protectGroupId);
        if (!lockFlag) {
            LOG.error((Object)"The pg is locked: %s", new Object[]{protectGroupId});
            throw new LegoCheckedException(102401L);
        }
        try {
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            Object object = THREAD_LOCK;
            synchronized (object) {
                ProtectGroupHelper.getInstance().checkProtectGroupRefresh(protectGroup);
                ProtectGroupHelper.getInstance().checkPgOperationByRecoveryPlanStatus(protectGroup);
                ApplicationRefreshProtectGroupBackTask task = new ApplicationRefreshProtectGroupBackTask(this, protectGroup);
                return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
            }
        }
        catch (LegoCheckedException le) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            throw le;
        }
        catch (Throwable e) {
            ProtectionJobUtil.getInstance().releaseLockPg(protectGroupId);
            ExceptionUtil.rethrowException((Throwable)e, (String)("refresh error, protectGroupId: " + protectGroupId), (long)-1L, (String[])new String[0], (Log)LOG);
            return -1L;
        }
    }

    @Override
    public List<ProtectGroupLogDetail> queryRunningHistoryLog(String s) {
        return null;
    }

    public void updateProtectObjectProperties(ProtectGroup protectGroup) {
        IProtectObjectBaseProvider poProvider = this.getProtectObjectProvider(protectGroup.getPoType());
        for (ProtectObject protectObject : protectGroup.getPolist()) {
            protectObject.setProtectGroup(protectGroup);
            poProvider.updateProtectObjectProps(protectObject, protectObject.getProps());
        }
        poProvider.buildProtectObjects(protectGroup);
        try {
            ArrayList protectObjectList = new ArrayList(protectGroup.getPolist());
            ProtectGroupHelper.getInstance().deleteProtectObjectStorageInfo(protectObjectList);
        }
        catch (Exception e) {
            LOG.error((Object)"Delete temp po StorageInfo error. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public void deleteProtectionTask(String protectGroupId) {
        this.protectionTaskService.deleteTaskAndJob(protectGroupId);
    }

    public void checkPolicyProps(int pgAppType, PolicyTemplate policyTemplate) {
        if (policyTemplate == null) {
            LOG.error((Object)"Policy template is null");
            throw new LegoCheckedException(1073947393L);
        }
        PolicyTemplate policyTemplateFromDB = this.getPolicyTemplateManager().getPtByUuid(policyTemplate.getUuid());
        if (policyTemplateFromDB == null) {
            LOG.error((Object)"PolicyTemplate[%s] is not exists!", new Object[]{policyTemplate.getUuid()});
            throw new LegoCheckedException(1073947394L, "PolicyTemplate is not exists!");
        }
        IPolicyTemplateFilter filter = TemplateFilterManager.getInstance().getTemplateFilterByType(policyTemplate.getType());
        if (!filter.checkPolicyTemplate(policyTemplate)) {
            return;
        }
        IProtectObjectBaseProvider poProvider = this.getProtectObjectProvider(pgAppType);
        policyTemplate.setType(policyTemplateFromDB.getType());
        poProvider.checkPolicyProps(policyTemplate);
    }

    public void invalidProtectGroupReplica(String pgId, List<String> replicaIds) {
        if (VerifyUtil.isEmpty((String)pgId) || VerifyUtil.isEmpty(replicaIds)) {
            LOG.error((Object)"The parameters is empty!");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroupHelper.getInstance().invalidProtectGroupReplica(pgId, replicaIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexForPgLogDetail(Session session) {
        LOG.info((Object)"Create index TI_PROTECTGROUPLOGDETAIL_INDEX_RELATEDDETAILID");
        boolean isNewSession = false;
        try {
            if (session == null) {
                session = this.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                isNewSession = true;
            }
            Transaction transaction = session.beginTransaction();
            String querySql = "SELECT 1 FROM pg_class c LEFT JOIN pg_namespace n ON n.oid = c.relnamespace WHERE n.nspname = 'PUBLIC' and c.relname  = 'ti_protectgrouplogdetail_index_relateddetailid'";
            NativeQuery alterQuery = session.createSQLQuery(querySql);
            List consList = alterQuery.list();
            if (consList != null && !consList.isEmpty()) {
                LOG.info((Object)"Index TI_PROTECTGROUPLOGDETAIL_INDEX_RELATEDDETAILID has been exist.");
                transaction.commit();
                return;
            }
            String createIndexSql = "CREATE INDEX TI_PROTECTGROUPLOGDETAIL_INDEX_RELATEDDETAILID ON TI_PROTECTGROUPLOGDETAIL (RELATEDDETAILID)";
            NativeQuery cIndexQuery = session.createSQLQuery(createIndexSql);
            cIndexQuery.executeUpdate();
            transaction.commit();
        }
        catch (Exception ex) {
            DBOperationUtil.rollbackSession((Session)session);
            LOG.error((Object)"Failed to create index for TI_PROTECTGROUPLOGDETAIL!: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        finally {
            if (isNewSession) {
                DBOperationUtil.closeSession((Session)session);
            }
        }
    }

    public void deleteSyncRateTask(String pgId) {
        this.getConfigSyncRateService().deleteSyncRateTask(pgId);
    }

    public void deleteProtectGroupHistory(String protectGroupId) {
        List logs = this.queryProtectGroupLogs(protectGroupId, 1, "starttime", false);
        if (VerifyUtil.isEmpty((Collection)logs)) {
            return;
        }
        try {
            for (ProtectGroupLog log : logs) {
                List details = this.queryHistoryLogDetail(String.valueOf(log.getHistoryLogId()));
                for (ProtectGroupLogDetail detail : details) {
                    this.getBaseDao().getHibernateTemplate().delete((Object)detail);
                }
                this.getBaseDao().getHibernateTemplate().delete((Object)log);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"DeleteProtectGroupHistory error, cause by %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    public boolean checkPublicParamsChanged(String protectGroupId, Map<String, String> publicParams) {
        PolicyTemplate template = ProtectGroupServiceImpl.queryPolicyTemplateByProtectGroup(protectGroupId);
        JSONObject newPublicParams = JSONObject.fromObject(publicParams);
        JSONObject oldPublicParams = JSONObject.fromObject(template.getProps().get("publicParam"));
        return ProtectCustomStepHelper.isParamChanged((JSONObject)newPublicParams, (JSONObject)oldPublicParams);
    }

    public boolean updateDiskProtect(String protectGroupId, UpdateDiskRequest updateDiskRequest) {
        String storagePoolMapping = updateDiskRequest.getStoragePoolMapping();
        JSONArray storagePoolMappingArray = JSONArray.fromObject((Object)storagePoolMapping);
        List storagePairs = JSONArray.toCollection((JSONArray)storagePoolMappingArray, StoragePair.class);
        DrmStorageServiceImpl drmStorageService = (DrmStorageServiceImpl)((Object)ServiceLocator.getInstance().getService(DrmStorageServiceImpl.class));
        try {
            for (StoragePair storagePair : storagePairs) {
                List<StoragePool> srcPools = drmStorageService.queryStoragePoolsBySn(storagePair.getSrcDevSN());
                List<StoragePool> tgtPools = drmStorageService.queryStoragePoolsBySn(storagePair.getTgtDevSN());
                LOG.debug((Object)"Storage pools: %s, is secDev: %s", new Object[]{srcPools, true});
                StoragePair.checkStoragePool(srcPools, (StoragePair)storagePair, (boolean)true);
                LOG.debug((Object)"Storage pools: %s, is secDev: %s", new Object[]{tgtPools, false});
                StoragePair.checkStoragePool(tgtPools, (StoragePair)storagePair, (boolean)false);
                storagePair.checkPair();
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Some poolId invalid.");
            throw e;
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, true);
        UpdateDiskProtectedBackTask task = new UpdateDiskProtectedBackTask(storagePairs, protectGroup);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsAntiBlackmailPg(String devSn) {
        boolean bl;
        Session session;
        block5: {
            String sql = "SELECT count(*) FROM ti_protectgroup a INNER JOIN ti_policytemplate b ON a.ptid = b.ptid WHERE b.type in (:types) AND a.pgprovidersn=:devsn";
            session = null;
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            NativeQuery sqlQuery = session.createSQLQuery(sql);
            sqlQuery.setParameterList("types", (Collection)AntiBlackMailConstant.ANTI_BLACKMAIL_TEMPLATE);
            sqlQuery.setParameter("devsn", (Object)devSn);
            Object result = sqlQuery.uniqueResult();
            if (!(result instanceof BigInteger)) break block5;
            boolean bl2 = ((BigInteger)result).intValue() > 0;
            DBOperationUtil.closeSession((Session)session);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            boolean bl3;
            try {
                LOG.error((Object)"Query count of antiBlackmail protectGroup error, error msg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                bl3 = true;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return bl3;
        }
        DBOperationUtil.closeSession((Session)session);
        return bl;
    }

    public void enableSchedule(String protectGroupId, String scheduleId) {
        Schedule schedule = this.getSchedule(protectGroupId, scheduleId);
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(schedule.getProtectedType()) || PolicyTemplateType.KUBE_BACKUP_TYPES.contains(schedule.getProtectedType())) {
            this.disableAndEnableSchedule(schedule, true);
            return;
        }
        if (schedule.getScheduleMode() == 0 && schedule.getPeriodType() == 5) {
            LOG.info((Object)"Schedule is seconds. disable snapshotSchedule.");
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            SnapshotScheduleUtil.enable(protectGroup, schedule, true);
            schedule.setEnable(Boolean.valueOf(true));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)schedule);
            return;
        }
        this.protectionTaskService.enableTask(protectGroupId, scheduleId);
    }

    public void disableSchedule(String protectGroupId, String scheduleId) {
        Schedule schedule = this.getSchedule(protectGroupId, scheduleId);
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(schedule.getProtectedType()) || PolicyTemplateType.KUBE_BACKUP_TYPES.contains(schedule.getProtectedType()) || PolicyTemplateType.KUBE_HYPER_METRO_TYPES.contains(schedule.getProtectedType())) {
            this.disableAndEnableSchedule(schedule, false);
            return;
        }
        if (schedule.getScheduleMode() == 0 && schedule.getPeriodType() == 5) {
            LOG.info((Object)"Schedule is seconds. disable snapshotSchedule.");
            ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
            SnapshotScheduleUtil.enable(protectGroup, schedule, false);
            schedule.setEnable(Boolean.valueOf(false));
            CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)schedule);
            return;
        }
        this.protectionTaskService.disableTask(protectGroupId, scheduleId);
    }

    private void disableAndEnableSchedule(Schedule schedule, boolean isEnable) {
        schedule.setEnable(Boolean.valueOf(isEnable));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)schedule);
    }

    public void disableScheduleStatus(String protectGroupId, String scheduleId) {
        Schedule schedule = this.getSchedule(protectGroupId, scheduleId);
        schedule.setEnable(Boolean.valueOf(false));
        CommonDAOLocator.getBaseDao().getHibernateTemplate().update((Object)schedule);
    }

    private Schedule getSchedule(String protectGroupId, String scheduleId) {
        List scheduleList = this.getAllSchedule(protectGroupId);
        Schedule schedule = scheduleList.stream().filter(schedule1 -> schedule1.getScheduleId().equals(scheduleId)).findFirst().orElse(null);
        if (null == schedule) {
            String errorMsg = String.format(Locale.ROOT, "Schedule[%s] does not exists", scheduleId);
            LOG.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        return schedule;
    }

    public void addSchedule(String protectGroupId, Schedule schedule) {
        ProtectGroup protectGroup = this.checkAndGetProtectGroup(protectGroupId, schedule);
        Set scheduleSet = protectGroup.getTemplate().getSchedules();
        for (Schedule schedule1 : scheduleSet) {
            ScriptParamsUtils.convertUserDefinedParams((Schedule)schedule1);
            if (schedule1.getProtectLocation() != schedule.getProtectLocation() || schedule1.getProtectedType() != schedule.getProtectedType()) continue;
            String errMsg = "The schedule exists in the protection group[{0}] for the protect location[{1}]";
            LOG.error((Object)MessageFormatUtil.format((String)errMsg, (Object[])new Object[]{protectGroupId, schedule.getProtectLocation()}));
            throw new LegoCheckedException(1073947393L);
        }
        AddScheduleTask task = new AddScheduleTask(this, protectGroup, schedule);
        BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public void addSchedules(String protectGroupId, Set<Schedule> schedules) {
        ProtectGroup protectGroup = this.checkAndGetProtectGroup(protectGroupId, schedules.iterator().next());
        for (Schedule schedule : schedules) {
            AddScheduleTask task = new AddScheduleTask(this, protectGroup, schedule, "protectedGroup_schedule_update_operateName");
            BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
    }

    public long runSchedule(String protectGroupId, String scheduleId, Map<String, Object> parameter) {
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.MANUAL_EXECUTE, protectGroup);
        Schedule runSchedule = protectGroup.getTemplate().getSchedules().stream().filter(schedule1 -> schedule1.getScheduleId().equals(scheduleId)).findFirst().orElse(null);
        if (null == runSchedule) {
            String errorMsg = "schedule is not exists, protectGroupId is {0} and scheduleId is {1}";
            LOG.error((Object)MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{protectGroupId, scheduleId}));
            throw new LegoCheckedException(1073947393L);
        }
        if (runSchedule.getPeriodType() == 5 && protectGroup.getTemplate().getType() != 55) {
            String errorMsg = "second snapshot schedule is not supported manual execute, protectGroupId is {0} and scheduleId is {1}";
            LOG.error((Object)MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{protectGroupId, scheduleId}));
            throw new LegoCheckedException(1073948251L);
        }
        if (VerifyUtil.isEmpty(parameter)) {
            ProtectGroupHelper.getInstance();
            ProtectGroupHelper.checkTimeAllowExecute((ProtectGroup)protectGroup);
        } else {
            Integer procType = (Integer)parameter.get("SYNC_EXECUTE_IN_RECOVERY_PROCESS");
            if (VerifyUtil.isEmpty((Object)procType) || procType.intValue() != DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue()) {
                ProtectGroupHelper.getInstance();
                ProtectGroupHelper.checkTimeAllowExecute((ProtectGroup)protectGroup);
            }
        }
        return this.protectionTaskService.runTask(protectGroupId, scheduleId, parameter);
    }

    public long updateSchedule(String protectGroupId, Schedule schedule) {
        ProtectGroup protectGroup = this.checkAndGetProtectGroup(protectGroupId, schedule);
        List scheduleList = this.getAllSchedule(protectGroupId);
        List filterList = scheduleList.stream().filter(schedule1 -> schedule1.getScheduleId().equals(schedule.getScheduleId())).collect(Collectors.toList());
        if (VerifyUtil.isEmpty(filterList)) {
            String errorMsg = String.format(Locale.ROOT, "Schedule[%s] does not exists", schedule.getScheduleId());
            LOG.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        Schedule oldSchedule = (Schedule)filterList.stream().findFirst().get();
        if (oldSchedule.getProtectedType() != schedule.getProtectedType()) {
            String errorMsg = "Cannot modify protect type, old protect type is %s and new protect type is %s.";
            errorMsg = String.format(errorMsg, oldSchedule.getProtectedType(), schedule.getProtectedType());
            LOG.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        ScriptParamsUtils.convertUserDefinedParams((Schedule)schedule);
        UpdateScheduleTask task = new UpdateScheduleTask(this, protectGroup, schedule, oldSchedule);
        return BackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    private ProtectGroup checkAndGetProtectGroup(String protectGroupId, Schedule schedule) {
        if (schedule == null) {
            LOG.error((Object)"Schedule is null");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        ProtectGroupHelper.getInstance().checkProtectGroupOpt(ProtectGroupHelper.ProtectGroupOpt.UPDATE_TEMPLATE, protectGroup);
        return protectGroup;
    }

    @Override
    public void offlineTransfer(String protectGroupId, String scheduleId, int status) {
        Schedule scheduleInDb = this.getSchedule(protectGroupId, scheduleId);
        if (ScheduleProtectedType.CLOUD_BACKUP.getValue() != scheduleInDb.getProtectedType()) {
            String errorMsg = String.format("The protection type[%s] is not cloud backup and is not allowed.", scheduleInDb.getProtectedType());
            LOG.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
    }

    public void deleteProtectGroupReplica(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            LOG.error((Object)"Pg id is empty.");
            return;
        }
        List replicaList = ((IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class)).queryProtectGroupReplicaByGroup(protectGroupId, "TIME_STAMP", false);
        if (!VerifyUtil.isEmpty((Collection)replicaList)) {
            LOG.info((Object)"Deleting pg replica: %s", new Object[]{String.valueOf(replicaList.size())});
            replicaList.forEach(arg_0 -> ((HibernateTemplate)CommonDAOLocator.getBaseDao().getHibernateTemplate()).delete(arg_0));
        }
    }

    public List<StorageObjectBo> getUseHypermetroStorage(String protectGroupId) {
        if (VerifyUtil.isEmpty((String)protectGroupId)) {
            LOG.error((Object)"getUseHyperMetroStorage failed, protectGroupId is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup protectGroup = this.getProtectGroupByID(protectGroupId, false);
        if (VerifyUtil.isEmpty((Object)protectGroup)) {
            LOG.error((Object)("ProtectGroup(" + protectGroupId + ") not exist"), 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        List protectObjectStorageInfoList = protectGroup.distinctStorageInfo();
        if (VerifyUtil.isEmpty((Collection)protectObjectStorageInfoList)) {
            LOG.error((Object)"Protect object storage is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        ProtectObjectStorageInfo posi = (ProtectObjectStorageInfo)protectObjectStorageInfoList.stream().findAny().get();
        if (VerifyUtil.isEmpty((Object)posi.getResourceType())) {
            LOG.error((Object)("posi.getResourceType() is empty! DeviceName : " + posi.getDeviceName()));
            throw new LegoCheckedException(1073947393L);
        }
        if (posi.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.LUN.getValue()) {
            return this.queryLunHyperMetroStorageInfo(posi);
        }
        if (posi.getResourceType().intValue() == DrmEnumDefine.ResourceTypeE.NAS.getValue()) {
            String deviceSn = posi.getResourceProviderSN();
            String vStorePairId = (String)protectGroup.getProps().get("PROP_KEY_VSTORE_PAIR_ID");
            return this.queryNasHyperMetroStorageInfo(deviceSn, vStorePairId);
        }
        LOG.error((Object)("pg use storage resource type illegal, type is: " + posi.getResourceType()));
        throw new LegoCheckedException(1073947393L);
    }

    private List<StorageObjectBo> queryLunHyperMetroStorageInfo(ProtectObjectStorageInfo posi) {
        String lunWWN = posi.getLunWWN();
        if (VerifyUtil.isEmpty((String)lunWWN)) {
            LOG.error((Object)"lunWWN is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWWN});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            LOG.error((Object)("method[getSrcDeviceSN()]. Resources is empty or the size is not two! resources size:" + resources), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        StorageObjectBo srcBo = this.constructStorageObjectBo(lunWWN, ((StorageResource)resources.get(0)).getDevSn());
        StorageObjectBo remoteBo = this.constructStorageObjectBo(lunWWN, ((StorageResource)resources.get(1)).getDevSn());
        ArrayList<StorageObjectBo> storage = new ArrayList<StorageObjectBo>();
        storage.add(srcBo);
        storage.add(remoteBo);
        return storage;
    }

    private StorageObjectBo constructStorageObjectBo(String lunWWN, String devSn) {
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        StorageNE storageArray = storageService.getStorageBySn(devSn, null);
        if (VerifyUtil.isEmpty((Object)storageArray)) {
            LOG.error((Object)("StorageNE is empty, devSn is: " + devSn));
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<String> wwns = new ArrayList<String>();
        wwns.add(lunWWN);
        List pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(null, wwns, null, devSn, true);
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            LOG.error((Object)("HyperMetroPair List is emtpty." + wwns));
            throw new LegoCheckedException(1073947393L);
        }
        HyperMetroPair pair = (HyperMetroPair)CommonUtil.getFirstElement((Collection)pairList);
        int priorityStationType = 0;
        if (!pair.getIsPrimary().booleanValue()) {
            priorityStationType = 1;
        }
        StorageObjectBo bo = new StorageObjectBo();
        bo.setDevSn(devSn);
        bo.setName(storageArray.getName());
        bo.setPriorityStationType(priorityStationType);
        return bo;
    }

    private List<StorageObjectBo> queryNasHyperMetroStorageInfo(String deviceSn, String vStorePairId) {
        if (VerifyUtil.isEmpty((String)deviceSn) || VerifyUtil.isEmpty((String)vStorePairId)) {
            LOG.error((Object)("deviceSn or vStoreId is emtpty, vStorePairId: " + vStorePairId + " deviceSn: " + deviceSn));
            throw new LegoCheckedException(1073947393L);
        }
        VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(deviceSn, vStorePairId);
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            LOG.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByDeviceSn(deviceSn);
        List vstoreHyperMetroPairs = StorageResourceServiceRouter.getInstance().getVstoreHyperPair(site.getServerUuid(), vstoreHyperMetroPair);
        HashSet<String> devSNSet = new HashSet<String>();
        devSNSet.add(deviceSn);
        for (VstoreHyperMetroPair pair : vstoreHyperMetroPairs) {
            ManagedObject managedObject = pair.getParentMo();
            if (!(managedObject instanceof HvsUnit)) continue;
            devSNSet.add(((HvsUnit)managedObject).getDevSn());
        }
        if (devSNSet.size() != 2) {
            LOG.error((Object)("method[queryNasHyperMetroStorageInfo()]. DevSNSet is empty or the size is not two! devSNSet size:" + devSNSet), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        String active = vstoreHyperMetroPair.getActiveOrPassive();
        if (VerifyUtil.isEmpty((String)active)) {
            HyperMetroDomain hyperMetroDomain = ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).getHyperMetroDomainById(vstoreHyperMetroPair.getDomainId(), false);
            active = hyperMetroDomain.getServiceStatus();
        }
        return this.constructNasStorageObjectBo(deviceSn, active, devSNSet);
    }

    private List<StorageObjectBo> constructNasStorageObjectBo(String deviceSn, String activeOrPassive, Set<String> devSNSet) {
        HashSet<String> types = new HashSet<String>();
        types.add(String.valueOf(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue()));
        types.add(String.valueOf(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue()));
        if (!types.contains(activeOrPassive)) {
            LOG.error((Object)("activeOrPassive is error, activeOrPassive: " + activeOrPassive));
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<StorageObjectBo> list = new ArrayList<StorageObjectBo>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        for (String devSn : devSNSet) {
            StorageNE storageArray = storageService.getStorageBySn(devSn, null);
            if (VerifyUtil.isEmpty((Object)storageArray)) {
                LOG.error((Object)("StorageNE is empty, devSn is: " + devSn));
                throw new LegoCheckedException(1073947393L);
            }
            StorageObjectBo bo = new StorageObjectBo();
            bo.setDevSn(devSn);
            bo.setName(storageArray.getName());
            int srcVstorePairStatus = Integer.parseInt(activeOrPassive);
            if (deviceSn.equals(devSn)) {
                bo.setPriorityStationType(srcVstorePairStatus);
            } else if (XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue() == srcVstorePairStatus) {
                bo.setPriorityStationType(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.PASSIVE.getValue());
            } else {
                bo.setPriorityStationType(XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue());
            }
            list.add(bo);
        }
        return list;
    }

    private void changeProtectionPlanStatus(ProtectGroup protectGroup, String status) {
        IKubeHandler iKubeHandler;
        if (PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType())) {
            iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
            iKubeHandler.changeProtectionPlan(protectGroup.getPoProviderSN(), protectGroup);
        }
        if (PolicyTemplateType.KUBE_BACKUP_TYPES.contains(protectGroup.getTemplate().getType())) {
            iKubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
            iKubeHandler.changeBackUpInstance(protectGroup.getPoProviderSN(), protectGroup);
        }
    }

    public void saveProtectGroup(ProtectGroup protectGroup) {
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)protectGroup);
    }
}

