/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.group.subscriber;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.protection.framework.service.group.subscriber.AbstractExecuteSuccessSubscriber;
import com.huawei.ism.drm.protection.framework.service.task.CloneReplicaTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TimeUtil;
import java.util.List;
import java.util.Map;

public class MountReplicaSubscriber
extends AbstractExecuteSuccessSubscriber {
    private static final Log LOGGER = LogFactory.getInstance(MountReplicaSubscriber.class);

    public MountReplicaSubscriber(IMessageCenter messageCenter) {
        messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    @Override
    protected void handleProtectGroup(ProtectGroup protectGroup, Map<String, Object> parameter) {
        String mountCfgString = (String)protectGroup.getTemplate().getProps().get("AUTOMOUNTCONFIGS");
        JSONObject jsonObject = JSONObject.fromObject((Object)mountCfgString);
        boolean enabled = jsonObject.getBoolean("enabled");
        if (enabled) {
            LOGGER.info((Object)"Auto mounting replica is configured");
            ProtectGroupReplica toBeMountReplica = protectGroup.getLatestRepica();
            if (null == toBeMountReplica || !toBeMountReplica.isSanSnapshotReplica()) {
                return;
            }
            String jsonString = jsonObject.getString("mountConfigs");
            JSONArray array = JSONArray.fromObject((Object)jsonString);
            List mountCfgs = JSONArray.toCollection((JSONArray)array, MountConfiguration.class);
            this.findMountConfiguration(protectGroup, mountCfgs, toBeMountReplica);
        }
    }

    private void findMountConfiguration(ProtectGroup protectGroup, List<MountConfiguration> mountCfgs, ProtectGroupReplica replica) {
        String timeStr = TimeUtil.toLocalString((long)NumberUtil.convertToLong((Object)replica.getTimeStamp()));
        String[] array = timeStr.split(" ");
        if (array.length < 2) {
            return;
        }
        String hhmm = array[1].substring(0, array[1].lastIndexOf(":"));
        for (MountConfiguration mountcfg : mountCfgs) {
            String sourceTime = mountcfg.getStartTime() + "-" + mountcfg.getEndTime();
            if (!TimeUtil.isInTime((String)sourceTime, (String)hhmm)) continue;
            this.handleMountReplicaMessage(protectGroup, mountcfg);
        }
    }

    private void handleMountReplicaMessage(ProtectGroup protectGroup, MountConfiguration mountCfg) {
        User operator = RecoveryTaskUtil.getAdminUser();
        mountCfg.setName("AutoMount_" + protectGroup.getName() + "_" + System.currentTimeMillis());
        mountCfg.setStartTime(null);
        mountCfg.setEndTime(null);
        CloneReplicaTask task = new CloneReplicaTask(operator, protectGroup.getLatestRepica(), true, mountCfg);
        MountBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }
}

