/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.replica;

import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.framework.service.group.refinement.QueryProtectGroupRefineService;
import com.huawei.ism.drm.protection.framework.service.replica.AbstractReplicaServiceImpl;
import com.huawei.ism.drm.protection.framework.service.task.CloneReplicaTask;
import com.huawei.ism.drm.protection.framework.template.factory.ReplicaBuilderFactory;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.service.IReplicaBuilder;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@Service(name="com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService", desc="", interfaceClass=IReplicaBaseService.class)
public class ReplicaBaseServiceImpl
extends AbstractReplicaServiceImpl
implements IReplicaBaseService {
    private static final Log LOGGER = LogFactory.getInstance(ReplicaBaseServiceImpl.class);
    private final ReplicaBuilderFactory replicaBuilderFactory = ReplicaBuilderFactory.getInstance();

    protected ProtectGroupReplica getProtectGroupReplica(String protectGroupId, String replicaId) {
        ProtectGroupReplica srcReplica = this.queryProtectGroupReplicaById(replicaId);
        if (VerifyUtil.isEmpty((Object)srcReplica)) {
            srcReplica = SnapshotScheduleUtil.getProtectGroupReplica(replicaId);
        }
        if (srcReplica == null) {
            String errorMsg = "The replica[%s] of protect group[%s] is not exists!";
            errorMsg = String.format(Locale.ROOT, errorMsg, replicaId, protectGroupId);
            LOGGER.error((Object)errorMsg);
            throw new LegoCheckedException(1073947394L, errorMsg);
        }
        if (srcReplica.getPg() == null || !protectGroupId.equals(srcReplica.getPg().getUuid())) {
            String errorMsg = "The input protect group Id[%s] parameter is not the group id in replica[%s]";
            errorMsg = String.format(Locale.ROOT, errorMsg, protectGroupId, replicaId);
            LOGGER.error((Object)errorMsg);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        return srcReplica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtectGroupReplica queryProtectGroupReplicaById(String replicaId) {
        Session session;
        ProtectGroupReplica replica;
        block6: {
            replica = null;
            if (VerifyUtil.isEmpty((String)replicaId)) {
                LOGGER.error((Object)"Getting ProtectGroupReplica is error because groupId is empty");
                return replica;
            }
            replica = SnapshotScheduleUtil.getProtectGroupReplica(replicaId);
            if (replica != null) {
                return replica;
            }
            session = null;
            try {
                Iterator iterator;
                session = this.baseDao.getHibernateTemplate().getSessionFactory().openSession();
                Criteria criteria = session.createCriteria(ProtectGroupReplica.class);
                criteria.add((Criterion)Restrictions.eq((String)"id", (Object)replicaId));
                List queryResult = criteria.list();
                if (VerifyUtil.isEmpty((Collection)queryResult) || !(iterator = queryResult.iterator()).hasNext()) break block6;
                ProtectGroupReplica pgReplica = (ProtectGroupReplica)iterator.next();
                Hibernate.initialize((Object)pgReplica.getReplicas());
                replica = pgReplica;
            }
            catch (Exception e) {
                try {
                    LOGGER.error((Object)("Failed to query replica!" + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        return replica;
    }

    public void cloneReplica(User user, String protectGroupId, String replicaId, boolean isNeedMount, String mountConfigs) {
        MountConfiguration mountConfiguration = null;
        if (isNeedMount) {
            mountConfiguration = (MountConfiguration)JSONObject.toBean((String)mountConfigs, MountConfiguration.class);
        }
        ProtectGroupReplica srcReplica = this.getProtectGroupReplica(protectGroupId, replicaId);
        this.verifyReplica(srcReplica);
        CloneReplicaTask task = new CloneReplicaTask(user, srcReplica, isNeedMount, mountConfiguration);
        MountBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
    }

    public Integer querySecondProtectGroupReplicaCount(String protectGroupId, Schedule schedule, Long startTime, Long endTime) {
        LOGGER.info((Object)"Start querySecondProtectGroupReplica for:%s", new Object[]{protectGroupId});
        Integer totalCount = 0;
        ProtectGroup protectGroup = QueryProtectGroupRefineService.getInstance().getProtectGroupByID(protectGroupId, true);
        IReplicaBuilder builder = this.replicaBuilderFactory.getTemplateByType(protectGroup.getTemplate().getType());
        if (!SnapshotScheduleUtil.isExistsSecondSchedule(schedule)) {
            return totalCount;
        }
        Map devSns = builder.getProtectedDeviceSn(protectGroup);
        String devSn = (String)devSns.get(schedule.getProtectLocation());
        IStorageSnapshotScheduleManager scheduleManager = StorageSnapshotScheduleManagerProxy.getInstance().getStorageSnapshotMgrByDevId(devSn, schedule.getProtectedType());
        HashMap<String, String> conditions = new HashMap<String, String>();
        conditions.put("startTime", String.valueOf(startTime));
        conditions.put("endTime", String.valueOf(endTime));
        totalCount = scheduleManager.getProtectGroupReplicaCount(protectGroup, devSn, conditions);
        return totalCount;
    }
}

