/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.framework.service.task;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.cbb.base.task.BackTaskUtil;
import com.huawei.ism.drm.license.sdk.ILicenseControl;
import com.huawei.ism.drm.protection.framework.service.replica.factory.IReplicaFactory;
import com.huawei.ism.drm.protection.framework.service.replica.factory.ReplicaFactoryManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.task.CreateMountReplicaPlanTask;
import com.huawei.ism.drm.recovery.framework.task.MountBackTaskHandler;
import com.huawei.ism.drm.recovery.sdk.model.MountConfiguration;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Date;

public class CloneReplicaTask
extends AbstractBackTask {
    private static final Log logger = LogFactory.getInstance(CloneReplicaTask.class);
    private final User user;
    private final ProtectGroupReplica srcReplica;
    private final boolean isNeedMount;
    private final MountConfiguration mountConfigs;

    public CloneReplicaTask(User user, ProtectGroupReplica srcReplica, boolean isNeedMount, MountConfiguration mountConfigs) {
        super(UUIDGenerator.getUUID(), BackTaskUtil.buildBackTask((String)srcReplica.getName(), (String)"ism.drm.clone.replica", (String)user.getUserName(), (String)"", null), true);
        this.user = user;
        this.srcReplica = srcReplica;
        this.isNeedMount = isNeedMount;
        this.mountConfigs = mountConfigs;
    }

    protected void doWork() {
        boolean isVasa;
        IReplicaFactory targetReplicaFactory;
        int configTargetReplicaType;
        logger.info((Object)("CloneReplicaTask: Begin to clone replica from replica(" + this.srcReplica.getId() + "-" + this.srcReplica.getName() + ")."));
        ReplicaFactoryManager manager = ReplicaFactoryManager.getInstance();
        IReplicaFactory sourceReplicaFactory = manager.getReplicaFactory(this.srcReplica.getType());
        if (!sourceReplicaFactory.validReplica(this.srcReplica, true)) {
            logger.error((Object)("srcReplica is not valid: " + this.srcReplica.getId() + " isNeedMount:" + this.isNeedMount));
            throw new LegoCheckedException(1073948459L);
        }
        ILicenseControl licenseController = (ILicenseControl)ServiceLocator.getInstance().getService(ILicenseControl.class);
        ProtectGroup pg = this.srcReplica.getPg();
        licenseController.checkEnablePgCount(pg);
        int targetReplicaType = this.getDefaultTargetReplicaType();
        int n = configTargetReplicaType = this.mountConfigs != null ? this.mountConfigs.getTargetReplicaType() : 0;
        if (0 != configTargetReplicaType && targetReplicaType != 9) {
            targetReplicaType = configTargetReplicaType;
        }
        if (VerifyUtil.isEmpty((Object)(targetReplicaFactory = manager.getReplicaFactory(targetReplicaType)))) {
            logger.error((Object)("can not get replica Factory, replicaType=" + targetReplicaType));
            throw new LegoCheckedException(2117645L);
        }
        ProtectGroupReplica newReplica = targetReplicaFactory.createReplica(this.srcReplica);
        if (VerifyUtil.isEmpty((Object)newReplica)) {
            logger.error((Object)("create new replica failed, source replicaId=" + this.srcReplica.getId() + ", replicaName=" + this.srcReplica.getName() + ", replicaType=" + targetReplicaType));
            throw new LegoCheckedException(0x300001L);
        }
        IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        newReplica.setGeneration(Integer.valueOf(2));
        newReplica.addProperty("mountConfigs", JSONObject.fromObject((Object)this.mountConfigs).toString());
        newReplica.setTimeStamp(String.valueOf(new Date().getTime()));
        service.saveOrUpdateReplica(newReplica);
        if (this.isNeedMount) {
            String mountHost = this.mountConfigs.getHostOrGroupSn();
            CreateMountReplicaPlanTask task = new CreateMountReplicaPlanTask(newReplica, mountHost, this.user, this.mountConfigs);
            MountBackTaskHandler.getInstance().submitTask((AbstractBackTask)task);
        }
        if (isVasa = LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false)).booleanValue()) {
            TaskResultItem taskResultItem = new TaskResultItem();
            taskResultItem.setResultItem(this.getBackTask());
            taskResultItem.setResName(newReplica.getId());
            taskResultItem.setDetail("ism.drm.site.success");
            taskResultItem.setResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
            this.getBackTask().getTaskResultSet().add(taskResultItem);
        }
        logger.info((Object)("CloneReplicaTask: Finish cloning new replica(" + newReplica.getId() + "-" + newReplica.getName() + ")."));
    }

    private int getDefaultTargetReplicaType() {
        String sn = this.srcReplica.getStorageDeviceId();
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevId(sn);
        if (FusionStorageUnit.class.getName().equals(proxy.getStorageType())) {
            return 9;
        }
        return this.srcReplica.getType();
    }
}

