/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorReplicationSubProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RefactorReplicationForDRRingSubProcessor
extends RefactorReplicationSubProcessor {
    private static final long serialVersionUID = 143965753888664722L;
    private static final Log logger = LogFactory.getInstance(RefactorReplicationForDRRingSubProcessor.class);
    private static final String REPLICA = "replica";

    public RefactorReplicationForDRRingSubProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    @Override
    protected List<RemoteStorageReplica> getRemoteReplicas(RecoveryProcessorContext context, ProtectGroup protectGroup, String disasterSiteId) {
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        if (VerifyUtil.isEmpty((Collection)recoveryTasks)) {
            logger.error((Object)"get recoveryTasks is empty");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<RemoteStorageReplica> replicas = new ArrayList<RemoteStorageReplica>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            if (null == recoveryTask.getParams() || null == recoveryTask.getParams().get(REPLICA)) continue;
            RemoteStorageReplica remoteStorageReplica = (RemoteStorageReplica)recoveryTask.getParams().get(REPLICA);
            this.fillWwnWithStorage(protectGroup.getPoType(), remoteStorageReplica);
            replicas.add(remoteStorageReplica);
        }
        return replicas;
    }

    private void fillWwnWithStorage(int poType, RemoteStorageReplica remoteStorageReplica) {
        if (!VerifyUtil.isEmpty((String)remoteStorageReplica.getProtectObjectStorageWwn())) {
            return;
        }
        if (poType != 11) {
            logger.error((Object)"PoType is not Lun, no need to fill wwn.");
            return;
        }
        IStorageService service = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        Lun srcLun = service.getLunBySnAndLunId(remoteStorageReplica.getSrcStorageProviderSN(), remoteStorageReplica.getSrcStorageId());
        VerifyUtil.checkObject((Object)srcLun);
        logger.info((Object)"Storage wwn=%s", new Object[]{srcLun.getWwn()});
        remoteStorageReplica.setProtectObjectStorageWwn(srcLun.getWwn());
    }
}

