/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.ReplicationConstantDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReprotectManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageVstoreReplicationPairManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageReprotectManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairManager;
import com.huawei.ism.drm.storage.sdk.model.hypermetro.SanHyperMetroRingAirGapExecuteInfo;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;

public class RefactorReplicationSubProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = -2715459610241826383L;
    private static final Log logger = LogFactory.getInstance(RefactorReplicationSubProcessor.class);
    private static final int TIME_OUT = 1800;

    public RefactorReplicationSubProcessor() {
        this.setIsNeedSave(false);
    }

    public RefactorReplicationSubProcessor(RecoveryProcessor parentProcess) {
        super(parentProcess);
        this.setIsNeedSave(false);
    }

    public boolean execute(RecoveryProcessorContext context) {
        try {
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            String disasterSiteId = this.getDisasterSiteId(context);
            boolean result = this.refactorReplication(context, recoveryPlan, disasterSiteId);
            if (!result) {
                return false;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Refactoring replication failed.", (Throwable)e, 90160758787071L);
            this.updateProcessDetail(e);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("Refactoring replication failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected String getDisasterSiteId(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Map globalSettings = recoveryPlan.getGlobalSettings();
        String disasterSiteId = (String)globalSettings.get("DISASTER_SITE_ID");
        return disasterSiteId;
    }

    private boolean refactorReplication(RecoveryProcessorContext context, RecoveryPlan recoveryPlan, String disasterSiteId) {
        for (ProtectGroup protectGroup : recoveryPlan.getProtectGroups()) {
            String recoveryArray = this.getRecoveryArrayByPg(protectGroup, disasterSiteId);
            if (recoveryArray == null) {
                logger.error((Object)("There is no recovery array. pg:" + protectGroup.getName() + ",SiteID:" + disasterSiteId), 90160758784001L);
                continue;
            }
            List<RemoteStorageReplica> remoteReplicas = this.getRemoteReplicas(context, protectGroup, disasterSiteId);
            if (remoteReplicas == null || remoteReplicas.isEmpty()) {
                logger.error((Object)("The remote stor replicas is null. pg:" + protectGroup.getName() + ",SiteID:" + disasterSiteId), 90160758784001L);
                continue;
            }
            Map<String, RemoteStorageReplica> replicas = this.getRemoteStorageReplicaMap(remoteReplicas);
            if (protectGroup.getTemplate().getType() == 48) {
                this.filterReplicaWhenPartPortOpenFailed(context, replicas);
            }
            long startA = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            replicas.keySet().forEach(item -> sb.append((String)item).append(","));
            logger.debug((Object)"replicas pair ids:%s, size:%s", new Object[]{sb.toString(), replicas.size()});
            ArrayList<Callable<OperationResult>> reverseTasks = new ArrayList<Callable<OperationResult>>();
            for (RemoteStorageReplica remoteReplica : replicas.values()) {
                if (this.set4DCVaultReverseTask(context, protectGroup, recoveryArray, reverseTasks, remoteReplica)) continue;
                ReverseTask reverseTask = new ReverseTask(protectGroup, recoveryArray, remoteReplica);
                reverseTasks.add(reverseTask);
            }
            if (this.submitReverseTasks(startA, reverseTasks)) continue;
            return false;
        }
        return true;
    }

    private void filterReplicaWhenPartPortOpenFailed(RecoveryProcessorContext context, Map<String, RemoteStorageReplica> replicas) {
        SanHyperMetroRingAirGapExecuteInfo executeInfo = (SanHyperMetroRingAirGapExecuteInfo)context.getObject("SAN_HYPER_METRO_RING_RECOVERY_INFO", SanHyperMetroRingAirGapExecuteInfo.class);
        if (!executeInfo.isSiteAPortOpenSuccess()) {
            replicas.values().removeIf(replica -> executeInfo.getSiteADevSn().equals(replica.getSrcStorageProviderSN()) || executeInfo.getSiteADevSn().equals(replica.getStorageProviderSN()));
        }
        if (!executeInfo.isSiteBPortOpenSuccess()) {
            replicas.values().removeIf(replica -> executeInfo.getSiteBDevSn().equals(replica.getSrcStorageProviderSN()) || executeInfo.getSiteBDevSn().equals(replica.getStorageProviderSN()));
        }
        if (replicas.isEmpty()) {
            logger.error((Object)"The is no reverse tasks.", 90160758784001L);
            this.updateProcessDetail("lego.err.1677929521", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
    }

    private Map<String, RemoteStorageReplica> getRemoteStorageReplicaMap(List<RemoteStorageReplica> remoteReplicas) {
        HashMap<String, RemoteStorageReplica> replicas = new HashMap<String, RemoteStorageReplica>();
        for (RemoteStorageReplica remoteReplica : remoteReplicas) {
            boolean isConsistentGroup = RecoveryProcessUtil.isConsistentGroup((RemoteStorageReplica)remoteReplica);
            boolean isVstorePair = RecoveryProcessUtil.isVstorePair((RemoteStorageReplica)remoteReplica);
            if (isConsistentGroup) {
                replicas.put(ReplicationConstantDefine.ReplicationDescription.CONSISTENT_GROUP.name() + remoteReplica.getConsistentGroupId(), remoteReplica);
                continue;
            }
            if (isVstorePair) {
                replicas.put(ReplicationConstantDefine.ReplicationDescription.VSTORE_PAIR.name() + remoteReplica.getVstorePairId(), remoteReplica);
                continue;
            }
            replicas.put(remoteReplica.getReplicationPairId(), remoteReplica);
        }
        return replicas;
    }

    private boolean submitReverseTasks(long startA, List<Callable<OperationResult>> reverseTasks) {
        List results = ExecutionService.batchSubmit(reverseTasks, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)1800, (int)20);
        long startB = System.currentTimeMillis();
        logger.debug((Object)("update ReplicationPairsByMasterLun cost time:" + (startA - startB)));
        if (results.size() != reverseTasks.size()) {
            logger.error((Object)"The reverse tasks exsist failed task.", 90160758784001L);
            this.updateProcessDetail("lego.err.-1", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        for (OperationResult result : results) {
            if (result.isSuccess()) continue;
            logger.error((Object)"result is not success. errorCode: %s.", new Object[]{result.getErrorCode()});
            this.updateProcessDetail("lego.err." + result.getErrorCode(), result.getArgs());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        return true;
    }

    private boolean set4DCVaultReverseTask(RecoveryProcessorContext context, ProtectGroup protectGroup, String recoveryArray, List<Callable<OperationResult>> reverseTasks, RemoteStorageReplica remoteReplica) {
        if (!RecoveryTaskUtil.is4DCVaultRollBack((RecoveryProcessorContext)context)) {
            return false;
        }
        if (!recoveryArray.equals(remoteReplica.getStorageProviderSN())) {
            String tmpRecoveryArray = this.getRecoveryArrayByLocation(protectGroup, remoteReplica.getLocation());
            ReverseTask reverseTask = new ReverseTask(protectGroup, tmpRecoveryArray, remoteReplica);
            reverseTasks.add(reverseTask);
            return true;
        }
        return false;
    }

    protected String getRecoveryArrayByLocation(ProtectGroup protectGroup, int location) {
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || replica.getProtectLocation() != location) continue;
            return replica.getRecoveryArray();
        }
        return "";
    }

    protected List<RemoteStorageReplica> getRemoteReplicas(RecoveryProcessorContext context, ProtectGroup protectGroup, String disasterSiteId) {
        ProtectGroupReplica replicaSync;
        ProtectGroupReplica disasterReplica = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || null == replica.getRecoverySite() || !replica.getRecoverySite().equals(disasterSiteId)) continue;
            disasterReplica = replica;
            break;
        }
        ArrayList<RemoteStorageReplica> remoteStorageReplicas = new ArrayList<RemoteStorageReplica>();
        if (disasterReplica == null) {
            return remoteStorageReplicas;
        }
        this.putRemoteStorageReplicas(remoteStorageReplicas, disasterReplica);
        if (RecoveryTaskUtil.is4DCVaultRollBack((RecoveryProcessorContext)context) && disasterReplica.getProtectLocation() == DrmEnumDefine.ProtectLocation.B_C.getValue() && (replicaSync = this.getSyncReplica(protectGroup)) != null) {
            this.putRemoteStorageReplicas(remoteStorageReplicas, replicaSync);
        }
        return remoteStorageReplicas;
    }

    private void putRemoteStorageReplicas(List<RemoteStorageReplica> remoteStorageReplicas, ProtectGroupReplica protectGroupReplica) {
        int location = protectGroupReplica.getProtectLocation();
        for (ProtectObjectReplica protectObjectReplica : protectGroupReplica.getReplicas()) {
            for (RelicaStorageInfo storageInfo : protectObjectReplica.getStorageInfos()) {
                RemoteStorageReplica remoteStorage = (RemoteStorageReplica)storageInfo;
                remoteStorage.setLocation(location);
                logger.info((Object)("Need to reverse replicationPair direction:" + remoteStorage.getReplicationPairId()), 90160758786816L);
                remoteStorageReplicas.add(remoteStorage);
            }
        }
    }

    private ProtectGroupReplica getSyncReplica(ProtectGroup protectGroup) {
        ProtectGroupReplica protectGroupReplica = null;
        for (ProtectGroupReplica replica : protectGroup.getReplicaList()) {
            if (ProtectGroupUtil.isLocalStorageReplica((ProtectGroupReplica)replica) || replica.getProtectLocation() != DrmEnumDefine.ProtectLocation.A_B.getValue()) continue;
            protectGroupReplica = replica;
            break;
        }
        return Optional.ofNullable(protectGroupReplica).orElse(null);
    }

    private OperationResult reverseReplication(ProtectGroup protectGroup, String recoveryArray, RemoteStorageReplica replica) {
        OperationResult result;
        logger.debug((Object)"enter reverseReplication recoveryArray:%s", new Object[]{recoveryArray});
        boolean isConsistentGroup = RecoveryProcessUtil.isConsistentGroup((RemoteStorageReplica)replica);
        boolean isVstorePair = RecoveryProcessUtil.isVstorePair((RemoteStorageReplica)replica);
        String replicationId = isConsistentGroup ? replica.getConsistentGroupId() : replica.getReplicationPairId();
        IStorageVstoreReplicationPairManager vstoreReplicationPairManager = null;
        if (isVstorePair) {
            replicationId = replica.getVstorePairId();
            String queryArrayId = RecoveryTaskUtil.getAirGapQueryArrayId((String)replica.getSrcStorageProviderSN(), (String)replica.getStorageProviderSN());
            queryArrayId = VerifyUtil.isEmpty((String)queryArrayId) ? recoveryArray : queryArrayId;
            vstoreReplicationPairManager = StorageVstoreReplicationPairManagerProxy.getInstance().getMgrByDevId(queryArrayId);
        }
        logger.debug((Object)"enter reverseReplication isConsistentGroup:%s, replicationId:%s", new Object[]{isConsistentGroup, replicationId});
        String srcProviderSN = replica.getSrcStorageProviderSN();
        String providerSN = replica.getStorageProviderSN();
        String queryDevSn = RecoveryTaskUtil.getAirGapQueryArrayId((String)srcProviderSN, (String)providerSN);
        String tmpDevSn = VerifyUtil.isEmpty((String)queryDevSn) ? recoveryArray : queryDevSn;
        IStorageReprotectManager reprotectManager = (IStorageReprotectManager)StorageReprotectManagerProxy.getInstance().getStorageReprotectMgrByDevId(tmpDevSn);
        if (this.isUnReversedRemoteStorageReplica(protectGroup, recoveryArray, (RelicaStorageInfo)replica)) {
            logger.debug((Object)"not reverse Replication isVstorePair:%s", new Object[]{isVstorePair});
            result = isVstorePair ? this.getVstorePairResult(replicationId, vstoreReplicationPairManager, providerSN, srcProviderSN) : reprotectManager.reverseReplication(srcProviderSN, providerSN, replicationId, isConsistentGroup);
        } else {
            logger.debug((Object)"already reverse Replication isVstorePair:%s", new Object[]{isVstorePair});
            if (isVstorePair) {
                if (VerifyUtil.isEmpty((Object)vstoreReplicationPairManager)) {
                    throw new LegoCheckedException(1073947393L);
                }
                result = vstoreReplicationPairManager.setSecondaryPairReadWrite(providerSN, replicationId, String.valueOf(2));
            } else {
                result = reprotectManager.setSecondaryLunWriteProtection(srcProviderSN, providerSN, replicationId, isConsistentGroup);
            }
            Optional<OperationResult> opt = this.getAndCheckResult(result);
            result = opt.orElse(null);
        }
        logger.debug((Object)"out reverseReplication recoveryArray:%s, result%s", new Object[]{recoveryArray, result == null ? "null " : Boolean.valueOf(result.isSuccess())});
        return result;
    }

    private Optional<OperationResult> getAndCheckResult(OperationResult result) {
        if (result == null) {
            return Optional.empty();
        }
        String errorCode = result.getErrorCode();
        boolean isSpecialError = String.valueOf(1077938066L).equals(errorCode) || String.valueOf(1073749061L).equals(errorCode) || String.valueOf(0x40400744L).equals(errorCode);
        OperationResult tmpResult = result;
        if (!result.isSuccess() && isSpecialError) {
            tmpResult = new OperationResult("ism.business.replication.setTargetResAccessAttr", true, true, new String[0]);
        }
        return Optional.of(tmpResult);
    }

    private OperationResult getVstorePairResult(String replicationId, IStorageVstoreReplicationPairManager vstoreReplicationPairManager, String providerSN, String srcDevSN) {
        if (VerifyUtil.isEmpty((Object)vstoreReplicationPairManager)) {
            throw new LegoCheckedException(1073947393L);
        }
        String optDevSn = RecoveryTaskUtil.getAirGapQueryArrayId((String)srcDevSN, (String)providerSN);
        optDevSn = VerifyUtil.isEmpty((String)optDevSn) ? providerSN : optDevSn;
        VstoreReplicationPair vstoreReplicationPair = vstoreReplicationPairManager.queryVstorePairById(optDevSn, replicationId);
        OperationResult result = vstoreReplicationPairManager.swap(optDevSn, replicationId);
        if (VerifyUtil.isEmpty((Object)result) || !result.isSuccess()) {
            return result;
        }
        IStoragePortLinksManager portLinksManager = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(optDevSn);
        if (vstoreReplicationPair.isCmoIdentityPreserve() && (VerifyUtil.isEmpty((Object)(result = portLinksManager.changeLogicalPortWorkStatus(srcDevSN, vstoreReplicationPair, 2))) || !result.isSuccess())) {
            return result;
        }
        result = vstoreReplicationPairManager.setSecondaryPairReadWrite(optDevSn, replicationId, String.valueOf(2));
        if (VerifyUtil.isEmpty((Object)result) || !result.isSuccess()) {
            return result;
        }
        if (vstoreReplicationPair.isCmoIdentityPreserve()) {
            result = portLinksManager.changeLogicalPortWorkStatus(providerSN, vstoreReplicationPair, 1);
        }
        return result;
    }

    private boolean isUnReversedRemoteStorageReplica(ProtectGroup protectGroup, String recoveryArray, RelicaStorageInfo storageInfo) {
        String siteInfoListStr;
        Set<String> oldProductSiteIdSet = new HashSet<String>(Arrays.asList(protectGroup.getProductSiteId()));
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(protectGroup.getTemplate().getType()) && null != (siteInfoListStr = (String)protectGroup.getProps().get("PROP_KEY_SITE_INFO"))) {
            List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
            oldProductSiteIdSet = ((SiteInfo)siteInfoList.get(0)).getSiteIdSet();
        }
        Integer localResType = 11;
        String wwn = storageInfo.getProtectObjectStorageWwn();
        if (VerifyUtil.isEmpty((String)wwn) || wwn.contains("/")) {
            localResType = 40;
        }
        logger.debug((Object)"sn:%s, resId:%s,type:%s, wwn:%s", new Object[]{storageInfo.getStorageProviderSN(), storageInfo.getStorageProviderSN(), localResType, wwn});
        if (protectGroup.getTemplate().getType() == PolicyTemplateType.PolicyTemplateE.ARRAY_ASYNC_HYPER_METRO_RING.getValue() || protectGroup.getTemplate().getType() == PolicyTemplateType.PolicyTemplateE.ARRAY_SAN_HYPER_METRO_ASYNC_RING_AIRGAP_SNAPSHOT.getValue()) {
            if (localResType == 11 && protectGroup.isRepConsistentGroup()) {
                return storageInfo instanceof RemoteStorageReplica && !this.isReversed(oldProductSiteIdSet, storageInfo, protectGroup.getTemplate().getType(), localResType);
            }
            return storageInfo instanceof RemoteStorageReplica && !this.isReversed(oldProductSiteIdSet, storageInfo, protectGroup.getTemplate().getType(), localResType);
        }
        return storageInfo instanceof RemoteStorageReplica && recoveryArray.equals(storageInfo.getStorageProviderSN()) && !this.isReversed(oldProductSiteIdSet, storageInfo, protectGroup.getTemplate().getType(), localResType);
    }

    private final class ReverseTask
    implements Callable<OperationResult> {
        private ProtectGroup protectGroup = null;
        private String recoveryArraySN = null;
        private RemoteStorageReplica remoteStorageReplica = null;

        public ReverseTask(ProtectGroup protectGroup, String recoveryArray, RemoteStorageReplica replica) {
            this.protectGroup = protectGroup;
            this.recoveryArraySN = recoveryArray;
            this.remoteStorageReplica = replica;
        }

        @Override
        public OperationResult call() {
            OperationResult result = RefactorReplicationSubProcessor.this.reverseReplication(this.protectGroup, this.recoveryArraySN, this.remoteStorageReplica);
            return result;
        }
    }
}

