/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.process.reprotect;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorReplicationForDRRingSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorReplicationSubProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.RefreshStorageProcessor;
import com.huawei.ism.drm.recovery.framework.process.reprotect.ReprotectBaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RefactorStorageRelationProcessor
extends ReprotectBaseRecoveryProcessor {
    private static final long serialVersionUID = 3167111574987453300L;
    private static final Log logger = LogFactory.getInstance(RefactorStorageRelationProcessor.class);
    private static final String WAIT_SECONDS_KEY = "refreshStorage.wait.time";
    private static final int RETRY_TIMES = 5;

    public RefactorStorageRelationProcessor() {
        this.setProcName(this.getName());
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        return oldProcess.getClass() == newProcess.getClass();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        RefactorReplicationSubProcessor refactorReplication = this.createSubProcessor(context);
        refactorReplication.setIsNeedCreateDetail(false);
        boolean result = refactorReplication.execute(context);
        if (!result) {
            this.updateProcessDetail(refactorReplication.getProcDetail(), refactorReplication.getProcDetailParams());
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        long waitTime = LegoConfig.getInstance().getNumber(WAIT_SECONDS_KEY, 3000L);
        CommonUtil.sleep((long)waitTime);
        result = this.refreshStorage(context);
        if (!result) {
            this.updateProcessDetail("lego.err.1073948761", new String[0]);
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            return false;
        }
        Iterator iterator = context.getRecoveryPlan().getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)iterator.next();
        for (int retryTimes = 1; retryTimes <= 5; ++retryTimes) {
            if (this.isStorageRelationReversed(pg, context.getDisasterSiteId())) {
                logger.info((Object)"IsStorageRelationReversed: Success!");
                break;
            }
            int millis = retryTimes * 1000;
            CommUtil.pauseThread((long)millis);
            result = this.refreshStorage(context);
            if (!result) {
                this.updateProcessDetail("lego.err.1073948761", new String[0]);
                this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
                return false;
            }
            logger.info((Object)("RefreshStorage retryTimes:" + retryTimes));
        }
        context.setAttribute("hasReversedReplication", (Object)(!context.getHasReversedReplication() ? 1 : 0));
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        return true;
    }

    protected RefactorReplicationSubProcessor getSubProcessorInstance() {
        return new RefactorReplicationSubProcessor((RecoveryProcessor)this);
    }

    private RefactorReplicationSubProcessor createSubProcessor(RecoveryProcessorContext context) {
        CommonUtil.requireNonNull((Object)context.getProtectGroup(), (long)1073947394L, (String[])new String[0]);
        int type = context.getProtectGroup().getTemplate().getType();
        if (26 == type || 27 == type) {
            return new RefactorReplicationForDRRingSubProcessor((RecoveryProcessor)this);
        }
        return this.getSubProcessorInstance();
    }

    protected boolean refreshStorage(RecoveryProcessorContext context) {
        RefreshStorageProcessor refreshStorageProcessor = new RefreshStorageProcessor((RecoveryProcessor)this);
        refreshStorageProcessor.setIsNeedCreateDetail(false);
        return refreshStorageProcessor.execute(context);
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean isStorageRelationReversed(ProtectGroup pg, String disasterSiteId) {
        HashMap resourceType = new HashMap();
        List storageResourceIds = this.getLunIds(pg, disasterSiteId, resourceType);
        logger.info((Object)("Storage resource ids. PgName:" + pg.getName() + ",Ids:" + storageResourceIds.toString()), 90160758784000L);
        String recoveryArray = this.getRecoveryArrayByPg(pg, disasterSiteId);
        String productArray = this.getProductArrayByPg(pg, disasterSiteId);
        boolean reversedFlag = true;
        for (String lunId : storageResourceIds) {
            ReplicationRelation replicationRelation = this.findReversedStorageRelation(productArray, recoveryArray, lunId, (Integer)resourceType.get(lunId), true);
            String logMsg = "ProductSiteId:" + pg.getProductSiteId() + ",ProductArray:" + productArray + ",RecoverySiteId:" + disasterSiteId + ",RecoveryArray:" + recoveryArray + ",LunId:" + lunId;
            logger.info((Object)("isStorageRelationReversed:" + logMsg));
            if (replicationRelation != null) continue;
            reversedFlag = false;
            break;
        }
        return reversedFlag;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.recovery.framework.process.reprotect.RefactorStorageRelationProcessor.des");
    }
}

