/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.recovery.framework.task;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.task.LocalRecoveryBackTask;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class MountReplicaBackTask
extends LocalRecoveryBackTask {
    private static final Log logger = LogFactory.getInstance(MountReplicaBackTask.class);

    @Override
    protected void beforeExecuteRecoveryPlan(RecoveryProcessorContext context) {
        super.beforeExecuteRecoveryPlan(context);
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            logger.error((Object)"Replica is null");
            throw new LegoCheckedException(1073947393L);
        }
        IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        ProtectGroupReplica dbReplica = service.queryProtectGroupReplicaById(replica.getId());
        int planStatus = this.getRecoveryPlanExecuteType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA ? ReplicaMountStatus.UMOUNTING.getStatus() : ReplicaMountStatus.MOUNTING.getStatus();
        dbReplica.setMountStatus(Integer.valueOf(planStatus));
        service.saveOrUpdateReplica(dbReplica);
    }

    @Override
    protected void afterExecuteRecoveryPlan(boolean result, RecoveryProcessorContext context) {
        super.afterExecuteRecoveryPlan(result, context);
        IReplicaService service = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        if (VerifyUtil.isEmpty((Object)context.getProtectGroupReplica())) {
            logger.error((Object)"protectGroup replica is empty: pg=%s", new Object[]{context.getProtectGroup()});
            return;
        }
        ProtectGroupReplica replica = service.queryProtectGroupReplicaById(context.getProtectGroupReplica().getId());
        if (null == replica) {
            logger.info((Object)("afterExecuteRecoveryPlan: query Replica(" + context.getProtectGroupReplica().getId() + ") is null"));
            return;
        }
        String hostKey = "PG_DISASTER_HOST";
        String mountHost = (String)context.getRecoveryPlan().getGlobalSettings().get(hostKey);
        if (!result) {
            int planStatus = this.getRecoveryPlanExecuteType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA ? ReplicaMountStatus.UMOUNT_FAILED.getStatus() : ReplicaMountStatus.MOUNT_FAILED.getStatus();
            replica.setMountStatus(Integer.valueOf(planStatus));
            service.saveOrUpdateReplica(replica);
            String[] parameters = new String[]{replica.getId(), mountHost};
            String msg = "Mount replica[%s] to host or host group[%s] failed.";
            logger.error((Object)msg, new Object[]{90160758784001L, replica.getId(), mountHost});
            throw new LegoCheckedException(1073948249L, parameters, msg);
        }
        int planStatus = this.getRecoveryPlanExecuteType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.UMOUNT_REPLICA ? ReplicaMountStatus.UMOUNTED.getStatus() : ReplicaMountStatus.MOUNTED.getStatus();
        replica.setMountStatus(Integer.valueOf(planStatus));
        replica.setMountedHost(mountHost);
        if (planStatus == ReplicaMountStatus.UMOUNTED.getStatus()) {
            replica.setMountedHost("--");
        }
        service.saveOrUpdateReplica(replica);
    }
}

