/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.cfgdata.processor;

import com.huawei.ism.cbb.base.poll.IPollInitializer;
import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.poll.PollController;
import com.huawei.ism.cbb.discover.poll.PollControllerLocator;
import com.huawei.ism.drm.system.cfgdata.ConfigDataCommon;
import com.huawei.ism.drm.system.cfgdata.database.ConfigDataDao;
import com.huawei.ism.drm.system.cfgdata.processor.ConfigDataPoller;
import com.huawei.ism.drm.system.cfgdata.sdk.model.FtpServerInfo;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class ConfigDataPollInitializer
implements IPollInitializer,
SystemStatusChangedListener {
    private static final Log logger = LogFactory.getInstance(ConfigDataPollInitializer.class);
    private static final int PERIOD = 86400;
    private PollController pollController;
    private ConfigDataDao configDataDao;

    public ConfigDataDao getConfigDataDao() {
        return this.configDataDao;
    }

    public void setConfigDataDao(ConfigDataDao configDataDao) {
        this.configDataDao = configDataDao;
    }

    public PollController getPollController() {
        return this.pollController;
    }

    public void setPollController(PollController pollController) {
        this.pollController = pollController;
    }

    public void onStatusChangedEvent(StatusChangedEvent arg0) {
        if (Status.STATUS_STARTED.equals((Object)arg0.getStatus())) {
            logger.info((Object)"Start to init poller. ", 90160758786816L);
            this.initPoller();
            logger.info((Object)"Successed to init poller. ", 90160758786816L);
        }
    }

    public void initPoller() {
        FtpServerInfo ftpInfo = this.configDataDao.queryFtpServerInfo(null);
        if (ftpInfo == null) {
            logger.info((Object)"There is no ftp server info of config data.", 90160758786816L);
            return;
        }
        if (ftpInfo.isAutoBackupFlag()) {
            int delayTime = ConfigDataCommon.calculateFirstRunDelayTime((String)ftpInfo.getRunTime());
            ConfigDataPoller configDataPoller = new ConfigDataPoller(ftpInfo.getFtpServerId(), "CONFIG_DATA", ftpInfo);
            PollControllerLocator.getInstance().getPollController().addPoller((IPoller)configDataPoller, delayTime * 60, 86400);
        }
    }
}

