/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.system.personaldata.service;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.system.personaldata.sdk.service.IPersonalDataService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.huawei.lego.nem.fault.sdk.model.NotifyResItem;
import com.huawei.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.huawei.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.huawei.lego.nem.fault.sdk.model.SmsServer;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

@Service(name="com.huawei.ism.drm.system.personaldata.sdk.service.IPersonalDataService", desc="", interfaceClass=IPersonalDataService.class)
public class PersonalDataServiceImpl
extends BaseService
implements IPersonalDataService {
    private static Log logger = LogFactory.getInstance(PersonalDataServiceImpl.class);

    public void clearPersonalData() {
        this.clearTableData(RemoteNotifyServer.class, SmsServer.class, NotifyAlarmItem.class, NotifyResItem.class, RemoteNotifyRule.class);
    }

    private void clearTableData(Class<?> ... domains) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            if (session != null) {
                transaction = session.beginTransaction();
                for (Class<?> domain : domains) {
                    Query query = session.createQuery("delete from " + domain.getSimpleName());
                    query.executeUpdate();
                }
                transaction.commit();
            }
        }
        catch (Exception e) {
            try {
                DBOperationUtil.rollbackSession((Session)session);
                logger.error((Object)("clear table data failed," + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
                throw e;
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
        }
        DBOperationUtil.closeSession((Session)session);
    }
}

