/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.topo.builder;

import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.QuorumServer;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.topo.builder.AbstractTopoBuilder;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.model.site.SiteNode;
import com.huawei.ism.drm.topo.sdk.context.TopoBaseContext;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.manager.ITopoResourceManager;
import com.huawei.ism.drm.topo.sdk.model.ReplicationLinkTopoData;
import com.huawei.ism.drm.topo.sdk.model.Topo;
import com.huawei.ism.drm.topo.sdk.service.IDrmTopoService;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.topology.Element;
import com.huawei.topology.ElementBox;
import com.huawei.topology.Group;
import com.huawei.topology.IData;
import com.huawei.topology.Link;
import com.huawei.topology.Node;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;

public abstract class AbstractGlobalTopoBuilder
extends AbstractTopoBuilder {
    protected static final Double REPLICATION_ARROW_IO_WIDTH = 7.0;
    protected static final Double REPLICATION_ARROW_IO_HIGHTH = 6.0;
    protected static final double LINK_TO_X_OFFSET = 10.0;
    protected static final int LINK_STATUS_PART_BREAK = 1;
    protected static final int LINK_STATUS_ALL_BREAK = 2;
    protected static final int LINK_STATUS_PART_UNKNOWN = 3;
    protected static final int LINK_STATUS_ALL_UNKNOWN = 4;
    protected static final int PAIR_STATUS_BREAK_ONE = 4;
    protected static final int PAIR_STATUS_BREAK_TWO = 34;
    protected static final int LINK_STATUS_RESULT_LENTH = 2;
    protected static final double HOST_ICONS_XGAP = 5.0;
    protected static final double HOST_ICONS_YGAP = -20.0;
    protected static final int LINK_BREAK = 11;
    protected static final int LINK_UP = 10;
    private static final String USEFUL = "useful";
    private static final String CENTER = "center";
    private static final String COUNT = "count";
    private static final double SITERANNUM = 200.0;
    private static final double NODERANNUM = 100.0;
    private static final int LINK_STATUS_NORMAL = 0;
    private static final List<Integer> DEPEND_BLOCK_CLIENT_TEMPLATE_TYPE_LIST = new ArrayList<Integer>(Arrays.asList(33));
    private static final Log LOG = LogFactory.getInstance(AbstractGlobalTopoBuilder.class);
    @Autowired
    private IDrmTopoService topoService;

    @Deprecated
    protected void createStorages(TopoBaseContext context, Node host, ProtectObject protectObject, ElementBox layout) {
        ProtectGroup protectGroup = protectObject.getProtectGroup();
        Set storages = protectObject.getUsedStorageResourceSet();
        for (ProtectObjectStorageInfo storage : storages) {
            this.createStorage(context, protectGroup, storage, layout);
        }
    }

    protected void addIdtoList(List<String> idList, String id) {
        if (idList.contains(id)) {
            return;
        }
        idList.add(id);
    }

    protected Node createStorage(TopoBaseContext context, ProtectGroup protectGroup, ProtectObjectStorageInfo storage, ElementBox layout) {
        DrResource drResource = this.getDrResourceInContext(context, storage.getResourceProviderSN());
        if (drResource != null && drResource instanceof DrStorage) {
            DrStorage drStorage = (DrStorage)drResource;
            return this.createStorage(context, protectGroup, drStorage, layout);
        }
        return null;
    }

    public Node createStorage(TopoBaseContext context, ProtectGroup protectGroup, DrStorage storage, ElementBox layout) {
        ElementBox topoBox = context.getElementBox();
        String id = storage.getSiteId();
        Site productStorageSite = this.getSiteInContext(context, id);
        Group productStorageSiteGroup = this.getOrCreateGroup(topoBox, productStorageSite, layout);
        Node storageNode = (Node)topoBox.getElementByID((Object)(storage.getDeviceSn() + "---" + id));
        if (storageNode == null) {
            storageNode = this.createStorageNode(storage, productStorageSite, false);
            this.initNodeLocation(storageNode, (Node)productStorageSiteGroup, layout);
            productStorageSiteGroup.addChild((IData)storageNode);
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)storageNode);
        }
        this.addIdtoList(context.getStorageNodeIds(), String.valueOf(storageNode.getID()));
        this.addProtectGroupIDToElement((Element)storageNode, protectGroup.getUuid());
        return storageNode;
    }

    public void createHostAndStorageLink(TopoBaseContext context, Node hostNode, Node storageNode) {
        if (VerifyUtil.isEmpty((Object)hostNode) || VerifyUtil.isEmpty((Object)storageNode)) {
            LOG.debug((Object)"hostNode or storageNode is empty,not create HostAndStorageLink.");
            return;
        }
        if (hostNode instanceof Group) {
            for (Object child : hostNode.getChildren()) {
                this.createHostStorageLink(context, (Node)child, storageNode, true);
            }
        } else {
            this.createHostStorageLink(context, hostNode, storageNode, true);
        }
    }

    public int getIntFromStr(String str) {
        int i = -1;
        try {
            i = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)("the formatter error: " + str));
            i = -1;
        }
        return i;
    }

    public List<Initiator> getInitiatorsInContext(TopoBaseContext context, String deviceSn, Site site) {
        List initiators = (List)context.getInitiatorMaps().get(deviceSn);
        if (initiators != null) {
            return initiators;
        }
        initiators = context.getStorageResourceService().getArrayInitiators(deviceSn, site);
        if (VerifyUtil.isEmpty((Collection)initiators)) {
            LOG.debug((Object)("The initiators is null: " + deviceSn), 1L);
            return initiators;
        }
        context.getInitiatorMaps().put(deviceSn, initiators);
        return initiators;
    }

    protected void createStorageAndHostLink(TopoBaseContext context, Node storageNode, Node hostNode) {
        if (VerifyUtil.isEmpty((Object)hostNode) || VerifyUtil.isEmpty((Object)storageNode)) {
            LOG.debug((Object)"param is null", 1L);
            return;
        }
        this.createStorageHostLink(context, storageNode, hostNode);
    }

    private void createStorageHostLink(TopoBaseContext context, Node from, Node to) {
        if (from == null || to == null) {
            return;
        }
        if (from.equals(to)) {
            return;
        }
        ElementBox topoBox = context.getElementBox();
        ProtectGroup protectGroup = context.getProtectGroup();
        Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)from, (Node)to);
        if (link == null) {
            String linkID = "hostlink-" + from.getID() + ":" + to.getID();
            link = new Link((Object)linkID, from, to);
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            link.setClient("linkToXOffset", 10.0);
            link.setStyle("link.width", 1.0);
            link.setStyle("arrow.to", true);
            link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
            link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            link.setStyle("select.alpha", 1.0);
            link.setStyle("select.style", (Object)"none");
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)link);
        }
        try {
            this.setLinkDetail(context, link, to, from);
        }
        catch (Exception e) {
            LOG.error((Object)("setLinkDetail error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
    }

    protected boolean checkSnapshot(TopoBaseContext context) {
        if (VerifyUtil.isEmpty((Object)context) || VerifyUtil.isEmpty((Object)context.getProtectGroup()) || VerifyUtil.isEmpty((Object)context.getProtectGroup().getTemplate())) {
            LOG.debug((Object)"param is null", 1L);
            return false;
        }
        PolicyTemplate template = context.getProtectGroup().getTemplate();
        int ptType = template.getType();
        int subType = template.getSubType();
        return ptType == 2 || ptType == 14 || subType == 2;
    }

    protected Node getOrCreateRecoverSiteNode(TopoBaseContext context, ProtectGroupReplica replica, ElementBox layout) {
        String sn = replica.getRecoveryArray();
        DrStorage drRecoverStorage = (DrStorage)this.getDrResourceInContext(context, sn);
        if (drRecoverStorage == null) {
            LOG.debug((Object)("The drStorage is null: sn= " + sn), 1L);
            return null;
        }
        return this.createStorage(context, context.getProtectGroup(), drRecoverStorage, layout);
    }

    protected Node getOrCreateProductSiteNode(TopoBaseContext context, ProtectGroupReplica replica, ElementBox layout) {
        String sn = replica.getProductArray();
        DrStorage drStorage = (DrStorage)this.getDrResourceInContext(context, sn);
        if (drStorage == null) {
            LOG.debug((Object)("the drStorage is null, sn= " + sn), 1L);
            return null;
        }
        return this.createStorage(context, context.getProtectGroup(), drStorage, layout);
    }

    protected String getLayoutXml(String topoIndexId) {
        String info = null;
        try {
            Topo topoInfo = (Topo)CommonDAOLocator.getBaseDao().getHibernateTemplate().get(Topo.class, (Serializable)((Object)topoIndexId));
            if (topoInfo != null) {
                info = topoInfo.getTopoDetail();
            }
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"unable to get sites", (Throwable)ex, 90160758786873L);
        }
        return info;
    }

    protected void addProtectGroupIDToElement(Element element, String protectGroupID) {
        if (element == null) {
            LOG.debug((Object)"The param is null", 1L);
            return;
        }
        if (element instanceof Group) {
            for (Object child : element.getChildren()) {
                this.addProtectGroupIDToElement((Element)child, protectGroupID);
            }
        } else {
            ArrayList<String> protectGroupIDlist = (ArrayList<String>)element.getClient("linkPolicys");
            if (protectGroupIDlist == null) {
                protectGroupIDlist = new ArrayList<String>();
                protectGroupIDlist.add(protectGroupID);
            } else {
                if (protectGroupIDlist.contains(protectGroupID)) {
                    return;
                }
                protectGroupIDlist.add(protectGroupID);
            }
            element.setClient("linkPolicys", protectGroupIDlist);
        }
    }

    protected void createHostStorageLink(TopoBaseContext context, Node from, Node to, boolean isArrow) {
        if (from == null || to == null) {
            LOG.debug((Object)"The param is null", 1L);
            return;
        }
        if (from.equals(to)) {
            return;
        }
        ElementBox topoBox = context.getElementBox();
        ProtectGroup protectGroup = context.getProtectGroup();
        Link link = TopoServiceUtil.getExistLinkBetweenNodes((Node)from, (Node)to);
        if (link == null) {
            String linkID = "hostlink-" + from.getID() + ":" + to.getID();
            link = new Link((Object)linkID, from, to);
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            link.setClient("linkToXOffset", 10.0);
            link.setStyle("link.width", 1.0);
            link.setStyle("arrow.to", isArrow);
            link.setStyle("arrow.to.width", (Object)REPLICATION_ARROW_IO_WIDTH);
            link.setStyle("arrow.to.height", (Object)REPLICATION_ARROW_IO_HIGHTH);
            link.setStyle("arrow.to.shape", (Object)"arrow.delta");
            link.setStyle("select.alpha", 1.0);
            link.setStyle("select.style", (Object)"none");
            TopoServiceUtil.addElementToBox((ElementBox)topoBox, (IData)link);
        }
        try {
            this.setLinkDetail(context, link, from, to);
        }
        catch (Exception e) {
            LOG.error((Object)("setLinkDetail error!" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
        this.addProtectGroupIDToElement((Element)link, protectGroup.getUuid());
    }

    protected void setLinkDetail(TopoBaseContext context, Link link, Node hostNode, Node storageNode) {
        if (!VerifyUtil.isEmpty((String)link.getToolTip())) {
            return;
        }
        if (this.checkTemplateType(context)) {
            return;
        }
        String hostSn = this.getNetworkSnFromNodeId((String)hostNode.getID());
        String storageSn = this.getNetworkSnFromNodeId(null == storageNode ? null : (String)storageNode.getID());
        if (VerifyUtil.isEmpty((String)hostSn) || VerifyUtil.isEmpty((String)storageSn)) {
            link.setStyle("link.color", (Object)"0xbbbbbb");
            link.setStyle("arrow.to.color", (Object)"0xbbbbbb");
            return;
        }
        DrResource host = this.getDrResourceInContext(context, hostSn);
        if (VerifyUtil.isEmpty((Object)host)) {
            LOG.debug((Object)("The host is null: " + hostSn), 1L);
            return;
        }
        DrResource storage = this.getDrResourceInContext(context, storageSn);
        if (VerifyUtil.isEmpty((Object)storage)) {
            LOG.debug((Object)("The storage is null: " + storageSn), 1L);
            return;
        }
        Site site = this.getSiteInContext(context, storage.getSiteId());
        List<Initiator> storageIniators = this.getInitiatorsInContext(context, storageSn, site);
        List<Initiator> connectIniators = this.getConnectInitiators(host, storageIniators);
        link.setClient("devSN", (Object)storageSn);
        link.setClient("trgSN", (Object)hostSn);
        if (DEPEND_BLOCK_CLIENT_TEMPLATE_TYPE_LIST.contains(context.getProtectGroup().getTemplate().getType())) {
            this.setLinkSytleByBlockClient(link, context, connectIniators, host);
            return;
        }
        int len = connectIniators.size();
        int breakNum = 0;
        int unknownNum = 0;
        for (Initiator iniator : connectIniators) {
            if (VerifyUtil.isEmpty((Object)iniator.getRunningStatus())) {
                ++unknownNum;
                continue;
            }
            if (iniator.getRunningStatus() == -1) {
                ++breakNum;
                continue;
            }
            if (iniator.getRunningStatus() != 4) continue;
            ++unknownNum;
        }
        this.setToolTips(link, len, breakNum, unknownNum);
        if (len == 0) {
            this.removeLinkFromBox(context, link);
        }
    }

    private void setLinkSytleByBlockClient(Link link, TopoBaseContext context, List<Initiator> connectIniators, DrResource host) {
        Initiator connectIniator = connectIniators.stream().filter(iniator -> iniator.getInitiatorIp().equals(host.getIpAddress())).findFirst().get();
        int[] stateArray = new int[]{1, 0, 0};
        if (!VerifyUtil.isEmpty((Object)connectIniator)) {
            this.computeState(stateArray, connectIniator);
        }
        this.setToolTips(link, stateArray[0], stateArray[1], stateArray[2]);
        if (stateArray[0] == 1) {
            this.removeLinkFromBox(context, link);
        }
    }

    private void computeState(int[] stateArray, Initiator connectIniator) {
        stateArray[0] = stateArray[0] + 1;
        if (connectIniator.getHealthStatus() == 1) {
            stateArray[1] = stateArray[1] + 1;
        }
        if (connectIniator.getHealthStatus() > 1) {
            stateArray[2] = stateArray[2] + 1;
        }
    }

    private boolean checkTemplateType(TopoBaseContext context) {
        boolean result;
        PolicyTemplate template = context.getProtectGroup().getTemplate();
        int tempType = template.getType();
        int subType = template.getSubType();
        boolean bl = result = tempType == 14 || tempType == 17 || tempType == 1 && subType == 2;
        if (!result) {
            String vstorePairId;
            if (tempType == 28) {
                result = true;
            } else if (!(tempType != 15 && tempType != 18 && tempType != 20 || VerifyUtil.isEmpty((String)(vstorePairId = (String)template.getProps().get("PROP_KEY_VSTORE_PAIR_ID"))))) {
                result = true;
            }
        }
        return result;
    }

    protected void removeLinkFromBox(TopoBaseContext context, Link link) {
    }

    protected void setToolTips(Link link, int len, int breakNum, int unknownNum) {
        StringBuilder linkTips = new StringBuilder();
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        linkTips.append(resourceManager.getText("ism.drm.topo.initiator.status"));
        linkTips.append(" ");
        if (breakNum > 0 || len == breakNum) {
            link.setStyle("link.color", (Object)"0xfc4133");
            link.setStyle("arrow.to.color", (Object)"0xfc4133");
            linkTips.append(resourceManager.getText("ism.drm.topo.initiator.allbreak"));
        } else if (unknownNum > 0) {
            link.setStyle("link.color", (Object)"0x1dcfef");
            link.setStyle("arrow.to.color", (Object)"0x1dcfef");
            linkTips.append(resourceManager.getText("ism.drm.topo.storage.replica.unknown"));
        } else {
            link.setStyle("link.color", (Object)"0x31bd16");
            link.setStyle("arrow.to.color", (Object)"0x31bd16");
            linkTips.append(resourceManager.getText("ism.drm.topo.initiator.normal"));
        }
        link.setToolTip(linkTips.toString());
    }

    protected String getNetworkSnFromNodeId(String nodeId) {
        if (VerifyUtil.isEmpty((String)nodeId)) {
            return null;
        }
        Object[] idArray = nodeId.split("---");
        if (VerifyUtil.isEmpty((Object[])idArray)) {
            return null;
        }
        return idArray[0];
    }

    protected Node createStorageNode(DrStorage storage, Site site, boolean isVis) {
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Node storageNode = new Node((Object)(storage.getDeviceSn() + "---" + storage.getSiteId()));
        storageNode.setStyle("label.color", 35020);
        if (isVis) {
            this.setVisImageByStatus(storageNode, NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
        } else {
            StorageElement.setImageByStatus((Node)storageNode, (Integer)NumberUtil.convertToInteger((Object)storage.getStatus(), (int)0));
        }
        storageNode.setStyle("label.bold", false);
        storageNode.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        storageNode.setClient("moID", (Object)storage.getDeviceSn());
        if (isVis) {
            storageNode.setClient("isHostOrStorage", (Object)"isvis");
        } else {
            storageNode.setClient("isHostOrStorage", (Object)"isstorage");
        }
        storageNode.setClient("imageWidth", 48.0);
        storageNode.setClient("imageHeight", 60.0);
        storageNode.setName(TopoServiceUtil.getNodeShowName((String)storage.getName()));
        storageNode.setToolTip(StorageElement.createStorageTooltip((DrStorage)storage));
        storageNode.setStyle("select.alpha", 1.0);
        storageNode.setStyle("select.style", (Object)"none");
        return storageNode;
    }

    protected void setVisImageByStatus(Node visNode, Integer status) {
        if (status == 0) {
            visNode.setImage("/theme/recoverydirector/images/topo/visarray.png");
        } else if (status == -1) {
            visNode.setImage("/theme/recoverydirector/images/topo/visarray_offline.png");
            visNode.setStyle("label.color", 0x999999);
        } else if (status == 2) {
            visNode.setImage("/theme/recoverydirector/images/topo/visarray_faulty.png");
            visNode.setStyle("label.color", 15864852);
        } else {
            visNode.setImage("/theme/recoverydirector/images/topo/visarray_unknown.png");
            visNode.setStyle("label.color", 0x999999);
        }
    }

    protected Site getSiteInContext(TopoBaseContext context, String siteID) {
        Site site = (Site)context.getSiteMaps().get(siteID);
        if (site != null) {
            return site;
        }
        site = context.getSiteService().getSiteById(siteID);
        if (site == null) {
            LOG.debug((Object)("site is null, siteID=" + siteID));
            throw new LegoCheckedException(1073947394L);
        }
        context.getSiteMaps().put(siteID, site);
        return site;
    }

    protected DrResource getDrResourceInContext(TopoBaseContext context, String devSn) {
        String[] devSnArray;
        DrResource resource = (DrResource)context.getDrResourceMaps().get(devSn);
        if (resource != null) {
            return resource;
        }
        if (devSn.contains(":") && (devSnArray = devSn.split(":")).length > 0) {
            resource = this.getDrResource(devSnArray[0]);
        }
        if (resource == null) {
            resource = this.getDrResource(devSn);
        }
        if (resource != null) {
            context.getDrResourceMaps().put(devSn, resource);
        }
        return resource;
    }

    protected List<QuorumServer> getQuorumServersInContext(TopoBaseContext context, String devSn) {
        List quorumServers = (List)context.getQuorumServerMaps().get(devSn);
        if (!VerifyUtil.isEmpty((Collection)quorumServers)) {
            LOG.debug((Object)"The quorumServer in empty, devSn: %s", new Object[]{devSn});
            return quorumServers;
        }
        DrResource resource = this.getDrResourceInContext(context, devSn);
        if (null == resource) {
            LOG.error((Object)"The resource in empty, devSn: %s", new Object[]{devSn});
            return quorumServers;
        }
        quorumServers = context.getStorageResourceService().getQuorumServers(devSn);
        if (!VerifyUtil.isEmpty((Collection)quorumServers)) {
            context.getQuorumServerMaps().put(devSn, quorumServers);
        }
        return quorumServers;
    }

    protected List<HyperMetroDomain> getHyperMetroDomainsInContext(TopoBaseContext baseContext, String devSn) {
        if (!(baseContext instanceof TopoContext)) {
            return Lists.newArrayList();
        }
        TopoContext context = (TopoContext)baseContext;
        List hyperMetroDomains = (List)context.getHyperMetroDomainMaps().get(devSn);
        if (!VerifyUtil.isEmpty((Collection)hyperMetroDomains)) {
            LOG.debug((Object)"The hyperMetorDomains is in context, devSn=%s", new Object[]{devSn});
            return hyperMetroDomains;
        }
        DrResource resource = this.getDrResourceInContext((TopoBaseContext)context, devSn);
        if (null == resource) {
            LOG.debug((Object)"The resource is null, devSn=%s", new Object[]{devSn});
            return hyperMetroDomains;
        }
        hyperMetroDomains = context.getStorageResourceService().getHyperMetroDomains(devSn);
        if (!VerifyUtil.isEmpty((Collection)hyperMetroDomains)) {
            context.getHyperMetroDomainMaps().put(devSn, hyperMetroDomains);
        }
        return hyperMetroDomains;
    }

    protected void setNodeExtName(Node hostNode, String hostName, String groupName, String groupType) {
        int i;
        StringBuffer buffer;
        int cutNum;
        int groupNameLenth;
        if (VerifyUtil.isEmpty((String)groupName)) {
            LOG.debug((Object)"the gpName is null", 1L);
            return;
        }
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        String langInfo = resourceManager.getLangInfo();
        int x = 1;
        x = "zh".equals(langInfo) ? 1 : 2;
        String hostShowName = TopoServiceUtil.getNodeShowName((String)hostName);
        String groupShowName = TopoServiceUtil.getNodeShowName((String)("@" + groupName));
        int hostNameLenth = hostShowName.length();
        if (hostNameLenth > (groupNameLenth = groupShowName.length())) {
            cutNum = x * (hostNameLenth - groupNameLenth) / 2;
            buffer = new StringBuffer();
            for (i = 0; i < cutNum; ++i) {
                buffer.append(" ");
            }
            buffer.append(groupShowName);
            for (i = 0; i < cutNum; ++i) {
                buffer.append(" ");
            }
            groupShowName = buffer.toString();
        } else if (groupNameLenth > hostNameLenth) {
            cutNum = x * (groupNameLenth - hostNameLenth) / 2;
            buffer = new StringBuffer();
            for (i = 0; i < cutNum; ++i) {
                buffer.append(" ");
            }
            buffer.append(hostShowName);
            for (i = 0; i < cutNum; ++i) {
                buffer.append(" ");
            }
            hostShowName = buffer.toString();
        }
        hostNode.setName(hostShowName + "\n" + groupShowName);
        String toolTips = resourceManager.getText(groupType) + " " + groupName;
        String orgTips = hostNode.getToolTip();
        if (!VerifyUtil.isEmpty((String)orgTips) && !orgTips.contains(toolTips)) {
            StringBuilder tooltipBuilder = new StringBuilder();
            tooltipBuilder.append(orgTips);
            TooltipUtil.appendTooltip((StringBuilder)tooltipBuilder, (String)groupType, (String)StringEscapeUtil.escape((String)groupName));
            hostNode.setToolTip(tooltipBuilder.toString());
        }
    }

    protected Group getOrCreateGroup(ElementBox box, Site site, ElementBox layout, boolean isVis) {
        Group group = null;
        group = isVis ? (Group)box.getElementByID((Object)(site.getSiteId() + ":vis")) : (Group)box.getElementByID((Object)site.getSiteId());
        if (group == null) {
            group = this.createSiteTopoForGlobalTopo(site, isVis);
            this.initGroupLocation(group, null, layout);
            TopoServiceUtil.addElementToBox((ElementBox)box, (IData)group);
        }
        return group;
    }

    protected Group getOrCreateGroup(ElementBox box, Site site, ElementBox layout) {
        return this.getOrCreateGroup(box, site, layout, false);
    }

    protected Group createSiteTopoForGlobalTopo(Site site) {
        return this.createSiteTopoForGlobalTopo(site, false);
    }

    protected Group createSiteTopoForGlobalTopo(Site site, boolean isVis) {
        if (null == site) {
            LOG.debug((Object)"site is null", 1L);
            return null;
        }
        ITopoResourceManager resourceManager = TopoBaseContext.getTopoResourceManager();
        Group siteGroup = null;
        siteGroup = isVis ? new Group((Object)(site.getSiteId() + ":vis")) : new Group((Object)site.getSiteId());
        siteGroup.setStyle("label.bold", false);
        siteGroup.setStyle("label.font", (Object)resourceManager.getText("ism.drm.topo.label.font"));
        siteGroup.setClient("imageWidth", 48.0);
        siteGroup.setClient("imageHeight", 60.0);
        siteGroup.setName(TopoServiceUtil.getNodeShowName((String)site.getName()));
        siteGroup.setToolTip(new SiteNode(resourceManager).createSiteTooltip(site));
        siteGroup.setImage("/theme/recoverydirector/images/topo/site.png");
        siteGroup.setStyle("group.outline.color", (Object)"0xDCDCDC");
        siteGroup.setStyle("group.outline.width", 1);
        siteGroup.setStyle("group.fill.color", (Object)"0xfafafa");
        siteGroup.setStyle("group.shape", (Object)"roundrect");
        siteGroup.setStyle("vector.roundrect.radius", 12);
        siteGroup.setExpanded(true);
        siteGroup.setStyle("select.alpha", 1.0);
        siteGroup.setStyle("select.style", (Object)"none");
        siteGroup.setStyle("label.color", (Object)"0x222222");
        siteGroup.setStyle("label.size", 14.0);
        return siteGroup;
    }

    protected void initNodeLocation(Node node, Node fatherNode, ElementBox layout) {
        if (layout != null && layout.containsByID(node.getID())) {
            node.setLocation(((Node)layout.getDataByID(node.getID())).getLocation());
            layout.setClient(USEFUL, (Object)true);
        } else {
            SecureRandom radom = new SecureRandom();
            double rx = radom.nextDouble() * 100.0;
            double ry = radom.nextDouble() * 100.0;
            if (fatherNode != null) {
                Point2D location = fatherNode.getLocation();
                node.setLocation(location.getX() + rx, location.getY() + ry);
            } else {
                node.setLocation(rx, ry);
            }
        }
    }

    protected void initGroupLocation(Group group, Node fatherNode, ElementBox layout) {
        if (null == group) {
            return;
        }
        Group savedGroup = (Group)layout.getDataByID(group.getID());
        if (savedGroup != null) {
            group.setLocation(savedGroup.getLocation());
            group.setExpanded(savedGroup.isExpanded());
            layout.setClient(USEFUL, (Object)true);
            return;
        }
        SecureRandom random = new SecureRandom();
        if (fatherNode != null) {
            double rx = random.nextDouble() * 100.0;
            double ry = random.nextDouble() * 100.0;
            Point2D location = fatherNode.getLocation();
            group.setLocation(location.getX() + rx, location.getY() + ry);
            return;
        }
        Point center = (Point)layout.getClient(CENTER);
        AtomicInteger count = (AtomicInteger)layout.getClient(COUNT);
        double x = center.getX() + random.nextDouble() * 200.0;
        double y = center.getY() + random.nextDouble() * 200.0;
        group.setLocation(x, y);
        double v = count.getAndIncrement();
        x = (center.getX() * v + group.getLocation().getX()) / (v + 1.0);
        y = (center.getY() * v + group.getLocation().getY()) / (v + 1.0);
        center.setLocation(x, y);
    }

    protected int getStorageLinkStatus(TopoBaseContext baseContext, String srcSN, String trgSN) {
        long pairCount = 0L;
        long breakPairCount = 0L;
        long linkupPairCount = 0L;
        long unknownCount = 0L;
        try {
            List links = baseContext.getTopoBaseService().getLinkDetailInfo(srcSN, trgSN);
            pairCount = links.size();
            for (ReplicationLinkTopoData linkData : links) {
                int iStatus = linkData.getLinkStatus();
                if (iStatus == 11) {
                    ++breakPairCount;
                    continue;
                }
                if (iStatus == 10) {
                    ++linkupPairCount;
                    continue;
                }
                ++unknownCount;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("setStorageLinkStatus failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return this.getLinkStatus(pairCount, breakPairCount, unknownCount);
    }

    protected int getLinkStatus(long pairCount, long breakPairCount, long unknownCount) {
        if (pairCount == breakPairCount) {
            return 2;
        }
        if (breakPairCount > 0L) {
            return 1;
        }
        if (pairCount == unknownCount) {
            return 4;
        }
        if (unknownCount > 0L) {
            return 3;
        }
        return 0;
    }

    protected List<Initiator> getConnectInitiators(DrResource resource, List<Initiator> arrayInitiators) {
        ArrayList<Initiator> initiators = new ArrayList<Initiator>();
        if (VerifyUtil.isEmpty(arrayInitiators)) {
            return initiators;
        }
        try {
            String hostExt = resource.getExtProperty();
            if (VerifyUtil.isEmpty((String)hostExt)) {
                return initiators;
            }
            JSONObject hostExtInfo = JSONObject.fromObject((Object)hostExt);
            if (VerifyUtil.isEmpty((Map)hostExtInfo)) {
                return initiators;
            }
            String fsbBlockIp = hostExtInfo.getString("fsb_block_client_ip", "");
            JSONArray hostInitiators = JSONArray.fromObject((Object)hostExtInfo.get("HBA"));
            if (VerifyUtil.isEmpty((Collection)hostInitiators)) {
                return initiators;
            }
            Iterator it = hostInitiators.iterator();
            while (it.hasNext()) {
                JSONObject initiator = JSONObject.fromObject(it.next());
                String initiatorId = initiator.getString("IDENTITY");
                String hbaType = initiator.getString("TYPE");
                initiators.addAll(this.filterInitiators(arrayInitiators, initiatorId, hbaType, fsbBlockIp));
            }
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)("Unable to get initiator, HostSn: " + resource.getDeviceSn()), (Throwable)e, 90160758786873L);
        }
        return initiators;
    }

    private List<Initiator> filterInitiators(List<Initiator> arrayInitiators, String initiatorId, String hbaType, String fsbBlockIp) {
        List<String> targetInitiatorIds = this.separatorInitiators(initiatorId, hbaType);
        ArrayList<Initiator> filteredInitiators = new ArrayList<Initiator>();
        int matchedCount = 0;
        for (Initiator eachInitiator : arrayInitiators) {
            if (this.isInitiatorExist(targetInitiatorIds, eachInitiator.getIdentity()) && hbaType.equalsIgnoreCase(eachInitiator.getHbaType())) {
                filteredInitiators.add(eachInitiator);
                if (++matchedCount != targetInitiatorIds.size()) continue;
                break;
            }
            if (!VerifyUtil.isEmpty((String)eachInitiator.getIdentity()) || !VerifyUtil.isEmpty((String)eachInitiator.getHbaType()) || VerifyUtil.isEmpty((String)fsbBlockIp) || !fsbBlockIp.equals(eachInitiator.getInitiatorIp())) continue;
            filteredInitiators.add(eachInitiator);
            break;
        }
        return filteredInitiators;
    }

    protected boolean isInitiatorExist(List<String> targetInitiatorIds, String identity) {
        if (VerifyUtil.isEmpty(targetInitiatorIds)) {
            return false;
        }
        for (String initiatorId : targetInitiatorIds) {
            if (!initiatorId.equalsIgnoreCase(identity)) continue;
            return true;
        }
        return false;
    }

    protected List<String> separatorInitiators(String initiatorId, String hbaType) {
        return this.topoService.separateInitiatorId(initiatorId, hbaType);
    }
}

