/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.process;

import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.kube.discovery.util.ProcessorUtil;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.ism.drm.kube.service.IKubeService;
import com.huawei.ism.drm.kube.service.impl.KubeServiceImpl;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class KubePingProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(KubePingProcessor.class);
    private final IKubeService kubeService = new KubeServiceImpl();

    public boolean process(AbstractContext context) {
        int resourceStatus;
        KubernetesNE networkEntity = ProcessorUtil.getKubeNe(context);
        LOGGER.info((Object)"[kubernetes]KubePingProcessor start, server ip: %s", new Object[]{networkEntity.getLinkIp()});
        String deviceSn = networkEntity.getSn();
        if (this.kubeService.checkCDRStatusBySN(deviceSn)) {
            resourceStatus = 0;
        } else {
            LOGGER.error((Object)"[kubernetes]Ping kubernetes error, could not connect to CDR, server ip: %s", new Object[]{context.getAttribute("kubeServerIp")});
            resourceStatus = -1;
            this.kubeService.deregisterHyperMetroProtectGroupWatch(deviceSn);
        }
        if (resourceStatus == 0) {
            if (Boolean.TRUE.equals(context.getAttribute("isManual"))) {
                this.kubeService.deregisterHyperMetroProtectGroupWatch(deviceSn);
            }
            this.kubeService.registerHyperMetroProtectGroupWatch(deviceSn);
        }
        this.kubeService.updateKubeStatus(deviceSn, resourceStatus);
        return true;
    }

    public void postProcess(AbstractContext abstractContext) {
    }

    public void clean(AbstractContext abstractContext) {
    }
}

