/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.process;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionPlan;
import com.huawei.ism.drm.kube.sdk.model.KubeStorage;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.utils.KubeRefreshResourceUtils;
import com.huawei.ism.drm.kube.utils.KubeResourceBuildUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.io.File;
import java.util.Optional;

public class MonitorProtectionPlanTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(MonitorProtectionPlanTask.class);
    private ProtectGroup protectGroup;
    private final IKubeHandler kubeHandler = (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    private KubeProtectionPlan plan;

    public MonitorProtectionPlanTask(ProtectGroup protectGroup, KubeProtectionPlan plan) {
        this.protectGroup = protectGroup;
        this.plan = plan;
    }

    @Override
    public void run() {
        try {
            LOGGER.info((Object)"Begin check src protection plan status.");
            String planName = this.plan.getName();
            KubeRefreshResourceUtils.checkProtectPlanStatusNormalOrError(this.protectGroup, this.protectGroup.getPoProviderSN(), planName);
            LOGGER.info((Object)"Begin rebuild trg protection plan.");
            String trgSn = ((Schedule)this.protectGroup.getTemplate().getSchedules().iterator().next()).getTargetSn();
            if (!this.kubeHandler.checkProtectionPlanExist(trgSn, planName)) {
                this.kubeHandler.rebuildProtectionPlan(((ProtectGroupReplica)this.protectGroup.getReplicaList().iterator().next()).getRecoveryArray(), this.rbuildTrgProtectionPlan(this.protectGroup, (Schedule)this.protectGroup.getTemplate().getSchedules().iterator().next(), this.plan));
            } else {
                this.kubeHandler.rebuildProtectionPlan(trgSn, planName);
            }
            KubeRefreshResourceUtils.checkProtectPlanStatusNormalOrError(this.protectGroup, trgSn, planName);
            this.restoreAlarm(planName);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Monitor protection plan status failed. ProtectGroup name:%s.", new Object[]{this.protectGroup.getName()});
            ProtectGroup curProtectGroup = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getProtectGroupByID(this.protectGroup.getUuid());
            curProtectGroup.setStatus(DrmEnumDefine.ProtectGroupStatus.INVALID.getStatus());
            CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)curProtectGroup);
            this.sendAlarm(this.protectGroup);
            throw e;
        }
    }

    private KubeProtectionPlan rbuildTrgProtectionPlan(ProtectGroup protectGroup, Schedule schedule, KubeProtectionPlan protectionPlan) {
        Optional<KubeStorage> targetOpt = KubeResourceBuildUtil.getTargetKubeStorage(schedule);
        if (!targetOpt.isPresent()) {
            LOGGER.error((Object)"Not find target kube storage.");
            throw new LegoCheckedException(2117645L);
        }
        KubeStorage storage = null;
        storage = protectGroup.getTemplate().getType() == 55 ? KubeResourceBuildUtil.getPVCSBC((ProtectObject)protectGroup.getPolist().iterator().next()) : KubeResourceBuildUtil.getSBC((ProtectObject)protectGroup.getPolist().iterator().next());
        KubeStorage targetStorage = targetOpt.get();
        protectionPlan.setRoleType(KubeEnumDefine.RoleType.RECOVERY);
        protectionPlan.setLocalSBCName(targetStorage.getNamespace() + File.separator + targetStorage.getName());
        protectionPlan.setLocalSBCSn(targetStorage.getDeviceSn());
        protectionPlan.setRemoteSBCName(storage.getNamespace() + File.separator + storage.getName());
        protectionPlan.setRemoteSBCSn(storage.getDeviceSn());
        return protectionPlan;
    }

    private void checkMasterProtectPlanStatus(String devSn, String name) {
        block3: {
            Optional opt;
            long curTime;
            long startTime = System.currentTimeMillis();
            do {
                CommUtil.pauseThread((long)5000L);
                opt = ((IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class)).getProtectionPlan(devSn, name);
                if (!opt.isPresent()) {
                    LOGGER.error((Object)"Not find the protect protectPlan: %s", new Object[]{name});
                    throw new LegoCheckedException(2117645L);
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.ERROR) {
                    LOGGER.info((Object)"The protect cdr PP is Error, can not create recovery.");
                    throw new LegoCheckedException(1073947751L, new String[]{name, ((KubeProtectionPlan)opt.get()).getStatus().getValue()});
                }
                if (((KubeProtectionPlan)opt.get()).getStatus() == KubeEnumDefine.CDRProtectGroupStatus.NORMAL) break block3;
            } while ((curTime = System.currentTimeMillis()) - startTime < 360000L);
            LOGGER.error((Object)"Get PP status: %s by max wait time.", new Object[]{((KubeProtectionPlan)opt.get()).getStatus().getValue()});
            throw new LegoCheckedException(1073947433L);
        }
        LOGGER.info((Object)"The protect cdr PP is normal, can create recovery.");
    }

    private void sendAlarm(ProtectGroup protectGroup) {
        String[] alarmParams = new String[]{this.plan.getName(), protectGroup.getName(), protectGroup.getUuid()};
        AlarmReporter.sendAlarm((String)"0x3230087", (String)protectGroup.getUuid(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])alarmParams);
    }

    private void restoreAlarm(String protectionPlanName) {
        AlarmReporter.restoreAlarm((String)"0x3230087", (String[])new String[]{protectionPlanName});
    }
}

