/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.discovery.synchronizer;

import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.kube.model.KubeExtendInfo;
import com.huawei.ism.drm.kube.sdk.model.KubernetesNE;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class KubeSynchronizer
extends AbstractSynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(KubeSynchronizer.class);

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter params, MoListOrMap parent) {
        LOGGER.info((Object)"[kubernetes]Kubernetes synchronizer start. device ip: %s", new Object[]{params.getDeviceIp()});
        KubeExtendInfo extendInfo = this.parseKubeParams(params);
        this.retrieve(params, parent, extendInfo);
        return new MoListOrMap(Collections.emptyMap());
    }

    private void retrieve(SynchronizeParameter params, MoListOrMap parent, KubeExtendInfo extendInfo) {
        CommonTemplate template;
        DiscoverContext context = new DiscoverContext(params, parent);
        if (StringUtils.isEmpty((CharSequence)extendInfo.getDeviceSn())) {
            template = CommonTemplateManager.getInstance().getDiscoverTemplateByDeviceType("Kube");
            context.setAttribute("DiscoveryType", (Object)"register");
        } else {
            template = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Kube");
            context.setAttribute("DiscoveryType", (Object)"refresh");
        }
        context.setAttribute("kubeExtendInfo", (Object)extendInfo);
        context.setAttribute("OPERATORID", (Object)params.getDiscoveryPolicy().getOperatorId());
        context.setAttribute("kubeSiteId", (Object)extendInfo.getSiteId());
        context.setAttribute("kubeServerIp", (Object)extendInfo.getIp());
        KubernetesNE kubernetesNE = this.buildKubernetesNE(params, extendInfo);
        context.setAttribute("StorageDevice", (Object)kubernetesNE);
        context.setAttribute("kubeDeviceSN", (Object)kubernetesNE.getSn());
        Map extendAttributeMap = params.getDiscoveryPolicy().getExtendAttributeMap();
        Object discoveryTask = extendAttributeMap.get("discoveryTask");
        context.setAttribute("BackTask", discoveryTask);
        template.process((AbstractContext)context);
    }

    private KubeExtendInfo parseKubeParams(SynchronizeParameter synchronizeParameter) {
        DiscoveryPolicy policy = synchronizeParameter.getDiscoveryPolicy();
        if (policy == null || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            return new KubeExtendInfo();
        }
        Map paramMap = policy.getParamMap();
        KubeExtendInfo extendInfo = (KubeExtendInfo)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)paramMap), KubeExtendInfo.class);
        paramMap.remove("configText");
        return extendInfo;
    }

    private KubernetesNE buildKubernetesNE(SynchronizeParameter params, KubeExtendInfo extendInfo) {
        String deviceSn = extendInfo.getDeviceSn();
        deviceSn = VerifyUtil.isEmpty((String)deviceSn) ? UUIDGenerator.getUUID() : deviceSn;
        KubernetesNE networkEntity = new KubernetesNE();
        networkEntity.setSn(deviceSn);
        networkEntity.setUuid(deviceSn);
        networkEntity.setMainType("ism.drm.deviceType.container.mainType");
        networkEntity.setSubType("ism.drm.deviceType.kube.subType");
        networkEntity.setIpAddress(extendInfo.getIp());
        networkEntity.setLinkIp(extendInfo.getIp());
        networkEntity.setIsTopMo(Boolean.valueOf(true));
        networkEntity.setManaged(Boolean.valueOf(true));
        networkEntity.setName(extendInfo.getIp());
        networkEntity.setManufacturer("ism.storage.manufacture.0huawei");
        networkEntity.setManagementProtocolMap(params.getManagementProtocolMap());
        networkEntity.setManagementProtocol("Kube");
        networkEntity.setProductModel("Kube");
        return networkEntity;
    }
}

