/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.execute.process;

import com.huawei.ism.drm.kube.listener.KubeJobListenerExecutor;
import com.huawei.ism.drm.kube.model.KubeJobListenerExecuteParam;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeBackup;
import com.huawei.ism.drm.kube.sdk.model.KubeBackupJob;
import com.huawei.ism.drm.kube.sdk.model.KubeProtectionJob;
import com.huawei.ism.drm.kube.sdk.model.constants.KubeEnumDefine;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeJobType;
import com.huawei.ism.drm.kube.utils.KubeResourceBuildUtil;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.framework.engine.action.AbstractBaseProtectAction;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractCDRMonitorAction
extends AbstractBaseProtectAction {
    private static final Log LOGGER = LogFactory.getInstance(AbstractCDRMonitorAction.class);
    private static final int CHECK_REPLICA_DURATION = 2;
    private static final int CHECK_REPLICA_TIME_OUT = 5;

    public boolean doExecute(ActionContext context) {
        return true;
    }

    protected abstract String getStartKeyword();

    protected abstract String getEndKeyword();

    protected boolean startListen(ProtectGroup protectGroup, String jobName, KubeJobType jobType) {
        KubeJobListenerExecutor listener = KubeJobListenerExecutor.getInstance();
        final AtomicBoolean result = new AtomicBoolean(true);
        KubeJobListenerExecuteParam param = new KubeJobListenerExecuteParam();
        param.setDevSn(protectGroup.getPoProviderSN());
        param.setJobType(jobType);
        param.setJobName(jobName);
        param.setStartKeyword(this.getStartKeyword());
        param.setEndKeyword(this.getEndKeyword());
        listener.startListen(param, new KubeJobListenerExecutor.ListenCallback(){

            @Override
            public void success(String devSn, String jobName, Map<String, Object> extend) {
                LOGGER.info((Object)"Listen CDR event [%s] success. JobName:%s.", new Object[]{"", jobName});
            }

            @Override
            public void error(String jobName, String message, String reason) {
                LOGGER.error((Object)"Listen CDR event [%s] error. JobName:%s. Reason:%s. Message:%s", new Object[]{"", jobName, reason, message});
                AbstractCDRMonitorAction.this.setDetail("lego.err.1073947753");
                AbstractCDRMonitorAction.this.setDetailParams(message);
                result.set(false);
            }

            @Override
            public void timeout(String jobName, long startTime, long endTime) {
                LOGGER.error((Object)"Listen CDR event [%s] timeout. JobName:%s. StartTime:%s. EndTime:%s", new Object[]{"", jobName, String.valueOf(startTime), String.valueOf(endTime)});
                result.set(false);
            }
        });
        return result.get();
    }

    protected boolean listenReplicationAction(ActionContext context, ProtectGroup protectGroup, String listenKey) {
        KubeProtectionJob kubeProtectionJob = (KubeProtectionJob)context.getObject("protectionJob", KubeProtectionJob.class);
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Object)kubeProtectionJob)) {
            LOGGER.error((Object)"ProtectGroup or backupJob is empty. IsProtectGroup empty:%s. IsBackupJobEmpty:%s.", new Object[]{VerifyUtil.isEmpty((Object)protectGroup), VerifyUtil.isEmpty((Object)kubeProtectionJob)});
            return false;
        }
        long startTime = System.currentTimeMillis();
        context.addObject("start " + listenKey, (Object)startTime);
        boolean isListenRight = this.startListen(protectGroup, kubeProtectionJob.getName(), KubeJobType.PROTECTION_JOB);
        context.addObject("end " + listenKey, (Object)System.currentTimeMillis());
        return isListenRight;
    }

    protected boolean listenBackupAction(ActionContext context, ProtectGroup protectGroup, String listenKey) {
        KubeBackupJob kubeBackupJob = (KubeBackupJob)context.getObject("backupJob", KubeBackupJob.class);
        if (VerifyUtil.isEmpty((Object)protectGroup) || VerifyUtil.isEmpty((Object)kubeBackupJob)) {
            LOGGER.error((Object)"ProtectGroup or backupJob is empty. IsProtectGroup empty:%s. IsBackupJobEmpty:%s.", new Object[]{VerifyUtil.isEmpty((Object)protectGroup), VerifyUtil.isEmpty((Object)kubeBackupJob)});
            return false;
        }
        long startTime = System.currentTimeMillis();
        context.addObject("start " + listenKey, (Object)startTime);
        boolean isListenRight = this.startListen(protectGroup, kubeBackupJob.getName(), KubeJobType.BACKUP_JOB);
        context.addObject("end " + listenKey, (Object)System.currentTimeMillis());
        this.checkAndSaveBackupReplica(protectGroup, kubeBackupJob.getName());
        return isListenRight;
    }

    private void checkAndSaveBackupReplica(ProtectGroup protectGroup, String backupJobName) {
        KubeBackup backup;
        long startTime = System.currentTimeMillis();
        do {
            CommonUtil.sleep((long)2L, (TimeUnit)TimeUnit.SECONDS);
            Optional optional = this.getKubeHandler().getBackupByBackupJob(protectGroup.getPoProviderSN(), backupJobName);
            if (!optional.isPresent()) {
                LOGGER.warn((Object)"Manual synchronize backup replica failed, could not find target backup replica of backup job (%s), maybe removed on CDR manually?", new Object[]{backupJobName});
                return;
            }
            backup = (KubeBackup)optional.get();
            String status = backup.getStatus();
            if (!KubeEnumDefine.KubeBackupStatus.COMPLETED.getCdrStatus().equals(status) && !KubeEnumDefine.KubeBackupStatus.FAILED.getCdrStatus().equals(status)) continue;
            ProtectGroupReplica replica = KubeResourceBuildUtil.buildBackupReplica(backup, protectGroup, true);
            this.getReplicaService().saveOrUpdateReplica(replica);
            return;
        } while (System.currentTimeMillis() - startTime <= TimeUnit.MINUTES.toMillis(5L));
        ProtectGroupReplica replica = KubeResourceBuildUtil.buildBackupReplica(backup, protectGroup, true);
        this.getReplicaService().saveOrUpdateReplica(replica);
    }

    public boolean checkPreHook(ProtectGroup protectGroup) {
        Map<String, String> map = this.getExtParams(protectGroup);
        if (map.containsKey("preHook")) {
            String preHook = map.get("preHook");
            return !VerifyUtil.isEmpty((String)preHook);
        }
        return false;
    }

    public boolean checkPostHook(ProtectGroup protectGroup) {
        Map<String, String> map = this.getExtParams(protectGroup);
        if (map.containsKey("postHook")) {
            String preHook = map.get("postHook");
            return !VerifyUtil.isEmpty((String)preHook);
        }
        return false;
    }

    private Map<String, String> getExtParams(ProtectGroup protectGroup) {
        Schedule schedule = Optional.ofNullable(protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getSchedules).orElse(Collections.emptySet()).stream().filter(schedule1 -> schedule1.isEnable()).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L));
        return schedule.getExtParameters();
    }

    private IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    private IReplicaBaseService getReplicaService() {
        return (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
    }
}

