/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.execute.process;

import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.kube.execute.process.AbstractCDRMonitorAction;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeEventKeywords;
import com.huawei.ism.drm.protection.action.model.ActionContext;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class CDRMonitorExecuteAction
extends AbstractCDRMonitorAction {
    private static final Log LOGGER = LogFactory.getInstance(CDRMonitorExecuteAction.class);

    @Override
    public boolean doExecute(ActionContext context) {
        ProtectGroup protectGroup = null;
        if (context.getObject("PG_ENTITY") instanceof ProtectGroup) {
            protectGroup = (ProtectGroup)context.getObject("PG_ENTITY");
        }
        try {
            if (protectGroup == null) {
                LOGGER.error((Object)"The protectGroup is null.");
                throw new LegoCheckedException(2117645L);
            }
            return PolicyTemplateType.KUBE_REPLICATION_TYPES.contains(protectGroup.getTemplate().getType()) ? this.listenReplicationAction(context, protectGroup, "protectionJob") : this.listenBackupAction(context, protectGroup, "backupJob");
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Fail to monitor protectGroup execute.");
            this.setDetail("lego.err.1073947753");
            this.setDetailParams(e.getMessage());
            return false;
        }
    }

    @Override
    protected String getStartKeyword() {
        return "";
    }

    @Override
    protected String getEndKeyword() {
        return KubeEventKeywords.DisasterProtectionJob.SYNC_END.getValue();
    }
}

