/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.kube.listener;

import com.huawei.ism.drm.base.util.ResourceLockUtil;
import com.huawei.ism.drm.kube.model.KubeJobListenerExecuteParam;
import com.huawei.ism.drm.kube.sdk.IKubeHandler;
import com.huawei.ism.drm.kube.sdk.model.KubeEvent;
import com.huawei.ism.drm.kube.sdk.model.KubeRecoveryJob;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeEventReason;
import com.huawei.ism.drm.kube.sdk.model.enums.KubeJobType;
import com.huawei.ism.drm.kube.utils.KubeResourceUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class KubeJobListenerExecutor {
    private static final Log LOGGER = LogFactory.getInstance(KubeJobListenerExecutor.class);
    private static final long MAX_TIME_OUT = 1800000L;
    private static final int LISTEN_PERIOD = 5000;
    private static final String CORE_SIZE_PROP_KEY = "cdr.listener.thread.pool.core.size";
    private static final int CORE_POOL_SIZE = (int)LegoBaseConfig.getInstance().getNumberWithMaxValue("cdr.listener.thread.pool.core.size", 10L, 64L);
    private static final int MAXIMUM_POOL_SIZE = 30;
    private static final int THREAD_QUEUE_SIZE = 512;
    private static final int KEEP_ALIVE = 2;
    private static final int CHECK_EVENT_AFTER_JOB_COMPLETE_MAX_WAIT = 5;
    private static final ExecutorService WORK_TASK = new ThreadPoolExecutor(CORE_POOL_SIZE, 30, 2L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(512));

    private KubeJobListenerExecutor() {
    }

    public static KubeJobListenerExecutor getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void startListen(KubeJobListenerExecuteParam param, ListenCallback callback) {
        LOGGER.info((Object)"Start listen kube event. devSn: %s, jobName: %s, jobType: %s, endKeyword: %s", new Object[]{param.getDevSn(), param.getJobName(), param.getJobType(), param.getEndKeyword()});
        VerifyUtil.checkStrs((String[])new String[]{param.getDevSn(), param.getJobName(), param.getEndKeyword()});
        String lockId = ResourceLockUtil.lockRes((String)param.getJobName(), (String)"KubeJob", (long)1800000L);
        try {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            WORK_TASK.execute(new WorkTask(param, countDownLatch, callback));
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new LegoCheckedException("Listen kube job error.", (Throwable)e);
        }
        finally {
            ResourceLockUtil.unlockRes((String)lockId);
        }
    }

    private void handleEventResult(KubeEvent kubeEvent, KubeJobListenerExecuteParam param, ListenCallback callback) {
        if (KubeEventReason.SUCCESS.getValue().equals(kubeEvent.getReason())) {
            LOGGER.warn((Object)"Listen kube job succeed, jobName: %s, endKeyword: %s", new Object[]{param.getJobName(), param.getEndKeyword()});
            HashMap<String, Object> extend = new HashMap<String, Object>();
            if (KubeJobType.RECOVERY_JOB.equals((Object)param.getJobType())) {
                Optional optional = this.getKubeHandler().getKubeRecoveryJobByName(param.getDevSn(), param.getJobName());
                if (!optional.isPresent()) {
                    LOGGER.error((Object)"Could not find target recovery job, kubeSn: %s, jobName: %s", new Object[]{param.getDevSn(), param.getJobName()});
                    throw new LegoCheckedException(1073947393L);
                }
                KubeRecoveryJob kubeRecoveryJob = (KubeRecoveryJob)optional.get();
                extend.put("stage", kubeRecoveryJob.getStage());
                extend.put("lastUpdateTimestamp", kubeRecoveryJob.getLastUpdateTimestamp());
            }
            callback.success(param.getDevSn(), param.getJobName(), extend);
        } else {
            LOGGER.warn((Object)"Listen kube job failed, jobName: %s, endKeyword: %s, message: %s", new Object[]{param.getJobName(), param.getEndKeyword(), kubeEvent.getMessage()});
            String keywordAndMessage = kubeEvent.getMessage();
            String message = keywordAndMessage.replace(param.getEndKeyword(), "");
            callback.error(param.getJobName(), message, kubeEvent.getReason());
        }
    }

    private boolean checkIfJobComplete(String kubeSn, String jobName, KubeJobType jobType, Map<String, Object> extend) {
        boolean isJobComplete;
        switch (jobType) {
            case RECOVERY_JOB: {
                isJobComplete = KubeResourceUtil.checkIfRecoveryJobComplete(kubeSn, jobName, extend);
                break;
            }
            case RESTORE_JOB: {
                isJobComplete = KubeResourceUtil.checkIfRestoreJobComplete(kubeSn, jobName);
                break;
            }
            case BACKUP_JOB: {
                isJobComplete = KubeResourceUtil.checkIfBackupJobComplete(kubeSn, jobName);
                break;
            }
            case PROTECTION_JOB: {
                isJobComplete = KubeResourceUtil.checkIfProtectionJobComplete(kubeSn, jobName);
                break;
            }
            case RE_PROTECTION_JOB: {
                isJobComplete = KubeResourceUtil.checkIfReProtectionJobComplete(kubeSn, jobName);
                break;
            }
            default: {
                throw new LegoCheckedException(1073947393L);
            }
        }
        return isJobComplete;
    }

    private Optional<KubeEvent> hasEventCompleteNormallyAndRetry(String kubeSn, String jobName, String keyword) {
        long startTime = System.currentTimeMillis();
        do {
            CommonUtil.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
            Optional<KubeEvent> optional = this.hasEventCompleteNormally(kubeSn, jobName, keyword);
            if (!optional.isPresent()) continue;
            return optional;
        } while (System.currentTimeMillis() - startTime <= TimeUnit.MINUTES.toMillis(5L));
        return Optional.empty();
    }

    private Optional<KubeEvent> hasEventCompleteNormally(String kubeSn, String jobName, String keyword) {
        List events = this.getKubeHandler().getKubeEvent(kubeSn, jobName);
        if (VerifyUtil.isEmpty((Collection)events)) {
            return Optional.empty();
        }
        return events.stream().filter(e -> StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)keyword)).findFirst();
    }

    private void sleepPeriod(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Listen kube job error, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Listen kube job error.", (Throwable)e);
        }
    }

    private IKubeHandler getKubeHandler() {
        return (IKubeHandler)ServiceLocator.getInstance().getService(IKubeHandler.class);
    }

    public static interface ListenCallback {
        public void success(String var1, String var2, Map<String, Object> var3);

        public void error(String var1, String var2, String var3);

        public void timeout(String var1, long var2, long var4);
    }

    private static class SingletonHolder {
        static final KubeJobListenerExecutor INSTANCE = new KubeJobListenerExecutor();

        private SingletonHolder() {
        }
    }

    class WorkTask
    implements Runnable {
        private KubeJobListenerExecuteParam param;
        private CountDownLatch countDownLatch;
        private ListenCallback callback;

        public WorkTask(KubeJobListenerExecuteParam param, CountDownLatch countDownLatch, ListenCallback callback) {
            this.param = param;
            this.countDownLatch = countDownLatch;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                this.dealWithCallBack();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Monitor CDR job failed.", (Throwable)e);
                this.callback.error(this.param.getJobName(), e.getMessage(), KubeEventReason.FAILURE.getValue());
            }
            finally {
                this.countDownLatch.countDown();
            }
        }

        private void dealWithCallBack() {
            while (true) {
                Optional firstOptional;
                if ((firstOptional = KubeJobListenerExecutor.this.hasEventCompleteNormally(this.param.getDevSn(), this.param.getJobName(), this.param.getEndKeyword())).isPresent()) {
                    KubeEvent firstEvent = (KubeEvent)firstOptional.get();
                    LOGGER.info((Object)"Listen kube event successfully. sn: %s, jobName: %s, endKeyword: %s, message: %s, reason: %s", new Object[]{this.param.getDevSn(), this.param.getJobName(), this.param.getEndKeyword(), firstEvent.getMessage(), firstEvent.getReason()});
                    KubeJobListenerExecutor.this.handleEventResult(firstEvent, this.param, this.callback);
                    this.countDownLatch.countDown();
                    break;
                }
                if (KubeJobListenerExecutor.this.checkIfJobComplete(this.param.getDevSn(), this.param.getJobName(), this.param.getJobType(), this.param.getExtend())) {
                    Optional retryOptional = KubeJobListenerExecutor.this.hasEventCompleteNormallyAndRetry(this.param.getDevSn(), this.param.getJobName(), this.param.getEndKeyword());
                    if (retryOptional.isPresent()) {
                        KubeEvent retryEvent = (KubeEvent)retryOptional.get();
                        KubeJobListenerExecutor.this.handleEventResult(retryEvent, this.param, this.callback);
                    } else {
                        this.callback.error(this.param.getJobName(), "Could not monitor target event after job completed", KubeEventReason.FAILURE.getValue());
                    }
                    this.countDownLatch.countDown();
                    break;
                }
                KubeJobListenerExecutor.this.sleepPeriod(5000L);
            }
        }
    }
}

